/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.clean.impl;

import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnOrg;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnRole;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnUser;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnOrgRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnRoleRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnUserRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.support.clean.PolicyCascadeDeleteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyCascadeDeleteServiceImpl
implements PolicyCascadeDeleteService {
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private DataPolicyOnUserRepository dataPolicyOnUserRepository;
    @Autowired
    private DataPolicyOnRoleRepository dataPolicyOnRoleRepository;
    @Autowired
    private DataPolicyOnOrgRepository dataPolicyOnOrgRepository;

    @Override
    public void deleteUser(long userSid) {
        this.policyCrudService.deletePolicy(userSid, TargetType.user.name());
        List<DataPolicyOnUser> dataPolicies = this.dataPolicyOnUserRepository.findByUserSid(userSid);
        for (DataPolicyOnUser dataPolicy : dataPolicies) {
            this.dataPolicyCrudService.deleteById(dataPolicy.getPolicySid());
        }
    }

    @Override
    public void deleteUser(long tenantSid, long userSid) {
        this.policyCrudService.deletePolicy(tenantSid, userSid, TargetType.user.name());
        List<DataPolicyOnUser> dataPolicies = this.dataPolicyOnUserRepository.findByUserSid(userSid);
        for (DataPolicyOnUser user : dataPolicies) {
            DataPolicy dataPolicy = (DataPolicy)this.dataPolicyCrudService.findBySid(user.getPolicySid());
            if (dataPolicy == null || dataPolicy.getTenantSid() != tenantSid) continue;
            this.dataPolicyCrudService.deleteById(user.getPolicySid());
        }
    }

    @Override
    public void deleteRole(long tenantSid, long roleSid) {
        this.policyCrudService.deletePolicy(tenantSid, roleSid, TargetType.role.name());
        List<DataPolicyOnRole> dataPolicies = this.dataPolicyOnRoleRepository.findByRoleSid(roleSid);
        for (DataPolicyOnRole dataPolicy : dataPolicies) {
            this.dataPolicyCrudService.deleteById(dataPolicy.getPolicySid());
        }
    }

    @Override
    public void deleteOrg(long tenantSid, long orgSid) {
        this.policyCrudService.deletePolicy(tenantSid, orgSid, TargetType.org.name());
        List<DataPolicyOnOrg> dataPolicies = this.dataPolicyOnOrgRepository.findByOrgSid(orgSid);
        for (DataPolicyOnOrg dataPolicy : dataPolicies) {
            this.dataPolicyCrudService.deleteById(dataPolicy.getPolicySid());
        }
    }
}

