/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.clean.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.CacheMapper;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.iam.support.clean.SysCacheDeleteService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteImgService;
import com.digiwin.dap.middleware.iam.util.LanguageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RefreshCacheServiceImpl
implements RefreshCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RefreshCacheServiceImpl.class);
    @Autowired
    private CacheMapper cacheMapper;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private RemoteImgService remoteImgService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private SysCacheDeleteService sysCacheDeleteService;

    @Override
    public void deletePermissionBySys(String sysId) {
        Sys sys = this.cacheMapper.findSysBySysId(sysId);
        if (sys != null) {
            this.deletePermissionBySys(sys.getSid(), sys.getId(), 0L);
        }
    }

    @Override
    public void deletePermissionBySys(long sysSid, String sysId, long tenantSid) {
        try {
            this.sysCacheDeleteService.deleteTreeBySysSid(sysSid, tenantSid);
            String appKey = CalcUser.appKey(sysId);
            SetOperations setOperations = RedisUtils.opsForSet();
            Set objects = setOperations.members((Object)appKey);
            if (objects != null && !objects.isEmpty()) {
                List allKeys = objects.stream().map(Object::toString).collect(Collectors.toList());
                List partitionKeys = ListUtils.partition(allKeys, (int)500);
                partitionKeys.forEach(keys -> {
                    this.deletePermission((List<String>)keys);
                    setOperations.remove((Object)appKey, keys.toArray());
                });
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u5e94\u7528[{}]\u6743\u9650\u7f13\u5b58", (Object)sysId, (Object)e);
        }
    }

    @Override
    public void deletePermissionBySysAndTenant(String sysId, String tenantId) {
        if (tenantId == null) {
            return;
        }
        try {
            List allKeys;
            List<String> keys;
            String appKey = CalcUser.appKey(sysId);
            SetOperations setOperations = RedisUtils.opsForSet();
            Set objects = setOperations.members((Object)appKey);
            if (objects != null && !objects.isEmpty() && !(keys = (allKeys = objects.stream().map(Object::toString).collect(Collectors.toList())).stream().filter(p -> p.endsWith("::" + tenantId + "::" + sysId)).collect(Collectors.toList())).isEmpty()) {
                this.deletePermission(keys);
                setOperations.remove((Object)appKey, keys.toArray());
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u5e94\u7528[" + sysId + "]\u79df\u6237[" + tenantId + "]\u6743\u9650\u7f13\u5b58", (Throwable)e);
        }
    }

    @Override
    public void deletePermissionByTenant(long tenantSid) {
        List<String> sysIds = this.cacheMapper.findSysIdsByTenantSid(tenantSid);
        for (String sysId : sysIds) {
            this.deletePermissionBySys(sysId);
        }
    }

    @Override
    public void deletePermissionByUserAndTenant(long userSid, long tenantSid) {
        try {
            String userId = this.cacheMapper.findUserIdByUserSid(userSid);
            if (userId == null) {
                return;
            }
            String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
            if (tenantId == null) {
                return;
            }
            List<String> sysIds = this.cacheMapper.findSysIdsByTenantSid(tenantSid);
            ArrayList<String> allKeys = new ArrayList<String>();
            sysIds.forEach(sysId -> allKeys.add(String.format("iam:permission:auth:%s::%s::%s", userId, tenantId, sysId)));
            this.deletePermission(allKeys);
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u7528\u6237[" + userSid + "]\u79df\u6237[" + tenantSid + "]\u6743\u9650\u7f13\u5b58", (Throwable)e);
        }
    }

    @Override
    public void deletePermissionByUserAndTenant(List<Long> userSids, long tenantSid) {
        try {
            List<String> userIds = this.cacheMapper.findUserIdInUserSids(userSids);
            if (CollectionUtils.isEmpty(userIds)) {
                return;
            }
            String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
            if (tenantId == null) {
                return;
            }
            List<String> sysIds = this.cacheMapper.findSysIdsByTenantSid(tenantSid);
            ArrayList<String> allKeys = new ArrayList<String>();
            userIds.forEach(u -> sysIds.forEach(sysId -> allKeys.add(String.format("iam:permission:auth:%s::%s::%s", u, tenantId, sysId))));
            this.deletePermission(allKeys);
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u7528\u6237[" + userSids.stream().map(String::valueOf).collect(Collectors.joining(",")) + "]\u79df\u6237[" + tenantSid + "]\u6743\u9650\u7f13\u5b58", (Throwable)e);
        }
    }

    @Override
    public void deletePermissionByPolicy(long tenantSid, String type, long targetSid, long sysSid) {
        try {
            List<String> userIds = this.getUserIds(tenantSid, type, targetSid);
            String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
            String sysId = this.cacheMapper.findSysIdBySysSid(sysSid);
            ArrayList<String> allKeys = new ArrayList<String>();
            userIds.stream().distinct().forEach(userId -> allKeys.add(String.format("iam:permission:auth:%s::%s::%s", userId, tenantId, sysId)));
            this.deletePermission(allKeys);
        }
        catch (Exception e) {
            logger.error("\u7b56\u7565\u53d8\u66f4\u6e05\u9664\u6743\u9650\u7f13\u5b58", (Throwable)e);
        }
    }

    private void deletePermission(List<String> keys) {
        RedisUtils.delete(keys);
        List lastModifiedKeys = keys.stream().map(p -> p.replace("auth", "last:modified")).collect(Collectors.toList());
        RedisUtils.delete(lastModifiedKeys);
    }

    private List<String> getUserIds(long tenantSid, String type, long targetSid) {
        ArrayList<String> userIds = new ArrayList<String>();
        if ("user".equals(type)) {
            userIds.add(this.cacheMapper.findUserIdByUserSid(targetSid));
        } else if ("role".equals(type)) {
            if (tenantSid > 0L) {
                userIds.addAll(this.cacheMapper.findUserIdsByRoleSidAndTenantSid(targetSid, tenantSid));
            } else {
                userIds.addAll(this.cacheMapper.findUserIdsByRoleSid(targetSid));
            }
        } else if ("org".equals(type)) {
            Org org = this.cacheMapper.findOrgUriByOrgSid(targetSid);
            if (org != null && StringUtils.hasText((String)org.getUri())) {
                List<Long> roleSids;
                List<Long> orgSids = this.cacheMapper.findOrgSidsByOrgUriAndTenantSid(org.getUri(), org.getTenantSid());
                if (!orgSids.isEmpty()) {
                    userIds.addAll(this.cacheMapper.findUserIdsByOrgSids(orgSids));
                }
                if (!(roleSids = this.cacheMapper.findRoleSidsByOrgUriAndTenantSid(org.getUri(), org.getTenantSid())).isEmpty()) {
                    userIds.addAll(this.cacheMapper.findUserIdsByRoleSidsAndTenantSid(roleSids, tenantSid));
                }
            }
        } else if ("tenant".equals(type)) {
            userIds.addAll(this.cacheMapper.findUserIdsByTenantSid(targetSid));
        }
        return userIds;
    }

    @Override
    @Async
    public void deleteCacAuthBySysAsync(List<String> sysIds) {
        HashSet deleteKeys = new HashSet();
        sysIds.forEach(sysId -> {
            String redisKey = LoginUser.cacAuthKey("*", "*", sysId);
            Set cacKeys = RedisUtils.keys((String)redisKey);
            deleteKeys.addAll(cacKeys);
        });
        RedisUtils.delete(deleteKeys);
    }

    @Override
    public void deleteSysInTenant(long tenantSid, long sysSid) {
        try {
            String tenantId = this.cacheMapper.findTenantIdByTenantSid(tenantSid);
            String sysId = this.cacheMapper.findSysIdBySysSid(sysSid);
            String redisKey = String.format("dap:entity:sys:%s::%s", sysId, tenantId);
            String redisSysInTenantKey = String.format("dap:entity:sysintenant:%s:%s", sysId, tenantSid);
            RedisUtils.delete(Arrays.asList(redisKey, redisSysInTenantKey));
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u79df\u6237\u5e94\u7528\u5173\u7cfb\u7f13\u5b58{},{}, \u9519\u8bef\u4fe1\u606f:{}", new Object[]{tenantSid, sysSid, e.getMessage()});
        }
    }

    @Override
    @Async
    public void updateImgTenantNameAsync(long tenantSid, String tenantName) {
        HashMap<String, Object> tenantMap = new HashMap<String, Object>();
        tenantMap.put("tenantSid", tenantSid);
        tenantMap.put("tenantName", tenantName);
        this.remoteImgService.updateTenantInfo(tenantMap);
    }

    @Override
    @Async
    public void updateEocUserNameAsync(User user, String userToken) {
        this.remoteEocService.refreshUserName(user, userToken);
    }

    @Override
    public void updateMetadata(User user) {
        try {
            UserMetadataVO userMetadataVO = new UserMetadataVO("basic", "dapAcceptLanguage", LanguageUtil.getDefaultLanguage(this.envProperties.getCountry()), 0L, user.getSid());
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u7528\u6237\u6dfb\u52a0\u9ed8\u8ba4\u5143\u6570\u636e[dapAcceptLanguage]", (Throwable)e);
        }
    }
}

