/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CardTypeEnum;
import com.digiwin.dap.middleware.iam.domain.excel.CardExcelVO;
import com.digiwin.dap.middleware.iam.entity.CardInfo;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.CardInfoRepository;
import com.digiwin.dap.middleware.iam.service.card.CardInfoCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.util.I18nUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Scope(value="prototype")
public class CardExcelListener {
    private static final Logger logger = LoggerFactory.getLogger(CardExcelListener.class);
    private final List<CardExcelVO> successResults = new ArrayList<CardExcelVO>();
    private final List<CardExcelVO> errorResults = new ArrayList<CardExcelVO>();
    @Resource
    private UserCrudService userCrudService;
    @Resource
    private CardInfoCrudService cardInfoCrudService;
    @Resource
    private TenantCrudService tenantCrudService;
    @Resource
    private UserInTenantCrudService userInTenantCrudService;
    @Resource
    private CardInfoRepository cardInfoRepository;

    public void processExcel(List<CardExcelVO> rows) {
        rows.forEach(this::checkUserInTenant);
        this.checkCardType(rows);
        this.checkMultipleCards(rows);
        this.checkMultipleUsers(rows);
        rows.forEach(this::saveCard);
    }

    private void checkCardType(List<CardExcelVO> rows) {
        for (CardExcelVO row : rows) {
            if (CardTypeEnum.isValidType(row.getCardType())) continue;
            row.appendError(I18nError.IAM_CARD_INVALID_TYPE.getMessage(new Object[]{row.getCardType()}));
            this.errorResults.add(row);
        }
    }

    private void checkMultipleUsers(List<CardExcelVO> rows) {
        HashSet errorRows = new HashSet();
        HashMap cardSet = new HashMap();
        for (CardExcelVO row2 : rows) {
            Optional.ofNullable(row2.getUserInTenant()).ifPresent(u -> {
                String key = row2.getCardId() + row2.getCardType();
                if (cardSet.containsKey(key)) {
                    ((List)cardSet.get(key)).add(row2);
                    errorRows.addAll((Collection)cardSet.get(key));
                } else {
                    cardSet.computeIfAbsent(key, a -> new ArrayList()).add(row2);
                }
            });
        }
        rows.forEach(row -> {
            if (errorRows.contains(row)) {
                row.appendError(I18nError.IAM_CARD_SINGLE_USER.getMessage(new Object[0]));
            }
        });
        this.errorResults.addAll(errorRows);
    }

    private void checkMultipleCards(List<CardExcelVO> rows) {
        HashSet errorRows = new HashSet();
        HashMap<String, List> userInTenantSet = new HashMap<String, List>();
        for (CardExcelVO row2 : rows) {
            if (row2.getUserInTenant() == null) continue;
            String key = row2.getUserInTenant().getSid() + row2.getCardType();
            if (userInTenantSet.containsKey(key)) {
                ((List)userInTenantSet.get(key)).add(row2);
                errorRows.addAll((Collection)userInTenantSet.get(key));
                continue;
            }
            userInTenantSet.computeIfAbsent(key, a -> new ArrayList()).add(row2);
        }
        rows.forEach(row -> {
            if (errorRows.contains(row)) {
                row.appendError(I18nError.IAM_CARD_SINGLE_CARD.getMessage(new Object[0]));
            }
        });
        this.errorResults.addAll(errorRows);
    }

    private void checkUserInTenant(CardExcelVO data) {
        Tenant tenant;
        StringJoiner errors = new StringJoiner(",");
        User user = (User)this.userCrudService.findById(data.getUserId());
        if (user == null) {
            errors.add(I18nError.USER_NOT_EXIST.getMessage(new Object[]{data.getUserId()}));
        }
        if ((tenant = (Tenant)this.tenantCrudService.findById(data.getTenantId())) == null) {
            errors.add(I18nError.TENANT_INVITED_USER_TENANT_EXISTED.getMessage(new Object[]{data.getTenantId()}));
        }
        UserInTenant userInTenant = null;
        if (user != null && tenant != null && (userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid())) == null) {
            errors.add(I18nUtils.getMessage((String)I18nCode.EXCEL_IMPORT_TENANT_USER_EXISTED_ERROR.getCode(), (Object[])new Object[]{data.getTenantId()}));
        }
        if (errors.length() > 0) {
            data.setErrors(errors.toString());
            this.errorResults.add(data);
            return;
        }
        data.setUserInTenant(userInTenant);
    }

    private void saveCard(CardExcelVO data) {
        try {
            if (StringUtils.isEmpty((Object)data.getErrors())) {
                List<CardInfo> userWithCard = this.cardInfoRepository.findByUserTenantSid(data.getUserInTenant().getSid());
                if (userWithCard.stream().anyMatch(a -> a.getType().equals(data.getCardType()) && !a.getId().equals(data.getCardId()))) {
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_BIND_CHECK_USER);
                }
                CardInfo cardOnUser = this.cardInfoCrudService.findByIdAndType(data.getCardId(), data.getCardType());
                if (cardOnUser != null) {
                    logger.info("\u5361\u5df2\u7ed1\u5b9a\u7528\u6237\uff0c\u89e3\u7ed1\u5361,\u5361\u53f7:{},\u7c7b\u578b:{},\u539f\u79df\u6237\u7528\u6237sid:{}", new Object[]{data.getCardId(), data.getCardType(), cardOnUser.getUserTenantSid()});
                    this.cardInfoCrudService.deleteById(cardOnUser.getSid());
                }
                CardInfo cardInfo = new CardInfo();
                cardInfo.setId(data.getCardId());
                cardInfo.setType(data.getCardType());
                cardInfo.setUserTenantSid(data.getUserInTenant().getSid());
                this.cardInfoCrudService.create(cardInfo);
                this.successResults.add(data);
            }
        }
        catch (Exception e) {
            data.setErrors(e.getMessage());
            this.errorResults.add(data);
        }
    }

    public List<CardExcelVO> getSuccessResults() {
        return this.successResults;
    }

    public List<CardExcelVO> getErrorResults() {
        return this.errorResults;
    }
}

