/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CellphonePrefixEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.excel.ImportEnterpriseUserExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.ImportEnterpriseUserExcelWithoutWechatVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserCondition;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.util.CellPhoneUtil;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import com.digiwin.dmc.sdk.entity.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ImportEnterpriseUserExcelListener
extends AnalysisEventListener<ImportEnterpriseUserExcelVO> {
    Logger logger = LoggerFactory.getLogger(ImportEnterpriseUserExcelListener.class);
    private List<ImportEnterpriseUserExcelVO> importEnterpriseUsers = new ArrayList<ImportEnterpriseUserExcelVO>();
    private List<ImportEnterpriseUserExcelVO> errorImportEnterpriseUsers = new ArrayList<ImportEnterpriseUserExcelVO>();
    private EnvProperties envProperties;
    private RoleCrudService roleCrudService;
    private OrgCrudService orgCrudService;
    private TenantQueryService tenantQueryService;
    private DmcService dmcService;
    private UserCrudService userCrudService;
    private SysCrudService sysCrudService;
    private UserInTenantCrudService userInTenantCrudService;
    private TenantCrudService tenantCrudService;
    private UserInTenantOperationService userInTenantOperationService;
    private UserInRoleService userInRoleService;
    private UserV2Service userV2Service;
    private boolean isAdmin;
    private Map<String, Object> corpIdAndAppConfig;
    private boolean hasCorpWechat;
    private AutoEOCService autoEOCService;
    private RemoteEMCService remoteEMCService;
    private Set<String> bundleChildren;

    public ImportEnterpriseUserExcelListener(boolean isAdmin, AutoEOCService autoEOCService, EnvProperties envProperties, RoleCrudService roleCrudService, OrgCrudService orgCrudService, TenantQueryService tenantQueryService, DmcService dmcService, UserCrudService userCrudService, SysCrudService sysCrudService, UserInTenantCrudService userInTenantCrudService, TenantCrudService tenantCrudService, UserInTenantOperationService userInTenantOperationService, UserInRoleService userInRoleService, UserV2Service userV2Service, Map<String, Object> corpIdAndAppConfig, boolean hasCorpWechat, RemoteEMCService remoteEMCService, Set<String> bundleChildren) {
        this.autoEOCService = autoEOCService;
        this.envProperties = envProperties;
        this.roleCrudService = roleCrudService;
        this.orgCrudService = orgCrudService;
        this.tenantQueryService = tenantQueryService;
        this.dmcService = dmcService;
        this.userCrudService = userCrudService;
        this.sysCrudService = sysCrudService;
        this.userInTenantCrudService = userInTenantCrudService;
        this.tenantCrudService = tenantCrudService;
        this.userInTenantOperationService = userInTenantOperationService;
        this.userInRoleService = userInRoleService;
        this.userV2Service = userV2Service;
        this.isAdmin = isAdmin;
        this.corpIdAndAppConfig = corpIdAndAppConfig;
        this.hasCorpWechat = hasCorpWechat;
        this.remoteEMCService = remoteEMCService;
        this.bundleChildren = bundleChildren;
    }

    public void invoke(ImportEnterpriseUserExcelVO userExcelVO, AnalysisContext analysisContext) {
        if (analysisContext.readRowHolder().getCellMap().size() > 0) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            Assert.notNull((Object)authoredUser, (String)I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_NULL_TENANT.getMessage());
            boolean updateFlag = false;
            User existUser = null;
            if (StringUtils.isEmpty((Object)userExcelVO.getId())) {
                userExcelVO.setErrors(I18nCode.EXCEL_IMPORT_ERROR_EMPTY_ID.getMessage());
            } else {
                existUser = (User)this.userCrudService.findById(authoredUser.getTenantId() + "$" + userExcelVO.getId());
                if (null != existUser) {
                    updateFlag = true;
                }
            }
            if (StringUtils.isEmpty((Object)userExcelVO.getName())) {
                userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_ERROR_EMPTY_NAME.getMessage() : userExcelVO.getErrors() + I18nCode.EXCEL_IMPORT_ERROR_EMPTY_NAME.getMessage());
            }
            if (StringUtils.isEmpty((Object)userExcelVO.getPassword())) {
                userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_ERROR_EMPTY_PASSWORD.getMessage() : userExcelVO.getErrors() + I18nCode.EXCEL_IMPORT_ERROR_EMPTY_PASSWORD.getMessage());
            }
            if (!StringUtils.isEmpty((Object)userExcelVO.getId()) && UserIdValidator.validateUserId(userExcelVO.getId())) {
                userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_ERROR_USER_ID_1.getMessage() : userExcelVO.getErrors() + I18nCode.EXCEL_IMPORT_ERROR_USER_ID.getMessage());
            }
            if (!StringUtils.isEmpty((Object)userExcelVO.getPassword()) && (PasswordValidator.validateTenantCustomPassword(userExcelVO.getPassword()) || userExcelVO.getPassword().length() < this.tenantQueryService.getTenantPasswordMinLength(authoredUser.getTenantSid()))) {
                userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ERROR_PASSWORD.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors()));
            }
            if (!StringUtils.isEmpty((Object)userExcelVO.getMail())) {
                if (!StringUtil.checkEmail(userExcelVO.getMail())) {
                    userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_EMAIL.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors()));
                }
                UserCondition userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).email(userExcelVO.getMail()).build();
                User userExist = this.userCrudService.queryUserByTenantSidAndCondition(authoredUser.getTenantSid(), userCondition);
                if (null != userExist && existUser != null && userExist.getSid() != existUser.getSid()) {
                    userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_EMAIL_EXIST.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors()));
                }
            }
            if (!StringUtils.isEmpty((Object)userExcelVO.getTelephone())) {
                boolean checkMobilePhone = CellPhoneUtil.checkPhoneFormat(userExcelVO.getCellphonePrefix(), userExcelVO.getTelephone(), this.envProperties.getCountry());
                if (!checkMobilePhone) {
                    userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_TELEPHONE.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors()));
                }
                UserCondition userCondition = new UserCondition.Builder().type(UserTypeEnum.INTERNAL.getCode()).telephone(userExcelVO.getTelephone()).build();
                User userExist = this.userCrudService.queryUserByTenantSidAndCondition(authoredUser.getTenantSid(), userCondition);
                if (null != userExist && existUser != null && userExist.getSid() != existUser.getSid()) {
                    userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_TELEPHONE_EXIST.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors()));
                }
                if (StringUtils.isEmpty((Object)userExcelVO.getCellphonePrefix()) || !CellphonePrefixEnum.prefixValid(userExcelVO.getCellphonePrefix())) {
                    userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_CELLPHONE_PREFIX_INVALID_1.getMessage() : userExcelVO.getErrors() + ", " + I18nCode.EXCEL_IMPORT_CELLPHONE_PREFIX_INVALID_1.getMessage());
                }
            }
            ArrayList<GeneralParametersVO> roles = new ArrayList<GeneralParametersVO>();
            this.checkRoleOrOrgOrApps(userExcelVO, userExcelVO.getRoles(), "role", authoredUser, roles);
            ArrayList<GeneralParametersVO> orgs = new ArrayList<GeneralParametersVO>();
            String errorOrg = this.checkRoleOrOrgOrApps(userExcelVO, userExcelVO.getOrgs(), "org", authoredUser, orgs);
            if (!StringUtils.isEmpty((Object)errorOrg)) {
                userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_NOT_EXISTED_ORG.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors(), errorOrg, authoredUser.getTenantId()));
            }
            ArrayList<GeneralParametersVO> apps = new ArrayList<GeneralParametersVO>();
            String errorApp = this.checkRoleOrOrgOrApps(userExcelVO, userExcelVO.getApps(), "app", authoredUser, apps);
            if (!StringUtils.isEmpty((Object)errorApp)) {
                userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_NOT_BUY_APPLICATION.getMessage(), StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? "" : userExcelVO.getErrors(), authoredUser.getTenantId(), errorApp));
            }
            for (GeneralParametersVO app : apps) {
                if (!this.bundleChildren.contains(app.getId())) continue;
                userExcelVO.setErrors(String.format("%s;" + I18nCode.BUNDLE_CHILDREN_FORBIDDEN.getMessage(), Optional.ofNullable(userExcelVO.getErrors()).orElse("")));
                break;
            }
            if (!StringUtils.isEmpty((Object)userExcelVO.getWechat()) && this.hasCorpWechat) {
                if (StringUtils.isEmpty((Object)((String)this.corpIdAndAppConfig.get("corpId")))) {
                    userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_TENANT_CORPID_NOT_EXIST.getMessage() : userExcelVO.getErrors() + ", " + I18nCode.EXCEL_IMPORT_TENANT_CORPID_NOT_EXIST.getMessage());
                } else if (!Boolean.TRUE.equals(this.corpIdAndAppConfig.get("appConfig"))) {
                    userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_TENANT_APPCONFIG_NOT_EXIST.getMessage() : userExcelVO.getErrors() + ", " + I18nCode.EXCEL_IMPORT_TENANT_APPCONFIG_NOT_EXIST.getMessage());
                } else if (Objects.isNull(this.remoteEMCService.checkWechatExistReturnOpenUserId(null, authoredUser.getTenantId(), userExcelVO.getWechat(), authoredUser.getTenantId() + "$" + userExcelVO.getId()))) {
                    userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.EXCEL_IMPORT_USER_WECHAT_ERROR.getMessage() : userExcelVO.getErrors() + ", " + I18nCode.EXCEL_IMPORT_USER_WECHAT_ERROR.getMessage());
                }
            }
            if (this.autoEOCService.isConsole(authoredUser.getTenantSid()) && this.autoEOCService.isAutoEOC(authoredUser.getTenantSid()) && ObjectUtils.isEmpty((Object)userExcelVO.getEmpId())) {
                userExcelVO.setErrors(StringUtils.isEmpty((Object)userExcelVO.getErrors()) ? I18nCode.IAM_EXCEL_USER_EMP_EMPTY.getMessage() : userExcelVO.getErrors() + ", " + I18nCode.IAM_EXCEL_USER_EMP_EMPTY.getMessage());
            }
            if (StringUtils.isEmpty((Object)userExcelVO.getErrors())) {
                try {
                    this.importEnterpriseUsers.add(userExcelVO);
                    User user = new User();
                    if (updateFlag) {
                        user = existUser;
                    }
                    user.setId(authoredUser.getTenantId() + "$" + userExcelVO.getId());
                    user.setName(userExcelVO.getName());
                    user.setPassword(DigestUtils.sha256((String)userExcelVO.getPassword()));
                    user.setCellphonePrefix(userExcelVO.getCellphonePrefix());
                    user.setTelephone(userExcelVO.getTelephone());
                    user.setEmail(userExcelVO.getMail());
                    user.setActivated(true);
                    user.setChanged(false);
                    user.setType(1);
                    if (updateFlag) {
                        this.userCrudService.update((BaseEntity)user);
                    } else {
                        long userSid = this.userCrudService.create((BaseEntity)user);
                        UserInTenant userInTenant = new UserInTenant();
                        userInTenant.setTenantSid(authoredUser.getTenantSid());
                        userInTenant.setUserSid(userSid);
                        userInTenant.setUserType(false);
                        this.userInTenantCrudService.create(userInTenant);
                    }
                    this.autoEOCService.userJoinTenant(userExcelVO.getEmpId(), user, authoredUser.getTenantSid(), false, false);
                    Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
                    List<GeneralParametersVO> generalParametersVOS = this.userInTenantOperationService.initializeUserData(tenant, user, roles, orgs, apps, userExcelVO.getWechat(), false);
                    if (generalParametersVOS.size() > 0) {
                        generalParametersVOS.forEach(o -> userExcelVO.setErrors(o.getMessage()));
                    }
                    if (!StringUtils.isEmpty((Object)userExcelVO.getErrors())) {
                        String lastError = userExcelVO.getErrors().startsWith(",") ? userExcelVO.getErrors().substring(1) : userExcelVO.getErrors();
                        userExcelVO.setErrors(lastError);
                        this.errorImportEnterpriseUsers.add(userExcelVO);
                    }
                }
                catch (Exception ex) {
                    userExcelVO.setErrors(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_INFO.getMessage(), ex.getMessage()));
                    this.errorImportEnterpriseUsers.add(userExcelVO);
                    this.logger.error(ex.getMessage());
                }
            } else {
                String lastError = userExcelVO.getErrors().startsWith(",") ? userExcelVO.getErrors().substring(1) : userExcelVO.getErrors();
                userExcelVO.setErrors(lastError);
                this.errorImportEnterpriseUsers.add(userExcelVO);
            }
        }
    }

    private String checkRoleOrOrgOrApps(ImportEnterpriseUserExcelVO importEnterpriseUserExcelVO, String content, String type, AuthoredUser authoredUser, List<GeneralParametersVO> successResults) {
        String errorInfo = "";
        try {
            if (!StringUtils.isEmpty((Object)content)) {
                List<String> canUserApps = null;
                if (type.equals("app")) {
                    canUserApps = this.tenantQueryService.getTenantApplication(authoredUser.getTenantId(), Arrays.asList(GoodsCategoryEnum.APP.id(), GoodsCategoryEnum.BUNDLE.id()));
                }
                String roleAdminErrorInfo = "";
                if (content.contains(",") || content.contains("\uff0c")) {
                    String[] contents;
                    String regex = ",|\uff0c|\\s+";
                    for (String subContent : contents = content.split(regex)) {
                        if ("role".equals(type) && !this.isAdmin && "superadmin".equals(subContent)) {
                            roleAdminErrorInfo = String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_SUPERADMIN_ERROR.getMessage(), errorInfo);
                            continue;
                        }
                        errorInfo = this.checkRoleOrOrgOrApp(errorInfo, type, authoredUser, successResults, subContent, canUserApps);
                    }
                } else if ("role".equals(type) && !this.isAdmin && "superadmin".equals(content)) {
                    roleAdminErrorInfo = String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_SUPERADMIN_ERROR.getMessage(), errorInfo);
                } else {
                    errorInfo = this.checkRoleOrOrgOrApp(errorInfo, type, authoredUser, successResults, content, canUserApps);
                }
                if ("role".equals(type)) {
                    if (!StringUtils.isEmpty((Object)errorInfo)) {
                        importEnterpriseUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_ROLE.getMessage(), StringUtils.isEmpty((Object)importEnterpriseUserExcelVO.getErrors()) ? "" : importEnterpriseUserExcelVO.getErrors(), errorInfo, authoredUser.getTenantId()));
                    }
                    if (!StringUtils.isEmpty((Object)roleAdminErrorInfo)) {
                        importEnterpriseUserExcelVO.setErrors(String.format("%s,%s", StringUtils.isEmpty((Object)importEnterpriseUserExcelVO.getErrors()) ? "" : importEnterpriseUserExcelVO.getErrors(), roleAdminErrorInfo));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            errorInfo = ex.getMessage();
        }
        return errorInfo;
    }

    private String checkRoleOrOrgOrApp(String errorInfo, String type, AuthoredUser authoredUser, List<GeneralParametersVO> successResults, String subContent, List<String> canUserApps) {
        if (type.equals("role")) {
            if (!this.roleCrudService.existsByTenantSidAndId(authoredUser.getTenantSid(), subContent)) {
                errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
            } else {
                Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), subContent);
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(role.getId());
                generalParametersVO.setName(role.getName());
                generalParametersVO.setSid(role.getSid());
                successResults.add(generalParametersVO);
            }
        } else if (type.equals("org")) {
            if (!this.orgCrudService.existsByTenantSidAndId(authoredUser.getTenantSid(), subContent)) {
                errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
            } else {
                List<Org> orgs = this.orgCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), subContent);
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(orgs.get(0).getId());
                generalParametersVO.setName(orgs.get(0).getName());
                generalParametersVO.setSid(orgs.get(0).getSid());
                successResults.add(generalParametersVO);
            }
        } else if (canUserApps == null || !canUserApps.contains(subContent)) {
            errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
        } else {
            Sys sys = (Sys)this.sysCrudService.findById(subContent);
            if (sys == null) {
                errorInfo = String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_APP.getMessage(), errorInfo, subContent);
            } else {
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(sys.getId());
                generalParametersVO.setName(sys.getName());
                generalParametersVO.setSid(sys.getSid());
                successResults.add(generalParametersVO);
            }
        }
        return errorInfo;
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public ImportExcelResultVO getBatchInvitedResult(boolean hasCorpWechat) {
        try {
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setSuccessCount(this.importEnterpriseUsers.size());
            importExcelResultVO.setErrorCount(this.errorImportEnterpriseUsers.size());
            if (this.errorImportEnterpriseUsers.size() > 0) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = String.format("error%s.xlsx", localTime);
                File file = new File(fileName);
                InputStream inputStream = hasCorpWechat ? (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_withWechat_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_withWechat_error_TW.xlsx").getInputStream()) : (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_error_TW.xlsx").getInputStream());
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                if (hasCorpWechat) {
                    excelWriter.write(this.errorImportEnterpriseUsers, writeSheet);
                } else {
                    List errorImportEnterpriseWithoutWechatUsers = this.errorImportEnterpriseUsers.stream().map(ImportEnterpriseUserExcelWithoutWechatVO::new).collect(Collectors.toList());
                    excelWriter.write(errorImportEnterpriseWithoutWechatUsers, writeSheet);
                }
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        this.logger.error("no data to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo, 3, LocalDateTime.now().plusMonths(3L), true));
                }
                importExcelResultVO.setErrorFileName(fileName);
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }
}

