/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.entity.BaseEntityWithIdAndTenant;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CellphonePrefixEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantUserTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateModeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.excel.ImportEnterpriseUserExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.ImportEnterpriseUserExcelWithoutWechatVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserBO;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import com.digiwin.dap.middleware.iam.util.CellPhoneUtil;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dmc.sdk.entity.FileInfo;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ImportEnterpriseUserExcelListenerV2
extends AnalysisEventListener<ImportEnterpriseUserExcelVO> {
    private final Logger logger = LoggerFactory.getLogger(ImportEnterpriseUserExcelListenerV2.class);
    private static final String SPLIT_REGEX = ",|\uff0c|\\s+";
    private final List<ImportEnterpriseUserExcelVO> importEnterpriseUsers = new ArrayList<ImportEnterpriseUserExcelVO>();
    private final List<ImportEnterpriseUserExcelVO> errorImportEnterpriseUsers = new ArrayList<ImportEnterpriseUserExcelVO>();
    private final List<ImportEnterpriseUserExcelVO> successImportEnterpriseUsers = new ArrayList<ImportEnterpriseUserExcelVO>();
    private final Map<String, AuthorizationResultVO> authorizationResultVOMap = new HashMap<String, AuthorizationResultVO>();
    private final Tenant tenant;
    private final List<String> canUseApps;
    private final Set<String> bundleChildren;
    private final TenantCorpConfigDTO corpIdAndAppConfig;
    private final Integer minPasswordLength;
    private final boolean autoEOCFlag;
    private final boolean consoleFlag;
    private final boolean hasCorpWechat;
    private final UpdateModeEnum updateModeEnum;
    private final boolean isAdmin;
    private final EnvProperties envProperties;
    private final RoleMapper roleMapper;
    private final OrgMapper orgMapper;
    private final SysMapper sysMapper;
    private final UserMapper userMapper;
    private final UserCrudService userCrudService;
    private final UserRepository userRepository;
    private final RemoteEMCService remoteEMCService;
    private final UserInTenantCrudService userInTenantCrudService;
    private final UserInTenantOperationService userInTenantOperationService;
    private final AutoEOCService autoEOCService;
    private final DmcService dmcService;

    public ImportEnterpriseUserExcelListenerV2(boolean autoEOCFlag, AutoEOCService autoEOCService, Set<String> bundleChildren, List<String> canUseApps, boolean consoleFlag, TenantCorpConfigDTO corpIdAndAppConfig, EnvProperties envProperties, boolean hasCorpWechat, UpdateModeEnum updateModeEnum, boolean isAdmin, Integer minPasswordLength, OrgMapper orgMapper, RemoteEMCService remoteEMCService, RoleMapper roleMapper, SysMapper sysMapper, Tenant tenant, UserCrudService userCrudService, UserRepository userRepository, UserInTenantCrudService userInTenantCrudService, UserInTenantOperationService userInTenantOperationService, UserMapper userMapper, DmcService dmcService) {
        this.autoEOCFlag = autoEOCFlag;
        this.autoEOCService = autoEOCService;
        this.bundleChildren = bundleChildren;
        this.canUseApps = canUseApps;
        this.consoleFlag = consoleFlag;
        this.corpIdAndAppConfig = corpIdAndAppConfig;
        this.envProperties = envProperties;
        this.hasCorpWechat = hasCorpWechat;
        this.updateModeEnum = updateModeEnum;
        this.isAdmin = isAdmin;
        this.minPasswordLength = minPasswordLength;
        this.orgMapper = orgMapper;
        this.remoteEMCService = remoteEMCService;
        this.roleMapper = roleMapper;
        this.sysMapper = sysMapper;
        this.tenant = tenant;
        this.userCrudService = userCrudService;
        this.userRepository = userRepository;
        this.userInTenantCrudService = userInTenantCrudService;
        this.userInTenantOperationService = userInTenantOperationService;
        this.userMapper = userMapper;
        this.dmcService = dmcService;
    }

    public void invoke(ImportEnterpriseUserExcelVO userExcelVO, AnalysisContext analysisContext) {
        if (analysisContext.readRowHolder().getCellMap().isEmpty()) {
            return;
        }
        this.importEnterpriseUsers.add(userExcelVO);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        Map<Object, Object> existEmailUserMap = new HashMap();
        List<String> emailList = this.importEnterpriseUsers.stream().map(ImportEnterpriseUserExcelVO::getMail).filter(StringUtils::hasLength).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(emailList)) {
            List<User> emailUserList = this.userMapper.queryUserByTenantSidAndEmailList(this.tenant.getSid(), UserTypeEnum.INTERNAL.getCode(), emailList);
            existEmailUserMap = emailUserList.stream().collect(Collectors.toMap(User::getEmail, e -> e, (v1, v2) -> v1));
        }
        Map<Object, Object> existTelephoneUserMap = new HashMap();
        List<String> telephoneList = this.importEnterpriseUsers.stream().map(ImportEnterpriseUserExcelVO::getTelephone).filter(StringUtils::hasLength).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(telephoneList)) {
            List<User> telephoneUserList = this.userMapper.queryUserByTenantSidAndTelephoneList(this.tenant.getSid(), UserTypeEnum.INTERNAL.getCode(), telephoneList);
            existTelephoneUserMap = telephoneUserList.stream().collect(Collectors.toMap(User::getTelephone, e -> e, (v1, v2) -> v1));
        }
        Map<Object, Object> existUserMap = new HashMap();
        List<String> userIdList = this.importEnterpriseUsers.stream().map(user -> this.tenant.getId() + "$" + user.getId()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(userIdList)) {
            List<User> userList = this.userMapper.getUsersByTenantSidAndUserIds(this.tenant.getSid(), userIdList);
            existUserMap = userList.stream().collect(Collectors.toMap(BaseEntityWithId::getId, e -> e, (v1, v2) -> v1));
        }
        HashMap<String, SysQueryResultVO> existSysMap = new HashMap();
        List<String> appIdList = this.importEnterpriseUsers.stream().filter(user -> StringUtils.hasLength((String)user.getApps())).map(user -> user.getApps().split(SPLIT_REGEX)).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(appIdList)) {
            List<SysQueryResultVO> sysList = this.sysMapper.getSysVOListByTenant(this.tenant.getSid(), appIdList);
            existSysMap = sysList.stream().collect(Collectors.toMap(SysQueryResultVO::getId, v -> v, (v1, v2) -> v1));
        }
        HashMap<String, Role> roleMap = new HashMap();
        List<String> roleIdList = this.importEnterpriseUsers.stream().filter(user -> StringUtils.hasLength((String)user.getRoles())).map(user -> user.getRoles().split(SPLIT_REGEX)).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(roleIdList)) {
            List<Role> roleList = this.roleMapper.findInRoleIds(this.tenant.getSid(), roleIdList);
            roleMap = roleList.stream().collect(Collectors.toMap(Role::getId, v -> v, (v1, v2) -> v1));
        }
        HashMap<String, Org> orgMap = new HashMap();
        List<String> orgIdList = this.importEnterpriseUsers.stream().filter(user -> StringUtils.hasLength((String)user.getOrgs())).map(user -> user.getOrgs().split(SPLIT_REGEX)).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orgIdList)) {
            List<Org> orgList = this.orgMapper.getOrgsByTenantSidAndIds(this.tenant.getSid(), orgIdList);
            orgMap = orgList.stream().collect(Collectors.toMap(BaseEntityWithIdAndTenant::getId, v -> v, (v1, v2) -> v1));
        }
        for (ImportEnterpriseUserExcelVO userExcelVO : this.importEnterpriseUsers) {
            User existUser = (User)((Object)existUserMap.get(this.tenant.getId() + "$" + userExcelVO.getId()));
            if (ObjectUtils.isEmpty((Object)userExcelVO.getId())) {
                userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ERROR_EMPTY_ID.getMessage());
            } else if (null == existUser && Boolean.TRUE.equals(this.envProperties.getCheckUserId()) && UserIdValidator.validateUserId(userExcelVO.getId())) {
                userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ERROR_USER_ID_1.getMessage());
            }
            if (ObjectUtils.isEmpty((Object)userExcelVO.getName())) {
                userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ERROR_EMPTY_NAME.getMessage());
            }
            if (ObjectUtils.isEmpty((Object)userExcelVO.getPassword())) {
                userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ERROR_EMPTY_PASSWORD.getMessage());
            } else if (PasswordValidator.validateTenantCustomPassword(userExcelVO.getPassword()) || userExcelVO.getPassword().length() < this.minPasswordLength) {
                userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ERROR_PASSWORD.getMessage());
            }
            if (!ObjectUtils.isEmpty((Object)userExcelVO.getMail())) {
                User userExist;
                if (!StringUtil.checkEmail(userExcelVO.getMail())) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_EMAIL.getMessage());
                }
                if (null != (userExist = (User)((Object)existEmailUserMap.get(userExcelVO.getMail()))) && existUser != null && userExist.getSid() != existUser.getSid()) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_EMAIL_EXIST.getMessage());
                }
            }
            if (!ObjectUtils.isEmpty((Object)userExcelVO.getTelephone())) {
                User userExist;
                boolean checkMobilePhone = CellPhoneUtil.checkPhoneFormat(userExcelVO.getCellphonePrefix(), userExcelVO.getTelephone(), this.envProperties.getCountry());
                if (!checkMobilePhone) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_TELEPHONE.getMessage());
                }
                if (null != (userExist = (User)((Object)existTelephoneUserMap.get(userExcelVO.getTelephone()))) && existUser != null && userExist.getSid() != existUser.getSid()) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_TELEPHONE_EXIST.getMessage());
                }
                if (ObjectUtils.isEmpty((Object)userExcelVO.getCellphonePrefix()) || !CellphonePrefixEnum.prefixValid(userExcelVO.getCellphonePrefix())) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_CELLPHONE_PREFIX_INVALID_1.getMessage());
                }
            }
            if (!ObjectUtils.isEmpty((Object)userExcelVO.getWechat()) && this.hasCorpWechat) {
                if (ObjectUtils.isEmpty((Object)this.corpIdAndAppConfig.getCorpId())) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_TENANT_CORPID_NOT_EXIST.getMessage());
                } else if (!Boolean.TRUE.equals(this.corpIdAndAppConfig.getAppConfig())) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_TENANT_APPCONFIG_NOT_EXIST.getMessage());
                } else if (Objects.isNull(this.remoteEMCService.checkWechatExistReturnOpenUserId(null, this.tenant.getId(), userExcelVO.getWechat(), this.tenant.getId() + "$" + userExcelVO.getId()))) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_USER_WECHAT_ERROR.getMessage());
                }
            }
            if (this.consoleFlag && this.autoEOCFlag && ObjectUtils.isEmpty((Object)userExcelVO.getEmpId())) {
                userExcelVO.getErrorList().add(I18nCode.IAM_EXCEL_USER_EMP_EMPTY.getMessage());
            }
            ArrayList<GeneralParametersVO> roles = new ArrayList<GeneralParametersVO>();
            if (StringUtils.hasText((String)userExcelVO.getRoles())) {
                String[] roleIds = userExcelVO.getRoles().split(SPLIT_REGEX);
                if (Arrays.asList(roleIds).contains("superadmin") && !this.isAdmin) {
                    userExcelVO.getErrorList().add(I18nCode.EXCEL_IMPORT_USER_ROLE_SUPERADMIN_ERROR.getMessage());
                } else {
                    ArrayList<String> notExistsContentList = new ArrayList<String>();
                    for (String id : roleIds) {
                        this.checkExists(notExistsContentList, "role", roles, id, existSysMap, roleMap, orgMap);
                    }
                    if (!notExistsContentList.isEmpty()) {
                        String contents = String.join((CharSequence)"\u3001", notExistsContentList);
                        userExcelVO.getErrorList().add(String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_ID_EXISTED.getMessage(), contents));
                    }
                }
            }
            ArrayList<GeneralParametersVO> orgs = new ArrayList<GeneralParametersVO>();
            if (StringUtils.hasText((String)userExcelVO.getOrgs())) {
                String[] orgIds = userExcelVO.getOrgs().split(SPLIT_REGEX);
                ArrayList<String> notExistsContentList = new ArrayList<String>();
                for (String id : orgIds) {
                    this.checkExists(notExistsContentList, "org", orgs, id, existSysMap, roleMap, orgMap);
                }
                if (!notExistsContentList.isEmpty()) {
                    String contents = String.join((CharSequence)"\u3001", notExistsContentList);
                    userExcelVO.getErrorList().add(String.format(I18nCode.EXCEL_IMPORT_USER_ORG_ID_EXISTED.getMessage(), contents));
                }
            }
            ArrayList<GeneralParametersVO> apps = new ArrayList<GeneralParametersVO>();
            if (StringUtils.hasText((String)userExcelVO.getApps())) {
                String[] app = userExcelVO.getApps().split(SPLIT_REGEX);
                ArrayList<String> notExistsContentList = new ArrayList<String>();
                for (String id : app) {
                    this.checkExists(notExistsContentList, "app", apps, id, existSysMap, roleMap, orgMap);
                }
                if (!notExistsContentList.isEmpty()) {
                    String contents = String.join((CharSequence)"\u3001", notExistsContentList);
                    userExcelVO.getErrorList().add(String.format(I18nCode.EXCEL_IMPORT_USER_APP_ID_EXISTED.getMessage(), contents));
                }
            }
            Set intersection = apps.stream().map(GeneralParametersVO::getId).filter(this.bundleChildren::contains).collect(Collectors.toSet());
            if (!intersection.isEmpty()) {
                userExcelVO.getErrorList().add(String.join((CharSequence)"\u3001", intersection) + I18nCode.BUNDLE_CHILDREN_FORBIDDEN.getMessage());
            }
            if (userExcelVO.getErrorList().isEmpty()) {
                try {
                    List<GeneralParametersVO> authorizationFailureApps;
                    User user2 = new User();
                    if (existUser != null) {
                        user2 = existUser;
                    }
                    user2.setId(this.tenant.getId() + "$" + userExcelVO.getId());
                    user2.setName(userExcelVO.getName());
                    user2.setPassword(DigestUtils.sha256((String)userExcelVO.getPassword()));
                    user2.setCellphonePrefix(userExcelVO.getCellphonePrefix());
                    user2.setTelephone(userExcelVO.getTelephone());
                    user2.setEmail(userExcelVO.getMail());
                    user2.setActivated(true);
                    user2.setChanged(false);
                    user2.setType(UserTypeEnum.INTERNAL.getCode());
                    if (existUser != null) {
                        if (UpdateModeEnum.all.equals((Object)this.updateModeEnum)) {
                            EntityUtils.setModifyFields((BaseEntity)user2);
                            this.userRepository.save((Object)user2);
                            user2 = (User)this.userCrudService.findBySid(user2.getSid());
                        } else {
                            this.userCrudService.update((BaseEntity)user2);
                        }
                    } else {
                        long userSid = this.userCrudService.create((BaseEntity)user2);
                        user2 = (User)this.userCrudService.findBySid(userSid);
                        UserInTenant userInTenant = new UserInTenant();
                        userInTenant.setTenantSid(this.tenant.getSid());
                        userInTenant.setUserSid(userSid);
                        userInTenant.setUserType(TenantUserTypeEnum.NORMAL.getValue());
                        this.userInTenantCrudService.create(userInTenant);
                    }
                    userExcelVO.setUser(user2);
                    if (StringUtils.hasText((String)userExcelVO.getEmpId())) {
                        userExcelVO.setEmpUserVO(new EmpUserVO(this.tenant.getSid(), user2, userExcelVO.getEmpId()));
                    }
                    if (!(authorizationFailureApps = this.userInTenantOperationService.initializeUserData(this.tenant, user2, roles, orgs, this.authorizationResultVOMap, apps, TenantUserTypeEnum.NORMAL.getValue(), this.updateModeEnum)).isEmpty()) {
                        String collect = authorizationFailureApps.stream().map(GeneralParametersVO::getMessage).collect(Collectors.joining("\uff1b"));
                        this.logger.error("\u6279\u91cf\u5bfc\u5165\u4f01\u4e1a\u7528\u6237\uff0c\u7528\u6237\u6dfb\u52a0\u5e94\u7528\u6388\u6743\u5931\u8d25\uff0c\u7528\u6237id : {}, \u9519\u8bef\u4fe1\u606f : {}", (Object)user2.getId(), (Object)collect);
                    }
                }
                catch (Exception ex) {
                    userExcelVO.getErrorList().add(String.format(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_INFO.getMessage(), ex.getMessage()));
                    userExcelVO.setErrors(String.join((CharSequence)"\uff1b", userExcelVO.getErrorList()));
                    this.errorImportEnterpriseUsers.add(userExcelVO);
                    this.logger.error(I18nCode.EXCEL_IMPORT_ENTERPRISE_USER_ERROR_INFO.getMessage(), (Throwable)ex);
                }
            } else {
                userExcelVO.setErrors(String.join((CharSequence)"\uff1b", userExcelVO.getErrorList()));
                this.errorImportEnterpriseUsers.add(userExcelVO);
            }
            if (!userExcelVO.getErrorList().isEmpty()) continue;
            this.successImportEnterpriseUsers.add(userExcelVO);
        }
    }

    private void checkExists(List<String> notExistsContentList, String type, List<GeneralParametersVO> successResults, String subContent, Map<String, SysQueryResultVO> sysMap, Map<String, Role> roleMap, Map<String, Org> orgMap) {
        switch (type) {
            case "role": {
                if (!roleMap.containsKey(subContent)) {
                    notExistsContentList.add(subContent);
                    break;
                }
                this.addGeneralParameters(successResults, (Object)roleMap.get(subContent));
                break;
            }
            case "org": {
                if (!orgMap.containsKey(subContent)) {
                    notExistsContentList.add(subContent);
                    break;
                }
                this.addGeneralParameters(successResults, (Object)orgMap.get(subContent));
                break;
            }
            case "app": {
                if (this.canUseApps == null || !this.canUseApps.contains(subContent) || !sysMap.containsKey(subContent)) {
                    notExistsContentList.add(subContent);
                    break;
                }
                this.addGeneralParameters(successResults, sysMap.get(subContent));
                break;
            }
            default: {
                this.logger.error("\u672a\u77e5\u7684\u7c7b\u578b type: {}", (Object)type);
            }
        }
    }

    private void addGeneralParameters(List<GeneralParametersVO> successResults, Object entity) {
        GeneralParametersVO generalParametersVO = new GeneralParametersVO();
        if (entity instanceof Role) {
            Role role = (Role)((Object)entity);
            generalParametersVO.setId(role.getId());
            generalParametersVO.setName(role.getName());
            generalParametersVO.setSid(role.getSid());
        } else if (entity instanceof Org) {
            Org org = (Org)((Object)entity);
            generalParametersVO.setId(org.getId());
            generalParametersVO.setName(org.getName());
            generalParametersVO.setSid(org.getSid());
        } else if (entity instanceof SysQueryResultVO) {
            SysQueryResultVO sysQueryResultVO = (SysQueryResultVO)entity;
            generalParametersVO.setId(sysQueryResultVO.getId());
            generalParametersVO.setName(sysQueryResultVO.getName());
            generalParametersVO.setSid(sysQueryResultVO.getSid());
        }
        successResults.add(generalParametersVO);
    }

    public void bindingUserConsoleBatch(String userToken) {
        List<EmpUserVO> empUserVOList = this.successImportEnterpriseUsers.stream().map(ImportEnterpriseUserExcelVO::getEmpUserVO).filter(Objects::nonNull).collect(Collectors.toList());
        EmpUserBO bo = new EmpUserBO();
        bo.setConsole(this.consoleFlag);
        bo.setAutoEOC(this.autoEOCFlag);
        bo.setEmpUserVOList(empUserVOList);
        this.autoEOCService.userJoinTenant(bo, userToken);
    }

    public void updateWechat(String userToken) {
        for (ImportEnterpriseUserExcelVO vo : this.successImportEnterpriseUsers) {
            if (!StringUtils.hasText((String)vo.getWechat())) continue;
            this.userInTenantOperationService.updateWechat(this.tenant, vo.getUser(), vo.getWechat(), userToken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.warn("\u66f4\u65b0\u4f01\u4e1a\u5fae\u4fe1 Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public ImportExcelResultVO getBatchInvitedResult(boolean hasCorpWechat) {
        try {
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setSuccessCount(this.successImportEnterpriseUsers.size());
            importExcelResultVO.setErrorCount(this.errorImportEnterpriseUsers.size());
            if (!this.errorImportEnterpriseUsers.isEmpty()) {
                String fileName = String.format("error%s.xlsx", LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.PURE_DATETIME_FORMATTER));
                File file = new File(fileName);
                InputStream inputStream = hasCorpWechat ? (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_withWechat_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_withWechat_error_TW.xlsx").getInputStream()) : (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/enterprise_user_import_error_TW.xlsx").getInputStream());
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                if (hasCorpWechat) {
                    excelWriter.write(this.errorImportEnterpriseUsers, writeSheet);
                } else {
                    List errorImportEnterpriseWithoutWechatUsers = this.errorImportEnterpriseUsers.stream().map(ImportEnterpriseUserExcelWithoutWechatVO::new).collect(Collectors.toList());
                    excelWriter.write(errorImportEnterpriseWithoutWechatUsers, writeSheet);
                }
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    byte[] bytes = new byte[input.available()];
                    int read = input.read(bytes);
                    if (read <= 0) {
                        this.logger.error("no data to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo, 3, LocalDateTime.now().plusMonths(3L), true));
                }
                importExcelResultVO.setErrorFileName(fileName);
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }
}

