/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.excel.InvitedUserExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.InvitedUserExcelWithoutWechatVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.InvitedUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dmc.sdk.entity.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class InvitedExcelListener
extends AnalysisEventListener<InvitedUserExcelVO> {
    Logger logger = LoggerFactory.getLogger(InvitedExcelListener.class);
    private List<InvitedUserExcelVO> invitedUsers = new ArrayList<InvitedUserExcelVO>();
    private List<InvitedUserExcelVO> errorInvitedUsers = new ArrayList<InvitedUserExcelVO>();
    private EnvProperties envProperties;
    private RoleCrudService roleCrudService;
    private OrgCrudService orgCrudService;
    private TenantQueryService tenantQueryService;
    private UserRepository userRepository;
    private UserInTenantCrudService userInTenantCrudService;
    private TenantRelationWithUserService tenantRelationWithUserService;
    private SysCrudService sysCrudService;
    private DmcService dmcService;
    private boolean isAdmin;
    private TenantCorpConfigDTO corpIdAndAppConfig;
    private List<String> wechats;
    private boolean hasCorpWechat;
    private RemoteEocService remoteEocService;
    private AutoEOCService autoEOCService;
    private Set<String> bundleChildren;
    private UserCrudService userCrudService;

    public InvitedExcelListener(boolean isAdmin, EnvProperties envProperties, RoleCrudService roleCrudService, OrgCrudService orgCrudService, TenantQueryService tenantQueryService, UserRepository userRepository, UserInTenantCrudService userInTenantCrudService, TenantRelationWithUserService tenantRelationWithUserService, SysCrudService sysCrudService, DmcService dmcService, RemoteEocService remoteEocService, TenantCorpConfigDTO corpIdAndAppConfig, List<String> wechats, boolean hasCorpWechat, AutoEOCService autoEOCService, Set<String> bundleChildren, UserCrudService userCrudService) {
        this.isAdmin = isAdmin;
        this.envProperties = envProperties;
        this.roleCrudService = roleCrudService;
        this.orgCrudService = orgCrudService;
        this.tenantQueryService = tenantQueryService;
        this.userRepository = userRepository;
        this.userInTenantCrudService = userInTenantCrudService;
        this.tenantRelationWithUserService = tenantRelationWithUserService;
        this.sysCrudService = sysCrudService;
        this.dmcService = dmcService;
        this.remoteEocService = remoteEocService;
        this.corpIdAndAppConfig = corpIdAndAppConfig;
        this.wechats = wechats;
        this.hasCorpWechat = hasCorpWechat;
        this.autoEOCService = autoEOCService;
        this.bundleChildren = bundleChildren;
        this.userCrudService = userCrudService;
    }

    public void invoke(InvitedUserExcelVO invitedUserExcelVO, AnalysisContext analysisContext) {
        if (analysisContext.readRowHolder().getCellMap().size() > 0) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            Assert.notNull((Object)authoredUser, (String)I18nCode.EXCEL_INVITED_ERROR_NULL_TENANT.getMessage());
            long tenantSid = authoredUser.getTenantSid();
            if (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase())) {
                if (StringUtils.isEmpty((Object)invitedUserExcelVO.getTelephone()) && StringUtils.isEmpty((Object)invitedUserExcelVO.getMail())) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_INVITED_ERROR_EMPTY_TELEPHONE_EMAIL.getMessage());
                } else {
                    this.checkTelephone(invitedUserExcelVO, authoredUser, "cn");
                }
                this.checkEmail(invitedUserExcelVO, authoredUser);
            } else {
                if (StringUtils.isEmpty((Object)invitedUserExcelVO.getTelephone()) && StringUtils.isEmpty((Object)invitedUserExcelVO.getMail())) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_INVITED_ERROR_EMPTY_TELEPHONE_EMAIL.getMessage());
                } else {
                    this.checkEmail(invitedUserExcelVO, authoredUser);
                }
                this.checkTelephone(invitedUserExcelVO, authoredUser, "tw");
            }
            ArrayList<GeneralParametersVO> roles = new ArrayList<GeneralParametersVO>();
            this.checkRoleOrOrgOrApps(invitedUserExcelVO, invitedUserExcelVO.getRoles(), "role", authoredUser, roles);
            ArrayList<GeneralParametersVO> orgs = new ArrayList<GeneralParametersVO>();
            String errorOrg = this.checkRoleOrOrgOrApps(invitedUserExcelVO, invitedUserExcelVO.getOrgs(), "org", authoredUser, orgs);
            if (!StringUtils.isEmpty((Object)errorOrg)) {
                invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_ORG.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors(), errorOrg, authoredUser.getTenantId()));
            }
            ArrayList<GeneralParametersVO> apps = new ArrayList<GeneralParametersVO>();
            String errorApp = this.checkRoleOrOrgOrApps(invitedUserExcelVO, invitedUserExcelVO.getApps(), "app", authoredUser, apps);
            if (!StringUtils.isEmpty((Object)errorApp)) {
                invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_BUY_APPLICATION.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors(), authoredUser.getTenantId(), errorApp));
            }
            if (!StringUtils.isEmpty((Object)invitedUserExcelVO.getWechat()) && this.hasCorpWechat) {
                if (StringUtils.isEmpty((Object)this.corpIdAndAppConfig.getCorpId())) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_IMPORT_TENANT_CORPID_NOT_EXIST.getMessage());
                } else if (!Boolean.TRUE.equals(this.corpIdAndAppConfig.getAppConfig())) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_IMPORT_TENANT_APPCONFIG_NOT_EXIST.getMessage());
                } else if (!this.wechats.contains(invitedUserExcelVO.getWechat())) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_IMPORT_USER_WECHAT_NOT_IN_TENANT.getMessage());
                }
            }
            this.checkUserType(invitedUserExcelVO);
            String inviteContent = String.format(I18nCode.EXCEL_INVITED_CONTENT.getMessage(), authoredUser.getTenantName());
            if (!StringUtils.isEmpty((Object)invitedUserExcelVO.getLanguage())) {
                StringBuilder exitInfo = this.checkLanguage(invitedUserExcelVO.getLanguage());
                if (!StringUtils.isEmpty((Object)exitInfo.toString())) {
                    invitedUserExcelVO.setErrors(String.format("%s, %s", StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors(), exitInfo));
                }
                inviteContent = String.format(I18nCode.EXCEL_INVITED_CONTENT.getMessageForLanguage(invitedUserExcelVO.getLanguage()), authoredUser.getTenantName());
            }
            if (this.autoEOCService.isConsole(tenantSid) && this.autoEOCService.isAutoEOC(tenantSid) && !"1".equals(invitedUserExcelVO.getUserType()) && StringUtils.isEmpty((Object)invitedUserExcelVO.getEmpId())) {
                invitedUserExcelVO.setErrors(I18nCode.IAM_EXCEL_USER_EMP_EMPTY.getMessage());
            }
            for (GeneralParametersVO app : apps) {
                if (!this.bundleChildren.contains(app.getId())) continue;
                invitedUserExcelVO.setErrors(String.format("%s;" + I18nCode.BUNDLE_CHILDREN_FORBIDDEN.getMessage(), invitedUserExcelVO.getErrors()));
                break;
            }
            if (StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors())) {
                try {
                    InvitedUserVO invitedUserVO = new InvitedUserVO();
                    invitedUserVO.setUser(StringUtils.isEmpty((Object)invitedUserExcelVO.getMail()) ? invitedUserExcelVO.getTelephone() : invitedUserExcelVO.getMail());
                    invitedUserVO.setContent(inviteContent);
                    invitedUserVO.setRole(roles);
                    invitedUserVO.setOrg(orgs);
                    invitedUserVO.setApp(apps);
                    if ("1".equals(invitedUserExcelVO.getUserType())) {
                        invitedUserVO.setUserType(true);
                    } else if ("0".equals(invitedUserExcelVO.getUserType())) {
                        invitedUserVO.setUserType(false);
                    }
                    invitedUserVO.setWechat(invitedUserExcelVO.getWechat());
                    invitedUserVO.setLanguage(invitedUserExcelVO.getLanguage());
                    if (this.autoEOCService.isConsole(tenantSid) && !StringUtils.isEmpty((Object)invitedUserExcelVO.getEmpId())) {
                        invitedUserVO.setEmpId(invitedUserExcelVO.getEmpId());
                    }
                    this.invitedUsers.add(invitedUserExcelVO);
                    this.tenantRelationWithUserService.invitedUserJoin(tenantSid, invitedUserVO, true);
                }
                catch (Exception ex) {
                    invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_INFO.getMessage(), ex.getMessage()));
                    this.errorInvitedUsers.add(invitedUserExcelVO);
                    this.logger.error(ex.getMessage());
                }
            } else {
                String lastError = invitedUserExcelVO.getErrors().startsWith(",") ? invitedUserExcelVO.getErrors().substring(1) : invitedUserExcelVO.getErrors();
                invitedUserExcelVO.setErrors(lastError);
                this.errorInvitedUsers.add(invitedUserExcelVO);
            }
        }
    }

    private void checkEmail(InvitedUserExcelVO invitedUserExcelVO, AuthoredUser authoredUser) {
        try {
            if (!StringUtils.isEmpty((Object)invitedUserExcelVO.getMail())) {
                if (!StringUtil.checkEmail(invitedUserExcelVO.getMail())) {
                    invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_EMAIL.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors()));
                } else {
                    User user = this.userRepository.findFirstByEmailAndType(invitedUserExcelVO.getMail(), 0);
                    if (null != user && user.getType().equals(1)) {
                        invitedUserExcelVO.setErrors(I18nCode.EXCEL_INVITED_ERROR_USER_TYPE.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            invitedUserExcelVO.setErrors(String.format("%s,%s", invitedUserExcelVO.getErrors(), ex.getMessage()));
        }
    }

    private void checkUserType(InvitedUserExcelVO invitedUserExcelVO) {
        if (!("1".equals(invitedUserExcelVO.getUserType()) || "0".equals(invitedUserExcelVO.getUserType()) || StringUtils.isEmpty((Object)invitedUserExcelVO.getUserType()))) {
            invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_USER_TYPE_FORMAT.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors()));
        }
    }

    private StringBuilder checkLanguage(String language) {
        if (IamConstants.DW_LANGUAGE_LIST.contains(language)) {
            return new StringBuilder();
        }
        return new StringBuilder(I18nCode.EXCEL_IMPORT_USER_LANGUAGE_ERROR.getMessage());
    }

    private void checkTelephone(InvitedUserExcelVO invitedUserExcelVO, AuthoredUser authoredUser, String area) {
        try {
            if (!StringUtils.isEmpty((Object)invitedUserExcelVO.getTelephone())) {
                User user;
                if (area.equals("tw")) {
                    if (!StringUtil.checkTWMobilePhone(invitedUserExcelVO.getTelephone())) {
                        invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_TELEPHONE.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors()));
                    }
                } else if (!StringUtil.checkMobilePhone(invitedUserExcelVO.getTelephone())) {
                    invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_TELEPHONE.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors()));
                }
                if (null != (user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(invitedUserExcelVO.getTelephone(), invitedUserExcelVO.getTelephone(), invitedUserExcelVO.getTelephone(), 0)) && user.getType().equals(1)) {
                    invitedUserExcelVO.setErrors(I18nCode.EXCEL_INVITED_ERROR_USER_TYPE.getMessage());
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            invitedUserExcelVO.setErrors(String.format("%s,%s", invitedUserExcelVO.getErrors(), ex.getMessage()));
        }
    }

    private String checkRoleOrOrgOrApps(InvitedUserExcelVO invitedUserExcelVO, String content, String type, AuthoredUser authoredUser, List<GeneralParametersVO> successResults) {
        String errorInfo = "";
        try {
            if (!StringUtils.isEmpty((Object)content)) {
                List<String> canUserApps = null;
                if (type.equals("app")) {
                    canUserApps = this.tenantQueryService.getTenantApplication(authoredUser.getTenantId(), GoodsCategoryEnum.getApps(false));
                }
                String roleAdminErrorInfo = "";
                if (content.contains(",") || content.contains("\uff0c")) {
                    String[] subContents;
                    String regex = ",|\uff0c|\\s+";
                    for (String subContent : subContents = content.split(regex)) {
                        if ("role".equals(type) && !this.isAdmin && "superadmin".equals(subContent)) {
                            roleAdminErrorInfo = String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_SUPERADMIN_ERROR.getMessage(), errorInfo);
                            continue;
                        }
                        errorInfo = this.checkRoleOrOrgOrApp(errorInfo, type, authoredUser, successResults, subContent, canUserApps);
                    }
                } else if ("role".equals(type) && !this.isAdmin && "superadmin".equals(content)) {
                    roleAdminErrorInfo = String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_SUPERADMIN_ERROR.getMessage(), errorInfo);
                } else {
                    errorInfo = this.checkRoleOrOrgOrApp(errorInfo, type, authoredUser, successResults, content, canUserApps);
                }
                if ("role".equals(type)) {
                    if (!StringUtils.isEmpty((Object)errorInfo)) {
                        invitedUserExcelVO.setErrors(String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_ROLE.getMessage(), StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors(), errorInfo, authoredUser.getTenantId()));
                    }
                    if (!StringUtils.isEmpty((Object)roleAdminErrorInfo)) {
                        invitedUserExcelVO.setErrors(String.format("%s,%s", StringUtils.isEmpty((Object)invitedUserExcelVO.getErrors()) ? "" : invitedUserExcelVO.getErrors(), roleAdminErrorInfo));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            errorInfo = ex.getMessage();
        }
        return errorInfo;
    }

    private String checkRoleOrOrgOrApp(String errorInfo, String type, AuthoredUser authoredUser, List<GeneralParametersVO> successResults, String subContent, List<String> canUserApps) {
        if (type.equals("role")) {
            if (!this.roleCrudService.existsByTenantSidAndId(authoredUser.getTenantSid(), subContent)) {
                errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
            } else {
                Role role = this.roleCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), subContent);
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(role.getId());
                generalParametersVO.setName(role.getName());
                generalParametersVO.setSid(role.getSid());
                successResults.add(generalParametersVO);
            }
        } else if (type.equals("org")) {
            if (!this.orgCrudService.existsByTenantSidAndId(authoredUser.getTenantSid(), subContent)) {
                errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
            } else {
                List<Org> orgs = this.orgCrudService.findByTenantSidAndId(authoredUser.getTenantSid(), subContent);
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(orgs.get(0).getId());
                generalParametersVO.setName(orgs.get(0).getName());
                generalParametersVO.setSid(orgs.get(0).getSid());
                successResults.add(generalParametersVO);
            }
        } else if (canUserApps == null || !canUserApps.contains(subContent)) {
            errorInfo = StringUtils.isEmpty((Object)errorInfo) ? subContent : String.format("%s;%s", errorInfo, subContent);
        } else {
            Sys sys = (Sys)this.sysCrudService.findById(subContent);
            if (sys == null) {
                errorInfo = String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_APP.getMessage(), errorInfo, subContent);
            } else {
                GeneralParametersVO generalParametersVO = new GeneralParametersVO();
                generalParametersVO.setId(sys.getId());
                generalParametersVO.setName(sys.getName());
                generalParametersVO.setSid(sys.getSid());
                successResults.add(generalParametersVO);
            }
        }
        return errorInfo;
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public ImportExcelResultVO getBatchInvitedResult(boolean hasCorpWechat) {
        try {
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setSuccessCount(this.invitedUsers.size());
            Integer count = this.errorInvitedUsers.size();
            for (InvitedUserExcelVO error : this.errorInvitedUsers) {
                if (null == error.getEmpExist() || error.getEmpExist().booleanValue()) continue;
                count = this.errorInvitedUsers.size() - 1;
            }
            importExcelResultVO.setErrorCount(count);
            if (this.errorInvitedUsers.size() > 0) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = String.format("error%s.xlsx", localTime);
                File file = new File(fileName);
                InputStream inputStream = hasCorpWechat ? (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_invite_template_withWechat_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_invite_template_withWechat_error_TW.xlsx").getInputStream()) : (!Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_invite_template_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_invite_template_error_TW.xlsx").getInputStream());
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                if (hasCorpWechat) {
                    excelWriter.write(this.errorInvitedUsers, writeSheet);
                } else {
                    List errorInvitedUserWithoutWechatVOs = this.errorInvitedUsers.stream().map(InvitedUserExcelWithoutWechatVO::new).collect(Collectors.toList());
                    excelWriter.write(errorInvitedUserWithoutWechatVOs, writeSheet);
                }
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        this.logger.error("no data to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo, 3, LocalDateTime.now().plusMonths(3L), true));
                }
                importExcelResultVO.setErrorFileName(fileName);
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }
}

