/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.excel.OrgExcelVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OrgExcelListener
extends AnalysisEventListener<OrgExcelVO> {
    Logger logger = LoggerFactory.getLogger(OrgExcelListener.class);
    private List<OrgExcelVO> orgExcelVOS = new ArrayList<OrgExcelVO>();
    private List<OrgExcelVO> errOrgExcelVOS = new ArrayList<OrgExcelVO>();
    private OrgCatalogCrudService orgCatalogCrudService;
    private OrgTypeCrudService orgTypeCrudService;
    private OrgAspectCrudService orgAspectCrudService;
    private OrgCrudService orgCrudService;
    private long tenantSid;

    public List<OrgExcelVO> getOrgExcelVOS() {
        return this.orgExcelVOS;
    }

    public void setOrgExcelVOS(List<OrgExcelVO> orgExcelVOS) {
        this.orgExcelVOS = orgExcelVOS;
    }

    public List<OrgExcelVO> getErrOrgExcelVOS() {
        return this.errOrgExcelVOS;
    }

    public void setErrOrgExcelVOS(List<OrgExcelVO> errOrgExcelVOS) {
        this.errOrgExcelVOS = errOrgExcelVOS;
    }

    public OrgExcelListener(OrgCatalogCrudService orgCatalogCrudService, OrgTypeCrudService orgTypeCrudService, OrgAspectCrudService orgAspectCrudService, OrgCrudService orgCrudService, long tenantSid) {
        this.orgCatalogCrudService = orgCatalogCrudService;
        this.orgTypeCrudService = orgTypeCrudService;
        this.orgAspectCrudService = orgAspectCrudService;
        this.orgCrudService = orgCrudService;
        this.tenantSid = tenantSid;
    }

    public void invoke(OrgExcelVO orgExcelVO, AnalysisContext analysisContext) {
        if (analysisContext.readRowHolder().getCellMap().size() > 0) {
            long orgAspectSid;
            if (StringUtils.isEmpty((Object)orgExcelVO.getOrgCatalogId()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgCatalogName()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgAspectId()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgAspectName()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgUri()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgUrn())) {
                this.errOrgExcelVOS.add(orgExcelVO);
                return;
            }
            String orgUri = orgExcelVO.getOrgUri().substring("drn:iam:org:".length());
            String[] orgIdUri = orgUri.split(":");
            String[] orgNameUrn = orgExcelVO.getOrgUrn().split(":");
            int orgIdUriLength = orgIdUri.length;
            int orgNameUrnLength = orgNameUrn.length;
            if (orgNameUrnLength < 3 || orgIdUriLength != orgNameUrnLength) {
                this.errOrgExcelVOS.add(orgExcelVO);
                return;
            }
            long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(this.tenantSid, orgExcelVO.getOrgCatalogId());
            if (orgCatalogSid == 0L) {
                OrgCatalog orgCatalog = new OrgCatalog();
                orgCatalog.setId(orgExcelVO.getOrgCatalogId());
                orgCatalog.setName(orgExcelVO.getOrgCatalogName());
                orgCatalog.setTenantSid(this.tenantSid);
                orgCatalogSid = this.orgCatalogCrudService.create((BaseEntity)orgCatalog);
            }
            if ((orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{this.tenantSid, orgCatalogSid, orgExcelVO.getOrgAspectId()})) == 0L) {
                OrgAspect orgAspect = new OrgAspect();
                orgAspect.setId(orgExcelVO.getOrgAspectId());
                orgAspect.setName(orgExcelVO.getOrgAspectName());
                orgAspect.setOrgCatalogSid(orgCatalogSid);
                orgAspectSid = this.orgAspectCrudService.create((BaseEntity)orgAspect);
            }
            long newOrgTypeParentSid = 0L;
            if (!StringUtils.isEmpty((Object)orgExcelVO.getOrgTypeId()) && !StringUtils.isEmpty((Object)orgExcelVO.getOrgTypeName())) {
                if (StringUtils.isEmpty((Object)orgExcelVO.getOrgTypeUri()) || StringUtils.isEmpty((Object)orgExcelVO.getOrgTypeUrn())) {
                    this.errOrgExcelVOS.add(orgExcelVO);
                    return;
                }
                String orgTypeUri = orgExcelVO.getOrgTypeUri().substring("drn:iam:orgtype:".length());
                String[] orgTypeIdUri = orgTypeUri.split(":");
                String[] orgTypeNameUrn = orgExcelVO.getOrgTypeUrn().split(":");
                int orgTypeIdUriLength = orgTypeIdUri.length;
                int orgTypeNameUrnLength = orgTypeNameUrn.length;
                if (orgTypeIdUriLength < 2 || orgTypeIdUriLength != orgTypeNameUrnLength) {
                    this.errOrgExcelVOS.add(orgExcelVO);
                    return;
                }
                StringBuilder newOrgTypeUri = new StringBuilder();
                newOrgTypeUri.append("drn:iam:orgtype:");
                StringBuilder newOrgTypeUrn = new StringBuilder();
                for (int i = 1; i < orgTypeIdUriLength; ++i) {
                    long orgTypeSid = this.orgTypeCrudService.getSidByUnionKey(this.tenantSid, orgCatalogSid, orgTypeIdUri[i]);
                    newOrgTypeUri.append(orgTypeIdUri[i]).append(":");
                    newOrgTypeUrn.append(orgTypeNameUrn[i]).append(":");
                    if (orgTypeSid != 0L) continue;
                    OrgType orgType = new OrgType();
                    orgType.setId(orgTypeIdUri[i]);
                    orgType.setName(orgTypeNameUrn[i]);
                    orgType.setParentSid(newOrgTypeParentSid);
                    orgType.setOrgCatalogSid(orgCatalogSid);
                    orgType.setUri(newOrgTypeUri.toString().substring(0, newOrgTypeUri.toString().length() - 1));
                    orgType.setUrn(newOrgTypeUrn.toString().substring(0, newOrgTypeUrn.toString().length() - 1));
                    orgType.setTenantSid(this.tenantSid);
                    newOrgTypeParentSid = this.orgTypeCrudService.create((BaseEntity)orgType);
                }
            }
            StringBuilder newOrgUri = new StringBuilder();
            newOrgUri.append("drn:iam:org:");
            StringBuilder newOrgUrn = new StringBuilder();
            long newOrgParentSid = 0L;
            for (int i = 2; i < orgIdUriLength; ++i) {
                long orgSid = this.orgCrudService.getSidByUnionKey(new Object[]{this.tenantSid, orgAspectSid, orgIdUri[i], newOrgParentSid});
                newOrgUri.append(orgIdUri[i]).append(":");
                newOrgUrn.append(orgNameUrn[i]).append(":");
                if (orgSid != 0L) continue;
                Org org = new Org();
                org.setId(orgIdUri[i]);
                org.setName(orgNameUrn[i]);
                org.setParentSid(newOrgParentSid);
                org.setOrgAspectSid(orgAspectSid);
                org.setOrgTypeSid(newOrgTypeParentSid);
                org.setUri(newOrgUri.toString().substring(0, newOrgUri.toString().length() - 1));
                org.setUrn(newOrgUrn.toString().substring(0, newOrgUrn.toString().length() - 1));
                org.setTenantSid(this.tenantSid);
                newOrgParentSid = this.orgCrudService.create((BaseEntity)org);
            }
        }
        this.orgExcelVOS.add(orgExcelVO);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }
}

