/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.excel.RoleExcelVO;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RoleExcelListener
extends AnalysisEventListener<RoleExcelVO> {
    Logger logger = LoggerFactory.getLogger(RoleExcelListener.class);
    private List<RoleExcelVO> roleExcelVOS = new ArrayList<RoleExcelVO>();
    private List<RoleExcelVO> errRoleExcelVOS = new ArrayList<RoleExcelVO>();
    private RoleCatalogCrudService roleCatalogCrudService;
    private RoleCrudService roleCrudService;
    private OrgCatalogCrudService orgCatalogCrudService;
    private OrgAspectCrudService orgAspectCrudService;
    private OrgTypeCrudService orgTypeCrudService;
    private OrgCrudService orgCrudService;
    private long tenantSid;

    public List<RoleExcelVO> getRoleExcelVOS() {
        return this.roleExcelVOS;
    }

    public void setRoleExcelVOS(List<RoleExcelVO> roleExcelVOS) {
        this.roleExcelVOS = roleExcelVOS;
    }

    public List<RoleExcelVO> getErrRoleExcelVOS() {
        return this.errRoleExcelVOS;
    }

    public void setErrRoleExcelVOS(List<RoleExcelVO> errRoleExcelVOS) {
        this.errRoleExcelVOS = errRoleExcelVOS;
    }

    public RoleExcelListener(RoleCatalogCrudService roleCatalogCrudService, RoleCrudService roleCrudService, OrgCatalogCrudService orgCatalogCrudService, OrgAspectCrudService orgAspectCrudService, OrgTypeCrudService orgTypeCrudService, long tenantSid, OrgCrudService orgCrudService) {
        this.roleCatalogCrudService = roleCatalogCrudService;
        this.roleCrudService = roleCrudService;
        this.orgCatalogCrudService = orgCatalogCrudService;
        this.orgAspectCrudService = orgAspectCrudService;
        this.orgTypeCrudService = orgTypeCrudService;
        this.tenantSid = tenantSid;
        this.orgCrudService = orgCrudService;
    }

    public void invoke(RoleExcelVO roleExcelVO, AnalysisContext analysisContext) {
        if (!analysisContext.readRowHolder().getCellMap().isEmpty()) {
            long roleSid;
            long roleCatalogSid;
            if (StringUtils.isEmpty((Object)roleExcelVO.getRoleId()) || StringUtils.isEmpty((Object)roleExcelVO.getRoleName()) || StringUtils.isEmpty((Object)roleExcelVO.getRoleCatalogId()) || StringUtils.isEmpty((Object)roleExcelVO.getRoleCatalogName())) {
                this.errRoleExcelVOS.add(roleExcelVO);
                return;
            }
            long newOrgParentSid = 0L;
            if (!StringUtils.isEmpty((Object)roleExcelVO.getOrgId())) {
                long orgAspectSid;
                if (StringUtils.isEmpty((Object)roleExcelVO.getOrgUri()) || StringUtils.isEmpty((Object)roleExcelVO.getOrgUrn())) {
                    this.errRoleExcelVOS.add(roleExcelVO);
                    return;
                }
                String orgUri = roleExcelVO.getOrgUri().substring("drn:iam:org:".length());
                String[] orgIdUri = orgUri.split(":");
                String[] orgNameUrn = roleExcelVO.getOrgUrn().split(":");
                int orgIdUriLength = orgIdUri.length;
                int orgNameUrnLength = orgNameUrn.length;
                if (orgNameUrnLength < 3 || orgIdUriLength != orgNameUrnLength) {
                    this.errRoleExcelVOS.add(roleExcelVO);
                    return;
                }
                long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(this.tenantSid, orgIdUri[0]);
                if (orgCatalogSid == 0L) {
                    OrgCatalog orgCatalog = new OrgCatalog();
                    orgCatalog.setId(orgIdUri[0]);
                    orgCatalog.setName(orgNameUrn[0]);
                    orgCatalog.setTenantSid(this.tenantSid);
                    orgCatalogSid = this.orgCatalogCrudService.create((BaseEntity)orgCatalog);
                }
                if ((orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{this.tenantSid, orgCatalogSid, orgIdUri[1]})) == 0L) {
                    OrgAspect orgAspect = new OrgAspect();
                    orgAspect.setId(orgIdUri[1]);
                    orgAspect.setName(orgNameUrn[1]);
                    orgAspect.setOrgCatalogSid(orgCatalogSid);
                    orgAspectSid = this.orgAspectCrudService.create((BaseEntity)orgAspect);
                }
                long newOrgTypeParentSid = 0L;
                if (!StringUtils.isEmpty((Object)roleExcelVO.getOrgTypeId()) && !StringUtils.isEmpty((Object)roleExcelVO.getOrgTypeName())) {
                    if (StringUtils.isEmpty((Object)roleExcelVO.getOrgTypeUri()) || StringUtils.isEmpty((Object)roleExcelVO.getOrgTypeUrn())) {
                        this.errRoleExcelVOS.add(roleExcelVO);
                        return;
                    }
                    String orgTypeUri = roleExcelVO.getOrgTypeUri().substring("drn:iam:orgtype:".length());
                    String[] orgTypeIdUri = orgTypeUri.split(":");
                    String[] orgTypeNameUrn = roleExcelVO.getOrgTypeUrn().split(":");
                    int orgTypeIdUriLength = orgTypeIdUri.length;
                    int orgTypeNameUrnLength = orgTypeNameUrn.length;
                    if (orgTypeIdUriLength < 2 || orgTypeIdUriLength != orgTypeNameUrnLength) {
                        this.errRoleExcelVOS.add(roleExcelVO);
                        return;
                    }
                    StringBuilder newOrgTypeUri = new StringBuilder();
                    newOrgTypeUri.append("drn:iam:orgtype:");
                    StringBuilder newOrgTypeUrn = new StringBuilder();
                    for (int i = 1; i < orgTypeIdUriLength; ++i) {
                        long orgTypeSid = this.orgTypeCrudService.getSidByUnionKey(this.tenantSid, orgCatalogSid, orgTypeIdUri[i]);
                        newOrgTypeUri.append(orgTypeIdUri[i]).append(":");
                        newOrgTypeUrn.append(orgTypeNameUrn[i]).append(":");
                        if (orgTypeSid != 0L) continue;
                        OrgType orgType = new OrgType();
                        orgType.setId(orgTypeIdUri[i]);
                        orgType.setName(orgTypeNameUrn[i]);
                        orgType.setParentSid(newOrgTypeParentSid);
                        orgType.setOrgCatalogSid(orgCatalogSid);
                        orgType.setUri(newOrgTypeUri.toString().substring(0, newOrgTypeUri.toString().length() - 1));
                        orgType.setUrn(newOrgTypeUrn.toString().substring(0, newOrgTypeUrn.toString().length() - 1));
                        orgType.setTenantSid(this.tenantSid);
                        newOrgTypeParentSid = this.orgTypeCrudService.create((BaseEntity)orgType);
                    }
                }
                StringBuilder newOrgUri = new StringBuilder();
                newOrgUri.append("drn:iam:org:");
                StringBuilder newOrgUrn = new StringBuilder();
                for (int i = 2; i < orgIdUriLength; ++i) {
                    long orgSid = this.orgCrudService.getSidByUnionKey(new Object[]{this.tenantSid, orgAspectSid, orgIdUri[i], newOrgParentSid});
                    newOrgUri.append(orgIdUri[i]).append(":");
                    newOrgUrn.append(orgNameUrn[i]).append(":");
                    if (orgSid != 0L) continue;
                    Org org = new Org();
                    org.setId(orgIdUri[i]);
                    org.setName(orgNameUrn[i]);
                    org.setParentSid(newOrgParentSid);
                    org.setOrgAspectSid(orgAspectSid);
                    org.setOrgTypeSid(newOrgTypeParentSid);
                    org.setUri(newOrgUri.toString().substring(0, newOrgUri.toString().length() - 1));
                    org.setUrn(newOrgUrn.toString().substring(0, newOrgUrn.toString().length() - 1));
                    org.setTenantSid(this.tenantSid);
                    newOrgParentSid = this.orgCrudService.create((BaseEntity)org);
                }
            }
            if ((roleCatalogSid = this.roleCatalogCrudService.getSidByTenantAndId(this.tenantSid, roleExcelVO.getRoleCatalogId())) == 0L) {
                RoleCatalog roleCatalog = new RoleCatalog();
                roleCatalog.setName(roleExcelVO.getRoleCatalogName());
                roleCatalog.setId(roleExcelVO.getRoleCatalogId());
                roleCatalog.setTenantSid(this.tenantSid);
                roleCatalogSid = this.roleCatalogCrudService.create((BaseEntity)roleCatalog);
            }
            if ((roleSid = this.roleCrudService.getSidByTenantAndId(this.tenantSid, roleExcelVO.getRoleId())) == 0L) {
                Role role = new Role();
                role.setId(roleExcelVO.getRoleId());
                role.setName(roleExcelVO.getRoleName());
                if (!StringUtils.isEmpty((Object)roleExcelVO.getPriority())) {
                    role.setPriority(Integer.parseInt(roleExcelVO.getPriority()));
                }
                role.setRoleCatalogSid(roleCatalogSid);
                role.setOrgSid(newOrgParentSid);
                if (StringUtils.isEmpty((Object)roleExcelVO.getReadonly())) {
                    role.setReadonly(Boolean.parseBoolean(roleExcelVO.getReadonly()));
                }
                role.setUri(roleExcelVO.getOrgUri() + ":" + role.getId());
                role.setUrn(roleExcelVO.getOrgUrn() + ":" + role.getName());
                role.setTenantSid(this.tenantSid);
            }
        }
        this.roleExcelVOS.add(roleExcelVO);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }
}

