/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.excel.RoleExcelNewVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RoleExcelNewListener
extends AnalysisEventListener<RoleExcelNewVO> {
    Logger logger = LoggerFactory.getLogger(RoleExcelNewListener.class);
    private List<RoleExcelNewVO> success = new ArrayList<RoleExcelNewVO>();
    private List<RoleExcelNewVO> failed = new ArrayList<RoleExcelNewVO>();
    private RoleCatalogCrudService roleCatalogCrudService;
    private RoleCrudService roleCrudService;
    private long tenantSid;
    private LanguageCrudService languageCrudService;

    public RoleExcelNewListener(RoleCatalogCrudService roleCatalogCrudService, RoleCrudService roleCrudService, long tenantSid, LanguageCrudService languageCrudService) {
        this.roleCatalogCrudService = roleCatalogCrudService;
        this.roleCrudService = roleCrudService;
        this.tenantSid = tenantSid;
        this.languageCrudService = languageCrudService;
    }

    public void invoke(RoleExcelNewVO data, AnalysisContext analysisContext) {
        if (!analysisContext.readRowHolder().getCellMap().isEmpty()) {
            String defaultCatalogId = "defaultRoleCatalog";
            String error = this.checkInput(data);
            if (StringUtils.hasLength((String)error)) {
                data.setErrors(error);
                this.failed.add(data);
            } else {
                try {
                    RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(this.tenantSid, defaultCatalogId);
                    long roleCatalogSid = roleCatalog.getSid();
                    Role role = this.roleCrudService.findByTenantSidAndId(this.tenantSid, data.getRoleId());
                    if (role != null) {
                        role.setName(data.getRoleName());
                        role.setRemark(data.getRemark());
                        this.roleCrudService.update((BaseEntity)role);
                    } else {
                        role = new Role();
                        role.setTenantSid(this.tenantSid);
                        role.setId(data.getRoleId());
                        role.setName(data.getRoleName());
                        role.setRemark(data.getRemark());
                        role.setRoleCatalogSid(roleCatalogSid);
                        this.roleCrudService.create((BaseEntity)role);
                    }
                    this.languageCrudService.save(role.getSid(), "roleName", role.getName());
                    this.success.add(data);
                }
                catch (Exception e) {
                    this.failed.add(data);
                    data.setErrors(e.getMessage());
                    this.logger.error("import role failed", (Throwable)e);
                }
            }
        }
    }

    private String checkInput(RoleExcelNewVO data) {
        ArrayList<String> errors = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)data.getRoleId())) {
            errors.add(I18nError.IAM_EXCEL_ROLE_ID.getMessage(new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)data.getRoleName())) {
            errors.add(I18nError.IAM_EXCEL_ROLE_NAME.getMessage(new Object[0]));
        }
        if (errors.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)";", errors);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public List<RoleExcelNewVO> getSuccess() {
        return this.success;
    }

    public void setSuccess(List<RoleExcelNewVO> success) {
        this.success = success;
    }

    public List<RoleExcelNewVO> getFailed() {
        return this.failed;
    }

    public void setFailed(List<RoleExcelNewVO> failed) {
        this.failed = failed;
    }
}

