/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.iam.domain.excel.TenantExcelVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Scope(value="prototype")
public class TenantExcelListener
extends AnalysisEventListener<TenantExcelVO> {
    private List<TenantExcelVO> importSuccessResults = new ArrayList<TenantExcelVO>();
    private List<TenantExcelVO> errorResults = new ArrayList<TenantExcelVO>();

    public void invoke(TenantExcelVO tenantExcelVO, AnalysisContext analysisContext) {
        if (analysisContext.readRowHolder().getCellMap().size() > 0) {
            String errorMessage = "";
            if (!StringUtils.hasText((String)tenantExcelVO.getId())) {
                errorMessage = "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (!StringUtils.hasText((String)tenantExcelVO.getContacts())) {
                String string = errorMessage = StringUtils.hasText((String)errorMessage) ? String.format("%s;\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a", errorMessage) : "\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.hasText((String)errorMessage)) {
                tenantExcelVO.setRemark(errorMessage);
                this.errorResults.add(tenantExcelVO);
            } else {
                this.importSuccessResults.add(tenantExcelVO);
            }
        }
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public List<TenantExcelVO> getImportSuccessResults() {
        return this.importSuccessResults;
    }

    public List<TenantExcelVO> getErrorResults() {
        return this.errorResults;
    }
}

