/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.CellphonePrefixEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.ExcelErrorUserInfo;
import com.digiwin.dap.middleware.iam.domain.excel.ImportUserInfo;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.util.CellPhoneUtil;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.iam.util.vlidator.PasswordValidator;
import com.digiwin.dap.middleware.iam.util.vlidator.UserIdValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@Scope(value="prototype")
public class UserImportProcessor {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private AutoEOCService autoEOCService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private DictDataService dictDataService;
    List<ImportUserInfo> successImports = new CopyOnWriteArrayList<ImportUserInfo>();
    List<ExcelErrorUserInfo> failedImports = new CopyOnWriteArrayList<ExcelErrorUserInfo>();
    private Tenant tenant;
    private TenantCorpConfigDTO corpIdAndAppConfig;
    private boolean hasCorpWechat;
    private boolean allowExistUpdate;

    public void setFields(Tenant tenant, TenantCorpConfigDTO corpIdAndAppConfig, boolean hasCorpWechat, boolean allowExistUpdate) {
        this.tenant = tenant;
        this.corpIdAndAppConfig = corpIdAndAppConfig;
        this.hasCorpWechat = hasCorpWechat;
        this.allowExistUpdate = allowExistUpdate;
    }

    public void process(ImportUserInfo user) {
        StringBuilder errorInfo = new StringBuilder();
        boolean canAdd = this.checkExcel(user, errorInfo);
        if (canAdd) {
            this.successImports.add(user);
        } else {
            ExcelErrorUserInfo excelErrorUserInfo = new ExcelErrorUserInfo(user);
            excelErrorUserInfo.setMemo(errorInfo.toString());
            this.failedImports.add(excelErrorUserInfo);
        }
    }

    private boolean checkExcel(ImportUserInfo importUserInfo, StringBuilder errorInfo) {
        StringBuilder orgExitInfo;
        StringBuilder exitInfo;
        boolean canAdd = true;
        if (StringUtils.isEmpty((Object)importUserInfo.getId())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_ID_EMPTY.getMessage());
            canAdd = false;
        } else {
            User user = (User)this.userCrudService.findById(importUserInfo.getId());
            if (user != null && !this.allowExistUpdate) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_USER_EXISTED_USER.getMessage());
                canAdd = false;
            }
            if (this.idInvalid(importUserInfo.getId())) {
                errorInfo.append(String.format(I18nCode.EXCEL_IMPORT_ERROR_USER_ID.getMessage(), importUserInfo.getId()));
                canAdd = false;
            }
        }
        if (StringUtils.isEmpty((Object)importUserInfo.getName())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_NAME_EMPTY.getMessage());
            canAdd = false;
        }
        canAdd = this.checkPhoneAndEmail(importUserInfo, errorInfo, canAdd);
        if (this.envProperties.isCloud() && this.envProperties.isAli() && !User.isADAccount(importUserInfo.getId()) && ObjectUtils.isEmpty((Object)importUserInfo.getTelephone())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_TELEPHONE_EMPTY.getMessage());
            canAdd = false;
        }
        if (StringUtils.isEmpty((Object)importUserInfo.getPassword())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_PASSWORD_EMPTY.getMessage());
            canAdd = false;
        } else if (PasswordValidator.validateTenantCustomPassword(importUserInfo.getPassword()) || this.passwordLengthTooShort(importUserInfo.getPassword())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_ERROR_PASSWORD.getMessage());
            canAdd = false;
        }
        if (!StringUtils.isEmpty((Object)importUserInfo.getRoleId()) && !StringUtils.isEmpty((Object)(exitInfo = this.checkRoleExit(importUserInfo.getRoleId(), this.tenant.getSid())).toString())) {
            errorInfo.append((CharSequence)exitInfo);
            canAdd = false;
        }
        if (!StringUtils.isEmpty((Object)importUserInfo.getOrgId()) && !StringUtils.isEmpty((Object)(orgExitInfo = this.checkOrgExit(importUserInfo.getOrgId(), this.tenant.getSid())).toString())) {
            errorInfo.append((CharSequence)orgExitInfo);
            canAdd = false;
        }
        if (!StringUtils.isEmpty((Object)importUserInfo.getDapAcceptLanguage()) && !StringUtils.isEmpty((Object)(exitInfo = this.checkLanguage(importUserInfo.getDapAcceptLanguage())).toString())) {
            errorInfo.append((CharSequence)exitInfo);
            canAdd = false;
        }
        if (StringUtils.hasText((String)importUserInfo.getWechat()) && this.hasCorpWechat) {
            if (StringUtils.isEmpty((Object)this.corpIdAndAppConfig.getCorpId())) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_TENANT_CORPID_NOT_EXIST.getMessage());
                canAdd = false;
            } else if (!Boolean.TRUE.equals(this.corpIdAndAppConfig.getAppConfig())) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_TENANT_APPCONFIG_NOT_EXIST.getMessage());
                canAdd = false;
            } else if (Objects.isNull(this.remoteEMCService.checkWechatExistReturnOpenUserId(null, this.tenant.getId(), importUserInfo.getWechat(), importUserInfo.getId()))) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_USER_WECHAT_ERROR.getMessage());
                canAdd = false;
            }
        }
        if (!this.checkUserType(importUserInfo)) {
            errorInfo.append(I18nCode.EXCEL_INVITED_ERROR_USER_TYPE_FORMAT.getMessage());
            canAdd = false;
        }
        if (this.autoEOCService.isConsole(this.tenant.getSid()) && this.autoEOCService.isAutoEOC(this.tenant.getSid()) && !"1".equals(importUserInfo.getUserType()) && ObjectUtils.isEmpty((Object)importUserInfo.getEmpId())) {
            errorInfo.append(I18nCode.IAM_EXCEL_USER_EMP_EMPTY.getMessage());
            canAdd = false;
        }
        return canAdd;
    }

    private boolean passwordLengthTooShort(String password) {
        DictDataDTO dictDataDTO = new DictDataDTO();
        dictDataDTO.setDictId("pw_min_length");
        dictDataDTO.setDictKey("pw_min_length");
        List dictData = this.dictDataService.selectDictDataList(dictDataDTO);
        int minLength = Integer.parseInt(dictData.stream().findFirst().map(DictData::getDictValue).orElse("8"));
        return password.length() < minLength;
    }

    private boolean checkPhoneAndEmail(ImportUserInfo importUserInfo, StringBuilder errorInfo, boolean canAdd) {
        if (0 == this.envProperties.getCloud()) {
            return this.checkCloud(importUserInfo, errorInfo, canAdd);
        }
        return this.checkJinYu(importUserInfo, errorInfo, canAdd);
    }

    private boolean checkJinYu(ImportUserInfo importUserInfo, StringBuilder errorInfo, boolean canAdd) {
        User user;
        if (!StringUtils.isEmpty((Object)importUserInfo.getTelephone())) {
            user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(importUserInfo.getTelephone(), importUserInfo.getTelephone(), importUserInfo.getTelephone(), 0);
            if (user != null) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_USER_TELEPHONE_EXISTED.getMessage());
                canAdd = false;
            }
            if (StringUtils.isEmpty((Object)importUserInfo.getCellphonePrefix()) || !CellphonePrefixEnum.prefixValid(importUserInfo.getCellphonePrefix())) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_CELLPHONE_PREFIX_INVALID.getMessage());
                canAdd = false;
            }
        }
        if (!StringUtils.isEmpty((Object)importUserInfo.getEmail()) && (user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(importUserInfo.getEmail(), importUserInfo.getEmail(), importUserInfo.getEmail(), 0)) != null) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_EMAIL_EXISTED.getMessage());
            canAdd = false;
        }
        return canAdd;
    }

    private boolean checkCloud(ImportUserInfo importUserInfo, StringBuilder errorInfo, boolean canAdd) {
        if (StringUtils.isEmpty((Object)importUserInfo.getTelephone()) && StringUtils.isEmpty((Object)importUserInfo.getEmail())) {
            errorInfo.append(I18nCode.EXCEL_IMPORT_USER_ERROR_EMPTY_TELEPHONE_EMAIL.getMessage());
            canAdd = false;
        } else if (!StringUtils.isEmpty((Object)importUserInfo.getTelephone())) {
            boolean checkMobilePhone = CellPhoneUtil.checkPhoneFormat(importUserInfo.getCellphonePrefix(), importUserInfo.getTelephone(), this.envProperties.getCountry());
            if (!checkMobilePhone) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_USER_ERROR_TELEPHONE.getMessage());
                canAdd = false;
            } else {
                User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(importUserInfo.getTelephone(), importUserInfo.getTelephone(), importUserInfo.getTelephone(), 0);
                if (user != null && !this.allowExistUpdate) {
                    errorInfo.append(I18nCode.EXCEL_IMPORT_USER_TELEPHONE_EXISTED.getMessage());
                    canAdd = false;
                }
            }
            if (StringUtils.isEmpty((Object)importUserInfo.getCellphonePrefix()) || !CellphonePrefixEnum.prefixValid(importUserInfo.getCellphonePrefix())) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_CELLPHONE_PREFIX_INVALID.getMessage());
                canAdd = false;
            }
        }
        if (!StringUtils.isEmpty((Object)importUserInfo.getEmail())) {
            if (!StringUtil.checkEmail(importUserInfo.getEmail())) {
                errorInfo.append(I18nCode.EXCEL_IMPORT_USER_ERROR_EMAIL.getMessage());
                canAdd = false;
            } else {
                User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(importUserInfo.getEmail(), importUserInfo.getEmail(), importUserInfo.getEmail(), 0);
                if (user != null && !this.allowExistUpdate) {
                    errorInfo.append(I18nCode.EXCEL_IMPORT_USER_EMAIL_EXISTED.getMessage());
                    canAdd = false;
                }
            }
        }
        return canAdd;
    }

    private boolean idInvalid(String id) {
        if (0 == this.envProperties.getCloud()) {
            return this.envProperties.getCheckUserId() != false && UserIdValidator.validateUserId(id) && !User.isADAccount(id);
        }
        int minLength = 1;
        try {
            DictDataDTO dictDataDTO = new DictDataDTO();
            dictDataDTO.setDictId("id_min_length");
            dictDataDTO.setDictKey("id_min_length");
            List dictData = this.dictDataService.selectDictDataList(dictDataDTO);
            minLength = Integer.parseInt(dictData.stream().findFirst().map(DictData::getDictValue).orElse("1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return id.length() < minLength;
    }

    private boolean checkUserType(ImportUserInfo importUserInfo) {
        return "1".equals(importUserInfo.getUserType()) || "0".equals(importUserInfo.getUserType()) || StringUtils.isEmpty((Object)importUserInfo.getUserType());
    }

    private StringBuilder checkRoleExit(String roleIdStr, long tenantSid) {
        String[] roleIds = roleIdStr.split(",");
        StringBuilder errorInfo = new StringBuilder();
        ArrayList<String> existedRoles = new ArrayList<String>();
        for (String roleId : roleIds) {
            boolean exit = this.roleCrudService.existsByTenantSidAndId(tenantSid, roleId);
            if (exit) continue;
            existedRoles.add(roleId);
        }
        if (existedRoles.size() > 0) {
            errorInfo.append(String.format(I18nCode.EXCEL_IMPORT_USER_ROLE_ID_EXISTED.getMessage(), String.join((CharSequence)",", existedRoles)));
        }
        return errorInfo;
    }

    private StringBuilder checkLanguage(String language) {
        if (IamConstants.DW_LANGUAGE_LIST.contains(language)) {
            return new StringBuilder();
        }
        return new StringBuilder(I18nCode.EXCEL_IMPORT_USER_LANGUAGE_ERROR.getMessage());
    }

    private StringBuilder checkOrgExit(String orgIdStr, long tenantSid) {
        String[] orgIds = orgIdStr.split(",");
        StringBuilder errorInfo = new StringBuilder();
        ArrayList<String> existedOrgs = new ArrayList<String>();
        for (String orgId : orgIds) {
            boolean exit = this.orgCrudService.existsByTenantSidAndId(tenantSid, orgId);
            if (exit) continue;
            existedOrgs.add(orgId);
        }
        if (existedOrgs.size() > 0) {
            errorInfo.append(String.format(I18nCode.EXCEL_IMPORT_USER_ORG_ID_EXISTED.getMessage(), String.join((CharSequence)",", existedOrgs)));
        }
        return errorInfo;
    }

    public List<ImportUserInfo> getSuccessImports() {
        return this.successImports;
    }

    public List<ExcelErrorUserInfo> getFailedImports() {
        return this.failedImports;
    }
}

