/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.excel.UserJoinTenantExcelVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UserJoinTenantExcelListener
extends AnalysisEventListener<UserJoinTenantExcelVO> {
    private static final Logger logger = LoggerFactory.getLogger(UserJoinTenantExcelListener.class);
    private List<UserJoinTenantExcelVO> importSuccessResults = new ArrayList<UserJoinTenantExcelVO>();
    private List<UserJoinTenantExcelVO> errorResults = new ArrayList<UserJoinTenantExcelVO>();
    private UserCrudService userCrudService;
    private UserInTenantCrudService userInTenantCrudService;
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    private UserInTenantOperationService userInTenantOperationService;
    private RoleCrudService roleCrudService;
    private OrgCrudService orgCrudService;
    private SysCrudService sysCrudService;
    private RemoteEocService remoteEocService;
    private Tenant tenant;
    private List<String> canUseApps;
    private Set<String> bundleChildren;

    public List<UserJoinTenantExcelVO> getImportSuccessResults() {
        return this.importSuccessResults;
    }

    public List<UserJoinTenantExcelVO> getErrorResults() {
        return this.errorResults;
    }

    public UserJoinTenantExcelListener(UserCrudService userCrudService, UserInTenantCrudService userInTenantCrudService, InvitedUserHistoryCrudService invitedUserHistoryCrudService, UserInTenantOperationService userInTenantOperationService, RoleCrudService roleCrudService, OrgCrudService orgCrudService, SysCrudService sysCrudService, RemoteEocService remoteEocService, Tenant tenant, List<String> canUseApps, Set<String> bundleChildren) {
        this.userCrudService = userCrudService;
        this.userInTenantCrudService = userInTenantCrudService;
        this.invitedUserHistoryCrudService = invitedUserHistoryCrudService;
        this.userInTenantOperationService = userInTenantOperationService;
        this.roleCrudService = roleCrudService;
        this.orgCrudService = orgCrudService;
        this.sysCrudService = sysCrudService;
        this.remoteEocService = remoteEocService;
        this.tenant = tenant;
        this.canUseApps = canUseApps;
        this.bundleChildren = bundleChildren;
    }

    public void invoke(UserJoinTenantExcelVO data, AnalysisContext context) {
        if (context.readRowHolder().getCellMap().size() < 1) {
            return;
        }
        String errorInfo = "";
        User user = null;
        boolean exists = false;
        if (StringUtils.isEmpty((Object)data.getId())) {
            errorInfo = "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a";
        } else {
            user = (User)this.userCrudService.findById(data.getId());
            if (user == null) {
                errorInfo = "\u7528\u6237\u4e0d\u5b58\u5728";
            } else {
                exists = this.userInTenantCrudService.existsByUnionKey(this.tenant.getSid(), user.getSid());
            }
        }
        ArrayList<GeneralParametersVO> orgList = new ArrayList<GeneralParametersVO>();
        errorInfo = this.checkRolesOrOrgsOrApps(data, data.getOrgs(), "org", orgList, errorInfo);
        ArrayList<GeneralParametersVO> roleList = new ArrayList<GeneralParametersVO>();
        errorInfo = this.checkRolesOrOrgsOrApps(data, data.getRoles(), "role", roleList, errorInfo);
        ArrayList<GeneralParametersVO> appList = new ArrayList<GeneralParametersVO>();
        errorInfo = this.checkRolesOrOrgsOrApps(data, data.getApps(), "app", appList, errorInfo);
        if (StringUtils.isEmpty((Object)data.getUserType()) || "0".equals(data.getUserType())) {
            data.setUserTypeBoolean(Boolean.FALSE);
        } else if ("1".equals(data.getUserType())) {
            data.setUserTypeBoolean(Boolean.TRUE);
        } else {
            errorInfo = String.format("%s;\u7528\u6237\u6027\u8d28\u6709\u8bef\uff0c\u8bf7\u586b\u51650(\u8868\u793a\u4e00\u822c\u7528\u6237)\u62161(\u8868\u5916\u90e8\u7528\u6237)\uff0c\u7a7a\u767d\u9ed8\u8ba4\u4e3a0(\u8868\u793a\u4e00\u822c\u7528\u6237)", errorInfo);
        }
        String errorEmp = "";
        if (this.tenant.isEoc() && !StringUtils.isEmpty((Object)data.getEmpId())) {
            try {
                EmpInfoVO empInfoVO = this.remoteEocService.getEmpByTenant(this.tenant.getSid(), data.getEmpId());
                if (empInfoVO == null || empInfoVO.getUser() != null) {
                    errorEmp = String.format("\u5458\u5de5\u7f16\u53f7%s\u65e0\u6cd5\u5bf9\u5e94\u6216\u5df2\u88ab\u7ed1\u5b9a", data.getEmpId());
                }
            }
            catch (Exception e) {
                logger.error("\u3010EOC\u8c03\u7528\u3011\u83b7\u53d6\u6307\u5b9a\u79df\u6237\u5458\u5de5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                errorEmp = String.format("\u4f01\u4e1a\u8fd0\u8425\u83b7\u53d6\u79df\u6237%s\u4e0b\u5458\u5de5%s\u4fe1\u606f\u5931\u8d25", this.tenant.getId(), data.getEmpId());
            }
            if (StringUtils.isEmpty((Object)errorEmp)) {
                data.setEmpExist(Boolean.TRUE);
            }
        }
        for (GeneralParametersVO app : appList) {
            if (!this.bundleChildren.contains(app.getId())) continue;
            errorInfo = String.format("%s;" + I18nCode.BUNDLE_CHILDREN_FORBIDDEN.getMessage(), errorInfo);
            break;
        }
        if (StringUtils.isEmpty((Object)errorInfo)) {
            try {
                if (!exists) {
                    UserInTenant userInTenant = new UserInTenant(Objects.requireNonNull(user).getSid(), this.tenant.getSid());
                    userInTenant.setUserType(data.isUserTypeBoolean());
                    this.userInTenantCrudService.create(userInTenant);
                    this.updateInvitedUserHistory(user);
                }
                this.userInTenantOperationService.initializeUserData(this.tenant, user, roleList, orgList, appList, null, Boolean.TRUE.equals(data.getEmpExist()) ? data.getEmpId() : null, data.isUserTypeBoolean());
                if (!StringUtils.isEmpty((Object)errorEmp)) {
                    data.setErrors(String.format("%s%s", "\u7528\u6236\u5df2\u52a0\u5165\u79df\u6237\uff0c\u4f46", errorEmp));
                }
                this.importSuccessResults.add(data);
            }
            catch (Exception e) {
                data.setErrors(StringUtils.isEmpty((Object)errorEmp) ? String.format("\u7528\u6237\u52a0\u5165\u79df\u6237\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", e.getMessage()) : String.format("%s;\u7528\u6237\u52a0\u5165\u79df\u6237\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", errorEmp, e.getMessage()));
                this.errorResults.add(data);
                logger.error("\u6279\u91cf\u5bfc\u5165\u7528\u6237{}\u52a0\u5165\u79df\u6237\u5931\u8d25", (Object)data.getId(), (Object)e);
            }
        } else {
            if (!StringUtils.isEmpty((Object)errorEmp)) {
                errorInfo = String.format("%s;%s", errorInfo, errorEmp);
            }
            data.setErrors(errorInfo.startsWith(";") ? errorInfo.substring(1) : errorInfo);
            this.errorResults.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    private void updateInvitedUserHistory(User user) {
        List<InvitedUserHistory> invitedUserHistories = this.invitedUserHistoryCrudService.findInvitedUserHistories(this.tenant.getSid(), user.getSid(), null, null, Arrays.asList(IamConstants.AcceptedStatus.ApplyWaitAgree.toString(), IamConstants.AcceptedStatus.InvitedWaitAgree.toString()));
        if (!CollectionUtils.isEmpty(invitedUserHistories)) {
            for (InvitedUserHistory history : invitedUserHistories) {
                if (IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(history.getAcceptedStatus())) {
                    history.setConfirmDate(LocalDateTime.now());
                    history.setAcceptedstatus(IamConstants.AcceptedStatus.Joined.toString());
                    continue;
                }
                if (!IamConstants.AcceptedStatus.InvitedWaitAgree.toString().equals(history.getAcceptedStatus())) continue;
                history.setConfirmDate(LocalDateTime.now());
                history.setAcceptedstatus(IamConstants.AcceptedStatus.Agree.toString());
            }
            this.invitedUserHistoryCrudService.saveAll(invitedUserHistories);
        }
    }

    private String checkRolesOrOrgsOrApps(UserJoinTenantExcelVO data, String content, String type, List<GeneralParametersVO> successResults, String errorInfo) {
        String currentErrorInfo = "";
        try {
            if (StringUtils.isEmpty((Object)content)) {
                return errorInfo;
            }
            List subContents = Arrays.stream(content.replace("\uff0c", ",").split(",")).distinct().collect(Collectors.toList());
            for (String subContent : subContents) {
                currentErrorInfo = this.checkRoleOrOrgOrApp(currentErrorInfo, type, successResults, subContent);
            }
            if (StringUtils.isEmpty((Object)currentErrorInfo)) {
                return errorInfo;
            }
            if ("org".equals(type)) {
                return String.format("%s;\u7ec4\u7ec7%s\u4e0d\u5b58\u5728", errorInfo, currentErrorInfo);
            }
            if ("role".equals(type)) {
                return String.format("%s;\u89d2\u8272%s\u4e0d\u5b58\u5728", errorInfo, currentErrorInfo);
            }
            return String.format("%s;%s", errorInfo, currentErrorInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            currentErrorInfo = e.getMessage();
            return String.format("%s;%s", errorInfo, currentErrorInfo);
        }
    }

    private String checkRoleOrOrgOrApp(String currentErrorInfo, String type, List<GeneralParametersVO> successResults, String subContent) {
        if ("role".equals(type)) {
            if (!this.roleCrudService.existsByTenantSidAndId(this.tenant.getSid(), subContent)) {
                currentErrorInfo = StringUtils.isEmpty((Object)currentErrorInfo) ? subContent : String.format("%s\u3001%s", currentErrorInfo, subContent);
            } else {
                Role role = this.roleCrudService.findByTenantSidAndId(this.tenant.getSid(), subContent);
                GeneralParametersVO vo = new GeneralParametersVO();
                vo.setId(role.getId());
                vo.setName(role.getName());
                vo.setSid(role.getSid());
                successResults.add(vo);
            }
        } else if ("org".equals(type)) {
            if (!this.orgCrudService.existsByTenantSidAndId(this.tenant.getSid(), subContent)) {
                currentErrorInfo = StringUtils.isEmpty((Object)currentErrorInfo) ? subContent : String.format("%s\u3001%s", currentErrorInfo, subContent);
            } else {
                List<Org> orgs = this.orgCrudService.findByTenantSidAndId(this.tenant.getSid(), subContent);
                GeneralParametersVO vo = new GeneralParametersVO();
                vo.setId(orgs.get(0).getId());
                vo.setName(orgs.get(0).getName());
                vo.setSid(orgs.get(0).getSid());
                successResults.add(vo);
            }
        } else if (this.canUseApps == null || !this.canUseApps.contains(subContent)) {
            currentErrorInfo = StringUtils.isEmpty((Object)currentErrorInfo) ? String.format("\u79df\u6237%s\u6ca1\u6709\u8d2d\u4e70\u5e94\u7528%s", this.tenant.getId(), subContent) : String.format("%s;\u79df\u6237%s\u6ca1\u6709\u8d2d\u4e70\u5e94\u7528%s", currentErrorInfo, this.tenant.getId(), subContent);
        } else {
            Sys sys = (Sys)this.sysCrudService.findById(subContent);
            if (sys == null) {
                return String.format(I18nCode.EXCEL_INVITED_ERROR_NOT_EXISTED_APP.getMessage(), currentErrorInfo, subContent);
            }
            GeneralParametersVO vo = new GeneralParametersVO();
            vo.setId(sys.getId());
            vo.setName(sys.getName());
            vo.setSid(sys.getSid());
            successResults.add(vo);
        }
        return currentErrorInfo;
    }
}

