/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.iam.domain.excel.UserMappingImportExcelVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Scope(value="prototype")
public class UserMappingExcelListener
extends AnalysisEventListener<UserMappingImportExcelVO> {
    private static final Logger logger = LoggerFactory.getLogger(UserMappingExcelListener.class);
    private final List<UserMappingImportExcelVO> successResults = new ArrayList<UserMappingImportExcelVO>();
    private final List<UserMappingImportExcelVO> errorResults = new ArrayList<UserMappingImportExcelVO>();
    @Autowired
    private UserMappingService userMappingService;

    public void invoke(UserMappingImportExcelVO data, AnalysisContext context) {
        if (context.readRowHolder().getCellMap().size() < 1) {
            return;
        }
        try {
            Assert.hasText((String)data.getUserId(), (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)data.getVerifyUserId(), (String)"\u5e94\u7528\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)data.getProviderId(), (String)"\u5e94\u7528\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            UserMappingVO userMappingVO = new UserMappingVO();
            userMappingVO.setUserId(data.getUserId());
            userMappingVO.setIdentityId(data.getProviderId());
            userMappingVO.setVerifyUserId(data.getVerifyUserId());
            this.userMappingService.map(UserUtils.getTenantSid(), userMappingVO, true, true);
            this.successResults.add(data);
        }
        catch (Exception e) {
            data.setErrors(e.getMessage());
            this.errorResults.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<UserMappingImportExcelVO> getSuccessResults() {
        return this.successResults;
    }

    public List<UserMappingImportExcelVO> getErrorResults() {
        return this.errorResults;
    }
}

