/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.domain.excel.UserWechatExcelVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class UserWechatExcelListener
extends AnalysisEventListener<UserWechatExcelVO> {
    private static final Logger logger = LoggerFactory.getLogger(UserWechatExcelListener.class);
    private List<UserWechatExcelVO> importDatas = new ArrayList<UserWechatExcelVO>();
    private List<UserWechatExcelVO> successResults = new ArrayList<UserWechatExcelVO>();
    private List<UserWechatExcelVO> errorResults = new ArrayList<UserWechatExcelVO>();
    private UserCrudService userCrudService;
    private UserInTenantCrudService userInTenantCrudService;

    public UserWechatExcelListener(UserCrudService userCrudService, UserInTenantCrudService userInTenantCrudService) {
        this.userCrudService = userCrudService;
        this.userInTenantCrudService = userInTenantCrudService;
    }

    public void invoke(UserWechatExcelVO data, AnalysisContext context) {
        boolean existed;
        if (context.readRowHolder().getCellMap().size() < 1) {
            return;
        }
        if (StringUtils.isEmpty((Object)data.getWechat())) {
            this.successResults.add(data);
            return;
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (StringUtils.isEmpty((Object)data.getId())) {
            data.setErrors(I18nCode.EXCEL_IMPORT_USER_ID_EMPTY.getMessage());
            this.errorResults.add(data);
            return;
        }
        User user = (User)this.userCrudService.findById(data.getId());
        boolean bl = existed = user != null && this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid());
        if (existed) {
            this.importDatas.add(data);
            this.successResults.add(data);
        } else {
            data.setErrors(String.format(I18nCode.EXCEL_IMPORT_TENANT_USER_WECHAT_EXISTED_ERROR.getMessage(), authoredUser.getTenantId()));
            this.errorResults.add(data);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<UserWechatExcelVO> getImportDatas() {
        return this.importDatas;
    }

    public void setImportDatas(List<UserWechatExcelVO> importDatas) {
        this.importDatas = importDatas;
    }

    public List<UserWechatExcelVO> getErrorResults() {
        return this.errorResults;
    }

    public void setErrorResults(List<UserWechatExcelVO> errorResults) {
        this.errorResults = errorResults;
    }

    public List<UserWechatExcelVO> getSuccessResults() {
        return this.successResults;
    }

    public void setSuccessResults(List<UserWechatExcelVO> successResults) {
        this.successResults = successResults;
    }
}

