/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantUserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.SysCascade;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.excel.CardExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.OrgExportExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.RoleExportExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.TenantExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserJoinTenantExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserMappingExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserMappingImportExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.UserWechatExcelVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportScopeVO;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.CardMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMappingMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleQueryService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.service.user.UserQueryService;
import com.digiwin.dap.middleware.iam.support.excel.CardExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.excel.TenantExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.UserJoinTenantExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.UserMappingExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.UserWechatExcelListener;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.util.SpringBeanUtils;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.download.FileService;
import com.digiwin.dmc.sdk.service.download.IFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ExcelServiceImpl
implements IExcelService {
    private Logger logger = LoggerFactory.getLogger(ExcelServiceImpl.class);
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private UserInOrgQueryService userInOrgQueryService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    UserInRoleMapper userInRoleMapper;
    @Autowired
    private RoleQueryService roleQueryService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private UserMappingMapper userMappingMapper;
    @Autowired
    private CardMapper cardMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private SysQueryService sysQueryService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private UserRepository userRepository;
    private static final String USER_WECHAT_EXCEL_NAME = "user_wechat";
    private static final String EXCEL_USER_JOIN_TENANT = "user_join_tenant";
    private static final String EXCEL_USER_MAPPING = "user_mapping";
    private static final String EXCEL_CARD = "card";

    @Override
    public void exportUserWechat(Long tenantSid, HttpServletResponse response) {
        try {
            List<UserWechatExcelVO> excelVOS = this.userQueryService.getTenantUsersWechatExcelVO(tenantSid);
            this.exportCore(excelVOS, USER_WECHAT_EXCEL_NAME, UserWechatExcelVO.class, response);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public File exportUserInfo(Long tenantSid) {
        try {
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            List<User> users = this.userMapper.getAllUsersByTenantSid(tenantSid);
            ArrayList<UserExcelVO> allUsers = new ArrayList<UserExcelVO>();
            if (!CollectionUtils.isEmpty(users)) {
                for (User user : users) {
                    List<QueryRoleResultVO> roleVOS;
                    UserExcelVO u = new UserExcelVO();
                    u.setId(user.getId());
                    u.setName(user.getName());
                    UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid());
                    if (!userInTenant.isDisabled()) {
                        u.setState("\u542f\u7528");
                    } else {
                        u.setState("\u7981\u7528");
                    }
                    if (0 == user.getType()) {
                        u.setTypeName("\u9f0e\u6377\u4e91\u7528\u6237");
                    } else if (1 == user.getType()) {
                        u.setTypeName("\u4f01\u4e1a\u7528\u6237");
                    }
                    List<QueryUserInOrgResultVO> orgVOS = this.userInOrgQueryService.queryUserInOrgByUser(tenantSid, user.getSid());
                    if (!CollectionUtils.isEmpty(orgVOS)) {
                        String orgStr = orgVOS.stream().map(QueryUserInOrgResultVO::getOrgName).collect(Collectors.joining("/"));
                        u.setOrgName(orgStr);
                    }
                    if (!CollectionUtils.isEmpty(roleVOS = this.userInRoleQueryService.queryUserInRoleByUserWithLanguage(tenantSid, user.getSid()))) {
                        String roleStr = roleVOS.stream().map(QueryRoleResultVO::getName).collect(Collectors.joining("/"));
                        u.setRoleName(roleStr);
                    }
                    u.setCellphone(user.getTelephone());
                    u.setAuthorizations(this.cacService.getAuthorizations(tenant.getId(), u.getId()).stream().map(AuthorizationResultVO::getDisplayName).collect(Collectors.joining("/")));
                    u.setEmail(user.getEmail());
                    u.setUserType(TenantUserTypeEnum.getUserTypeName(user.getType()));
                    allUsers.add(u);
                }
                return this.exportCore(allUsers, "users_export");
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public File exportUserOrgInfo(Long tenantSid) {
        try {
            Long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(tenantSid, "defaultOrgCatalog");
            Long orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{tenantSid, orgCatalogSid, "defaultOrgAspect"});
            List<OrgResultVO> orgResultVOS = this.orgQueryService.getAspect(tenantSid, orgAspectSid);
            if (null != orgResultVOS && orgResultVOS.size() > 0) {
                List parentOrgs = orgResultVOS.stream().filter(org -> org.getParentSid() == 0L).collect(Collectors.toList());
                ArrayList<OrgExportExcelVO> allSortOrgResultVOS = new ArrayList<OrgExportExcelVO>();
                for (OrgResultVO parentOrg : parentOrgs) {
                    OrgExportExcelVO parentOrgExcelVO = new OrgExportExcelVO();
                    parentOrgExcelVO.setId(parentOrg.getLabel());
                    parentOrgExcelVO.setName(parentOrg.getName());
                    parentOrgExcelVO.setOrgTypeName(parentOrg.getTypeName());
                    ArrayList<OrgExportExcelVO> sortOrgResultVOS = new ArrayList<OrgExportExcelVO>();
                    sortOrgResultVOS.add(parentOrgExcelVO);
                    ExcelServiceImpl.sortList(orgResultVOS, parentOrg, sortOrgResultVOS);
                    allSortOrgResultVOS.addAll(sortOrgResultVOS);
                }
                return this.exportCore(allSortOrgResultVOS, "org_export");
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    public static void sortList(List<OrgResultVO> orgResultVOS, OrgResultVO parentOrg, List<OrgExportExcelVO> sortOrgResultVOS) {
        for (OrgResultVO org : orgResultVOS) {
            if (org.getParentSid() != parentOrg.getSid()) continue;
            OrgExportExcelVO orgExcelVO = new OrgExportExcelVO();
            orgExcelVO.setId(org.getLabel());
            orgExcelVO.setName(org.getName());
            orgExcelVO.setOrgTypeName(org.getTypeName());
            orgExcelVO.setOrgParentId(parentOrg.getLabel());
            sortOrgResultVOS.add(orgExcelVO);
            ExcelServiceImpl.sortList(orgResultVOS, org, sortOrgResultVOS);
        }
    }

    @Override
    public File exportUserRoleInfo(Long tenantSid) {
        try {
            ArrayList<RoleExportExcelVO> roleVOS = new ArrayList<RoleExportExcelVO>();
            List<RoleQueryResultVO> roleQueryResultVOS = this.roleQueryService.getRoleQueryResultVosByType(false, tenantSid);
            if (!CollectionUtils.isEmpty(roleQueryResultVOS)) {
                for (RoleQueryResultVO role : roleQueryResultVOS) {
                    RoleExportExcelVO roleExportExcelVO = new RoleExportExcelVO();
                    roleExportExcelVO.setId(role.getId());
                    roleExportExcelVO.setName(role.getName());
                    if (null != role.getOrg()) {
                        roleExportExcelVO.setOrgName(role.getOrg().getName());
                    }
                    roleVOS.add(roleExportExcelVO);
                }
                return this.exportCore(roleVOS, "roles_export");
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    @Transactional
    public ImportExcelResultVO importUserWechat(String fileId, AuthoredUser authoredUser) {
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        UserWechatExcelListener listener = new UserWechatExcelListener(this.userCrudService, this.userInTenantCrudService);
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)input, UserWechatExcelVO.class, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        List<UserWechatExcelVO> successResults = listener.getSuccessResults();
        List<UserWechatExcelVO> errorResults = listener.getErrorResults();
        for (UserWechatExcelVO data : listener.getImportDatas()) {
            try {
                User user = (User)this.userCrudService.findById(data.getId());
                if (user == null) {
                    throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{data.getId()});
                }
                if (!StringUtils.hasText((String)data.getWechat())) {
                    this.metadataCrudService.removeMetadata(authoredUser.getTenantSid(), user.getSid(), "contact", "wechat");
                    this.metadataCrudService.removeMetadata(authoredUser.getTenantSid(), user.getSid(), "contact", "open_wecom");
                } else {
                    WeComUserVO weComUserVO = this.remoteEMCService.checkWechatExistReturnOpenUserId(null, authoredUser.getTenantId(), data.getWechat(), user.getId());
                    if (Objects.isNull(weComUserVO)) {
                        throw new BusinessException((ErrorHandler)I18nError.USER_WECHAT_EXIST_ERROR);
                    }
                    UserMetadataVO metadataVO = new UserMetadataVO("contact", "wechat", data.getWechat(), authoredUser.getTenantSid(), user.getSid());
                    this.metadataUpdateService.updateMetadataValue(metadataVO);
                    if (StringUtils.hasText((String)weComUserVO.getOpen_userid())) {
                        UserMetadataVO openWeComMetadata = new UserMetadataVO("contact", "open_wecom", weComUserVO.getOpen_userid(), authoredUser.getTenantSid(), user.getSid());
                        this.metadataUpdateService.updateMetadataValue(openWeComMetadata);
                    }
                }
            }
            catch (Exception e) {
                data.setErrors(String.format(I18nCode.EXCEL_IMPORT_TENANT_USER_WECHAT_UPDATE_ERROR.getMessage(), e.getMessage()));
                this.logger.error(e.getMessage());
            }
            if (StringUtils.isEmpty((Object)data.getErrors())) continue;
            errorResults.add(data);
            successResults.remove(data);
        }
        return this.getImportResult(successResults, errorResults, USER_WECHAT_EXCEL_NAME);
    }

    @Override
    @Transactional
    public ImportExcelResultVO importUserJoinTenant(String tenantId, String fileId) {
        byte[] bytes;
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_INVITED_USER_TENANT_EXISTED, new Object[]{tenantId});
        }
        try {
            bytes = this.dmcClient.download(fileId);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.DMC_GET_FILE_FAILED, new Object[]{fileId});
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        List<String> canUseApps = this.tenantQueryService.getTenantApplication(tenantId, GoodsCategoryEnum.getApps());
        Set<String> bundleChildren = this.tenantQueryService.getTenantBundleChildren(tenantId);
        UserJoinTenantExcelListener listener = new UserJoinTenantExcelListener(this.userCrudService, this.userInTenantCrudService, this.invitedUserHistoryCrudService, this.userInTenantOperationService, this.roleCrudService, this.orgCrudService, this.sysCrudService, this.remoteEocService, tenant, canUseApps, bundleChildren);
        EasyExcel.read((InputStream)input, UserJoinTenantExcelVO.class, (ReadListener)listener).sheet().doRead();
        List<UserJoinTenantExcelVO> successResults = listener.getImportSuccessResults();
        List<UserJoinTenantExcelVO> errorResults = listener.getErrorResults();
        List empErrorList = successResults.stream().filter(x -> !StringUtils.isEmpty((Object)x.getErrors())).collect(Collectors.toList());
        successResults.removeAll(empErrorList);
        errorResults.addAll(empErrorList);
        return this.getImportResult(successResults, errorResults, EXCEL_USER_JOIN_TENANT);
    }

    private void exportCore(List resultList, String filePrefix, Class clz, HttpServletResponse response) throws Exception {
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? new DefaultResourceLoader().getResource(String.format("classpath:/static/templates/%s_export_template_CN.xlsx", filePrefix)).getInputStream() : new DefaultResourceLoader().getResource(String.format("classpath:/static/templates/%s_export_template_TW.xlsx", filePrefix)).getInputStream();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = String.format("%s_export_%s", filePrefix, localTime);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), (Class)clz).withTemplate(inputStream).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(resultList);
    }

    private File exportCore(List resultList, String templateName) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = templateName + "_" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = new DefaultResourceLoader().getResource(String.format("classpath:/static/templates/%s_template_CN.xlsx", templateName)).getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(resultList, writeSheet);
        excelWriter.finish();
        return file;
    }

    private File exportCoreWithLocale(List resultList, String templateName, boolean needMultiLanguage) throws Exception {
        String location = String.format("classpath:/static/templates/%s_export_template_CN.xlsx", templateName);
        if (needMultiLanguage && Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(LocaleContextHolder.getLocale().getCountry())) {
            location = String.format("classpath:/static/templates/%s_export_template_TW.xlsx", templateName);
        }
        File file = new File(templateName + "_" + DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()) + ".xlsx");
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(new DefaultResourceLoader().getResource(location).getInputStream()).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(resultList, writeSheet);
        excelWriter.finish();
        return file;
    }

    private ImportExcelResultVO getImportResult(List importSuccessList, List errorList, String filePrefix) {
        try {
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO(importSuccessList.size(), errorList.size());
            if (!CollectionUtils.isEmpty((Collection)errorList)) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = String.format("error_%s_%s.xlsx", filePrefix, localTime);
                File file = new File(fileName);
                InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry()) ? new DefaultResourceLoader().getResource(String.format("classpath:/static/templates/%s_export_template_CN.xlsx", filePrefix)).getInputStream() : new DefaultResourceLoader().getResource(String.format("classpath:/static/templates/%s_export_template_TW.xlsx", filePrefix)).getInputStream();
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                excelWriter.write(errorList, writeSheet);
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        this.logger.error("no data to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo));
                }
                importExcelResultVO.setErrorFileName(fileName);
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    private ImportExcelResultVO getImportResultWithLocale(List importSuccessList, List errorList, String filePrefix) {
        try {
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO(importSuccessList.size(), errorList.size());
            if (!CollectionUtils.isEmpty((Collection)errorList)) {
                String fileName = String.format("error_%s_%s.xlsx", filePrefix, DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now()));
                File file = new File(fileName);
                String location = String.format("classpath:/static/templates/%s_export_template_CN.xlsx", filePrefix);
                if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(LocaleContextHolder.getLocale().getCountry())) {
                    location = String.format("classpath:/static/templates/%s_export_template_TW.xlsx", filePrefix);
                }
                InputStream inputStream = new DefaultResourceLoader().getResource(location).getInputStream();
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                excelWriter.write(errorList, writeSheet);
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        this.logger.error("no data to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo));
                }
                importExcelResultVO.setErrorFileName(fileName);
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public String exportUserMapping(long tenantSid, UserMappingVO userMappingVO) {
        List<UserMappingQueryResultVO> byCondition = this.userMappingMapper.findByCondition(tenantSid, userMappingVO);
        List excelVOS = byCondition.stream().map(a -> {
            UserMappingExcelVO excelVO = new UserMappingExcelVO();
            BeanUtils.copyProperties((Object)a, (Object)excelVO);
            return excelVO;
        }).collect(Collectors.toList());
        try {
            File userMapping = this.exportCore(excelVOS, EXCEL_USER_MAPPING);
            return this.dmcService.upload(userMapping);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public ImportExcelResultVO importUserMapping(String fileId) {
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        UserMappingExcelListener listener = SpringBeanUtils.getBean(UserMappingExcelListener.class);
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)input, UserMappingImportExcelVO.class, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        return this.getImportResult(listener.getSuccessResults(), listener.getErrorResults(), EXCEL_USER_MAPPING);
    }

    @Override
    public String exportCard(UserInTenantVO body) {
        List<CardExcelVO> byCondition = this.cardMapper.findByCondition(body);
        try {
            File card = this.exportCoreWithLocale(byCondition, EXCEL_CARD, true);
            return this.dmcService.getTempUrl(card);
        }
        catch (Exception e) {
            this.logger.error("Export user mapping failed", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public ImportExcelResultVO importCard(String fileId) {
        ByteArrayInputStream input = new ByteArrayInputStream(FileService.fileInstance().download("Athena", fileId, new TenantId[0]));
        CardExcelListener listener = SpringBeanUtils.getBean(CardExcelListener.class);
        List rows = ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)input).head(CardExcelVO.class)).sheet().headRowNumber(Integer.valueOf(2))).doReadSync();
        listener.processExcel(rows);
        return this.getImportResultWithLocale(listener.getSuccessResults(), listener.getErrorResults(), EXCEL_CARD);
    }

    @Override
    public ImportExcelResultVO batchUpdateTenants(String fileId) {
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        TenantExcelListener tenantExcelListener = SpringBeanUtils.getBean(TenantExcelListener.class);
        ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)new ByteArrayInputStream(bytes), TenantExcelVO.class, (ReadListener)tenantExcelListener).sheet().headRowNumber(Integer.valueOf(1))).doRead();
        List<TenantExcelVO> tenantInfos = tenantExcelListener.getImportSuccessResults();
        List<TenantExcelVO> errorTenants = tenantExcelListener.getErrorResults();
        ArrayList updateSqlList = new ArrayList();
        List<String> tenantIds = tenantInfos.stream().map(TenantExcelVO::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(tenantIds)) {
            List<TenantVO> tenants = this.tenantMapper.getTenantByTenantIds(tenantIds, null);
            tenantInfos.forEach(t -> {
                TenantVO tenant = tenants.stream().filter(et -> et.getId().equals(t.getId())).findFirst().orElse(null);
                if (null == tenant) {
                    t.setRemark("\u79df\u6237\u4e0d\u5b58\u5728");
                    errorTenants.add((TenantExcelVO)t);
                } else {
                    boolean update = false;
                    if (StringUtils.hasText((String)tenant.getContacts())) {
                        t.setRemark("\u79df\u6237\u4e0a\u7684\u8054\u7edc\u4eba\u4fe1\u606f\u5df2\u5b58\u5728");
                    } else {
                        tenant.setContacts(t.getContacts());
                        update = true;
                    }
                    if (StringUtils.hasText((String)t.getEmail())) {
                        if (StringUtils.hasText((String)tenant.getEmail())) {
                            t.setRemark(StringUtils.hasText((String)t.getRemark()) ? String.format("%s;\u79df\u6237\u4e0a\u7684\u8054\u7edc\u4eba\u90ae\u7bb1\u5df2\u5b58\u5728", t.getRemark()) : "\u79df\u6237\u4e0a\u7684\u8054\u7edc\u4eba\u90ae\u7bb1\u5df2\u5b58\u5728");
                        } else {
                            tenant.setEmail(t.getEmail());
                            update = true;
                        }
                    }
                    if (StringUtils.hasText((String)t.getTelephone())) {
                        if (StringUtils.hasText((String)tenant.getTelephone())) {
                            t.setRemark(StringUtils.hasText((String)t.getRemark()) ? String.format("%s;\u79df\u6237\u4e0a\u7684\u8054\u7edc\u4eba\u624b\u673a\u5df2\u5b58\u5728", t.getRemark()) : "\u79df\u6237\u4e0a\u7684\u8054\u7edc\u4eba\u624b\u673a\u5df2\u5b58\u5728");
                        } else {
                            tenant.setTelephone(t.getTelephone());
                            update = true;
                        }
                    }
                    if (StringUtils.hasText((String)t.getAddress())) {
                        if (StringUtils.hasText((String)tenant.getAddress())) {
                            t.setRemark(StringUtils.hasText((String)t.getRemark()) ? String.format("%s;\u516c\u53f8\u5730\u5740\u5df2\u5b58\u5728", t.getRemark()) : "\u516c\u53f8\u5730\u5740\u5df2\u5b58\u5728");
                        } else {
                            tenant.setAddress(t.getAddress());
                            update = true;
                        }
                    }
                    if (StringUtils.hasText((String)t.getRemark())) {
                        errorTenants.add((TenantExcelVO)t);
                    }
                    if (update) {
                        updateSqlList.add(new Object[]{tenant.getContacts(), tenant.getTelephone(), tenant.getEmail(), tenant.getAddress(), tenant.getId()});
                    }
                }
            });
            if (!updateSqlList.isEmpty()) {
                String updateSql = String.format("update  `tenant`  set `contacts`=?,`telephone`=?,`email`=?,`address`=? where  `id`=?", new Object[0]);
                this.jdbcTemplate.batchUpdate(updateSql, updateSqlList);
            }
        }
        return this.getImportResultWithLocale(updateSqlList, errorTenants, "tenant_update");
    }

    @Override
    public List<ConsolePolicyExportVO> genPolicyExportData(ConsolePolicyExportScopeVO input) {
        Long tenantSid = input.getTenantSid();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        String scope = input.getScope();
        ArrayList<ConsolePolicyExportVO> result = new ArrayList<ConsolePolicyExportVO>();
        for (String appId : input.getAppIds()) {
            SysCascade sysCascade = this.sysQueryService.getSysCascadeBySid(tenantSid, tenant.getId(), 0L, appId, false, true);
            Long sysSid = sysCascade.getApp().getSid();
            if (ObjectUtils.isEmpty(sysCascade.getModules())) continue;
            for (Long targetSid : input.getActualSids()) {
                List<ConsolePolicyExportVO> resultOfEachScope = ExcelServiceImpl.prepareEntryOfEachScope(sysCascade);
                this.populateScope(targetSid, scope, tenantSid, resultOfEachScope);
                List<Long> calculatedResult = this.policyHandleService.getPolicyActionExcluded(tenantSid, sysSid, targetSid, scope);
                Map<Long, String> actualConfig = this.policyHandleService.getPolicyActionActual(tenantSid, sysSid, targetSid, scope);
                for (ConsolePolicyExportVO aResult : resultOfEachScope) {
                    if (aResult.getActionSid() != null) {
                        aResult.setActuallySetPermission(actualConfig.get(aResult.getActionSid()));
                        aResult.setCalculatedPermission(calculatedResult.contains(aResult.getActionSid()));
                        continue;
                    }
                    aResult.setActuallySetPermission(actualConfig.get(aResult.getModuleSid()));
                    aResult.setCalculatedPermission(calculatedResult.contains(aResult.getModuleSid()));
                }
                result.addAll(resultOfEachScope);
            }
        }
        if (!Boolean.TRUE.equals(input.getExportAll())) {
            result.removeIf(a -> !Boolean.TRUE.equals(a.getCalculatedPermission()) && StrUtil.isEmpty((CharSequence)a.getActuallySetPermission()));
        }
        return result;
    }

    private void populateScope(Long targetSid, String scope, Long tenantSid, List<ConsolePolicyExportVO> resultOfEachScope) {
        if (TargetType.role.name().equalsIgnoreCase(scope)) {
            Role role = (Role)this.roleRepository.findBySidAndTenantSid(targetSid, tenantSid);
            if (role != null) {
                resultOfEachScope.forEach(a -> {
                    a.setScopeId(role.getId());
                    a.setScopeName(role.getName());
                });
            }
        } else if (TargetType.user.name().equalsIgnoreCase(scope)) {
            User user = this.userRepository.findBySid(targetSid);
            if (user != null) {
                resultOfEachScope.forEach(a -> {
                    a.setScopeId(user.getId());
                    a.setScopeName(user.getName());
                });
            }
        } else if (TargetType.org.name().equalsIgnoreCase(scope)) {
            Optional org = this.orgRepository.findById(targetSid);
            org.ifPresent(o -> resultOfEachScope.forEach(a -> {
                a.setScopeId(o.getId());
                a.setScopeName(o.getName());
            }));
        }
    }

    private static List<ConsolePolicyExportVO> prepareEntryOfEachScope(SysCascade sysCascade) {
        SysQueryResultVO app = sysCascade.getApp();
        ArrayList<ConsolePolicyExportVO> resultOfEachScope = new ArrayList<ConsolePolicyExportVO>();
        for (ModuleQueryResultVO module : sysCascade.getModules()) {
            ConsolePolicyExportVO moduleEntry = new ConsolePolicyExportVO();
            resultOfEachScope.add(moduleEntry);
            moduleEntry.setModuleName(module.getName());
            moduleEntry.setModuleSid(module.getSid());
            moduleEntry.setAppId(app.getId());
            moduleEntry.setAppName(app.getName());
            if (ObjectUtils.isEmpty(module.getActions())) continue;
            for (ActionQueryResultVO action : module.getActions()) {
                ConsolePolicyExportVO actionEntry = new ConsolePolicyExportVO();
                resultOfEachScope.add(actionEntry);
                actionEntry.setActionName(action.getName());
                actionEntry.setActionSid(action.getSid());
                actionEntry.setModuleName(module.getName());
                actionEntry.setModuleSid(module.getSid());
                actionEntry.setAppId(app.getId());
                actionEntry.setAppName(app.getName());
            }
        }
        return resultOfEachScope;
    }
}

