/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.OrgExcelVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.support.excel.ImportOrgExcelService;
import com.digiwin.dap.middleware.iam.support.excel.OrgExcelListener;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.download.FileService;
import com.digiwin.dmc.sdk.service.download.IFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class ImportOrgExcelServiceImpl
implements ImportOrgExcelService {
    private static final Logger log = LoggerFactory.getLogger(ImportOrgExcelServiceImpl.class);
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DmcService dmcService;

    @Override
    public ImportExcelResultVO importOrgExcel(String fileId, long tenantSid) {
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
        try {
            OrgExcelListener listener = new OrgExcelListener(this.orgCatalogCrudService, this.orgTypeCrudService, this.orgAspectCrudService, this.orgCrudService, tenantSid);
            ExcelReader excelReader = EasyExcel.read((InputStream)fis, OrgExcelVO.class, (ReadListener)listener).build();
            ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
            excelReader.read(new ReadSheet[]{readSheet});
            List<OrgExcelVO> orgExcelVOList = listener.getOrgExcelVOS();
            List<OrgExcelVO> errOrgExcelVOList = listener.getErrOrgExcelVOS();
            excelReader.finish();
            ((InputStream)fis).close();
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setErrorCount(errOrgExcelVOList.size());
            importExcelResultVO.setSuccessCount(orgExcelVOList.size());
            if (errOrgExcelVOList.size() > 0) {
                File file = this.excelWriter(errOrgExcelVOList);
                byte[] fileBytes = this.dmcService.getFileByte(file);
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(file.getName());
                fileInfo.setDisplayName(file.getName());
                fileInfo.setExtension("xlsx");
                String shareFileId = this.dmcService.getShareFileId(fileBytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo);
                importExcelResultVO.setErrorFileUri(shareFileId);
                importExcelResultVO.setErrorFileName(file.getName());
                boolean delete = file.delete();
                if (!delete) {
                    log.error("file {} not deleted", (Object)file);
                }
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    private File excelWriter(List<OrgExcelVO> errOrgExcelVOList) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = "orgError_" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_TW.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(errOrgExcelVOList, writeSheet);
        excelWriter.finish();
        return file;
    }
}

