/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.RoleExcelNewVO;
import com.digiwin.dap.middleware.iam.domain.excel.RoleExcelVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.support.excel.ImportRoleExcelService;
import com.digiwin.dap.middleware.iam.support.excel.RoleExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.RoleExcelNewListener;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.download.FileService;
import com.digiwin.dmc.sdk.service.download.IFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class ImportRoleExcelServiceImpl
implements ImportRoleExcelService {
    private static final Logger log = LoggerFactory.getLogger(ImportRoleExcelServiceImpl.class);
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private LanguageCrudService languageCrudService;

    @Override
    public ImportExcelResultVO importRoleExcel(String fileId, long tenantSid) {
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        ByteArrayInputStream fis = new ByteArrayInputStream(bytes);
        try {
            RoleExcelListener listener = new RoleExcelListener(this.roleCatalogCrudService, this.roleCrudService, this.orgCatalogCrudService, this.orgAspectCrudService, this.orgTypeCrudService, tenantSid, this.orgCrudService);
            ExcelReader excelReader = EasyExcel.read((InputStream)fis, RoleExcelVO.class, (ReadListener)listener).build();
            ReadSheet readSheet = EasyExcel.readSheet((Integer)0).build();
            excelReader.read(new ReadSheet[]{readSheet});
            List<RoleExcelVO> roleExcelVOList = listener.getRoleExcelVOS();
            List<RoleExcelVO> errRoleExcelVOList = listener.getErrRoleExcelVOS();
            excelReader.finish();
            ((InputStream)fis).close();
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setErrorCount(errRoleExcelVOList.size());
            importExcelResultVO.setSuccessCount(roleExcelVOList.size());
            if (errRoleExcelVOList.size() > 0) {
                File file = this.excelWriter(errRoleExcelVOList);
                byte[] fileBytes = this.dmcService.getFileByte(file);
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(file.getName());
                fileInfo.setDisplayName(file.getName());
                fileInfo.setExtension("xlsx");
                String shareFileId = this.dmcService.getShareFileId(fileBytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo);
                importExcelResultVO.setErrorFileUri(shareFileId);
                importExcelResultVO.setErrorFileName(file.getName());
                boolean delete = file.delete();
                if (!delete) {
                    log.error("file {} not deleted", (Object)file);
                }
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    private File excelWriter(List<RoleExcelVO> errRoleExcelVOList) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = "roleError_" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_TW.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(errRoleExcelVOList, writeSheet);
        excelWriter.finish();
        return file;
    }

    @Override
    public ImportExcelResultVO importRoleExcelNew(String fileId, long tenantSid) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(FileService.fileInstance().download(fileId, new TenantId[0]));
            RoleExcelNewListener listener = new RoleExcelNewListener(this.roleCatalogCrudService, this.roleCrudService, tenantSid, this.languageCrudService);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)fis, RoleExcelNewVO.class, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(1))).doRead();
            List<RoleExcelNewVO> errorList = listener.getFailed();
            ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
            importExcelResultVO.setSuccessCount(listener.getSuccess().size());
            importExcelResultVO.setErrorCount(errorList.size());
            if (!errorList.isEmpty()) {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = String.format("error_%s.xlsx", localTime);
                File file = Files.createTempFile(fileName, "xlsx", new FileAttribute[0]).toFile();
                InputStream inputStream = new DefaultResourceLoader().getResource("classpath:/static/templates/import_role.xlsx").getInputStream();
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
                excelWriter.write(errorList, writeSheet);
                excelWriter.finish();
                FileInfo fileInfo = new FileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setExtension("xlsx");
                try (FileInputStream input = new FileInputStream(file);){
                    byte[] bytes = new byte[((InputStream)input).available()];
                    int read = ((InputStream)input).read(bytes);
                    if (read <= 0) {
                        log.error("nothing to read");
                    }
                    importExcelResultVO.setErrorFileUri(this.dmcService.getShareFileId(bytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo));
                    importExcelResultVO.setErrorFileName(fileName);
                }
            }
            return importExcelResultVO;
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }
}

