/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nCode;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.excel.BatchRegisterUserVO;
import com.digiwin.dap.middleware.iam.domain.excel.ExcelErrorUserInfo;
import com.digiwin.dap.middleware.iam.domain.excel.ExcelErrorUserInfoWithoutWechat;
import com.digiwin.dap.middleware.iam.domain.excel.ImportUserInfo;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadaVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.excel.ImportUserInfoByExcelService;
import com.digiwin.dap.middleware.iam.support.excel.UserExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.UserImportProcessor;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.WeComUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AppAuthUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.util.SpringBeanUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.download.FileService;
import com.digiwin.dmc.sdk.service.download.IFileService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ImportUserInfoByExcelServiceImpl
implements ImportUserInfoByExcelService {
    private static final Logger log = LoggerFactory.getLogger(ImportUserInfoByExcelServiceImpl.class);
    @Autowired
    private UserBasicInfoUpdateService userBasicInfoUpdateService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInOrgUpdateService userInOrgUpdateService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private CacService cacService;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;
    @Autowired
    private AutoEOCService autoEOCService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public ImportExcelResultVO checkAndImportUserExcel(String fileId, long tenantSid, boolean hasCorpWechat) {
        Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(tenantSid).orElseThrow(() -> new BusinessException(String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", tenantSid))));
        IFileService fileService = FileService.fileInstance();
        byte[] bytes = fileService.download(fileId, new TenantId[0]);
        try (ByteArrayInputStream fis = new ByteArrayInputStream(bytes);){
            TenantCorpConfigDTO corpIdAndAppConfig = new TenantCorpConfigDTO();
            if (hasCorpWechat) {
                corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(tenantSid);
            }
            UserImportProcessor userImportProcessor = SpringBeanUtils.getBean(UserImportProcessor.class);
            userImportProcessor.setFields(tenant, corpIdAndAppConfig, hasCorpWechat, false);
            UserExcelListener listener = new UserExcelListener(userImportProcessor);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)fis, ImportUserInfo.class, (ReadListener)listener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
            List<ExcelErrorUserInfo> failedImports = userImportProcessor.getFailedImports();
            List<ImportUserInfo> successImports = userImportProcessor.getSuccessImports();
            this.importUserExcel(false, successImports, tenant, failedImports, corpIdAndAppConfig);
            ImportExcelResultVO importExcelResultVO = this.getImportExcelResultVO(hasCorpWechat, failedImports, successImports.size() + failedImports.size());
            return importExcelResultVO;
        }
        catch (BusinessException e) {
            ErrorHandler errorHandler = e.getErrorHandler();
            throw new BusinessException(errorHandler);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    @Transactional
    public ImportResultVO<?> registerUser(BatchRegisterUserVO batchRegisterUserVO, long tenantSid) {
        Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(tenantSid).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.ERROR_21018)));
        boolean hasCorpWechat = batchRegisterUserVO.isHasCorpWechat();
        try {
            TenantCorpConfigDTO corpIdAndAppConfig = new TenantCorpConfigDTO();
            if (hasCorpWechat) {
                corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(tenantSid);
            }
            UserImportProcessor importer = SpringBeanUtils.getBean(UserImportProcessor.class);
            importer.setFields(tenant, corpIdAndAppConfig, hasCorpWechat, true);
            batchRegisterUserVO.getUserInfos().forEach(importer::process);
            List<ExcelErrorUserInfo> failedImports = importer.getFailedImports();
            List<ImportUserInfo> successImports = importer.getSuccessImports();
            this.importUserExcel(true, successImports, tenant, failedImports, corpIdAndAppConfig);
            return this.getImportResultVO(failedImports, successImports.size() + failedImports.size());
        }
        catch (BusinessException e) {
            log.error("registerUser failed", (Throwable)e);
            ErrorHandler errorHandler = e.getErrorHandler();
            throw new BusinessException(errorHandler);
        }
        catch (Exception e) {
            log.error("registerUser failed", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public ImportResultVO batchRegisterUser(BatchRegisterUserVO batchRegisterUserVO, long tenantSid) {
        Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(tenantSid).orElseThrow(() -> new BusinessException(String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", tenantSid))));
        boolean hasCorpWechat = batchRegisterUserVO.isHasCorpWechat();
        try {
            TenantCorpConfigDTO corpIdAndAppConfig = new TenantCorpConfigDTO();
            UserImportProcessor importer = SpringBeanUtils.getBean(UserImportProcessor.class);
            importer.setFields(tenant, corpIdAndAppConfig, hasCorpWechat, false);
            if (!CollectionUtils.isEmpty(batchRegisterUserVO.getUserInfos())) {
                for (ImportUserInfo toRegister : batchRegisterUserVO.getUserInfos()) {
                    User byId = (User)this.userCrudService.findById(toRegister.getId());
                    if (byId == null) {
                        importer.process(toRegister);
                        continue;
                    }
                    toRegister.setUpdate(true);
                    importer.getSuccessImports().add(toRegister);
                }
            }
            List<ExcelErrorUserInfo> failedImports = importer.getFailedImports();
            List<ImportUserInfo> successImports = importer.getSuccessImports();
            this.importUserExcel2(successImports, tenant, failedImports);
            this.authUsers(tenant, importer);
            return this.getImportResultVO(failedImports, successImports.size() + failedImports.size());
        }
        catch (BusinessException e) {
            log.error("batchRegisterUser failed", (Throwable)e);
            ErrorHandler errorHandler = e.getErrorHandler();
            throw new BusinessException(errorHandler);
        }
        catch (Exception e) {
            log.error("batchRegisterUser failed", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    private void importUserExcel2(List<ImportUserInfo> importUserInfos, Tenant tenant, List<ExcelErrorUserInfo> excelErrorUserInfos) {
        ArrayList failedDuringCreation = new ArrayList();
        if (CollectionUtils.isEmpty(importUserInfos)) {
            return;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ImportUserInfo importUserInfo : importUserInfos) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.doImport(tenant, excelErrorUserInfos, importUserInfo, failedDuringCreation), (Executor)this.dapTaskExecutor);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        importUserInfos.removeAll(failedDuringCreation);
    }

    public void doImport(Tenant tenant, List<ExcelErrorUserInfo> excelErrorUserInfos, ImportUserInfo importUserInfo, List<ImportUserInfo> failedDuringCreation) {
        try {
            if (importUserInfo.isUpdate()) {
                this.doUpdate(tenant, importUserInfo);
            } else {
                User exist = (User)this.userCrudService.findById(importUserInfo.getId());
                if (exist != null) {
                    failedDuringCreation.add(importUserInfo);
                    throw new BusinessException(I18nCode.EXCEL_IMPORT_USER_EXISTED_USER.getMessage());
                }
                UserInfo userInfo = importUserInfo.generateUserInfo();
                User user = this.userBasicInfoUpdateService.create(userInfo, false, true);
                this.saveLanguageMatedata(user.getSid(), importUserInfo.getDapAcceptLanguage());
                if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
                    UserInTenant userInTenant = new UserInTenant();
                    userInTenant.setUserSid(user.getSid());
                    userInTenant.setTenantSid(tenant.getSid());
                    if ("1".equals(importUserInfo.getUserType())) {
                        userInTenant.setUserType(true);
                    }
                    this.userInTenantCrudService.create(userInTenant);
                }
                if (StringUtils.hasLength((String)importUserInfo.getRoleId())) {
                    List<String> roles = Arrays.asList(importUserInfo.getRoleId().split(","));
                    this.userInRoleService.updateUserInRoleByUser(tenant.getSid(), user.getSid(), roles);
                }
                this.updateOrg(tenant, importUserInfo, user);
            }
        }
        catch (Exception e) {
            ExcelErrorUserInfo excelErrorUserInfo = new ExcelErrorUserInfo(importUserInfo);
            excelErrorUserInfo.setMemo(e.getMessage());
            excelErrorUserInfos.add(excelErrorUserInfo);
        }
    }

    private void doUpdate(Tenant tenant, ImportUserInfo importUserInfo) {
        User byId = (User)this.userCrudService.findById(importUserInfo.getId());
        if (byId != null) {
            UserInTenant relation;
            if (!Objects.equals(byId.getTelephone(), importUserInfo.getTelephone())) {
                byId.setTelephone(importUserInfo.getTelephone());
                this.userCrudService.update((BaseEntity)byId);
            }
            if ((relation = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), byId.getSid())) != null) {
                if (relation.isDisabled() != importUserInfo.isDisabled()) {
                    relation.setDisabled(importUserInfo.isDisabled());
                    this.userInTenantCrudService.update(relation);
                }
            } else {
                UserInTenant userInTenant = new UserInTenant();
                userInTenant.setUserSid(byId.getSid());
                userInTenant.setTenantSid(tenant.getSid());
                if ("1".equals(importUserInfo.getUserType())) {
                    userInTenant.setUserType(true);
                }
                this.userInTenantCrudService.create(userInTenant);
            }
            this.updateOrg(tenant, importUserInfo, byId);
        }
    }

    private void updateOrg(Tenant tenant, ImportUserInfo importUserInfo, User byId) {
        if (StringUtils.hasLength((String)importUserInfo.getOrgId())) {
            List<String> orgIds = Arrays.asList(importUserInfo.getOrgId().split(","));
            ArrayList<Long> orgSids = new ArrayList<Long>();
            for (String orgId : orgIds) {
                orgSids.addAll(this.orgCrudService.findByTenantSidAndId(tenant.getSid(), orgId).stream().map(BaseEntity::getSid).collect(Collectors.toList()));
            }
            if (!orgSids.isEmpty()) {
                this.userInOrgUpdateService.updateUserInOrgByUser(tenant.getSid(), byId.getSid(), "all", orgSids);
            }
        }
    }

    private void authUsers(Tenant tenant, UserImportProcessor importProcessor) {
        List<ImportUserInfo> successImports = importProcessor.getSuccessImports();
        String tenantId = tenant.getId();
        List<AppAuthUserVO> athenaUsers = this.cacService.getAppAuthUsers4Tenant(Collections.singletonList("Athena"), Collections.singletonList(tenantId));
        List<String> userIds = athenaUsers.get(0).getApps().get(0).getUserIds();
        List disabled = successImports.stream().filter(a -> Boolean.TRUE.equals(a.isDisabled()) || Boolean.FALSE.equals(a.isAuthorizationStatus())).collect(Collectors.toList());
        for (ImportUserInfo user : disabled) {
            if (!userIds.contains(user.getId())) continue;
            log.info("user:{} is disabled", (Object)user.getId());
            this.cacService.deleteUser(tenant.getId(), user.getId());
        }
        List<String> toAdd = successImports.stream().filter(a -> Boolean.FALSE.equals(a.isDisabled()) && Boolean.TRUE.equals(a.isAuthorizationStatus())).map(ImportUserInfo::getId).collect(Collectors.toList());
        if (!toAdd.isEmpty()) {
            log.info("Adding auth:{}", toAdd);
            CacAuth cacAuth = new CacAuth();
            cacAuth.setTenantId(tenantId);
            cacAuth.setTenantName(tenant.getName());
            cacAuth.setAuthorizations(Collections.singletonList(new Goods()));
            cacAuth.getAuthorizations().get(0).setCode("Athena");
            cacAuth.setAction(1);
            cacAuth.setUserIds(toAdd);
            try {
                this.cacService.purchaseOrUpdateApp(cacAuth);
            }
            catch (BusinessException e) {
                List authFailed = successImports.stream().filter(a -> toAdd.contains(a.getId())).collect(Collectors.toList());
                importProcessor.getSuccessImports().removeAll(authFailed);
                for (ImportUserInfo importUserInfo : authFailed) {
                    ExcelErrorUserInfo excelErrorUserInfo = new ExcelErrorUserInfo(importUserInfo);
                    excelErrorUserInfo.setMemo(e.getMessage());
                    importProcessor.getFailedImports().add(excelErrorUserInfo);
                }
            }
        }
    }

    private ImportExcelResultVO getImportExcelResultVO(boolean hasCorpWechat, List<ExcelErrorUserInfo> excelErrorUserInfos, int totalCount) throws Exception {
        ImportExcelResultVO importExcelResultVO = new ImportExcelResultVO();
        Integer errorCount = excelErrorUserInfos.size();
        for (ExcelErrorUserInfo error : excelErrorUserInfos) {
            if (null == error.getEmpExist() || error.getEmpExist().booleanValue()) continue;
            errorCount = errorCount - 1;
        }
        importExcelResultVO.setErrorCount(errorCount);
        importExcelResultVO.setSuccessCount(totalCount - errorCount);
        if (excelErrorUserInfos.size() > 0) {
            File file = null;
            if (hasCorpWechat) {
                file = this.excelWriter(excelErrorUserInfos);
            } else {
                List<ExcelErrorUserInfoWithoutWechat> excelErrorUserWithoutWechatInfos = excelErrorUserInfos.stream().map(ExcelErrorUserInfoWithoutWechat::new).collect(Collectors.toList());
                file = this.excelWriterWithoutWechat(excelErrorUserWithoutWechatInfos);
            }
            byte[] fileBytes = this.dmcService.getFileByte(file);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setDisplayName(file.getName());
            fileInfo.setExtension("xlsx");
            String shareFileId = this.dmcService.getShareFileId(fileBytes, (com.digiwin.dap.middleware.dmc.model.FileInfo)fileInfo);
            importExcelResultVO.setErrorFileUri(shareFileId);
            importExcelResultVO.setErrorFileName(file.getName());
            boolean delete = file.delete();
            if (!delete) {
                log.error("file {} not deleted", (Object)file);
            }
        }
        return importExcelResultVO;
    }

    private ImportResultVO getImportResultVO(List<ExcelErrorUserInfo> excelErrorUserInfos, int totalCount) {
        ImportResultVO<List<ExcelErrorUserInfo>> importResultVO = new ImportResultVO<List<ExcelErrorUserInfo>>();
        Integer errorCount = excelErrorUserInfos.size();
        for (ExcelErrorUserInfo error : excelErrorUserInfos) {
            if (null == error.getEmpExist() || error.getEmpExist().booleanValue()) continue;
            errorCount = errorCount - 1;
        }
        importResultVO.setErrorCount(errorCount);
        importResultVO.setSuccessCount(totalCount - errorCount);
        if (!CollectionUtils.isEmpty(excelErrorUserInfos)) {
            importResultVO.setError(excelErrorUserInfos);
        }
        return importResultVO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importUserExcel(Boolean updateExist, List<ImportUserInfo> importUserInfos, Tenant tenant, List<ExcelErrorUserInfo> excelErrorUserInfos, TenantCorpConfigDTO corpIdAndAppConfig) {
        ArrayList<ImportUserInfo> failedDuringCreation = new ArrayList<ImportUserInfo>();
        if (!CollectionUtils.isEmpty(importUserInfos)) {
            for (ImportUserInfo importUserInfo : importUserInfos) {
                try {
                    WeComUserVO weComUserVO;
                    User exist = (User)this.userCrudService.findById(importUserInfo.getId());
                    if (exist != null) {
                        if (!updateExist.booleanValue()) {
                            failedDuringCreation.add(importUserInfo);
                            throw new BusinessException(I18nCode.EXCEL_IMPORT_USER_EXISTED_USER.getMessage());
                        }
                        if (exist.isDisabled()) {
                            exist.setDisabled(false);
                        }
                        this.userCrudService.update((BaseEntity)exist);
                    } else {
                        UserInfo userInfo = importUserInfo.generateUserInfo();
                        exist = this.userBasicInfoUpdateService.create(userInfo, false, true);
                        this.saveLanguageMatedata(exist.getSid(), importUserInfo.getDapAcceptLanguage());
                    }
                    UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), exist.getSid());
                    if (null == userInTenant) {
                        userInTenant = new UserInTenant();
                        userInTenant.setUserSid(exist.getSid());
                        userInTenant.setTenantSid(tenant.getSid());
                        if ("1".equals(importUserInfo.getUserType())) {
                            userInTenant.setUserType(true);
                        }
                        this.userInTenantCrudService.create(userInTenant);
                    } else if (userInTenant.isDisabled()) {
                        userInTenant.setDisabled(false);
                        this.userInTenantCrudService.update(userInTenant);
                    }
                    if (!StringUtils.isEmpty((Object)importUserInfo.getRoleId())) {
                        List<String> roles = Arrays.asList(importUserInfo.getRoleId().split(","));
                        this.userInRoleService.updateUserInRoleByUser(tenant.getSid(), exist.getSid(), roles);
                    }
                    this.updateOrg(tenant, importUserInfo, exist);
                    if (StringUtils.hasText((String)importUserInfo.getWechat()) && Boolean.TRUE.equals(corpIdAndAppConfig.getAppConfig()) && Objects.nonNull(weComUserVO = this.remoteEMCService.checkWechatExistReturnOpenUserId(null, tenant.getId(), importUserInfo.getWechat(), exist.getId()))) {
                        this.metadataUpdateService.updateMetadata(new MetadaVO(exist.getId(), tenant.getId(), importUserInfo.getWechat()));
                        if (StringUtils.hasText((String)weComUserVO.getOpen_userid())) {
                            UserMetadataVO openWeComMetadata = new UserMetadataVO();
                            openWeComMetadata.setCatalogId("contact");
                            openWeComMetadata.setKey("open_wecom");
                            openWeComMetadata.setValue(weComUserVO.getOpen_userid());
                            openWeComMetadata.setUserSid(exist.getSid());
                            openWeComMetadata.setTenantSid(tenant.getSid());
                            this.metadataUpdateService.updateMetadataValue(openWeComMetadata);
                        }
                    }
                    if (tenant.isEoc()) {
                        this.autoEOCService.userJoinTenant(importUserInfo.getEmpId(), exist, tenant.getSid(), "1".equals(importUserInfo.getUserType()), true);
                    }
                    if (!ObjectUtil.equal((Object)"1", (Object)importUserInfo.getUserType())) continue;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("tenantId", tenant.getId());
                    data.put("userId", exist.getId());
                    data.put("telephone", exist.getTelephone());
                    data.put("email", exist.getEmail());
                    data.put("appIds", Collections.EMPTY_LIST);
                    this.sysNoticeService.userJoined(data, UserUtils.getToken());
                }
                catch (Exception e) {
                    ExcelErrorUserInfo excelErrorUserInfo = new ExcelErrorUserInfo(importUserInfo);
                    excelErrorUserInfo.setMemo(e.getMessage());
                    excelErrorUserInfos.add(excelErrorUserInfo);
                }
            }
            importUserInfos.removeAll(failedDuringCreation);
        }
    }

    private void saveLanguageMatedata(long userSid, String dapAcceptLanguage) {
        if (StringUtils.isEmpty((Object)dapAcceptLanguage)) {
            dapAcceptLanguage = "CN".equalsIgnoreCase(this.envProperties.getCountry()) ? "zh_CN" : "zh_TW";
        }
        this.metadataUpdateService.updateMetadataValue(new UserMetadataVO("basic", "dapAcceptLanguage", dapAcceptLanguage, 0L, userSid));
    }

    private File excelWriter(List<ExcelErrorUserInfo> excelErrorUserInfos) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = "registerError_" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_withWechat_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_withWechat_error_TW.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(excelErrorUserInfos, writeSheet);
        excelWriter.finish();
        return file;
    }

    private File excelWriterWithoutWechat(List<ExcelErrorUserInfoWithoutWechat> excelErrorUserWithoutWechatInfos) throws Exception {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = "registerError_" + localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = !Locale.TRADITIONAL_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase()) ? new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_CN.xlsx").getInputStream() : new DefaultResourceLoader().getResource("classpath:/static/templates/account_import_template_error_TW.xlsx").getInputStream();
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
        excelWriter.write(excelErrorUserWithoutWechatInfos, writeSheet);
        excelWriter.finish();
        return file;
    }
}

