/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.iam.constant.enums.TenantDataExportRecordStateEnum;
import com.digiwin.dap.middleware.iam.domain.BaseVO;
import com.digiwin.dap.middleware.iam.domain.permission.AllPermissionExcel;
import com.digiwin.dap.middleware.iam.domain.permission.AllPermissionQueryResult;
import com.digiwin.dap.middleware.iam.domain.permission.AllPermissionQueryVO;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportExcelVO;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportScopeVO;
import com.digiwin.dap.middleware.iam.domain.policy.ConsolePolicyExportVO;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ActionNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.BaseNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.ModuleNode;
import com.digiwin.dap.middleware.iam.domain.sys.tree.SysNode;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.service.permission.AuthActionService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantDataExportRecordService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.excel.IExcelService;
import com.digiwin.dap.middleware.iam.support.excel.PermissionExcelService;
import com.digiwin.dap.middleware.iam.util.ExcelFillCellMergeStrategy;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PermissionExcelServiceImpl
implements PermissionExcelService {
    private static final Logger logger = LoggerFactory.getLogger(PermissionExcelServiceImpl.class);
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;
    @Autowired
    private TenantDataExportRecordService tenantDataExportRecordService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private DMC dmcClient;
    @Autowired
    private AuthService authService;
    @Autowired
    private IExcelService excelService;
    @Autowired
    private AuthActionService authActionService;

    @Override
    public List<AllPermissionQueryResult> getAllPermissionDetails(AllPermissionQueryVO input, IamAuthoredUser authoredUser, AuthoredSys sys) {
        long tenantSid = authoredUser.getTenantSid();
        if (CollectionUtils.isEmpty(input.getSysIds())) {
            throw new IllegalArgumentException("\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<String> userIds = new HashSet<String>();
        if (CollectionUtils.isEmpty(input.getUserIds()) && CollectionUtils.isEmpty(input.getRoleIds()) && CollectionUtils.isEmpty(input.getOrgIds())) {
            userIds.addAll(this.authMapper.queryUserIdsByTenantSid(tenantSid));
        } else {
            if (!CollectionUtils.isEmpty(input.getUserIds())) {
                userIds.addAll(input.getUserIds());
            }
            if (!CollectionUtils.isEmpty(input.getRoleIds())) {
                userIds.addAll(this.userInRoleMapper.queryUserIdInRole(input.getRoleIds(), tenantSid));
            }
            if (!CollectionUtils.isEmpty(input.getOrgIds())) {
                userIds.addAll(this.userInOrgMapper.queryUserIdInOrg(tenantSid, input.getOrgIds()));
            }
        }
        if (CollectionUtils.isEmpty(userIds)) {
            return new ArrayList<AllPermissionQueryResult>();
        }
        List<CalcUser> calcUsers = this.authService.combineCalcUser(new ArrayList<String>(userIds), input.getSysIds(), authoredUser);
        CopyOnWriteArrayList<AllPermissionQueryResult> results = new CopyOnWriteArrayList<AllPermissionQueryResult>();
        HashMap sysDataMap = new HashMap();
        ArrayList futures = new ArrayList();
        calcUsers.forEach(calcUser -> {
            if (!sysDataMap.containsKey(calcUser.getAppId())) {
                sysDataMap.put(calcUser.getAppId(), this.authActionService.getSysData((CalcUser)calcUser));
            }
            SysNode sysData = (SysNode)sysDataMap.get(calcUser.getAppId());
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.combinePermissionUser((CalcUser)calcUser, sysData, (List<AllPermissionQueryResult>)results), (Executor)this.dapTaskExecutor);
            futures.add(future);
        });
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        if (!CollectionUtils.isEmpty(input.getActionIds())) {
            results.removeIf(a -> !CollectionUtils.contains(input.getActionIds().iterator(), (Object)a.getActionId()));
        }
        if (!CollectionUtils.isEmpty(input.getModuleIds())) {
            results.removeIf(a -> !CollectionUtils.contains(input.getModuleIds().iterator(), (Object)a.getModuleId()));
        }
        return results;
    }

    private void combinePermissionUser(CalcUser calcUser, SysNode sysData, List<AllPermissionQueryResult> results) {
        UserPermissionResult userPermission = this.authService.getUserPermission(calcUser, sysData);
        for (PermissionPolicy permission : userPermission.getPermissions()) {
            Map<String, PermissionUserOrg> orgs;
            AllPermissionQueryResult result = new AllPermissionQueryResult();
            result.setUserId(calcUser.getUserId());
            result.setUserName(calcUser.getUserName());
            List<PermissionUserRole> roles = userPermission.getRoles();
            if (!CollectionUtils.isEmpty(roles)) {
                result.setRoles(roles.stream().map(role -> {
                    BaseVO baseVO = new BaseVO();
                    baseVO.setId(role.getId());
                    baseVO.setName(role.getName());
                    return baseVO;
                }).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(orgs = userPermission.getOrg())) {
                result.setOrgs(orgs.values().stream().map(org -> {
                    BaseVO baseVO = new BaseVO();
                    baseVO.setId(org.getId());
                    baseVO.setName(org.getName());
                    return baseVO;
                }).collect(Collectors.toList()));
            }
            ActionNode actionNode = sysData.getActions().stream().filter(a -> a.getId().equals(permission.getId())).findFirst().get();
            ModuleNode moduleNode = sysData.getModules().stream().filter(m -> m.getId().equals(actionNode.getModuleId())).findFirst().get();
            Map<String, String> conditionMap = actionNode.getConditions().stream().collect(Collectors.toMap(BaseNode::getId, BaseNode::getName));
            result.setSysId(sysData.getId());
            result.setSysName(sysData.getName());
            result.setModuleId(moduleNode.getId());
            result.setModuleName(moduleNode.getName());
            result.setActionId(actionNode.getId());
            result.setActionName(actionNode.getName());
            List<BaseVO> conditions = permission.getCondition().entrySet().stream().filter(entry -> "allow".equals(entry.getValue())).map(entry -> {
                BaseVO baseVO = new BaseVO();
                baseVO.setId((String)entry.getKey());
                baseVO.setName((String)conditionMap.get(entry.getKey()));
                return baseVO;
            }).collect(Collectors.toList());
            result.setConditions(conditions);
            results.add(result);
        }
    }

    @Override
    public void getPermissionExcels(AllPermissionQueryVO input, IamAuthoredUser authoredUser, AuthoredSys sys, HttpServletResponse response) throws Exception {
        List<AllPermissionQueryResult> allPermissionDetails = this.getAllPermissionDetails(input, authoredUser, sys);
        List<AllPermissionExcel> permissionExcels = this.getPermissionExcel(allPermissionDetails);
        InputStream inputStream = this.getClass().getResourceAsStream("/static/templates/permission_export_template_CN.xlsx");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("UTF-8");
        String name = authoredUser.getTenantId() + "_user_" + LocalDate.now();
        String fileName = URLEncoder.encode(name, "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), AllPermissionExcel.class).withTemplate(inputStream).registerWriteHandler((WriteHandler)ExcelFillCellMergeStrategy.getStyleStrategy())).sheet(Integer.valueOf(0)).needHead(Boolean.valueOf(false))).doWrite(permissionExcels);
    }

    private List<AllPermissionExcel> getPermissionExcel(List<AllPermissionQueryResult> allPermissionDetails) {
        return allPermissionDetails.stream().map(o -> {
            int i;
            StringBuilder sb;
            AllPermissionExcel excel = new AllPermissionExcel();
            excel.setUserId(o.getUserId());
            excel.setUserName(o.getUserName());
            if (!CollectionUtils.isEmpty(o.getOrgs())) {
                sb = new StringBuilder();
                for (i = 0; i < o.getOrgs().size(); ++i) {
                    sb.append(o.getOrgs().get(i).getName()).append("(").append(o.getOrgs().get(i).getId()).append(")").append(i == o.getOrgs().size() - 1 ? "" : ",\n");
                }
                excel.setOrgShow(sb.toString());
            }
            if (!CollectionUtils.isEmpty(o.getRoles())) {
                sb = new StringBuilder();
                for (i = 0; i < o.getRoles().size(); ++i) {
                    sb.append(o.getRoles().get(i).getName()).append("(").append(o.getRoles().get(i).getId()).append(")").append(i == o.getRoles().size() - 1 ? "" : ",\n");
                }
                excel.setRoleShow(sb.toString());
            }
            excel.setSysShow(o.getSysName() + "(" + o.getSysId() + ")");
            excel.setModuleShow(o.getModuleName() + "(" + o.getModuleId() + ")");
            excel.setActionShow(o.getActionName() + "(" + o.getActionId() + ")");
            if (!CollectionUtils.isEmpty(o.getConditions())) {
                sb = new StringBuilder();
                for (i = 0; i < o.getConditions().size(); ++i) {
                    sb.append(o.getConditions().get(i).getName()).append("(").append(o.getConditions().get(i).getId()).append(")").append(i == o.getConditions().size() - 1 ? "" : ",\n");
                }
                excel.setConditionShow(sb.toString());
            }
            return excel;
        }).collect(Collectors.toList());
    }

    @Override
    public void exportAllPermission(AllPermissionQueryVO input, IamAuthoredUser user) {
        TenantDataExportRecord record = new TenantDataExportRecord();
        record.setPerm(true);
        record.setState(TenantDataExportRecordStateEnum.IN_PROGRESS.getValue());
        record.setTenantSid(user.getTenantSid());
        LocalDateTime etime = LocalDateTime.now().plusDays(1L);
        record.setExpireDate(LocalDateTime.of(etime.getYear(), etime.getMonthValue(), etime.getDayOfMonth(), 23, 59, 59));
        record.setId(UUID.randomUUID().toString());
        this.tenantDataExportRecordService.create(record);
        this.dapTaskExecutor.execute(() -> {
            try {
                LocaleContextHolder.setLocale((Locale)Locale.SIMPLIFIED_CHINESE);
                List<AllPermissionQueryResult> allPermissionDetails = this.getAllPermissionDetails(input, user, null);
                List<AllPermissionExcel> permissionExcels = this.getPermissionExcel(allPermissionDetails);
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                String localTime = df.format(LocalDateTime.now());
                String fileName = localTime + ".xlsx";
                File file = new File(fileName);
                InputStream inputStream = this.getClass().getResourceAsStream("/static/templates/permission_export_template_CN.xlsx");
                ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0).needHead(Boolean.valueOf(true))).build();
                excelWriter.write(permissionExcels, writeSheet);
                excelWriter.finish();
                String url = this.dmcClient.upload(file).getId();
                record.setUrl(url);
                record.setState(TenantDataExportRecordStateEnum.COMPLETED.getValue());
                this.tenantDataExportRecordService.update(record);
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u529f\u80fd\u6743\u9650\u5bfc\u51fa\u6570\u636eerror", (Throwable)e);
                record.setState(TenantDataExportRecordStateEnum.FAILED.getValue());
                this.tenantDataExportRecordService.update(record);
            }
        });
    }

    @Override
    public void exportAllPermissionV2(ConsolePolicyExportScopeVO input) {
        TenantDataExportRecord record = new TenantDataExportRecord();
        record.setPerm(true);
        record.setState(TenantDataExportRecordStateEnum.IN_PROGRESS.getValue());
        record.setTenantSid(input.getTenantSid());
        LocalDateTime etime = LocalDateTime.now().plusDays(3L);
        record.setExpireDate(LocalDateTime.of(etime.getYear(), etime.getMonthValue(), etime.getDayOfMonth(), 23, 59, 59));
        record.setId(UUID.randomUUID().toString());
        record.setRemark(input.getRemark());
        record.setExportParams(JsonUtils.objToJson((Object)input));
        this.tenantDataExportRecordService.create(record);
        Locale threadLocale = LocaleContextHolder.getLocale();
        this.dapTaskExecutor.execute(() -> {
            block3: {
                try {
                    LocaleContextHolder.setLocale((Locale)threadLocale);
                    String url = this.exportPermission(input);
                    TenantDataExportRecord currentRecord = (TenantDataExportRecord)this.tenantDataExportRecordService.findBySid(record.getSid());
                    if (currentRecord.getState() != TenantDataExportRecordStateEnum.CANCELLED.getValue().intValue()) {
                        currentRecord.setUrl(url);
                        currentRecord.setState(TenantDataExportRecordStateEnum.COMPLETED.getValue());
                        this.tenantDataExportRecordService.update(currentRecord);
                    }
                }
                catch (Exception e) {
                    logger.error("\u751f\u6210\u529f\u80fd\u6743\u9650\u5bfc\u51fa\u6570\u636eerror, sid={}", (Object)record.getSid(), (Object)e);
                    TenantDataExportRecord currentRecord = (TenantDataExportRecord)this.tenantDataExportRecordService.findBySid(record.getSid());
                    if (currentRecord.getState() == TenantDataExportRecordStateEnum.CANCELLED.getValue().intValue()) break block3;
                    currentRecord.setState(TenantDataExportRecordStateEnum.FAILED.getValue());
                    this.tenantDataExportRecordService.update(currentRecord);
                }
            }
        });
    }

    @Override
    public String exportPermission(ConsolePolicyExportScopeVO input) throws Exception {
        List<ConsolePolicyExportVO> consolePolicyExportVOS = this.excelService.genPolicyExportData(input);
        List permissionExcels = consolePolicyExportVOS.stream().map(ConsolePolicyExportExcelVO::new).collect(Collectors.toList());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String localTime = df.format(LocalDateTime.now());
        String fileName = localTime + ".xlsx";
        File file = new File(fileName);
        InputStream inputStream = this.getClass().getResourceAsStream("/static/templates/scope_permission_export_template_CN.xlsx");
        ExcelWriter excelWriter = EasyExcel.write((File)file).withTemplate(inputStream).build();
        WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0).needHead(Boolean.valueOf(true))).build();
        excelWriter.write(permissionExcels, writeSheet);
        excelWriter.finish();
        String url = this.dmcClient.upload(file).getId();
        return url;
    }

    @Override
    public void cancelExportTask(Long sid) {
        TenantDataExportRecord task = (TenantDataExportRecord)this.tenantDataExportRecordService.findBySid(sid);
        if (task != null) {
            task.setState(TenantDataExportRecordStateEnum.CANCELLED.getValue());
            this.tenantDataExportRecordService.update(task);
        }
    }
}

