/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.excel.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UpdateModeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.domain.excel.ImportEnterpriseUserExcelVO;
import com.digiwin.dap.middleware.iam.domain.excel.InvitedUserExcelVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.ImportExcelResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantCorpConfigDTO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.AutoEOCService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRelationWithUserService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantOperationService;
import com.digiwin.dap.middleware.iam.support.DeferredExecutionService;
import com.digiwin.dap.middleware.iam.support.excel.ImportEnterpriseUserExcelListenerV2;
import com.digiwin.dap.middleware.iam.support.excel.InvitedExcelListener;
import com.digiwin.dap.middleware.iam.support.excel.TenantBatchInviteUserService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dmc.sdk.service.download.FileService;
import com.digiwin.dmc.sdk.service.download.IFileService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantBatchInviteUserServiceImpl
implements TenantBatchInviteUserService {
    private static final Logger logger = LoggerFactory.getLogger(TenantBatchInviteUserServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantRelationWithUserService tenantRelationWithUserService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInTenantOperationService userInTenantOperationService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserV2Service userV2Service;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private AutoEOCService autoEOCService;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private DeferredExecutionService deferredExecutionService;

    @Override
    public ImportExcelResultVO batchInvitedUser(AuthoredUser authoredUser, String fileId, boolean hasCorpWechat) {
        try {
            List roles;
            boolean isAdmin = false;
            List<QueryRoleResultVO> roleResults = this.userInRoleCrudService.getUserInRoleByUser(authoredUser.getTenantSid(), authoredUser.getSid());
            if (roleResults != null && roleResults.size() > 0 && (roles = roleResults.stream().map(QueryRoleResultVO::getId).collect(Collectors.toList())).contains("superadmin")) {
                isAdmin = true;
            }
            Tenant tenant = (Tenant)((Object)this.tenantRepository.findById(authoredUser.getTenantSid()).orElseThrow(() -> new BusinessException(String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", authoredUser.getTenantSid()))));
            IFileService fileService = FileService.fileInstance();
            byte[] fileBytes = fileService.download(fileId, new TenantId[0]);
            ByteArrayInputStream input = new ByteArrayInputStream(fileBytes);
            TenantCorpConfigDTO corpIdAndAppConfig = new TenantCorpConfigDTO();
            ArrayList<String> wechats = new ArrayList();
            if (hasCorpWechat && Boolean.TRUE.equals((corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(authoredUser.getTenantSid())).getAppConfig()) && tenant.isCorpWechat()) {
                try {
                    wechats = this.remoteEMCService.getWechatUsers(null, authoredUser.getTenantId());
                }
                catch (Exception e) {
                    throw new BusinessException((ErrorHandler)I18nError.EXCEL_IMPORT_USER_WECHAT_ERROR);
                }
            }
            Set<String> bundleChildren = this.tenantQueryService.getTenantBundleChildren(authoredUser.getTenantId());
            InvitedExcelListener excelListener = new InvitedExcelListener(isAdmin, this.envProperties, this.roleCrudService, this.orgCrudService, this.tenantQueryService, this.userRepository, this.userInTenantCrudService, this.tenantRelationWithUserService, this.sysCrudService, this.dmcService, this.remoteEocService, corpIdAndAppConfig, wechats, hasCorpWechat, this.autoEOCService, bundleChildren, this.userCrudService);
            EasyExcel.read((InputStream)input, InvitedUserExcelVO.class, (ReadListener)excelListener).sheet().doRead();
            return excelListener.getBatchInvitedResult(hasCorpWechat);
        }
        catch (BusinessException e) {
            ErrorHandler errorHandler = e.getErrorHandler();
            throw new BusinessException(errorHandler);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }

    @Override
    public ImportExcelResultVO batchImportEnterpriseUser(AuthoredUser authoredUser, String fileId, boolean hasCorpWechat, UpdateModeEnum updateModeEnum) {
        List<QueryRoleResultVO> roleResultVOList = this.userInRoleCrudService.getUserInRoleByUser(authoredUser.getTenantSid(), authoredUser.getSid());
        boolean isAdmin = roleResultVOList.stream().map(QueryRoleResultVO::getId).anyMatch("superadmin"::equals);
        IFileService fileService = FileService.fileInstance();
        byte[] fileBytes = fileService.download(fileId, new TenantId[0]);
        ByteArrayInputStream input = new ByteArrayInputStream(fileBytes);
        TenantCorpConfigDTO corpIdAndAppConfig = new TenantCorpConfigDTO();
        if (hasCorpWechat) {
            corpIdAndAppConfig = this.tenantQueryService.getTenantCorpIdAndAppConfig(authoredUser.getTenantSid());
        }
        Set<String> bundleChildren = this.tenantQueryService.getTenantBundleChildren(authoredUser.getTenantId());
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        boolean autoEOCFlag = this.autoEOCService.isAutoEOC(authoredUser.getTenantSid());
        boolean consoleFlag = this.autoEOCService.isConsole(authoredUser.getTenantSid());
        List<String> canUseApps = this.tenantQueryService.getTenantApplication(authoredUser.getTenantId(), GoodsCategoryEnum.getApps(false));
        Integer minPasswordLength = this.tenantQueryService.getTenantPasswordMinLength(authoredUser.getTenantSid());
        ImportEnterpriseUserExcelListenerV2 excelListenerV2 = new ImportEnterpriseUserExcelListenerV2(autoEOCFlag, this.autoEOCService, bundleChildren, canUseApps, consoleFlag, corpIdAndAppConfig, this.envProperties, hasCorpWechat, updateModeEnum, isAdmin, minPasswordLength, this.orgMapper, this.remoteEMCService, this.roleMapper, this.sysMapper, tenant, this.userCrudService, this.userRepository, this.userInTenantCrudService, this.userInTenantOperationService, this.userMapper, this.dmcService);
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)input, ImportEnterpriseUserExcelVO.class, (ReadListener)excelListenerV2).sheet().headRowNumber(Integer.valueOf(2))).doRead();
            this.deferredExecutionService.runAfterCommitAsync(() -> excelListenerV2.bindingUserConsoleBatch(authoredUser.getToken()));
            this.deferredExecutionService.runAfterCommitAsync(() -> excelListenerV2.updateWechat(authoredUser.getToken()));
            return excelListenerV2.getBatchInvitedResult(hasCorpWechat);
        }
        catch (BusinessException e) {
            ErrorHandler errorHandler = e.getErrorHandler();
            throw new BusinessException(errorHandler);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.EXPORT_FAILED);
        }
    }
}

