/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.huawei.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthType;
import com.digiwin.dap.middleware.iam.domain.tenant.SysInTenantVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.oauth.ThirdOauthService;
import com.digiwin.dap.middleware.iam.support.remote.OAuthLogin4HuaweiService;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginInfo;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginRequest;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthLoginResponse;
import com.digiwin.dap.middleware.iam.support.remote.domain.huawei.OAuthUserInfo;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class Login4HuaweiServiceImpl
implements ThirdOauthService {
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private OAuthLogin4HuaweiService oAuthLogin4HuaweiService;
    @Autowired
    protected AuthoredUserService authoredUserService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantRepository tenantRepository;

    @Override
    public boolean support(OAuthLoginInfo loginInfo) {
        return OauthType.HuaWei.getCode().equals(loginInfo.getOauthType());
    }

    @Override
    public IamAuthoredUser getWebAccessToken(OAuthLoginInfo loginInfo) {
        Tenant tenant = this.tenantCrudService.findTenantByTenantId(loginInfo.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, loginInfo.getTenantId());
        }
        SysInTenantVO sysInfo = this.sysInTenantQueryService.getSysClientInfoByTenant(tenant.getSid(), loginInfo.getAppId());
        if (sysInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_AUTHORIZATION_INFO, new Object[]{tenant.getId(), loginInfo.getAppId()});
        }
        if (StringUtils.isEmpty((Object)sysInfo.getClientId()) || StringUtils.isEmpty((Object)sysInfo.getClientSecret())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_SECRET_INFO, new Object[]{tenant.getId(), sysInfo.getAppId()});
        }
        OAuthLoginRequest oAuthLoginRequest = new OAuthLoginRequest();
        oAuthLoginRequest.setClientId(sysInfo.getClientId());
        oAuthLoginRequest.setClientSecret(sysInfo.getClientSecret());
        oAuthLoginRequest.setCode(loginInfo.getCode());
        OAuthLoginResponse response = this.oAuthLogin4HuaweiService.getWebAccessToken(sysInfo.getDomainName(), oAuthLoginRequest);
        oAuthLoginRequest.setAccessToken(response.getAccessToken());
        oAuthLoginRequest.setTokenType(response.getTokenType());
        OAuthUserInfo oAuthUserInfo = this.oAuthLogin4HuaweiService.getUserInfo(sysInfo.getDomainName(), oAuthLoginRequest);
        return this.login(tenant, oAuthUserInfo.getUserName());
    }

    @Override
    public IamAuthoredUser getAppAccessToken(OAuthLoginInfo loginInfo) {
        Tenant tenant = this.tenantRepository.findByTenantCode(loginInfo.getTenantCode());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{loginInfo.getTenantCode()});
        }
        SysInTenantVO sysInfo = this.sysInTenantQueryService.getSysClientInfoByTenant(tenant.getSid(), null);
        if (sysInfo == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_AUTHORIZATION_INFO, new Object[]{tenant.getId()});
        }
        if (StringUtils.isEmpty((Object)sysInfo.getClientId()) || StringUtils.isEmpty((Object)sysInfo.getClientSecret())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_SECRET_INFO, new Object[]{loginInfo.getCode(), sysInfo.getAppId()});
        }
        OAuthLoginRequest oAuthLoginRequest = new OAuthLoginRequest();
        oAuthLoginRequest.setClientId(sysInfo.getClientId());
        oAuthLoginRequest.setClientSecret(sysInfo.getClientSecret());
        OAuthLoginResponse oAuthLoginResponse = this.oAuthLogin4HuaweiService.getAppTenantToken(sysInfo.getDomainName(), oAuthLoginRequest);
        oAuthLoginRequest.setSessionToken(loginInfo.getSessionToken());
        oAuthLoginRequest.setOperatingSysVersion(loginInfo.getOperatingSysVersion());
        oAuthLoginRequest.setDeviceIp(loginInfo.getDeviceIp());
        oAuthLoginRequest.setDeviceFingerprint(loginInfo.getDeviceFingerprint());
        oAuthLoginRequest.setAccessToken(oAuthLoginResponse.getAccessToken());
        oAuthLoginRequest.setTokenType(oAuthLoginResponse.getTokenType());
        oAuthLoginResponse = this.oAuthLogin4HuaweiService.getSSOTicket(sysInfo.getDomainName(), oAuthLoginRequest);
        oAuthLoginRequest.setSsoTicket(oAuthLoginResponse.getSsoTicket());
        OAuthUserInfo oAuthUserInfo = this.oAuthLogin4HuaweiService.verifySSOTicket(sysInfo.getDomainName(), oAuthLoginRequest);
        return this.login(tenant, oAuthUserInfo.getUserName());
    }

    private IamAuthoredUser login(Tenant tenant, String userId) {
        userId = String.format("%s$%s", tenant.getId(), userId);
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setIdentityType(IdentityType.huaweiOAuth);
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
        loginUser.setApp(new Sys(UserUtils.getAuthoredSys()));
        IamAuthoredUser authoredUser = this.authoredUserService.generate(loginUser, true, false);
        return authoredUser;
    }
}

