/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.huawei.impl;

import com.alibaba.excel.util.StringUtils;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.org.OrgPath;
import com.digiwin.dap.middleware.iam.domain.org.OrgResultVO;
import com.digiwin.dap.middleware.iam.domain.org.OrgVO;
import com.digiwin.dap.middleware.iam.domain.sync.ApplicationSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.AuthSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.FlagEnum;
import com.digiwin.dap.middleware.iam.domain.sync.OrgSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.OrgSyncInfo;
import com.digiwin.dap.middleware.iam.domain.sync.SaveTenantAuthSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.TenantSyncDTO;
import com.digiwin.dap.middleware.iam.domain.sync.UserSyncInfo;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgPathService;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantQueryService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.huawei.ProduceSyncService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAliasVO;
import com.digiwin.dap.middleware.iam.support.validate.OrgValidateService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProduceSyncServiceImpl
implements ProduceSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProduceSyncServiceImpl.class);
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    public static final LocalDateTime LOCAL_DATE_TIME_9999 = LocalDateTime.of(9999, 12, 31, 23, 59, 59);
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private SysInTenantQueryService sysInTenantQueryService;
    @Autowired
    private OrgCrudService orgCrudService;
    @Autowired
    private OrgPathService orgPathService;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgQueryService orgQueryService;
    @Autowired
    private OrgValidateService orgValidateService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private CacService cacService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInOrgMapper userInOrgMapper;

    @Override
    @Transactional
    public boolean updateTenantSync(TenantSyncDTO dto, long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        if (StrUtils.isNotEmpty((String)tenant.getTenantCode()) && !tenant.getTenantCode().equals(dto.getTenantCode())) {
            throw new BusinessException("\u5df2\u5b58\u5728\u79df\u6237[" + tenant.getTenantCode() + "]\u540c\u6b65\u4fe1\u606f\uff0c\u4e0d\u652f\u6301\u591a\u4e2a\u79df\u6237\u3002");
        }
        tenant.setTenantCode(dto.getTenantCode());
        tenant.setDomainName(dto.getDomainName());
        this.tenantCrudService.update((BaseEntity)tenant);
        return true;
    }

    @Override
    @Transactional
    public boolean saveTenantAppSync(ApplicationSyncDTO dto, AuthoredUser authoredUser) {
        String goodsCode = this.getGoodsCodeByGoodsAlias(dto.getAppId());
        SysInTenant sysInTenant = this.sysInTenantQueryService.getSysInTenantBySysIdAndTenantSid(authoredUser.getTenantSid(), goodsCode);
        if (sysInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_SYS_NOT_EXIST, new Object[]{authoredUser.getTenantId(), goodsCode});
        }
        sysInTenant.setClientId(dto.getClientId());
        sysInTenant.setClientSecret(dto.getClientSecret());
        this.sysInTenantCrudService.update((BaseEntity)sysInTenant);
        return true;
    }

    @Override
    @Transactional
    public boolean saveTenantAppSyncSave(ApplicationSyncDTO dto) {
        String goodsCode = dto.getGoodsCode();
        SysInTenant sysInTenant = this.sysInTenantQueryService.getSysInTenantBySysIdAndTenantSid(UserUtils.getTenantSid(), goodsCode);
        if (sysInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_SYS_NOT_EXIST, new Object[]{UserUtils.getTenantId(), goodsCode});
        }
        sysInTenant.setClientId(dto.getClientId());
        sysInTenant.setClientSecret(dto.getClientSecret());
        this.sysInTenantCrudService.update((BaseEntity)sysInTenant);
        return true;
    }

    @Override
    @Transactional
    public boolean saveTenantAuthSync(AuthSyncDTO dto, AuthoredUser authoredUser) {
        List userList;
        try {
            userList = (List)objectMapper.readValue(dto.getUserList(), (TypeReference)new TypeReference<List<UserSyncInfo>>(){});
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        if (CollectionUtils.isEmpty((Collection)userList)) {
            LOGGER.info("\u79df\u6237[{}]\u4e0buserList\u4e3a\u7a7a\uff0c\u9000\u51fa\u4fdd\u5b58", (Object)authoredUser.getTenantId());
            return false;
        }
        List<String> userIdList = ProduceSyncServiceImpl.getUserIdList(authoredUser, userList);
        if (userIdList.isEmpty()) {
            LOGGER.info("\u79df\u6237[{}]\u4e0buserList\u4e3a\u7a7a\uff0c\u9000\u51fa\u4fdd\u5b58", (Object)authoredUser.getTenantId());
            return false;
        }
        List<User> existsUserList = this.userRepository.findByIdIn(userIdList);
        List existsUserIdList = existsUserList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        if (FlagEnum.UPDATE.getValue().equals(dto.getFlag())) {
            List<UserSyncInfo> updateUserList = userList.stream().filter(x -> existsUserIdList.contains(x.getUserName())).collect(Collectors.toList());
            return this.updateUser(updateUserList, existsUserList, authoredUser.getTenantSid());
        }
        List<UserSyncInfo> addUserList = userList.stream().filter(x -> !existsUserIdList.contains(x.getUserName())).collect(Collectors.toList());
        this.createUser(addUserList, authoredUser.getTenantSid());
        String goodsCode = this.getGoodsCodeByGoodsAlias(dto.getAppId());
        dto.setGoodsCode(goodsCode);
        AuthorizationResultVO authorization = this.cacService.queryAllAuthorization(authoredUser.getTenantId(), dto.getGoodsCode());
        if (authorization == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NO_AUTHORIZATION_INFO, new Object[]{authoredUser.getTenantId(), dto.getGoodsCode()});
        }
        this.authUser(dto, authoredUser, userList, userIdList, authorization);
        return true;
    }

    @Override
    @Transactional
    public SaveTenantAuthSyncDTO saveTenantAuthSyncIAM(AuthSyncDTO dto, AuthoredUser authoredUser) {
        List userList;
        SaveTenantAuthSyncDTO result = new SaveTenantAuthSyncDTO();
        try {
            userList = (List)objectMapper.readValue(dto.getUserList(), (TypeReference)new TypeReference<List<UserSyncInfo>>(){});
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        if (CollectionUtils.isEmpty((Collection)userList)) {
            LOGGER.info("\u79df\u6237[{}]\u4e0buserList\u4e3a\u7a7a\uff0c\u9000\u51fa\u4fdd\u5b58", (Object)authoredUser.getTenantId());
            return result.returnResult(false);
        }
        List<String> userIdList = ProduceSyncServiceImpl.getUserIdList(authoredUser, userList);
        if (userIdList.isEmpty()) {
            LOGGER.info("\u79df\u6237[{}]\u4e0buserList\u4e3a\u7a7a\uff0c\u9000\u51fa\u4fdd\u5b58", (Object)authoredUser.getTenantId());
            return result.returnResult(false);
        }
        List<User> existsUserList = this.userRepository.findByIdIn(userIdList);
        List existsUserIdList = existsUserList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        if (FlagEnum.UPDATE.getValue().equals(dto.getFlag())) {
            List<UserSyncInfo> updateUserList = userList.stream().filter(x -> existsUserIdList.contains(x.getUserName())).collect(Collectors.toList());
            return result.returnResult(this.updateUser(updateUserList, existsUserList, authoredUser.getTenantSid()));
        }
        List<UserSyncInfo> addUserList = userList.stream().filter(x -> !existsUserIdList.contains(x.getUserName())).collect(Collectors.toList());
        this.createUser(addUserList, authoredUser.getTenantSid());
        result.setUserIdList(userIdList);
        result.setSuccess(true);
        return result;
    }

    private String getGoodsCodeByGoodsAlias(String appId) {
        List<GoodsAliasVO> goodsAliasList = this.gmcService.findGoodsAliasList(Collections.singletonMap("goodsAliasId", appId));
        if (goodsAliasList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_GOODS, new Object[]{appId});
        }
        String goodsCode = goodsAliasList.get(0).getGoodsCode();
        LOGGER.info("goodsCode={}, goodsAliasList={}", (Object)goodsCode, goodsAliasList);
        return goodsCode;
    }

    @Override
    @Transactional
    public boolean saveOrgSync(OrgSyncDTO dto, AuthoredUser authoredUser) {
        OrgVO orgVO = this.checkOrg(dto.getOrgCode(), dto.getOrgName(), authoredUser);
        if (FlagEnum.ADD.getValue().equals(dto.getFlag())) {
            return this.createOrg(dto.getParentCode(), authoredUser, orgVO);
        }
        if (FlagEnum.UPDATE.getValue().equals(dto.getFlag())) {
            return this.updateOrg(dto, authoredUser, orgVO);
        }
        if (FlagEnum.DELETE.getValue().equals(dto.getFlag())) {
            return this.deleteOrg(dto, authoredUser);
        }
        return false;
    }

    @Override
    @Transactional
    public boolean saveAllOrgSync(OrgSyncDTO dto, AuthoredUser authoredUser) {
        List orgInfoList;
        try {
            orgInfoList = (List)objectMapper.readValue(dto.getOrgInfo(), (TypeReference)new TypeReference<List<OrgSyncInfo>>(){});
        }
        catch (IOException e) {
            throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
        }
        if (CollectionUtils.isEmpty((Collection)orgInfoList)) {
            LOGGER.warn("\u79df\u6237[{}]\u4e0borgInfoList\u4e3a\u7a7a\uff0c\u9000\u51fa\u4fdd\u5b58", (Object)authoredUser.getTenantId());
            return true;
        }
        Long orgAspectSid = this.getAspectSid(authoredUser);
        if (orgAspectSid == null) {
            return false;
        }
        List<OrgResultVO> orgResultList = this.orgQueryService.getAspect(authoredUser.getTenantSid(), orgAspectSid);
        List<String> newCodeList = orgInfoList.stream().map(OrgSyncInfo::getOrgCode).collect(Collectors.toList());
        List<String> oldCodeList = orgResultList.stream().map(OrgResultVO::getLabel).collect(Collectors.toList());
        this.delOrgList(orgResultList, newCodeList);
        this.addOrgList(authoredUser, orgInfoList, oldCodeList);
        this.updateOrgList(authoredUser, orgInfoList, orgResultList);
        return true;
    }

    private Long getAspectSid(AuthoredUser authoredUser) {
        String orgCatalogId = "defaultOrgCatalog";
        String orgAspectId = "defaultOrgAspect";
        long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(authoredUser.getTenantSid(), orgCatalogId);
        if (orgCatalogSid == 0L) {
            LOGGER.warn("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7\u5206\u7c7b[{}]\u4e0d\u5b58\u5728", (Object)authoredUser.getTenantId(), (Object)orgCatalogId);
            return null;
        }
        long orgAspectSid = this.orgAspectCrudService.getSidByUnionKey(new Object[]{authoredUser.getTenantSid(), orgCatalogSid, orgAspectId});
        if (orgAspectSid == 0L) {
            LOGGER.warn("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7\u6811[{}]\u4e0d\u5b58\u5728", (Object)authoredUser.getTenantId(), (Object)orgAspectId);
            return null;
        }
        return orgAspectSid;
    }

    private void updateOrgList(AuthoredUser authoredUser, List<OrgSyncInfo> orgInfoList, List<OrgResultVO> orgResultList) {
        List updateList = orgResultList.stream().filter(x -> orgInfoList.stream().anyMatch(o -> Objects.equals(x.getLabel(), o.getOrgCode()) && !Objects.equals(x.getName(), o.getName()))).collect(Collectors.toList());
        for (OrgResultVO updateOrg : updateList) {
            OrgVO orgVO = this.checkOrg(updateOrg.getLabel(), updateOrg.getName(), authoredUser);
            Org org = (Org)this.orgCrudService.findBySid(updateOrg.getSid());
            orgInfoList.stream().filter(x -> Objects.equals(org.getId(), x.getOrgCode())).findFirst().ifPresent(x -> {
                org.setName(x.getName());
                OrgPath orgPath = this.orgPathService.getOrgPath(orgVO.getOrgCatalogSid(), org.getOrgAspectSid(), org.getParentSid(), org.getId(), org.getName());
                org.setUrn(orgPath.getOrgUrn());
                this.orgCrudService.update((BaseEntity)org);
            });
        }
    }

    private void addOrgList(AuthoredUser authoredUser, List<OrgSyncInfo> orgInfoList, List<String> oldCodeList) {
        List addList = orgInfoList.stream().filter(x -> !oldCodeList.contains(x.getOrgCode())).collect(Collectors.toList());
        for (OrgSyncInfo addOrg : addList) {
            OrgVO orgVO = this.checkOrg(addOrg.getOrgCode(), addOrg.getName(), authoredUser);
            this.createOrg(addOrg.getParentCode(), authoredUser, orgVO);
        }
    }

    private void delOrgList(List<OrgResultVO> orgResultList, List<String> newCodeList) {
        List delList = orgResultList.stream().filter(x -> !newCodeList.contains(x.getLabel())).collect(Collectors.toList());
        List delSidList = delList.stream().map(OrgResultVO::getSid).collect(Collectors.toList());
        delList.removeIf(o -> delSidList.contains(o.getParentSid()));
        for (OrgResultVO delOrg : delList) {
            this.orgCrudService.deleteOrgBySid(delOrg.getSid());
        }
    }

    private OrgVO checkOrg(String orgCode, String orgName, AuthoredUser user) {
        OrgVO orgVO = new OrgVO();
        orgVO.setOrgAspectId("defaultOrgAspect");
        orgVO.setOrgCatalogId("defaultOrgCatalog");
        orgVO.setTypeId("department");
        orgVO.setTenantSid(user.getTenantSid());
        orgVO.setId(orgCode);
        orgVO.setLabel(orgCode);
        orgVO.setName(orgName);
        if (!StringUtil.checkSpecialId(orgVO.getLabel())) {
            throw new BusinessException((ErrorHandler)I18nError.ORG_ID_ERROR);
        }
        this.orgValidateService.checkParameters(orgVO, user, user.getTenantSid());
        return orgVO;
    }

    private boolean createOrg(String parentCode, AuthoredUser user, OrgVO orgVO) {
        if (StringUtils.isEmpty((Object)parentCode)) {
            orgVO.setParentSid(0L);
        } else {
            List<Org> parentOrgList = this.orgCrudService.findByTenantSidAndId(user.getTenantSid(), parentCode);
            if (CollectionUtils.isEmpty(parentOrgList)) {
                LOGGER.error("\u79df\u6237[{}]\u4e0b\u7236\u7ec4\u7ec7[{}]\u4e0d\u5b58\u5728", (Object)user.getTenantId(), (Object)parentCode);
                return false;
            }
            orgVO.setParentSid(parentOrgList.get(0).getSid());
        }
        Org org = orgVO.convertToOrg();
        OrgPath orgPath = this.orgPathService.getOrgPath(orgVO.getOrgCatalogSid(), orgVO.getOrgAspectSid(), orgVO.getParentSid(), orgVO.getLabel(), orgVO.getName());
        org.setUri(orgPath.getOrgUri());
        org.setUrn(orgPath.getOrgUrn());
        Org oldOrg = (Org)this.orgCrudService.findByUnionKey(new Object[]{org.getTenantSid(), org.getOrgAspectSid(), org.getId(), org.getParentSid()});
        if (oldOrg != null) {
            LOGGER.error("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7[{}]\u5df2\u5b58\u5728\uff0c\u9000\u51fa\u65b0\u589e", (Object)user.getTenantId(), (Object)orgVO.getId());
            return false;
        }
        this.orgCrudService.create((BaseEntity)org);
        return true;
    }

    private boolean updateOrg(OrgSyncDTO dto, AuthoredUser user, OrgVO orgVO) {
        List<Org> oldOrgList = this.orgCrudService.findByTenantSidAndId(user.getTenantSid(), dto.getOrgCode());
        if (CollectionUtils.isEmpty(oldOrgList)) {
            LOGGER.error("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7[{}]\u4e0d\u5b58\u5728\uff0c\u9000\u51fa\u66f4\u65b0", (Object)user.getTenantId(), (Object)dto.getOrgCode());
            return false;
        }
        Org org = oldOrgList.get(0);
        org.setName(dto.getOrgName());
        OrgPath orgPath = this.orgPathService.getOrgPath(orgVO.getOrgCatalogSid(), orgVO.getOrgAspectSid(), org.getParentSid(), orgVO.getLabel(), orgVO.getName());
        org.setUrn(orgPath.getOrgUrn());
        this.orgCrudService.update((BaseEntity)org);
        return true;
    }

    private boolean deleteOrg(OrgSyncDTO dto, AuthoredUser user) {
        List<Org> oldOrgList = this.orgCrudService.findByTenantSidAndId(user.getTenantSid(), dto.getOrgCode());
        if (CollectionUtils.isEmpty(oldOrgList)) {
            LOGGER.warn("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7[{}]\u5df2\u5220\u9664", (Object)user.getTenantId(), (Object)dto.getOrgCode());
            return true;
        }
        Org org = oldOrgList.get(0);
        List<Org> childOrgs = this.orgRepository.findByParentSid(org.getSid());
        if (!CollectionUtils.isEmpty(childOrgs)) {
            LOGGER.error("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7[{}]\u4e0b\u5b58\u5728\u591a\u4e2a\u7ec4\u7ec7\uff0c\u9000\u51fa\u5220\u9664", (Object)user.getTenantId(), (Object)dto.getOrgCode());
            return false;
        }
        this.orgCrudService.deleteOrgBySid(org.getSid());
        return true;
    }

    private static List<String> getUserIdList(AuthoredUser authoredUser, List<UserSyncInfo> userList) {
        Iterator<UserSyncInfo> iterator = userList.iterator();
        while (iterator.hasNext()) {
            UserSyncInfo x = iterator.next();
            if (!x.getUserName().contains("$")) {
                x.setUserName(authoredUser.getTenantId() + "$" + x.getUserName());
            }
            if ("admin".equals(x.getRole())) {
                x.setRole("superadmin");
            } else {
                x.setRole(null);
            }
            if (x.getUserName().contains(authoredUser.getTenantId() + "$")) continue;
            iterator.remove();
        }
        return userList.stream().map(UserSyncInfo::getUserName).collect(Collectors.toList());
    }

    private void authUser(AuthSyncDTO dto, AuthoredUser authoredUser, List<UserSyncInfo> userList, List<String> userIdList, AuthorizationResultVO authorization) {
        List<String> authUserIds = this.cacService.getAuthorizedUserIds(authoredUser.getTenantId(), dto.getGoodsCode());
        int size = authUserIds.size();
        if (FlagEnum.DELETE.getValue().equals(dto.getFlag())) {
            authUserIds.removeAll(userIdList);
        } else if (FlagEnum.ADD.getValue().equals(dto.getFlag())) {
            authUserIds.addAll(userIdList.subList(0, Math.min(userList.size(), authorization.getTotalUserCount() < 0 ? Integer.MAX_VALUE : authorization.getTotalUserCount() - authorization.getUserCount())));
        }
        if (size != authUserIds.size()) {
            this.cacService.updateUserInCounting(authoredUser.getTenantId(), dto.getGoodsCode(), authUserIds);
        }
    }

    private boolean updateUser(List<UserSyncInfo> updateUserList, List<User> existsUserList, long tenantSid) {
        for (UserSyncInfo o : updateUserList) {
            existsUserList.stream().filter(u -> u.getId().equals(o.getUserName())).findFirst().ifPresent(user -> {
                List<Org> oldOrgList;
                QueryUserInOrgResultVO orgResultVO;
                String encryptName;
                if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, user.getSid())) {
                    UserInTenant userInTenant = new UserInTenant();
                    userInTenant.setTenantSid(tenantSid);
                    userInTenant.setUserSid(user.getSid());
                    userInTenant.setDueDate(LOCAL_DATE_TIME_9999);
                    userInTenant.setDisabled(false);
                    userInTenant.setUserType(Boolean.FALSE);
                    this.userInTenantCrudService.create(userInTenant);
                }
                if (!Objects.equals(encryptName = o.getName(), user.getName())) {
                    user.setName(encryptName);
                    this.userCrudService.update((BaseEntity)user);
                }
                this.userInRoleService.updateUserInRoleByUser(tenantSid, user.getSid(), Collections.singletonList(o.getRole()));
                List<QueryUserInOrgResultVO> existsUserInOrg = this.userInOrgMapper.queryUserInOrgByUser(tenantSid, user.getSid());
                List needDelList = existsUserInOrg.stream().filter(x -> !x.getOrgLabel().equals(o.getOrgCode())).collect(Collectors.toList());
                for (QueryUserInOrgResultVO existes : needDelList) {
                    this.userInOrgCrudService.deleteById(existes.getSid());
                }
                if (!StringUtils.isEmpty((Object)o.getOrgCode()) && (orgResultVO = (QueryUserInOrgResultVO)existsUserInOrg.stream().filter(x -> x.getOrgLabel().equals(o.getOrgCode())).findFirst().orElse(null)) == null && !CollectionUtils.isEmpty(oldOrgList = this.orgCrudService.findByTenantSidAndId(tenantSid, o.getOrgCode()))) {
                    Org org = oldOrgList.get(0);
                    this.userInOrgCrudService.create(new UserInOrg(user.getSid(), org.getSid()));
                }
            });
        }
        return true;
    }

    private void createUser(List<UserSyncInfo> addUserList, long tenantSid) {
        for (UserSyncInfo o : addUserList) {
            Role role;
            User user = new User();
            user.setId(o.getUserName());
            user.setPassword(DigestUtils.sha256((String)(o.getUserName() + "hw")));
            user.setChanged(false);
            user.setActivated(true);
            user.setType(1);
            user.setName(o.getName());
            long userSid = this.userCrudService.create((BaseEntity)user);
            if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
                UserInTenant userInTenant = new UserInTenant();
                userInTenant.setTenantSid(tenantSid);
                userInTenant.setUserSid(userSid);
                userInTenant.setDueDate(LOCAL_DATE_TIME_9999);
                userInTenant.setDisabled(false);
                userInTenant.setUserType(Boolean.FALSE);
                this.userInTenantCrudService.create(userInTenant);
            }
            if (!StringUtils.isEmpty((Object)o.getRole()) && (role = this.roleCrudService.findByTenantSidAndId(tenantSid, o.getRole())) != null) {
                Association association = new Association();
                association.setTenantSid(tenantSid);
                association.setRoleSid(role.getSid());
                association.setUserSid(userSid);
                association.setStatus(Boolean.TRUE);
                if (!this.userInRoleCrudService.existsByUnionKey(tenantSid, userSid, role.getSid())) {
                    this.userInRoleCrudService.create((BaseEntity)association);
                }
            }
            if (StringUtils.isEmpty((Object)o.getOrgCode())) continue;
            List<Org> oldOrgList = this.orgCrudService.findByTenantSidAndId(tenantSid, o.getOrgCode());
            if (CollectionUtils.isEmpty(oldOrgList)) {
                LOGGER.warn("\u79df\u6237[{}]\u4e0b\u7ec4\u7ec7[{}]\u4e0d\u5b58\u5728\uff0c\u7528\u6237{}\u8df3\u8fc7\u7ed1\u5b9a\u7ec4\u7ec7", new Object[]{tenantSid, o.getOrgCode(), o.getUserName()});
                continue;
            }
            Org org = oldOrgList.get(0);
            this.userInOrgCrudService.create(new UserInOrg(userSid, org.getSid()));
        }
    }
}

