/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.initialize.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyCondition;
import com.digiwin.dap.middleware.iam.domain.role.RoleVO;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.mapper.AuthMapper;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.AsscInitializeService;
import com.digiwin.dap.middleware.iam.support.remote.AsscService;
import com.digiwin.dap.middleware.iam.support.remote.domain.RolePermissionVO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AsscInitializeServiceImpl
implements AsscInitializeService {
    private static final Logger logger = LoggerFactory.getLogger(AsscInitializeServiceImpl.class);
    @Autowired
    private AsscService asscService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private AuthMapper authMapper;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private PolicyConditionValueCrudService policyConditionValueCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initializeAsscPermission(Long tenantSid, String appId, String backUri, List<RolePermissionVO> data) {
        if (!this.tenantCrudService.exists(tenantSid)) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantSid});
        }
        List<RolePermissionVO> asscRolePermissionVOList = !StringUtils.isEmpty((Object)backUri) ? this.asscService.getAsscRolePermission(appId, backUri) : data;
        if (asscRolePermissionVOList.size() > 0) {
            long sysSid = this.sysCrudService.getSidById(appId);
            List<PolicyAction> dbActions = this.authMapper.findPolicyAction(tenantSid, sysSid);
            List<PolicyCondition> dbConditions = this.authMapper.findPolicyCondition(sysSid);
            Map<Long, List<PolicyCondition>> dbConditionMap = dbConditions.stream().collect(Collectors.groupingBy(PolicyCondition::getActionSid));
            asscRolePermissionVOList.forEach(rolePermission -> {
                long roleSid = this.addRole(tenantSid, rolePermission.getRoleId(), rolePermission.getRoleName());
                Policy policy = this.policyHandleService.savePolicy(tenantSid, sysSid, roleSid, TargetType.role.name());
                long policySid = policy.getSid();
                this.policyConditionValueCrudService.deleteByPolicySid(policySid);
                ArrayList<Long> actionSids = new ArrayList<Long>();
                rolePermission.getActions().forEach(roleAction -> {
                    PolicyAction existedAction = dbActions.stream().filter(a -> {
                        if (StringUtils.isEmpty((Object)roleAction.getModuleId())) {
                            return a.getId().equals(roleAction.getActionId());
                        }
                        return a.getId().equals(roleAction.getActionId()) && a.getModuleId().equals(roleAction.getModuleId());
                    }).findFirst().orElse(null);
                    if (existedAction == null) {
                        logger.warn("\u5e94\u7528{}\u4e0b\u7684\u884c\u4e3a{}\u4e0d\u5b58\u5728", (Object)appId, (Object)roleAction.getActionId());
                        return;
                    }
                    Long actionSid = existedAction.getSid();
                    if (!actionSids.contains(actionSid)) {
                        actionSids.add(actionSid);
                        HashMap<String, String> roleConditions = new HashMap<String, String>();
                        for (Map<String, String> conditionValue : roleAction.getConditionValues()) {
                            if (!conditionValue.containsKey("key")) continue;
                            roleConditions.put(conditionValue.get("key"), conditionValue.get("value"));
                        }
                        if (!roleConditions.isEmpty() && !dbConditionMap.isEmpty()) {
                            Map<String, String> conditionValue;
                            PolicyConditionValue policyConditionValue = new PolicyConditionValue();
                            policyConditionValue.setActionSid(actionSid);
                            policyConditionValue.setPolicySid(policySid);
                            conditionValue = this.getConditionValue(roleConditions, (List)dbConditionMap.get(actionSid));
                            policyConditionValue.setConditionValue((String)((Object)conditionValue));
                            this.policyConditionValueCrudService.create(policyConditionValue);
                        }
                    }
                });
                this.policyHandleService.updateStatement(policy, Collections.emptyList(), actionSids, true, "");
            });
        }
    }

    private String getConditionValue(Map<String, String> roleConditions, List<PolicyCondition> defaultConditions) {
        ArrayList conditionValues = new ArrayList();
        defaultConditions.forEach(condition -> {
            HashMap<String, Object> conditionValue = new HashMap<String, Object>(3);
            conditionValue.put("sid", SnowFlake.getInstance().newId());
            conditionValue.put("key", condition.getKey());
            conditionValue.put("value", roleConditions.getOrDefault(condition.getKey(), condition.getValue()));
            conditionValues.add(conditionValue);
        });
        try {
            return JsonUtils.createObjectMapper().writeValueAsString(conditionValues);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Long addRole(long tenantSid, String roleId, String roleName) {
        Role role = this.roleRepository.findByTenantSidAndId(tenantSid, roleId);
        if (role == null) {
            RoleVO roleVO = new RoleVO();
            roleVO.setId(roleId);
            roleVO.setName(roleName);
            RoleCatalog roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, "defaultRoleCatalog");
            if (roleCatalog != null) {
                roleVO.setCatalogSid(roleCatalog.getSid());
                roleVO.setCatalogId(roleCatalog.getId());
            }
            return this.roleService.addRole(roleVO, tenantSid);
        }
        return role.getSid();
    }
}

