/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.initialize.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.digiwin.dap.middleware.domain.ComeFromEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.authentication.TenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.MappingInfo;
import com.digiwin.dap.middleware.iam.domain.escloud.vo.UserImportInfo;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.role.RoleInfo;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkImportInfo;
import com.digiwin.dap.middleware.iam.domain.user.DingTalkUserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.Metadata;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.TenantMetadata;
import com.digiwin.dap.middleware.iam.entity.TenantMetadataColumn;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.mapper.OrgMapper;
import com.digiwin.dap.middleware.iam.mapper.RoleMapper;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.repository.RoleRepository;
import com.digiwin.dap.middleware.iam.repository.TenantMetadataRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataCrudService;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.policy.DefaultPolicyService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantRegisterService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataColumnCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserBasicInfoUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingCrudService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.initialize.ImportDataService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.CountResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ImportDataServiceImpl
implements ImportDataService {
    private final Logger logger = LoggerFactory.getLogger(ImportDataServiceImpl.class);
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private TenantRegisterService tenantRegisterService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private UserMappingCrudService userMappingCrudService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private DefaultPolicyService defaultPolicyService;
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private UserBasicInfoUpdateService userBasicInfoUpdateService;
    @Autowired
    private UserMappingService userMappingService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private CacService cacService;
    @Autowired
    private MetadataColumnCrudService metadataColumnCrudService;
    @Autowired
    private MetadataCrudService metadataCrudService;
    @Autowired
    private MetadataUpdateService metadataUpdateService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private TenantMetadataRepository tenantMetadataRepository;
    @Autowired
    private TenantMetadataColumnCrudService tenantMetadataColumnCrudService;

    @Override
    public Tenant synDataFromDefaultTenant(UserImportInfo userImportInfo, User user) {
        this.logger.info("2.\u5f00\u59cb\u521b\u5efa\u79df\u6237\u4fe1\u606f,{}", (Object)userImportInfo.getTenantId());
        String tenantId = userImportInfo.getTenantId();
        String tenantName = userImportInfo.getTenantName();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            List<Tenant> tenants;
            boolean isCreateTenant = true;
            if (!StringUtils.isEmpty((Object)userImportInfo.getTaxNo()) && (tenants = this.tenantMapper.findByInvoiceInfoTaxCodeAndCustomerIdIsNull(userImportInfo.getTaxNo())) != null && tenants.size() > 0) {
                ArrayList<Tenant> oldTenants = new ArrayList<Tenant>();
                tenants.forEach(t -> {
                    Tenant oldTenant = new Tenant();
                    BeanUtils.copyProperties((Object)t, (Object)((Object)oldTenant));
                    if (StringUtils.isEmpty((Object)t.getCustomerId())) {
                        t.setCustomerId(userImportInfo.getCustomId());
                    }
                    t.setFullNameCH(StringUtils.hasLength((String)t.getFullNameCH()) ? t.getFullNameCH() : userImportInfo.getCustomerFullNameCH());
                    t.setFullNameEN(StringUtils.hasLength((String)t.getFullNameEN()) ? t.getFullNameEN() : userImportInfo.getCustomerFullNameEN());
                    t.setContacts(StringUtils.hasLength((String)t.getContacts()) ? t.getContacts() : userImportInfo.getContacts());
                    t.setEmail(StringUtils.hasLength((String)t.getEmail()) ? t.getEmail() : userImportInfo.getTenantEmail());
                    t.setTelephone(StringUtils.hasLength((String)t.getTelephone()) ? t.getTelephone() : userImportInfo.getTenantTelephone());
                    t.setAddress(StringUtils.hasLength((String)t.getAddress()) ? t.getAddress() : userImportInfo.getAddress());
                    this.updatePotentialCustomerId(userImportInfo, (Tenant)((Object)t));
                    oldTenants.add(oldTenant);
                });
                isCreateTenant = false;
                tenant = tenants.get(0);
                this.tenantCrudService.saveAll(tenants);
                this.changeLogService.batchSaveTenantChangeLog(oldTenants, tenants, ChangeTypeEnum.TENANT_UPDATE.getName(), Arrays.asList("customId", "fullNameCH", "fullNameEN", "contacts", "email", "telephone", "address", "potentialCustomerId"));
            }
            if (isCreateTenant) {
                tenant = new Tenant(tenantId, tenantName, user.getSid(), "ServiceCloud", userImportInfo);
                String adminTenantId = "99990000";
                if (adminTenantId.equals(tenantId)) {
                    tenant.setSid(Long.valueOf(adminTenantId));
                }
                ImportDataServiceImpl.changeA1ServiceCloudInfo(tenant);
                this.logger.info("2.1.\u5f00\u59cb\u521b\u5efa\u79df\u6237\u4fe1\u606f,{}", (Object)JsonUtils.writeValue((Object)((Object)tenant)));
                this.tenantCrudService.create((BaseEntity)tenant);
                this.tenantInitializeService.initDefaultTenant(tenant.getId(), tenant.getSid(), user.getId(), user.getSid());
                this.tenantInitializeService.initServiceCloudDefaultApp(tenant.getSid());
            }
        } else {
            Tenant oldTenant = new Tenant();
            BeanUtils.copyProperties((Object)((Object)tenant), (Object)((Object)oldTenant));
            if (userImportInfo.isEnterprise()) {
                tenant.setConfirm(1);
                tenant.setName(tenantName);
                tenant.setCustomerId(tenantId);
                tenant.setOwnerUserSid(user.getSid());
                tenant.setComeFrom("ServiceCloud");
                tenant.setEnterpriseType(userImportInfo.isEnterprise() ? 1 : 0);
                tenant.setFullNameCH(StringUtils.isEmpty((Object)userImportInfo.getCustomerFullNameCH()) ? tenant.getFullNameCH() : userImportInfo.getCustomerFullNameCH());
                tenant.setFullNameEN(StringUtils.isEmpty((Object)userImportInfo.getCustomerFullNameEN()) ? tenant.getFullNameEN() : userImportInfo.getCustomerFullNameEN());
                tenant.setAddress(userImportInfo.getAddress());
                tenant.setContacts(userImportInfo.getContacts());
                tenant.setTelephone(userImportInfo.getTenantTelephone());
                tenant.setEmail(userImportInfo.getTenantEmail());
                this.updatePotentialCustomerId(userImportInfo, tenant);
                this.logger.info("2.1.\u5f00\u59cb\u66f4\u65b0\u79df\u6237\u4fe1\u606f,{}", (Object)JsonUtils.writeValue((Object)((Object)tenant)));
                this.tenantCrudService.update((BaseEntity)tenant);
            }
            this.tenantInitializeService.initServiceCloudDefaultApp(tenant.getSid());
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.TENANT_UPDATE.getName(), (Object)oldTenant, (Object)tenant, String.valueOf(tenant.getSid()), Arrays.asList(ChangeTypeEnum.TENANT_UPDATE.getPrimaryKey()), Arrays.asList("customId", "ownerUserSid", "comeFrom", "fullNameCH", "fullNameEN", "contacts", "email", "telephone", "address", "potentialCustomerId"));
        }
        this.logger.info(String.format("2.2.\u7528\u6237[%s]\u5bfc\u5165\u79df\u6237[%s]\u7684\u4fe1\u606f\u6210\u529f\uff01", user.getId(), tenantId));
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenant.getSid());
            userInTenant.setUserSid(user.getSid());
            this.userInTenantCrudService.create(userInTenant);
            this.changeLogService.createChangeLog(ChangeTypeEnum.USER_JOIN_TENANT.getName(), (Object)userInTenant, ChangeTypeEnum.USER_JOIN_TENANT.getPrimaryKey(), String.valueOf(userInTenant.getSid()));
        }
        this.logger.info(String.format("2.3.\u7528\u6237[%s]\u521b\u5efa\u4e0e\u79df\u6237[%s]\u5173\u7cfb\u6210\u529f\uff01", user.getId(), tenantId));
        return tenant;
    }

    private static void changeA1ServiceCloudInfo(Tenant tenant) {
        String customerId = tenant.getCustomerId();
        if (StringUtils.hasLength((String)customerId) && customerId.length() == 8) {
            if (customerId.startsWith("30")) {
                tenant.setComeFrom("ServiceCloud-A1");
            }
            if (customerId.startsWith("50")) {
                tenant.setComeFrom("ServiceCloud-A1");
                tenant.setTestTenant(true);
            }
        }
    }

    private void updatePotentialCustomerId(UserImportInfo userImportInfo, Tenant t) {
        String potentialCustomerId = t.getPotentialCustomerId();
        if (StringUtils.hasLength((String)potentialCustomerId)) {
            List potentialCustomerIds = Arrays.stream(potentialCustomerId.split(";")).collect(Collectors.toList());
            if (!potentialCustomerIds.contains(userImportInfo.getPotentialCustomerId()) && StringUtils.hasLength((String)userImportInfo.getPotentialCustomerId())) {
                potentialCustomerIds.add(userImportInfo.getPotentialCustomerId());
                t.setPotentialCustomerId(String.join((CharSequence)";", potentialCustomerIds));
            }
        } else {
            t.setPotentialCustomerId(userImportInfo.getPotentialCustomerId());
        }
    }

    @Override
    public Tenant updateTenant(String tenantId, String tenantName, User user) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{tenantId});
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setUserSid(user.getSid());
            userInTenant.setTenantSid(tenant.getSid());
            this.userInTenantCrudService.create(userInTenant);
            this.changeLogService.createChangeLog(ChangeTypeEnum.USER_JOIN_TENANT.getName(), (Object)userInTenant, ChangeTypeEnum.USER_JOIN_TENANT.getPrimaryKey(), String.valueOf(userInTenant.getSid()));
        } else if (userInTenant.isDisabled()) {
            userInTenant.setDisabled(false);
            this.userInTenantCrudService.update(userInTenant);
        }
        return tenant;
    }

    @Override
    public void updateTenantRoles(Tenant tenant, List<RoleInfo> roleInfos, Boolean updateSrobot, String appId) {
        long tenantSid = tenant.getSid();
        for (RoleInfo roleInfo : roleInfos) {
            long roleCatalogSid;
            RoleCatalog roleCatalog;
            Role role = this.roleCrudService.findByTenantSidAndId(tenant.getSid(), roleInfo.getId());
            if (StringUtils.isEmpty((Object)roleInfo.getCatalogId())) {
                roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, "defaultRoleCatalog");
                Assert.notNull((Object)((Object)roleCatalog), (String)String.format("\u79df\u6237[%s]\u4e0b\u9884\u8bbe\u89d2\u8272\u5206\u7c7b[%s]\u4e0d\u5b58\u5728\uff01", tenant.getId(), "defaultRoleCatalog"));
                roleCatalogSid = roleCatalog.getSid();
            } else {
                roleCatalog = this.roleCatalogCrudService.findByTenantSidAndId(tenantSid, roleInfo.getCatalogId());
                if (roleCatalog == null) {
                    roleCatalog = new RoleCatalog();
                    roleCatalog.setTenantSid(tenantSid);
                    roleCatalog.setId(roleInfo.getCatalogId());
                    roleCatalog.setName(roleInfo.getCatalogName());
                    roleCatalogSid = this.roleCatalogCrudService.create((BaseEntity)roleCatalog);
                    this.logger.info(String.format("\u521b\u5efa\u89d2\u8272\u5206\u7c7b[%s]\u6210\u529f\uff01", roleInfo.getCatalogId()));
                } else {
                    roleCatalogSid = roleCatalog.getSid();
                }
            }
            if (role == null) {
                role = new Role();
                role.setId(roleInfo.getId());
                role.setName(roleInfo.getName());
                role.setTenantSid(tenantSid);
                role.setRoleCatalogSid(roleCatalogSid);
                role.setReadonly(roleInfo.isReadonly());
                role.setVisible(roleInfo.isVisible());
                this.roleCrudService.create((BaseEntity)role);
                if (updateSrobot.booleanValue()) {
                    this.defaultPolicyService.updateRolePolicy4Srobot(role, appId);
                } else {
                    this.defaultPolicyService.updateRolePolicy(role);
                }
                if ("endUser".equals(role.getId())) {
                    this.createMultiLanguage(tenantSid, role.getSid(), "\u4e00\u822c\u7528\u6237", "\u4e00\u822c\u7528\u6236", "common user");
                } else if ("superUser".equals(role.getId())) {
                    this.createMultiLanguage(tenantSid, role.getSid(), "\u8fdb\u9636\u7528\u6237", "\u9032\u968e\u7528\u6236", "advanced user");
                } else if ("mis".equals(role.getId())) {
                    this.createMultiLanguage(tenantSid, role.getSid(), "\u7ba1\u7406\u8005", "\u7ba1\u7406\u8005", "manager");
                }
                this.changeLogService.saveNewRoleChangeLogs(role, tenant);
                continue;
            }
            role.setName(roleInfo.getName());
            role.setTenantSid(tenantSid);
            role.setRoleCatalogSid(roleCatalogSid);
            role.setReadonly(roleInfo.isReadonly());
            role.setVisible(roleInfo.isVisible());
            EntityUtils.setModifyFields((BaseEntity)role);
            this.roleRepository.save((Object)role);
            if (!updateSrobot.booleanValue()) continue;
            this.defaultPolicyService.updateRolePolicy4Srobot(role, appId);
        }
    }

    private void createMultiLanguage(long tenantSid, Long dataSid, String name, String nameTW, String nameUS) {
        try {
            ArrayList<LanguageResource> languageResources = new ArrayList<LanguageResource>();
            LanguageResource languageResource = new LanguageResource(dataSid.longValue(), "roleName", name, "zh-CN");
            languageResources.add(languageResource);
            languageResource = new LanguageResource(dataSid.longValue(), "roleName", nameTW, "zh-TW");
            languageResources.add(languageResource);
            languageResource = new LanguageResource(dataSid.longValue(), "roleName", nameUS, "en-US");
            languageResources.add(languageResource);
            this.languageCrudService.insertAll(languageResources);
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u89d2\u8272\u591a\u8bed\u8a00\u6570\u636e\u51fa\u9519", (Throwable)ex);
        }
    }

    @Override
    public void updateUserRoles(Tenant tenant, User user, List<RoleInfo> roleInfos) {
        List roles = this.roleCrudService.findByTenantSid(tenant.getSid());
        List<QueryRoleResultVO> oldUserRoles = this.userInRoleCrudService.getUserInRoleByUser(tenant.getSid(), user.getSid());
        for (RoleInfo roleInfo : roleInfos) {
            Role role = roles.stream().filter(p -> p.getId().equals(roleInfo.getId())).findFirst().orElse(null);
            if (role == null) {
                this.logger.error(String.format("\u66f4\u65b0\u7528\u6237[%s]\u89d2\u8272[%s]\u65f6\u89d2\u8272\u4e0d\u5b58\u5728", user.getId(), roleInfo.getId()));
                continue;
            }
            Association association = this.userInRoleCrudService.findByUnionKey(tenant.getSid(), user.getSid(), role.getSid());
            if (association != null) continue;
            association = new Association();
            association.setTenantSid(tenant.getSid());
            association.setUserSid(user.getSid());
            association.setRoleSid(role.getSid());
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
            this.changeLogService.saveNewAssociationChangeLogs(role, roleInfo.getCatalogId(), tenant, user, oldUserRoles);
            QueryRoleResultVO queryRoleResultVO = new QueryRoleResultVO();
            queryRoleResultVO.setSid(role.getSid());
            queryRoleResultVO.setId(role.getId());
            queryRoleResultVO.setName(role.getName());
            queryRoleResultVO.setCatalogId(roleInfo.getCatalogId());
            queryRoleResultVO.setCatalogName(roleInfo.getCatalogName());
            oldUserRoles.add(queryRoleResultVO);
            this.logger.info(String.format("\u7528\u6237[%s]\u521b\u5efa\u4e0e\u89d2\u8272[%s]\u7684\u5173\u7cfb\u6210\u529f\uff01", user.getId(), roleInfo.getId()));
        }
    }

    @Override
    public void updateDigiwinDefaultOrg(Tenant tenant, User user, String orgId) {
        if ("99990000".equals(tenant.getId())) {
            UserInOrg userInOrg;
            this.logger.info(String.format("\u5f00\u59cb\u521b\u5efa\u9ed8\u8ba4\u7ec4\u7ec7%s", orgId));
            List<Org> orgs = this.orgMapper.getOrgsByTenantIdAndId(tenant.getId(), orgId);
            if (!orgs.isEmpty() && (userInOrg = (UserInOrg)this.userInOrgCrudService.findByUnionKey(new Object[]{user.getSid(), orgs.get(0).getSid()})) == null) {
                this.logger.info(String.format("\u5f00\u59cb\u7ed9\u7528\u6237%s\u521b\u5efa\u9ed8\u8ba4\u7ec4\u7ec7%s", user.getId(), orgId));
                userInOrg = new UserInOrg();
                userInOrg.setSid(SnowFlake.getInstance().newId());
                userInOrg.setOrgSid(orgs.get(0).getSid());
                userInOrg.setUserSid(user.getSid());
                this.userInOrgCrudService.create(userInOrg);
            }
        }
    }

    @Override
    public Tenant createTenant(TenantVO tenantVO, TenantCertification tenantCertification, User user) {
        Tenant tenant;
        RegisterTenantVO registerTenantVO = new RegisterTenantVO();
        registerTenantVO.setTenant(tenantVO);
        if (null != tenantCertification) {
            registerTenantVO.setTenantCertification(new TenantCertificationVO(tenantCertification));
        }
        if (null == (tenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId()))) {
            this.logger.info("\u79df\u6237{}\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u521b\u5efa", (Object)tenantVO.getId());
            this.tenantRegisterService.register(registerTenantVO, user.getSid());
            tenant = (Tenant)this.tenantCrudService.findById(tenantVO.getId());
            tenant.setConfirm(1);
            tenant.setTestTenant(null == tenantVO.getTestTenant() ? false : tenantVO.getTestTenant());
            tenant.setExperience(null == tenantVO.getExperience() ? false : tenantVO.getExperience());
            this.tenantCrudService.update((BaseEntity)tenant);
            this.tenantInitializeService.initDefaultTenant(tenantVO.getId(), tenant.getSid(), user.getId(), user.getSid());
        } else {
            this.logger.info("\u79df\u6237{}\u5df2\u7ecf\u5b58\u5728\u5b58\u5728\uff0c\u9700\u8981\u66f4\u65b0", (Object)tenantVO.getId());
            this.tenantRegisterService.updateRegisterTenantVO(registerTenantVO);
        }
        return tenant;
    }

    @Override
    public void updateUserMapping(Long tenantSid, Long userSid, String userId, List<MappingInfo> mappingInfos) {
        for (MappingInfo mappingInfo : mappingInfos) {
            UserMapping userMapping;
            if (StringUtils.isEmpty((Object)mappingInfo.getAccount())) {
                mappingInfo.setAccount(null);
            }
            if ((userMapping = this.userMappingCrudService.findByUnionKey(tenantSid, userSid, mappingInfo.getProviderId(), mappingInfo.getAccount())) == null) {
                userMapping = new UserMapping();
                userMapping.setAppId(mappingInfo.getProviderId());
                userMapping.setUserSid(userSid);
                userMapping.setTenantSid(tenantSid);
                userMapping.setAccount(mappingInfo.getAccount());
                userMapping.setVerifyUserId(mappingInfo.getVerifyUserId());
                this.userMappingCrudService.create((BaseEntity)userMapping);
                this.changeLogService.createChangeLog(ChangeTypeEnum.USERMAPPING_CREATE.getName(), (Object)userMapping, ChangeTypeEnum.USERMAPPING_CREATE.getPrimaryKey(), String.valueOf(userMapping.getSid()));
                continue;
            }
            if (userMapping.getVerifyUserId().equals(mappingInfo.getVerifyUserId())) continue;
            UserMapping oldUserMapping = new UserMapping();
            BeanUtils.copyProperties((Object)((Object)userMapping), (Object)((Object)oldUserMapping));
            userMapping.setVerifyUserId(mappingInfo.getVerifyUserId());
            this.userMappingCrudService.update((BaseEntity)userMapping);
            this.changeLogService.updateCompareChangeLog(ChangeTypeEnum.USERMAPPING_UPDATE.getName(), (Object)oldUserMapping, (Object)userMapping, Arrays.asList("sid"), Arrays.asList("verifyUserId"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DingTalkImportInfo importDingTalk(DingTalkImportInfo userImportInfo) {
        DingTalkImportInfo result = new DingTalkImportInfo();
        String comeFrom = userImportInfo.getComeFrom();
        String tenantId = userImportInfo.getTenantId();
        boolean isNewTenant = this.determineWhetherNewTenant(tenantId, comeFrom);
        if (!isNewTenant) {
            tenantId = this.tenantMetadataCrudService.getTenantIdFromCorpId(tenantId, comeFrom);
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (isNewTenant) {
            User user;
            DingTalkUserInfo createUser = userImportInfo.getUsers().stream().filter(u -> u.getId().equals(userImportInfo.getUserId())).findFirst().orElse(null);
            if (null == createUser) {
                user = (User)this.userCrudService.findById(userImportInfo.getUserId());
                if (null == user) {
                    if (null == tenant) {
                        throw new IllegalArgumentException(String.format("\u521b\u5efa\u8005%s\u7684\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", userImportInfo.getUserId()));
                    }
                } else {
                    if (!comeFrom.equals(user.getComeFrom())) {
                        this.logger.error("\u539f\u7528\u6237{}\u6e20\u9053\u662f{},\u65b0\u6ce8\u518c\u7528\u6237{}\u6e20\u9053\u662f{}", new Object[]{user.getId(), user.getComeFrom(), userImportInfo.getUserId(), comeFrom});
                    }
                    user.setRemark(String.format("\u7528\u6237%s\u6765\u6e90%s\u4e5f\u6709\u6ce8\u518c\u6b64\u8d26\u53f7", user.getId(), comeFrom));
                    this.userCrudService.update((BaseEntity)user);
                }
            } else {
                DingTalkUserInfo userInfo = new DingTalkUserInfo(createUser.getId(), createUser.getName(), createUser.getEmail(), createUser.getTelephone(), createUser.getPassword());
                userInfo.setRemark(userImportInfo.getRemark());
                user = this.generateUserForDingTalk(userImportInfo, userInfo, comeFrom, false, false, 0L, "", "");
            }
            this.logger.info("\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u6ce8\u518c\u521b\u5efa\u8005\u6210\u529f {}", (Object)userImportInfo.getComeFrom(), (Object)JsonUtils.objToJson((Object)((Object)user)));
            if (null == tenant) {
                TenantVO tenantVO = new TenantVO();
                tenantVO.setComeFrom(comeFrom);
                tenantVO.setId(tenantId);
                tenantVO.setName(userImportInfo.getTenantName());
                tenantVO.setEoc(userImportInfo.getEoc());
                tenantVO.setTestTenant(true);
                tenantVO.setExperience(true);
                tenant = this.createTenant(tenantVO, null, user);
                if (ComeFromEnum.DINGDING.getId().equals(comeFrom)) {
                    this.tenantMetadataUpdateService.updateTenantMetadataValue(tenant.getSid(), "corpId", ComeFromEnum.DINGDING.getId(), tenantId);
                }
            } else {
                if (tenant.getId().equals(tenant.getName())) {
                    tenant.setName(userImportInfo.getTenantName());
                }
                if (tenant.isEoc() != userImportInfo.getEoc().booleanValue()) {
                    tenant.setEoc(userImportInfo.getEoc());
                } else {
                    result.setEoc(false);
                }
                this.tenantCrudService.update((BaseEntity)tenant);
                if (!comeFrom.equals(tenant.getComeFrom())) {
                    this.logger.error("\u539f\u79df\u6237\u6e20\u9053\u662f{},\u65b0\u6ce8\u518c\u79df\u6237\u6e20\u9053\u662f{}", (Object)tenant.getComeFrom(), (Object)comeFrom);
                }
            }
            this.logger.info("\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u6ce8\u518c\u79df\u6237\u6210\u529f {}", (Object)userImportInfo.getComeFrom(), (Object)JsonUtils.objToJson((Object)((Object)tenant)));
        }
        this.createUsers(userImportInfo, tenant.getSid(), tenant.getId(), comeFrom);
        this.logger.info("\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u6ce8\u518c\u7528\u6237\u6210\u529f", (Object)userImportInfo.getComeFrom());
        result.setEoc(userImportInfo.getEoc());
        result.setTenant(tenant);
        this.addSysInTenantRelation(userImportInfo, tenant);
        this.logger.info("\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u521b\u5efasys\u548c\u79df\u6237\u5173\u7cfb\u6210\u529f", (Object)userImportInfo.getComeFrom());
        return result;
    }

    private boolean determineWhetherNewTenant(String tenantId, String comeFrom) {
        TenantMetadataColumn columns = (TenantMetadataColumn)this.tenantMetadataColumnCrudService.findByUnionKey(new Object[]{"corpId", comeFrom});
        if (columns != null) {
            List<TenantMetadata> tenantMetadata = this.tenantMetadataRepository.findByColumnSidAndValue(columns.getSid(), tenantId);
            return tenantMetadata.isEmpty();
        }
        return true;
    }

    private void addSysInTenantRelation(DingTalkImportInfo userImportInfo, Tenant tenant) {
        if (userImportInfo.getAuthTenant().booleanValue()) {
            if (userImportInfo.getAuth() == null || StringUtils.isEmpty((Object)userImportInfo.getAuth().getAppId())) {
                ArrayList<SysVO> sysVOS = new ArrayList<SysVO>();
                userImportInfo.getAuths().forEach(a -> {
                    SysVO sysVO = new SysVO();
                    sysVO.setId(a.getAppId());
                    sysVO.setIdFirst(a.getAppId());
                    sysVO.setClientId(a.getClientId());
                    sysVO.setClientSecret(a.getClientSecret());
                    sysVO.setClientInstanceId(a.getClientInstanceId());
                    sysVOS.add(sysVO);
                });
                this.purchaseApplicationService.purchaseApplicationList(tenant.getId(), "virtual", sysVOS, true);
            } else {
                SysVO sysVO = new SysVO();
                sysVO.setId(userImportInfo.getAuth().getAppId());
                sysVO.setIdFirst(userImportInfo.getAuth().getAppId());
                sysVO.setClientId(userImportInfo.getAuth().getClientId());
                sysVO.setClientSecret(userImportInfo.getAuth().getClientSecret());
                sysVO.setClientInstanceId(userImportInfo.getAuth().getClientInstanceId());
                this.purchaseApplicationService.purchaseApplication(tenant.getId(), "virtual", sysVO, true);
            }
        }
    }

    @Override
    public CountResultVO importDingTalkUser(DingTalkImportInfo userImportInfo, Tenant tenant) {
        this.logger.info("1.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6ce8\u518c\u7528\u6237:{}", (Object)userImportInfo.getComeFrom(), (Object)JsonUtils.objToJson((Object)userImportInfo));
        this.createUsers(userImportInfo, tenant.getSid(), tenant.getId(), userImportInfo.getComeFrom());
        this.bindEmps(userImportInfo, tenant, userImportInfo.getEoc());
        String appId = userImportInfo.getAuth().getAppId();
        if (userImportInfo.getAuthUser().booleanValue() && userImportInfo.getUsers().size() > 0) {
            List<String> userIds = userImportInfo.getUsers().stream().map(UserInfo::getId).collect(Collectors.toList());
            this.logger.info("2.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u6ce8\u518c\u79df\u6237\u4e0b{}\u5e94\u7528{}\u7684\u6388\u6743\uff0c\u6388\u6743\u7528\u6237:{}", new Object[]{userImportInfo.getComeFrom(), tenant.getId(), appId, JsonUtils.writeValue(userIds)});
            CacAuth auth = new CacAuth();
            auth.setAction(1);
            auth.setTenantId(tenant.getId());
            auth.setTenantName(tenant.getName());
            Goods authDataDO = new Goods();
            authDataDO.setCode(appId);
            auth.getAuthorizations().add(authDataDO);
            auth.setUserIds(userIds);
            CountResultVO countResultVO = this.cacService.purchaseOrUpdateApp(auth);
            return countResultVO;
        }
        return CountResultVO.noAuth();
    }

    @Override
    public void bindEmps(DingTalkImportInfo userImportInfo, Tenant tenant, Boolean eoc) {
        if (userImportInfo.getEoc().booleanValue()) {
            this.logger.info("3.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u5f00\u59cb\u7ed1\u5b9aeoc\u6570\u636e\uff0c\u5458\u5de5\u4fe1\u606f\uff1a{}", (Object)userImportInfo.getComeFrom(), (Object)JsonUtils.writeValue(userImportInfo.getUsers()));
            ArrayList<EmpUserVO> empUserVOS = new ArrayList<EmpUserVO>();
            userImportInfo.getUsers().forEach(u -> {
                if (!StringUtils.isEmpty((Object)u.getEmpId())) {
                    empUserVOS.add(new EmpUserVO(tenant.getSid(), u.getId(), u.getName(), u.getEmpId(), u.getDeptId()));
                }
            });
            TenantInfoVO tenantInfoVO = new TenantInfoVO(tenant);
            tenantInfoVO.setEoc(eoc);
            this.remoteEocService.batchBindingUser(tenantInfoVO, userImportInfo.getDeptId(), empUserVOS);
            this.logger.info("3.\u7b2c\u4e09\u65b9{}\u96c6\u6210\uff0c\u7ed1\u5b9aeoc\u6570\u636e\u6210\u529f", (Object)userImportInfo.getComeFrom());
        }
    }

    @Override
    public void syncUserMetadataForLine(String syncAppId, List<UserMappingQueryResultVO> mappingList) {
        if (CollectionUtils.isEmpty(mappingList)) {
            return;
        }
        MetadataColumn oldMetadataColumn = this.metadataColumnCrudService.getByCatalogIdAndKey("integrationUserId", "line_" + syncAppId);
        if (Objects.isNull((Object)oldMetadataColumn)) {
            MetadataColumn metadataColumn = new MetadataColumn();
            metadataColumn.setName("line_" + syncAppId);
            metadataColumn.setCatalogId("integrationUserId");
            metadataColumn.setKey("line_" + syncAppId);
            metadataColumn.setTenantSid(0L);
            metadataColumn.setType("string");
            metadataColumn.setTypeParameter("[]");
            this.metadataColumnCrudService.create(metadataColumn);
        }
        for (UserMappingQueryResultVO mapping : mappingList) {
            UserMetadataVO userMetadataVO = new UserMetadataVO();
            userMetadataVO.setUserSid(mapping.getUserSid());
            userMetadataVO.setTenantSid(0L);
            userMetadataVO.setValue(mapping.getVerifyUserId());
            userMetadataVO.setCatalogId("integrationUserId");
            userMetadataVO.setKey("line_" + syncAppId);
            this.metadataUpdateService.updateMetadataValue(userMetadataVO);
        }
    }

    private void createUsers(DingTalkImportInfo userImportInfo, Long tenantSid, String tenantId, String comeFrom) {
        Boolean isEnterprise = userImportInfo.getEnterprise();
        userImportInfo.getUsers().forEach(o -> {
            List<String> roleIds = o.getRoles();
            if (0L == o.getSid()) {
                if (isEnterprise.booleanValue()) {
                    if (o.getId().equals(userImportInfo.getUserId())) {
                        roleIds.add("superadmin");
                    }
                    o.setId(tenantId + "$" + o.getId());
                }
                User finalUser = this.generateUserForDingTalk(userImportInfo, (DingTalkUserInfo)o, comeFrom, isEnterprise, true, tenantSid, tenantId, StringUtils.isEmpty((Object)o.getUnionId()) ? o.getId() : o.getUnionId());
                if (!roleIds.isEmpty() && !Boolean.TRUE.equals(userImportInfo.getInnerApp())) {
                    List<Role> roles = this.roleMapper.findInRoleIds(tenantSid, roleIds);
                    roles.forEach(r -> this.bindUserRole(tenantSid, finalUser.getSid(), r.getSid()));
                }
            } else {
                this.bindUserIdMetadata(comeFrom, tenantSid, o.getThirdUserId(), o.getSid());
                if (!isEnterprise.booleanValue() && !StringUtils.hasText((String)o.getTelephone()) && StringUtils.hasText((String)o.getThirdTelephone())) {
                    User userFindByTelephone = this.userRepository.findFirstByTelephoneAndType(o.getThirdTelephone(), 0);
                    User userFindBySid = this.userRepository.findBySid(o.getSid());
                    if (userFindByTelephone == null) {
                        userFindBySid.setTelephone(o.getThirdTelephone());
                        this.userRepository.save((Object)userFindBySid);
                    } else if (userFindByTelephone.getSid() != o.getSid()) {
                        userFindBySid.setRemark(String.format("\u8be5\u4e09\u65b9\u624b\u673a\u53f7[%s]\u5df2\u88ab\u5176\u4ed6\u8d26\u53f7\u6ce8\u518c", o.getThirdTelephone()));
                        this.userRepository.save((Object)userFindBySid);
                    }
                }
                if (!isEnterprise.booleanValue() && Boolean.TRUE.equals(o.getNeedMapping())) {
                    this.bindMapping(tenantSid, o.getId(), userImportInfo.getAuth().getAppId(), StringUtils.isEmpty((Object)o.getUnionId()) ? o.getId() : o.getUnionId(), userImportInfo.getComeFrom());
                }
            }
        });
    }

    private User generateUserForDingTalk(DingTalkImportInfo userImportInfo, DingTalkUserInfo userInfo, String comeFrom, Boolean enterprise, Boolean mapping, Long tenantSid, String tenantId, String unionId) {
        User user = null;
        if (!enterprise.booleanValue()) {
            if ("email".equalsIgnoreCase(userImportInfo.getMatchProperty())) {
                if (StringUtils.hasText((String)userInfo.getEmail())) {
                    user = this.userRepository.findFirstByEmailAndType(userInfo.getEmail(), 0);
                }
                if (user == null && StringUtils.hasText((String)userInfo.getTelephone())) {
                    user = this.userRepository.findFirstByTelephoneAndType(userInfo.getTelephone(), 0);
                }
            } else {
                if (StringUtils.hasText((String)userInfo.getTelephone())) {
                    user = this.userRepository.findFirstByTelephoneAndType(userInfo.getTelephone(), 0);
                }
                if (user == null && StringUtils.hasText((String)userInfo.getEmail())) {
                    user = this.userRepository.findFirstByEmailAndType(userInfo.getEmail(), 0);
                }
            }
        }
        if (null == user) {
            user = (User)this.userCrudService.findById(userInfo.getId());
        }
        if (null == user) {
            if (Boolean.TRUE.equals(userImportInfo.getInnerApp())) {
                throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_MAPPING_ERROR, new Object[]{tenantId, userImportInfo.getAuth().getAppId(), userInfo.getId()});
            }
            userInfo.setComeFrom(comeFrom);
            if (!enterprise.booleanValue() && Boolean.TRUE.equals(userImportInfo.getValidatePersonalInfo()) && ObjectUtils.isEmpty((Object)userInfo.getEmail()) && ObjectUtils.isEmpty((Object)userInfo.getTelephone())) {
                throw new BusinessException((ErrorHandler)I18nError.THIRD_SYS_IMPORT_USER_VALIDATE);
            }
            user = this.userBasicInfoUpdateService.create(userInfo, enterprise);
        } else {
            User firstByTelephone;
            if (!comeFrom.equals(user.getComeFrom())) {
                this.logger.error("\u539f\u7528\u6237{}\u6e20\u9053\u662f{},\u65b0\u6ce8\u518c\u7528\u6237{}\u6e20\u9053\u662f{}", new Object[]{user.getId(), user.getComeFrom(), userInfo.getId(), comeFrom});
            }
            if (!enterprise.booleanValue() && StringUtils.hasText((String)userInfo.getTelephone()) && !StringUtils.hasText((String)user.getTelephone()) && (firstByTelephone = this.userRepository.findFirstByTelephoneAndType(userInfo.getTelephone(), 0)) == null) {
                user.setTelephone(userInfo.getTelephone());
            }
            user.setRemark(String.format("\u7528\u6237%s\u6765\u6e90%s\u4e5f\u6709\u6ce8\u518c\u6b64\u8d26\u53f7", user.getId(), comeFrom));
            this.userCrudService.update((BaseEntity)user);
            userInfo.setId(user.getId());
        }
        long userSid = user.getSid();
        if (tenantSid > 0L) {
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, user.getSid());
            if (userInTenant != null) {
                if (userInTenant.isDisabled() || userInTenant.isDeleted()) {
                    throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_DISABLE_TENANT, new Object[]{tenantId, user.getId()});
                }
            } else {
                if (Boolean.TRUE.equals(userImportInfo.getInnerApp())) {
                    throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenantId});
                }
                this.userInTenantCrudService.createUserInTenant(tenantSid, userSid, false);
            }
        }
        if (mapping.booleanValue() && !StringUtils.isEmpty((Object)unionId)) {
            String userId = user.getId();
            if (userImportInfo.getAuth() == null || StringUtils.isEmpty((Object)userImportInfo.getAuth().getAppId())) {
                userImportInfo.getAuths().forEach(a -> this.bindMapping(tenantSid, userId, a.getAppId(), unionId, comeFrom));
            } else {
                this.bindMapping(tenantSid, userId, userImportInfo.getAuth().getAppId(), unionId, comeFrom);
            }
        }
        this.bindUserIdMetadata(comeFrom, tenantSid, userInfo.getThirdUserId(), userSid);
        return user;
    }

    private void bindUserIdMetadata(String comeFrom, Long tenantSid, String thirdUserId, long userSid) {
        if (StringUtils.hasText((String)thirdUserId) && !Objects.equals(ComeFromEnum.LINE.getId(), comeFrom)) {
            MetadataColumn metadataColumn = (MetadataColumn)this.metadataColumnCrudService.findByUnionKey(new Object[]{"integrationUserId", comeFrom});
            if (metadataColumn != null) {
                Metadata metadata = (Metadata)this.metadataCrudService.findByUnionKey(new Object[]{tenantSid, metadataColumn.getSid(), userSid});
                if (metadata == null) {
                    metadata = new Metadata();
                    metadata.setColumnSid(metadataColumn.getSid());
                    metadata.setUserSid(userSid);
                    metadata.setValue(thirdUserId);
                    metadata.setTenantSid(tenantSid);
                    this.metadataCrudService.create((BaseEntity)metadata);
                } else if (!thirdUserId.equals(metadata.getValue())) {
                    metadata.setValue(thirdUserId);
                    this.metadataCrudService.update((BaseEntity)metadata);
                }
            } else {
                this.logger.error("\u7528\u6237{}\u7ed1\u5b9a\u6269\u5c55\u5c5e\u6027{}-{}\u4e0d\u5b58\u5728", new Object[]{userSid, "integrationUserId", comeFrom});
            }
        }
    }

    private void bindMapping(Long tenantSid, String userId, String appId, String unionId, String account) {
        UserMappingVO userMappingVO = new UserMappingVO();
        userMappingVO.setUserId(userId);
        userMappingVO.setIdentityId(appId);
        userMappingVO.setVerifyUserId(unionId);
        userMappingVO.setAccount(account);
        try {
            this.userMappingService.map(tenantSid, userMappingVO, false);
        }
        catch (Exception ex) {
            this.logger.error(String.format("\u6620\u5c04\u7528\u6237%s\u5173\u7cfb\u5931\u8d25", userId), (Throwable)ex);
        }
    }

    private void bindUserRole(long tenantSid, Long userSid, Long roleSid) {
        Association association = this.userInRoleCrudService.findByUnionKey(tenantSid, userSid, roleSid);
        if (association == null) {
            association = new Association();
            association.setTenantSid(tenantSid);
            association.setRoleSid(roleSid);
            association.setUserSid(userSid);
            association.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)association);
            this.changeLogService.createChangeLog(ChangeTypeEnum.USER_ROLE_UPDATE.getName(), (Object)association, ChangeTypeEnum.USER_ROLE_UPDATE.getPrimaryKey(), String.valueOf(association.getSid()));
        }
    }
}

