/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.initialize.impl;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.constant.enums.IamSysNoticeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TeamEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authentication.TenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.tenant.DevTenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.RegisterTenantVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.entity.Association;
import com.digiwin.dap.middleware.iam.entity.DevCertificationDO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.OrgAspect;
import com.digiwin.dap.middleware.iam.entity.OrgCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgTagCatalog;
import com.digiwin.dap.middleware.iam.entity.OrgType;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.RoleCatalog;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.CertificationRepository;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantCertificationRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.dev.certification.CertificationService;
import com.digiwin.dap.middleware.iam.service.org.OrgAspectCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTagCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.org.OrgTypeCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCatalogCrudService;
import com.digiwin.dap.middleware.iam.service.role.RoleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysInTenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataUpdateService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TenantInitializeServiceImpl
implements TenantInitializeService {
    private Logger logger = LoggerFactory.getLogger(TenantInitializeServiceImpl.class);
    @Autowired
    private RoleCatalogCrudService roleCatalogCrudService;
    @Autowired
    private RoleCrudService roleCrudService;
    @Autowired
    private UserInRoleCrudService userInRoleCrudService;
    @Autowired
    private OrgCatalogCrudService orgCatalogCrudService;
    @Autowired
    private OrgAspectCrudService orgAspectCrudService;
    @Autowired
    private OrgTypeCrudService orgTypeCrudService;
    @Autowired
    private OrgTagCatalogCrudService orgTagCatalogCrudService;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private SysInTenantCrudService sysInTenantCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private CertificationService certificationService;
    @Autowired
    private TenantMetadataUpdateService tenantMetadataUpdateService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private TenantCertificationRepository tenantCertificationCrudService;
    @Autowired
    private CertificationRepository certificationRepository;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;

    @Override
    public void initDefaultTenant(String tenantId, long tenantSid, String userId, long userSid) {
        this.initDefaultRoleAndUser(tenantSid, userSid, true);
        this.initDefaultOrg(tenantSid);
        this.initDefaultApp(tenantSid);
        this.certificationService.saveDefaultTenant(tenantSid);
        this.tenantMetadataUpdateService.saveTenantDefaultLanguage(tenantSid);
    }

    @Override
    public void initServicerDefaultTenant(String tenantId, long tenantSid, String userId, long userSid) {
        this.initDefaultTenant(tenantId, tenantSid, userId, userSid);
        this.initIsvApp(tenantSid);
    }

    @Override
    public void initServiceCloudDefaultApp(long tenantSid) {
        Sys sys = (Sys)this.sysRepository.findById("ServiceCloud");
        if (sys != null) {
            this.initDefaultSys(sys, tenantSid);
        } else {
            this.logger.error("ServiceCloud\u5e94\u7528\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public void initIsvApp(long tenantSid) {
        Sys sys = (Sys)this.sysRepository.findById("ISV");
        if (sys != null) {
            this.initDefaultSys(sys, tenantSid);
        }
    }

    @Override
    public void syncTenantToOtherAreas(Long tenantSid, String ownerUserId) {
        String opType;
        if (!this.isProdArea()) {
            return;
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            this.logger.error("\u79df\u6237\u4e0d\u5b58\u5728\uff0csid: {}\uff0c\u9000\u51fa\u540c\u6b65\u79df\u6237", (Object)tenantSid);
            return;
        }
        if (!"intelly".equals(tenant.getComeFrom())) {
            return;
        }
        RegisterTenantVO registerTenantVO = this.getRegisterTenantVO(tenant);
        if (TeamEnum.INTERNAL_ISV.getId().equals(tenant.getTeamId())) {
            opType = IamSysNoticeEnum.INTELLY_INTERNAL_TENANT_SYNC.name();
            registerTenantVO.setOwnerUserId(ownerUserId);
        } else if (TeamEnum.EXTERNAL_ISV.getId().equals(tenant.getTeamId())) {
            opType = IamSysNoticeEnum.INTELLY_EXTERNAL_TENANT_SYNC.name();
        } else {
            this.logger.info("\u79df\u6237\u7684teamId\u4e0d\u7b26\u5408\u9884\u671f\uff0cteamId: {}\uff0c\u9000\u51fa\u540c\u6b65\u79df\u6237", (Object)tenant.getTeamId());
            return;
        }
        MessageBody messageData = MessageBody.of((String)opType, (Object)registerTenantVO);
        messageData.setUserToken("");
        messageData.setSysId("INTERNAL_IAM");
        this.producerService.sys(messageData);
    }

    private RegisterTenantVO getRegisterTenantVO(Tenant tenant) {
        DevCertificationDO devCertification;
        long tenantSid = tenant.getSid();
        RegisterTenantVO registerTenantVO = new RegisterTenantVO();
        TenantVO tenantVO = new TenantVO(tenant);
        tenantVO.setSid(null);
        registerTenantVO.setTenant(tenantVO);
        TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
        if (tenantCertification != null) {
            registerTenantVO.setTenantCertification(new TenantCertificationVO(tenantCertification));
        }
        if ((devCertification = this.certificationRepository.findByTenantSid(tenantSid)) != null) {
            DevTenantCertificationVO certificationVO = new DevTenantCertificationVO();
            BeanUtils.mergeDifferentTypeObject((Object)((Object)devCertification), (Object)certificationVO);
            registerTenantVO.setCertification(certificationVO);
        }
        registerTenantVO.setMetadatas(this.tenantMetadataCrudService.getTenantMetadata(tenantSid));
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(tenantSid);
        if (invoiceInfo != null) {
            InvoiceInfoVO invoiceInfoVO = new InvoiceInfoVO().generateInvoiceInfoVO(invoiceInfo);
            invoiceInfoVO.setSid(null);
            registerTenantVO.setInvoice(invoiceInfoVO);
        }
        return registerTenantVO;
    }

    private boolean isProdArea() {
        DeployAreaEnum currentArea = DeployAreaEnum.get((String)this.envProperties.getDeployArea());
        if (currentArea == null) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u90e8\u7f72\u533a\u57df\u5931\u8d25\uff0cDeployArea\uff1a{}\uff0c\u9000\u51fa\u540c\u6b65\u79df\u6237", (Object)this.envProperties.getDeployArea());
            return false;
        }
        if (!Arrays.asList(DeployAreaEnum.AliyunProd, DeployAreaEnum.AzureProd).contains(currentArea)) {
            this.logger.info("\u5f53\u524d\u90e8\u7f72\u533a\u57df\u4e3a{}\uff0c\u975e\u963f\u91cc\u4e91\u6216Azure\u751f\u4ea7\u73af\u5883\uff0c\u4e0d\u8fdb\u884c\u540c\u6b65\u79df\u6237", (Object)currentArea);
            return false;
        }
        return true;
    }

    private void initDefaultApp(long tenantSid) {
        List<String> appIdList = this.whiteListService.getWhiteList("WHITE_LIST_AUTO_AUTH_TENANT_APPS");
        List<Sys> sysList = this.sysRepository.findByIdIn(appIdList);
        ArrayList<SysInTenant> sysInTenants = new ArrayList<SysInTenant>();
        for (Sys sys : sysList) {
            SysInTenant sysInTenant = new SysInTenant();
            sysInTenant.setSysSid(sys.getSid());
            sysInTenant.setTenantSid(tenantSid);
            sysInTenant.setTokenExpire(sys.getTokenExpire());
            SysInTenant sysInTenantTemp = this.sysInTenantCrudService.findByUnionKey(tenantSid, sys.getSid());
            if (sysInTenantTemp != null) continue;
            sysInTenants.add(sysInTenant);
        }
        if (!sysInTenants.isEmpty()) {
            this.sysInTenantCrudService.saveAll(sysInTenants);
        }
    }

    private void initDefaultSys(Sys sys, Long tenantSid) {
        SysInTenant sysInTenantTemp = this.sysInTenantCrudService.findByUnionKey(tenantSid, sys.getSid());
        if (sysInTenantTemp == null) {
            SysInTenant sysInTenant = new SysInTenant();
            sysInTenant.setSysSid(sys.getSid());
            sysInTenant.setTenantSid(tenantSid);
            sysInTenant.setTokenExpire(sys.getTokenExpire());
            this.sysInTenantCrudService.create((BaseEntity)sysInTenant);
        }
    }

    private void initDefaultOrg(long tenantSid) {
        OrgType orgTypeTempDepartment;
        OrgType orgTypeTempFactory;
        OrgType orgTypeTempCompany;
        OrgCatalog orgCatalog = new OrgCatalog();
        orgCatalog.setId("defaultOrgCatalog");
        orgCatalog.setName("\u9ed8\u8ba4\u7ec4\u7ec7\u5206\u7c7b");
        orgCatalog.setTenantSid(tenantSid);
        long orgCatalogSid = this.orgCatalogCrudService.getSidByTenantAndId(tenantSid, "defaultOrgCatalog");
        if (orgCatalogSid == 0L) {
            orgCatalogSid = this.orgCatalogCrudService.create((BaseEntity)orgCatalog);
        }
        OrgAspect orgAspect = new OrgAspect();
        orgAspect.setId("defaultOrgAspect");
        orgAspect.setTenantSid(tenantSid);
        orgAspect.setOrgCatalogSid(orgCatalogSid);
        orgAspect.setName("\u9ed8\u8ba4\u7ec4\u7ec7\u6811");
        OrgAspect orgAspectTemp = (OrgAspect)this.orgAspectCrudService.findByUnionKey(new Object[]{tenantSid, orgCatalogSid, "defaultOrgAspect"});
        if (orgAspectTemp == null) {
            this.orgAspectCrudService.create((BaseEntity)orgAspect);
        }
        if ((orgTypeTempCompany = this.orgTypeCrudService.findByUnionKey(tenantSid, orgCatalogSid, "company")) == null) {
            OrgType orgTypeCompany = new OrgType();
            orgTypeCompany.setTenantSid(tenantSid);
            orgTypeCompany.setOrgCatalogSid(orgCatalogSid);
            orgTypeCompany.setId("company");
            orgTypeCompany.setName(this.messageSource.getMessage("orgType.companyName.message", null, this.envProperties.getLocale()));
            orgTypeCompany.setUri("drn:iam:orgtype:defaultOrgCatalog:company");
            orgTypeCompany.setUrn(this.messageSource.getMessage("orgType.companyUrn.message", null, this.envProperties.getLocale()));
            long sid = this.orgTypeCrudService.create((BaseEntity)orgTypeCompany);
            HashMap<String, String> languageContents = new HashMap<String, String>();
            languageContents.put("zh-CN", "\u516c\u53f8");
            languageContents.put("zh-TW", "\u516c\u53f8");
            languageContents.put("en-US", "company");
            this.languageCrudService.save(sid, "name", languageContents);
        }
        if ((orgTypeTempFactory = this.orgTypeCrudService.findByUnionKey(tenantSid, orgCatalogSid, "factory")) == null) {
            OrgType orgTypeFactory = new OrgType();
            orgTypeFactory.setTenantSid(tenantSid);
            orgTypeFactory.setOrgCatalogSid(orgCatalogSid);
            orgTypeFactory.setId("factory");
            orgTypeFactory.setName(this.messageSource.getMessage("orgType.factoryName.message", null, this.envProperties.getLocale()));
            orgTypeFactory.setUri("drn:iam:orgtype:defaultOrgCatalog:factory");
            orgTypeFactory.setUrn(this.messageSource.getMessage("orgType.factoryUrn.message", null, this.envProperties.getLocale()));
            long sid = this.orgTypeCrudService.create((BaseEntity)orgTypeFactory);
            HashMap<String, String> languageContents = new HashMap<String, String>();
            languageContents.put("zh-CN", "\u5de5\u5382");
            languageContents.put("zh-TW", "\u5de5\u5ee0");
            languageContents.put("en-US", "factory");
            this.languageCrudService.save(sid, "name", languageContents);
        }
        if ((orgTypeTempDepartment = this.orgTypeCrudService.findByUnionKey(tenantSid, orgCatalogSid, "department")) == null) {
            OrgType orgTypeDepartment = new OrgType();
            orgTypeDepartment.setTenantSid(tenantSid);
            orgTypeDepartment.setOrgCatalogSid(orgCatalogSid);
            orgTypeDepartment.setId("department");
            orgTypeDepartment.setName(this.messageSource.getMessage("orgType.departmentName.message", null, this.envProperties.getLocale()));
            orgTypeDepartment.setUri("drn:iam:orgtype:defaultOrgCatalog:department");
            orgTypeDepartment.setUrn(this.messageSource.getMessage("orgType.departmentUrn.message", null, this.envProperties.getLocale()));
            long sid = this.orgTypeCrudService.create((BaseEntity)orgTypeDepartment);
            HashMap<String, String> languageContents = new HashMap<String, String>();
            languageContents.put("zh-CN", "\u90e8\u95e8");
            languageContents.put("zh-TW", "\u90e8\u9580");
            languageContents.put("en-US", "department");
            this.languageCrudService.save(sid, "name", languageContents);
        }
        OrgTagCatalog orgTagCatalog = new OrgTagCatalog();
        orgTagCatalog.setId("defaultOrgTagCatalog");
        orgTagCatalog.setName("\u9ed8\u8ba4\u6807\u7b7e\u5206\u7c7b");
        orgTagCatalog.setTenantSid(tenantSid);
        OrgTagCatalog orgTagCatalogTemp = (OrgTagCatalog)this.orgTagCatalogCrudService.findByUnionKey(new Object[]{tenantSid, "defaultOrgTagCatalog"});
        if (orgTagCatalogTemp == null) {
            this.orgTagCatalogCrudService.create((BaseEntity)orgTagCatalog);
        }
    }

    private void initDefaultRoleAndUser(long tenantSid, long userSid, boolean isCreateIntegration) {
        long sid;
        Association associationTemp;
        long roleCatalogSid = this.createRoleCatalog(tenantSid, "administrators", "\u540e\u53f0\u7ba1\u7406\u5458");
        this.createRoleCatalog(tenantSid, "defaultRoleCatalog", "\u9810\u8a2d\u89d2\u8272\u5206\u985e");
        this.createRoleCatalog(tenantSid, "integration", "\u7cfb\u7edf\u96c6\u6210\u5206\u7c7b");
        Role role = new Role();
        role.setId("superadmin");
        role.setName(this.getAdminName());
        role.setTenantSid(tenantSid);
        role.setReadonly(true);
        role.setRoleCatalogSid(roleCatalogSid);
        long adminRoleSid = this.roleCrudService.getSidByTenantAndId(tenantSid, "superadmin");
        if (adminRoleSid == 0L) {
            adminRoleSid = this.roleCrudService.create((BaseEntity)role);
        }
        if ((associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, userSid, adminRoleSid)) == null) {
            associationTemp = new Association();
            associationTemp.setTenantSid(tenantSid);
            associationTemp.setUserSid(userSid);
            associationTemp.setRoleSid(adminRoleSid);
            associationTemp.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)associationTemp);
        }
        if (isCreateIntegration) {
            sid = this.userCrudService.getSidById("integration");
            this.createUserInTenant(tenantSid, sid);
        }
        sid = this.userCrudService.getSidById("virtual");
        this.createUserInTenant(tenantSid, sid);
        associationTemp = this.userInRoleCrudService.findByUnionKey(tenantSid, sid, adminRoleSid);
        if (associationTemp == null) {
            associationTemp = new Association();
            associationTemp.setTenantSid(tenantSid);
            associationTemp.setRoleSid(adminRoleSid);
            associationTemp.setUserSid(sid);
            associationTemp.setStatus(Boolean.TRUE);
            this.userInRoleCrudService.create((BaseEntity)associationTemp);
        }
    }

    private String getAdminName() {
        if (Locale.TRADITIONAL_CHINESE.getCountry().equalsIgnoreCase(this.envProperties.getCountry())) {
            return "\u8d85\u7d1a\u7ba1\u7406\u54e1";
        }
        return "\u8d85\u7ea7\u7ba1\u7406\u5458";
    }

    private void createUserInTenant(long tenantSid, long userSid) {
        if (this.userInTenantCrudService.findByUnionKey(tenantSid, userSid) == null) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(userSid);
            userInTenant.setVisible(false);
            this.userInTenantCrudService.create(userInTenant);
        }
    }

    private long createRoleCatalog(long tenantSid, String roleCatalogId, String roleCatalogName) {
        long roleCatalogSid = this.roleCatalogCrudService.getSidByTenantAndId(tenantSid, roleCatalogId);
        if (roleCatalogSid == 0L) {
            RoleCatalog roleCatalog = new RoleCatalog();
            roleCatalog.setId(roleCatalogId);
            roleCatalog.setName(roleCatalogName);
            roleCatalog.setTenantSid(tenantSid);
            roleCatalog.setReadonly(true);
            roleCatalogSid = this.roleCatalogCrudService.create((BaseEntity)roleCatalog);
        }
        return roleCatalogSid;
    }
}

