/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.log.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.DeletePurchaseGoods;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordChangeLogInfo;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordDTO;
import com.digiwin.dap.middleware.iam.domain.changelog.ChangeLogDO;
import com.digiwin.dap.middleware.iam.domain.enumeration.StopTypeEnum;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.UserInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserTenantSimpleVO;
import com.digiwin.dap.middleware.iam.entity.Role;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationCode;
import com.digiwin.dap.middleware.iam.entity.ServiceAuthorizationRecord;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.PreOrderVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.TenantApplication;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.request.SaveCompareOpLog;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ChangeLogServiceImpl
implements ChangeLogService {
    private static final Logger logger = LoggerFactory.getLogger(ChangeLogServiceImpl.class);
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private LMC lmcClient;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public void saveNewRoleChangeLogs(Role role, Tenant tenant) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            AuthoredUser authoredUser = new AppAuthContext().getAuthoredUser();
            if (authoredUser != null) {
                changeLogDO.setEditUserId(authoredUser.getUserId());
                changeLogDO.setEditUserName(authoredUser.getUserName());
            }
            changeLogDO.setSource("iam");
            changeLogDO.setRemark("create by serviceCloud");
            changeLogDO.setEditTime(LocalDateTime.now());
            changeLogDO.setTenantId(tenant.getId());
            changeLogDO.setTenantName(tenant.getName());
            changeLogDO.setEditPlace("serviceCloud");
            changeLogDO.setActionId("tenant.addRole");
            changeLogDO.setTableName("role");
            changeLogDO.setPrimaryKey(tenant.getId());
            changeLogDO.setPrimaryName(tenant.getName());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", role.getSid());
            changeInfo.put("displayName", String.format("%s(%s)", role.getName(), role.getId()));
            HashMap<String, Object> insertInfo = new HashMap<String, Object>();
            insertInfo.put("orgName", "");
            insertInfo.put("name", role.getName());
            insertInfo.put("orgSid", role.getOrgSid());
            insertInfo.put("id", role.getId());
            insertInfo.put("sid", role.getSid());
            changeInfo.put("insertInfo", insertInfo);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveNewAssociationChangeLogs(Role role, String roleCatalogId, Tenant tenant, User user, List<QueryRoleResultVO> oldUserRoles) {
        try {
            HashMap<String, String> roleInfo;
            ChangeLogDO changeLogDO = new ChangeLogDO();
            AuthoredUser authoredUser = new AppAuthContext().getAuthoredUser();
            if (authoredUser != null) {
                changeLogDO.setEditUserId(authoredUser.getUserId());
                changeLogDO.setEditUserName(authoredUser.getUserName());
            }
            changeLogDO.setSource("iam");
            changeLogDO.setRemark("create by serviceCloud");
            changeLogDO.setEditTime(LocalDateTime.now());
            changeLogDO.setTenantId(tenant.getId());
            changeLogDO.setTenantName(tenant.getName());
            changeLogDO.setEditPlace("serviceCloud");
            changeLogDO.setActionId("tenant.userRole");
            changeLogDO.setTableName("association");
            changeLogDO.setPrimaryKey(user.getId());
            changeLogDO.setPrimaryName(user.getName());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", user.getId());
            changeInfo.put("displayName", user.getName());
            HashMap insertInfoMap = new HashMap();
            HashMap deleteInfoMap = new HashMap();
            ArrayList insertInfos = new ArrayList();
            ArrayList deleteInfos = new ArrayList();
            for (QueryRoleResultVO roleResult : oldUserRoles) {
                roleInfo = new HashMap();
                roleInfo.put("catalogId", roleResult.getCatalogId());
                roleInfo.put("id", roleResult.getId());
                roleInfo.put("name", roleResult.getName());
                insertInfos.add(roleInfo);
                deleteInfos.add(roleInfo);
            }
            roleInfo = new HashMap<String, String>();
            roleInfo.put("catalogId", roleCatalogId);
            roleInfo.put("id", role.getId());
            roleInfo.put("name", role.getName());
            insertInfos.add(roleInfo);
            insertInfoMap.put("list", insertInfos);
            deleteInfoMap.put("list", deleteInfos);
            changeInfo.put("insertInfo", insertInfoMap);
            changeInfo.put("deleteInfo", deleteInfoMap);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveDeleteAssociationChangeLogs(QueryRoleResultVO deleteRole, Tenant tenant, User user, List<QueryRoleResultVO> oldUserRoles) {
        try {
            HashMap<String, String> roleInfo;
            ChangeLogDO changeLogDO = new ChangeLogDO();
            AuthoredUser authoredUser = new AppAuthContext().getAuthoredUser();
            if (authoredUser != null) {
                changeLogDO.setEditUserId(authoredUser.getUserId());
                changeLogDO.setEditUserName(authoredUser.getUserName());
            }
            changeLogDO.setSource("iam");
            changeLogDO.setRemark("create by serviceCloud");
            changeLogDO.setEditTime(LocalDateTime.now());
            changeLogDO.setTenantId(tenant.getId());
            changeLogDO.setTenantName(tenant.getName());
            changeLogDO.setEditPlace("serviceCloud");
            changeLogDO.setActionId("tenant.userRole");
            changeLogDO.setTableName("association");
            changeLogDO.setPrimaryKey(user.getId());
            changeLogDO.setPrimaryName(user.getName());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", user.getId());
            changeInfo.put("displayName", user.getName());
            HashMap insertInfoMap = new HashMap();
            HashMap deleteInfoMap = new HashMap();
            ArrayList insertInfos = new ArrayList();
            ArrayList deleteInfos = new ArrayList();
            for (QueryRoleResultVO roleResult : oldUserRoles) {
                roleInfo = new HashMap();
                roleInfo.put("catalogId", roleResult.getCatalogId());
                roleInfo.put("id", roleResult.getId());
                roleInfo.put("name", roleResult.getName());
                insertInfos.add(roleInfo);
                deleteInfos.add(roleInfo);
            }
            roleInfo = new HashMap<String, String>();
            roleInfo.put("catalogId", deleteRole.getCatalogId());
            roleInfo.put("id", deleteRole.getId());
            roleInfo.put("name", deleteRole.getName());
            insertInfos.remove(roleInfo);
            insertInfoMap.put("list", insertInfos);
            deleteInfoMap.put("list", deleteInfos);
            changeInfo.put("insertInfo", insertInfoMap);
            changeInfo.put("deleteInfo", deleteInfoMap);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveStopCodeChangeLogs(ServiceAuthorizationCode authorizationCode, Tenant tenant) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            if (0 == authorizationCode.getType()) {
                changeLogDO.setActionId("tenant.serviceAuthorizationCode");
                changeLogDO.setRemark("Service code deactivation due to expiration");
            } else {
                changeLogDO.setActionId("tenant.serviceAgentAuthorizationCode");
                changeLogDO.setRemark("Agent Service code deactivation due to expiration");
            }
            changeLogDO.setSource("iam");
            changeLogDO.setPrimaryKey(tenant.getId());
            changeLogDO.setPrimaryName(tenant.getName());
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(UserUtils.getUserName());
            changeLogDO.setEditPlace("console");
            changeLogDO.setTenantId(tenant.getId());
            changeLogDO.setTenantName(tenant.getName());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", tenant.getId());
            changeInfo.put("displayName", tenant.getName());
            HashMap<String, Object> insertInfo = new HashMap<String, Object>();
            insertInfo.put("authorizationCode", authorizationCode.getCode());
            insertInfo.put("stopType", StopTypeEnum.EXPIRED_STOP.getValue());
            insertInfo.put("disabled", authorizationCode.isDisabled());
            insertInfo.put("editUserId", UserUtils.getUserId());
            insertInfo.put("editUserName", UserUtils.getUserName());
            insertInfo.put("status", 0);
            insertInfo.put("createDate", authorizationCode.getCreateDate());
            insertInfo.put("startDate", authorizationCode.getStartDate());
            insertInfo.put("modifyDate", authorizationCode.getModifyDate());
            insertInfo.put("endDate", authorizationCode.getEndDate());
            if (authorizationCode.getStartDate() != null && authorizationCode.getEndDate() != null) {
                insertInfo.put("effective", authorizationCode.getEndDate().toLocalDate().toEpochDay() - authorizationCode.getStartDate().toLocalDate().toEpochDay());
            }
            changeInfo.put("insertInfo", insertInfo);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveServiceAuthCodeRecordUpdateLogs(List<ServiceAuthorizationRecordChangeLogInfo> changeLogInfos) {
        try {
            ArrayList<ChangeLogDO> changeLogDOS = new ArrayList<ChangeLogDO>();
            changeLogInfos.forEach(c -> {
                Tenant tenant = c.getTenant();
                User user = c.getUser();
                ServiceAuthorizationRecord newRecord = c.getNewRecord();
                ServiceAuthorizationRecord oldRecord = c.getOldRecord();
                ChangeLogDO changeLogDO = new ChangeLogDO();
                changeLogDO.setSource("iam");
                changeLogDO.setEditUserId(UserUtils.getUserId());
                changeLogDO.setEditUserName(UserUtils.getUserName());
                changeLogDO.setEditPlace(StringUtils.isEmpty((Object)UserUtils.getSysId()) ? "console" : UserUtils.getSysId());
                changeLogDO.setTenantId(tenant.getId());
                changeLogDO.setTenantName(tenant.getName());
                changeLogDO.setActionId("tenant.serviceAgentAuthorizationCodeRecord");
                changeLogDO.setActId("tenant.serviceAgentAuthorizationCodeRecord");
                changeLogDO.setPrimaryKey(String.valueOf(newRecord.getSid()));
                changeLogDO.setPrimaryName(user.getId());
                changeLogDO.setAppId("digiwincloud");
                changeLogDO.setModuleId("djc-mang-user");
                ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
                HashMap<String, Object> changeInfo = new HashMap<String, Object>();
                if (null == oldRecord) {
                    changeLogDO.setOperationType("insert");
                    changeLogDO.setRemark(StringUtils.isEmpty((Object)newRecord.getRemark()) ? "\u7528\u6237\u6388\u6743\u4ee3\u7406" : newRecord.getRemark());
                    changeInfo.put("insertInfo", (Object)newRecord);
                    changeInfo.put("key", "userSid");
                    changeInfo.put("displayName", "\u7528\u6237");
                    changeInfo.put("originValue", "-");
                    changeInfo.put("modifyValue", String.format("%s(%s)", user.getName(), user.getId()));
                    changeInfoList.add(changeInfo);
                    changeInfo = new HashMap();
                    changeInfo.put("key", "StartDate");
                    changeInfo.put("displayName", "\u4ee3\u7406\u6388\u6743\u5f00\u59cb\u65f6\u95f4");
                    changeInfo.put("originValue", "-");
                    changeInfo.put("modifyValue", newRecord.getStartDate());
                    changeInfoList.add(changeInfo);
                    changeInfo = new HashMap();
                    changeInfo.put("key", "EndDate");
                    changeInfo.put("displayName", "\u4ee3\u7406\u6388\u6743\u622a\u6b62\u65f6\u95f4");
                    changeInfo.put("originValue", "-");
                    changeInfo.put("modifyValue", newRecord.getEndDate());
                    changeInfoList.add(changeInfo);
                } else {
                    changeLogDO.setOperationType("update");
                    changeLogDO.setRemark("\u7528\u6237\u6388\u6743\u4ee3\u7406\u4fe1\u606f\u53d8\u66f4");
                    if (!newRecord.getEndDate().equals(oldRecord.getEndDate())) {
                        changeInfo.put("key", "EndDate");
                        changeInfo.put("displayName", "\u7528\u6237\u4ee3\u7406\u6388\u6743\u622a\u6b62\u65f6\u95f4");
                        changeInfo.put("originValue", oldRecord.getEndDate());
                        changeInfo.put("modifyValue", newRecord.getEndDate());
                        changeInfoList.add(changeInfo);
                    }
                    if (newRecord.isDisabled() != oldRecord.isDisabled()) {
                        changeInfo = new HashMap();
                        changeInfo.put("key", "Disabled");
                        changeInfo.put("displayName", "\u7528\u6237\u4ee3\u7406\u6388\u6743\u72b6\u6001");
                        changeInfo.put("originValue", oldRecord.isDisabled());
                        changeInfo.put("modifyValue", newRecord.isDisabled());
                        changeInfoList.add(changeInfo);
                    }
                }
                if (!changeInfoList.isEmpty()) {
                    changeLogDO.setChangeInfoList(changeInfoList);
                    changeLogDOS.add(changeLogDO);
                }
            });
            if (!changeLogDOS.isEmpty()) {
                this.remoteLMCService.batchSaveChangeLog(changeLogDOS);
            }
        }
        catch (Exception ex) {
            logger.error("\u8bb0\u5f55\u53d8\u66f4\u5386\u7a0b\u5931\u8d25,\u9519\u8bef\u5185\u5bb9:{},\u9519\u8bef\u6d88\u606f:{}", new Object[]{JsonUtils.writeValue(changeLogInfos), ex.getMessage(), ex});
        }
    }

    @Override
    public void saveRemoveUserChangeLogs(User user) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setSource("iam");
            changeLogDO.setActionId("tenant.userRemove");
            changeLogDO.setActId("action_deleteUser");
            changeLogDO.setAppId("digiwincloud");
            changeLogDO.setEditPlace("console");
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(UserUtils.getUserName());
            changeLogDO.setModuleId("djc-mang-user");
            changeLogDO.setOperationObject(user.getName() + "(" + user.getId() + ")");
            changeLogDO.setOperationType("delete");
            changeLogDO.setPrimaryKey(user.getId());
            changeLogDO.setPrimaryName(user.getName());
            changeLogDO.setTenantName(UserUtils.getTenantName());
            changeLogDO.setTenantId(UserUtils.getTenantId());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", user.getId());
            changeInfo.put("displayName", user.getName());
            changeInfo.put("modifyValue", "-");
            changeInfo.put("originValue", user.getName() + "(" + user.getId() + ")");
            changeInfo.put("type", user.getType());
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveDeletePurchaseGoodsChangeLogs(DeletePurchaseGoods goods) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setSource("iam");
            changeLogDO.setActionId("tenant.deletePurchaseGoodsChangeLog");
            changeLogDO.setPrimaryKey(goods.getGoodsCode());
            changeLogDO.setPrimaryName(goods.getGoodsName());
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(UserUtils.getUserName());
            changeLogDO.setEditPlace("console");
            changeLogDO.setTenantId(goods.getTenantId());
            changeLogDO.setTenantName(goods.getTenantName());
            changeLogDO.setRemark(goods.getReason());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", goods.getTenantId());
            changeInfo.put("displayName", goods.getTenantName());
            HashMap insertInfo = new HashMap();
            changeInfo.put("insertInfo", insertInfo);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveDeleteSrobotChangeLogs(DeletePurchaseGoods goods, TenantApplication tenantApplication) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setSource("iam");
            changeLogDO.setActionId("tenant.deleteAppLog");
            changeLogDO.setPrimaryKey(tenantApplication.getId());
            changeLogDO.setPrimaryName(tenantApplication.getName());
            changeLogDO.setEditUserId("API\u8c03\u7528");
            changeLogDO.setEditUserName(UserUtils.getUserName());
            changeLogDO.setEditPlace("om");
            changeLogDO.setTenantId(goods.getTenantId());
            changeLogDO.setTenantName(goods.getTenantName());
            changeLogDO.setRemark("\u9000\u8d27");
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", "deleteApp");
            changeInfo.put("originValue", tenantApplication.getName() + "(" + tenantApplication.getId() + ")");
            changeInfo.put("modifyValue", "-");
            changeInfo.put("displayName", "\u5220\u9664\u5e94\u7528");
            changeInfo.put("insertInfo", tenantApplication);
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void addUserInCountingChangeLogs(ServiceAuthorizationRecordDTO dto, TenantApplication tenantApplication, List<String> userIds, List<String> newUserIds) {
        try {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setSource("CAC");
            changeLogDO.setActionId("update");
            changeLogDO.setPrimaryKey(tenantApplication.getPurchaseId());
            changeLogDO.setEditUserId(dto.getUserId());
            changeLogDO.setEditUserName(dto.getUserName());
            if (StringUtils.isEmpty((Object)dto.getRemark())) {
                changeLogDO.setRemark(String.format("\u670d\u52a1\u6388\u6743\u7801[%s]", dto.getCode()));
            } else {
                changeLogDO.setRemark(dto.getRemark());
            }
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, String> changeInfo = new HashMap<String, String>();
            changeInfo.put("key", "users");
            changeInfo.put("displayName", "\u6388\u6743\u7528\u6237\u53d8\u66f4");
            userIds = Optional.ofNullable(userIds).orElseGet(ArrayList::new);
            newUserIds = Optional.ofNullable(newUserIds).orElseGet(ArrayList::new);
            changeInfo.put("originValue", String.join((CharSequence)",", userIds));
            changeInfo.put("modifyValue", String.join((CharSequence)",", newUserIds));
            changeInfo.put("type", "simpleProperty");
            changeInfoList.add(changeInfo);
            changeLogDO.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(changeLogDO);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void appAuthChangeLogs(PreOrderVO preOrderVO, AuthorizationVO oldAuthVO, AuthorizationVO authVO, String goodsCode, LocalDateTime effectiveDateTime) {
        String token = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(this.envProperties.getManagerTenant()) : UserUtils.getToken();
        SaveCompareOpLog dto = new SaveCompareOpLog();
        dto.setActId("DigiwinCloud".toLowerCase());
        dto.setActionId("update");
        dto.setModuleId("default");
        dto.setOperationType("insert");
        dto.setEditUserId(preOrderVO.getCreateById());
        dto.setEditUserName(preOrderVO.getCreateById());
        ArrayList logFieldList = new ArrayList();
        String fieldName = "fieldName";
        String displayName = "displayName";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(fieldName, "remainingUsage");
        map.put(displayName, "\u5269\u4f59\u6b21\u6570");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "totalUsage");
        map.put(displayName, "\u603b\u4f7f\u7528\u6570\u91cf");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "expiredTime");
        map.put(displayName, "\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "effectiveTime");
        map.put(displayName, "\u6388\u6743\u5f00\u901a\u65e5");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules");
        map.put(displayName, "\u53d8\u66f4\u6a21\u7ec4");
        logFieldList.add(map);
        map = new HashMap();
        map.put(fieldName, "enabledModules.expiredTime");
        map.put(displayName, "\u6388\u6743\u5230\u671f\u65f6\u95f4");
        logFieldList.add(map);
        dto.setLogFieldList(logFieldList);
        ArrayList<HashMap<String, String>> primaryKeyList = new ArrayList<HashMap<String, String>>();
        map = new HashMap();
        map.put("path", "");
        map.put("keyName", "purchaseId");
        primaryKeyList.add(map);
        map = new HashMap();
        map.put("path", "enabledModules");
        map.put("keyName", "id");
        map.put("showField", "name");
        primaryKeyList.add(map);
        dto.setPrimaryKeyList(primaryKeyList);
        dto.setRemark(preOrderVO.getMemo());
        dto.setSource("CAC");
        dto.setTableName("purchase");
        try {
            authVO.setEffectiveTime(effectiveDateTime);
            if (authVO != null) {
                dto.setPrimaryKey(authVO.getPurchaseId());
                dto.setModifyJson((Map)objectMapper.convertValue((Object)authVO, Map.class));
                dto.setOriginJson(oldAuthVO != null ? (Map)objectMapper.convertValue((Object)oldAuthVO, Map.class) : new HashMap());
                this.lmcClient.saveCompareOpLogDirect(dto, token);
            }
        }
        catch (Exception e) {
            logger.error("\u8bb0\u5f55cac\u6388\u6743\u5386\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void enableOrDisableUserChangeLogs(Tenant tenant, UserInfo user, String remark, Object originValue, Object modifyValue) {
        ChangeLogDO changeLogDO = this.createChangeLogObject(user.getId(), user.getName(), tenant.getId(), tenant.getName(), remark, originValue, modifyValue);
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveTenantExportDataChangeLogs(TenantDataExportRecord r, String remark, Boolean success) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(r.getTenantSid());
        User user = (User)this.userCrudService.findBySid(r.getCreateBy());
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-data-export");
        changeLogDO.setActId("action_export");
        changeLogDO.setEditPlace("console");
        changeLogDO.setTenantId(tenant.getId());
        changeLogDO.setTenantName(tenant.getName());
        changeLogDO.setEditUserId(user.getId());
        changeLogDO.setEditUserName(user.getName());
        changeLogDO.setRemark(remark);
        changeLogDO.setOperationType("export");
        if (success.booleanValue()) {
            changeLogDO.setActionId("tenant.dataExportSucceed");
        } else {
            changeLogDO.setActionId("tenant.dataExportFailed");
        }
        changeLogDO.setOperationObject(r.getId());
        changeLogDO.setSource("iam");
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveAssociationChangeLogs(String primaryKey, String primaryName, String originValue, String modifyValue) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-user");
        changeLogDO.setActId("action_editUser");
        changeLogDO.setEditPlace("console");
        changeLogDO.setEditUserId(UserUtils.getUserId());
        changeLogDO.setEditUserName(UserUtils.getUserName());
        changeLogDO.setOperationType("update");
        changeLogDO.setActionId("tenant.userRole");
        changeLogDO.setOperationObject(primaryName + "(" + primaryKey + ")");
        changeLogDO.setPrimaryKey(primaryKey);
        changeLogDO.setPrimaryName(primaryName);
        changeLogDO.setSource("iam");
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        changeLogDO.setChangeInfoList(changeInfoList);
        HashMap<String, String> changeInfo = new HashMap<String, String>();
        changeInfoList.add(changeInfo);
        changeInfo.put("key", primaryKey);
        changeInfo.put("displayName", primaryName);
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveAssociationChangeLogs(User user, User operationUser, String originValue, String modifyValue) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-user");
        changeLogDO.setActId("action_editUser");
        changeLogDO.setEditPlace("console");
        changeLogDO.setEditUserId(operationUser.getId());
        changeLogDO.setEditUserName(operationUser.getName());
        changeLogDO.setOperationType("update");
        changeLogDO.setActionId("tenant.userRole");
        changeLogDO.setOperationObject(user.getName() + "(" + user.getId() + ")");
        changeLogDO.setPrimaryKey(user.getId());
        changeLogDO.setPrimaryName(user.getName());
        changeLogDO.setSource("iam");
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        changeLogDO.setChangeInfoList(changeInfoList);
        HashMap<String, String> changeInfo = new HashMap<String, String>();
        changeInfoList.add(changeInfo);
        changeInfo.put("key", user.getId());
        changeInfo.put("displayName", user.getName());
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveOrgInUserChangeLogs(String primaryKey, String primaryName, String originValue, String modifyValue) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-user");
        changeLogDO.setActId("action_editUser");
        changeLogDO.setEditPlace("console");
        changeLogDO.setEditUserId(UserUtils.getUserId());
        changeLogDO.setEditUserName(UserUtils.getUserName());
        changeLogDO.setOperationType("update");
        changeLogDO.setActionId("tenant.userOrg");
        changeLogDO.setOperationObject(primaryName + "(" + primaryKey + ")");
        changeLogDO.setPrimaryKey(primaryKey);
        changeLogDO.setPrimaryName(primaryName);
        changeLogDO.setSource("iam");
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        changeLogDO.setChangeInfoList(changeInfoList);
        HashMap<String, String> changeInfo = new HashMap<String, String>();
        changeInfoList.add(changeInfo);
        changeInfo.put("key", primaryKey);
        changeInfo.put("displayName", primaryName);
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        changeInfo.put("type", "userOrg");
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveOrgInUserChangeLogs(User user, User operationUser, String originValue, String modifyValue) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-user");
        changeLogDO.setActId("action_editUser");
        changeLogDO.setEditPlace("console");
        changeLogDO.setEditUserId(operationUser.getId());
        changeLogDO.setEditUserName(operationUser.getName());
        changeLogDO.setOperationType("update");
        changeLogDO.setActionId("tenant.userOrg");
        changeLogDO.setOperationObject(user.getName() + "(" + user.getId() + ")");
        changeLogDO.setPrimaryKey(user.getId());
        changeLogDO.setPrimaryName(user.getName());
        changeLogDO.setSource("iam");
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        changeLogDO.setChangeInfoList(changeInfoList);
        HashMap<String, String> changeInfo = new HashMap<String, String>();
        changeInfoList.add(changeInfo);
        changeInfo.put("key", user.getId());
        changeInfo.put("displayName", user.getName());
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        changeInfo.put("type", "userOrg");
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    @Override
    public void saveAppInUserChangeLogs(User user, User operationUser, String originValue, String modifyValue, Tenant tenant) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setAppId("digiwincloud");
        changeLogDO.setModuleId("djc-mang-user");
        changeLogDO.setActId("action_editUser");
        changeLogDO.setEditPlace("console");
        changeLogDO.setEditUserId(operationUser.getId());
        changeLogDO.setEditUserName(operationUser.getName());
        changeLogDO.setOperationType("update");
        changeLogDO.setActionId("tenant.editAuthorizedUser");
        changeLogDO.setOperationObject(user.getName() + "(" + user.getId() + ")");
        changeLogDO.setPrimaryKey(user.getId());
        changeLogDO.setPrimaryName(user.getName());
        changeLogDO.setSource("iam");
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        changeLogDO.setChangeInfoList(changeInfoList);
        HashMap<String, String> changeInfo = new HashMap<String, String>();
        changeInfoList.add(changeInfo);
        changeInfo.put("key", tenant.getId());
        changeInfo.put("displayName", tenant.getName() + "(" + tenant.getName() + ")");
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        changeInfo.put("type", "value");
        this.remoteLMCService.saveNewChangeLog(changeLogDO);
    }

    private ChangeLogDO createChangeLogObject(String userId, String userName, String tenantId, String tenantName, String remark, Object originValue, Object modifyValue) {
        ChangeLogDO changeLogDO = new ChangeLogDO();
        changeLogDO.setSource("iam");
        changeLogDO.setActionId("tenant.userEnabled");
        changeLogDO.setOperationType("update");
        changeLogDO.setOperationObject(String.format("\u88ab\u53d8\u66f4\u7528\u6237\u540d\u79f0(ID):%s(%s)", userName, userId));
        changeLogDO.setPrimaryKey(userId);
        changeLogDO.setPrimaryName(userName);
        changeLogDO.setEditUserId(StringUtils.isEmpty((Object)UserUtils.getUserId()) ? "" : UserUtils.getUserId());
        changeLogDO.setEditPlace("devConsole");
        changeLogDO.setEditTime(LocalDateTime.now());
        changeLogDO.setTenantId(tenantId);
        changeLogDO.setTenantName(tenantName);
        changeLogDO.setEditUserId(UserUtils.getUserId());
        changeLogDO.setEditUserName(StringUtils.isEmpty((Object)UserUtils.getUserName()) ? "" : UserUtils.getUserName());
        changeLogDO.setModuleId("dev-management");
        changeLogDO.setActId("dev-team-management");
        changeLogDO.setAppId("dev");
        changeLogDO.setRemark(remark);
        ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> changeInfo = new HashMap<String, Object>();
        changeInfo.put("key", "enabled");
        changeInfo.put("displayName", "enabled");
        changeInfo.put("type", "simpleProperty");
        changeInfo.put("originValue", originValue);
        changeInfo.put("modifyValue", modifyValue);
        changeInfoList.add(changeInfo);
        changeLogDO.setChangeInfoList(changeInfoList);
        return changeLogDO;
    }

    @Override
    public void batchDisableUserChangeLogs(List<UserTenantSimpleVO> userTenantSimpleVOS) {
        ArrayList<ChangeLogDO> changeLogDOS = new ArrayList<ChangeLogDO>();
        userTenantSimpleVOS.forEach(u -> changeLogDOS.add(this.createChangeLogObject(u.getUserId(), u.getUserName(), u.getTenantId(), u.getTenantName(), "", "Y", "N")));
        this.remoteLMCService.batchSaveChangeLog(changeLogDOS);
    }

    @Override
    public void saveBatchDisableUserFromTenantLog(AuthoredUser user, Long userSid, Exception e) {
        try {
            User targetUser = (User)this.userCrudService.findBySid(userSid);
            String name = targetUser.getName();
            ChangeLogDO log = new ChangeLogDO();
            AuthoredUser authoredUser = user;
            if (authoredUser != null) {
                log.setEditUserId(authoredUser.getUserId());
                log.setEditUserName(authoredUser.getUserName());
            }
            log.setOperationObject(StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{name, targetUser.getId()}));
            log.setSource("iam");
            log.setEditTime(LocalDateTime.now());
            log.setTenantId(user.getTenantId());
            log.setTenantName(user.getTenantName());
            log.setEditPlace("console");
            log.setActionId("tenant.userEnabled");
            log.setAppId("digiwincloud");
            log.setModuleId("djc-mang-user");
            log.setActId("action_stopUser");
            log.setOperationType("update");
            log.setPrimaryKey(targetUser.getId());
            log.setPrimaryName(name);
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, String> changeInfo = new HashMap<String, String>();
            changeInfo.put("key", "enabled");
            changeInfo.put("displayName", "enabled");
            changeInfo.put("type", "simpleProperty");
            changeInfo.put("originValue", "Y");
            if (e != null) {
                changeInfo.put("modifyValue", "\u505c\u7528\u5931\u8d25\uff1a" + e.getMessage());
            } else {
                changeInfo.put("modifyValue", "N");
            }
            changeInfoList.add(changeInfo);
            log.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(log);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveBatchDeleteUserFromTenantLog(AuthoredUser user, User targetUser, Exception e) {
        try {
            String name = targetUser.getName();
            ChangeLogDO log = new ChangeLogDO();
            AuthoredUser authoredUser = user;
            if (authoredUser != null) {
                log.setEditUserId(authoredUser.getUserId());
                log.setEditUserName(authoredUser.getUserName());
            }
            log.setOperationObject(StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{name, targetUser.getId()}));
            log.setSource("iam");
            log.setEditTime(LocalDateTime.now());
            log.setTenantId(user.getTenantId());
            log.setTenantName(user.getTenantName());
            log.setEditPlace("console");
            log.setActionId("tenant.userRemove");
            log.setAppId("digiwincloud");
            log.setModuleId("djc-mang-user");
            log.setActId("action_deleteUser");
            log.setPrimaryKey(targetUser.getId());
            log.setPrimaryName(name);
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> changeInfo = new HashMap<String, Object>();
            changeInfo.put("key", targetUser.getId());
            changeInfo.put("displayName", name);
            changeInfo.put("type", targetUser.getType());
            changeInfo.put("originValue", StrUtil.format((CharSequence)"{}({})", (Object[])new Object[]{name, targetUser.getId()}));
            if (e != null) {
                changeInfo.put("modifyValue", "\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
            } else {
                changeInfo.put("modifyValue", "-");
            }
            changeInfoList.add(changeInfo);
            log.setChangeInfoList(changeInfoList);
            this.remoteLMCService.saveChangeLogCore(log);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void batchSaveTenantChangeLog(List<Tenant> currentTenants, List<Tenant> changeTenants, String actionId, List<String> fields) {
        ArrayList<ChangeLogDO> changeLogDOS = new ArrayList<ChangeLogDO>();
        changeTenants.forEach(t -> {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setActId(actionId);
            changeLogDO.setActionId(actionId);
            changeLogDO.setAppId("digiwincloud");
            changeLogDO.setSource("iam");
            changeLogDO.setModuleId("tenant");
            changeLogDO.setOperationType("update");
            changeLogDO.setTenantId(t.getId());
            changeLogDO.setTenantName(t.getName());
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(StringUtils.isEmpty((Object)UserUtils.getUserName()) ? "" : UserUtils.getUserName());
            changeLogDO.setEditPlace(UserUtils.getSysId());
            changeLogDO.setEditTime(LocalDateTime.now());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            Optional<Tenant> matchTenant = currentTenants.stream().filter(c -> t.getId().equals(c.getId())).findFirst();
            fields.forEach(f -> {
                try {
                    Optional<Field> matchPField;
                    Field[] parentFields;
                    HashMap<String, String> changeInfo = new HashMap<String, String>();
                    changeInfo.put("key", (String)f);
                    changeInfo.put("type", "simpleProperty");
                    Field[] fields1 = ((Object)t).getClass().getDeclaredFields();
                    Optional<Field> matchField = Arrays.stream(fields1).filter(ff -> f.equals(ff.getName())).findFirst();
                    if (matchField.isPresent()) {
                        changeInfo.put("modifyValue", matchField.get().get(t).toString());
                    } else {
                        parentFields = ((Object)t).getClass().getFields();
                        matchPField = Arrays.stream(parentFields).filter(ff -> f.equals(ff.getName())).findFirst();
                        if (matchPField.isPresent()) {
                            matchPField.get().setAccessible(true);
                            changeInfo.put("modifyValue", matchPField.get().get(t).toString());
                        }
                    }
                    if (matchTenant.isPresent()) {
                        Field[] fields2 = ((Object)((Object)((Tenant)((Object)((Object)((Object)matchTenant.get())))))).getClass().getDeclaredFields();
                        Optional<Field> matchField2 = Arrays.stream(fields2).filter(ff -> f.equals(ff.getName())).findFirst();
                        if (matchField2.isPresent()) {
                            changeInfo.put("originValue", matchField2.get().get(matchTenant.get()).toString());
                        }
                    } else {
                        parentFields = matchTenant.getClass().getFields();
                        matchPField = Arrays.stream(parentFields).filter(ff -> f.equals(ff.getName())).findFirst();
                        if (matchPField.isPresent()) {
                            matchPField.get().setAccessible(true);
                            changeInfo.put("modifyValue", matchPField.get().get(matchTenant).toString());
                        }
                    }
                    changeInfoList.add(changeInfo);
                }
                catch (IllegalAccessException e) {
                    logger.error("\u89e3\u6790\u53d8\u66f4\u5b57\u6bb5\u62a5\u9519", (Throwable)e);
                }
            });
            changeLogDO.setChangeInfoList(changeInfoList);
            changeLogDOS.add(changeLogDO);
        });
        this.remoteLMCService.batchSaveChangeLog(changeLogDOS);
    }

    @Override
    public void batchSaveUserChangeLog(List<User> currentUsers, List<User> changeUsers, String actionId, List<String> fields) {
        ArrayList<ChangeLogDO> changeLogDOS = new ArrayList<ChangeLogDO>();
        changeUsers.forEach(t -> {
            ChangeLogDO changeLogDO = new ChangeLogDO();
            changeLogDO.setAppId("digiwincloud");
            changeLogDO.setActId(actionId);
            changeLogDO.setActionId(actionId);
            changeLogDO.setSource("iam");
            changeLogDO.setModuleId("user");
            changeLogDO.setOperationType("update");
            changeLogDO.setTenantId(t.getId());
            changeLogDO.setTenantName(t.getName());
            changeLogDO.setEditUserId(UserUtils.getUserId());
            changeLogDO.setEditUserName(StringUtils.isEmpty((Object)UserUtils.getUserName()) ? "" : UserUtils.getUserName());
            changeLogDO.setEditPlace(UserUtils.getSysId());
            changeLogDO.setEditTime(LocalDateTime.now());
            ArrayList<Map<String, Object>> changeInfoList = new ArrayList<Map<String, Object>>();
            Optional<User> matchTenant = currentUsers.stream().filter(c -> t.getId().equals(c.getId())).findFirst();
            fields.forEach(f -> {
                try {
                    HashMap<String, String> changeInfo = new HashMap<String, String>();
                    changeInfo.put("key", (String)f);
                    changeInfo.put("type", "simpleProperty");
                    Field[] fields1 = ((Object)t).getClass().getDeclaredFields();
                    Optional<Field> matchField = Arrays.stream(fields1).filter(ff -> f.equals(ff.getName())).findFirst();
                    if (matchField.isPresent()) {
                        matchField.get().setAccessible(true);
                        changeInfo.put("modifyValue", matchField.get().get(t).toString());
                    } else {
                        Field[] parentFields = ((Object)t).getClass().getFields();
                        Optional<Field> matchPField = Arrays.stream(parentFields).filter(ff -> f.equals(ff.getName())).findFirst();
                        if (matchPField.isPresent()) {
                            matchPField.get().setAccessible(true);
                            changeInfo.put("modifyValue", matchPField.get().get(t).toString());
                        }
                    }
                    if (matchTenant.isPresent()) {
                        Field[] fields2 = ((Object)((Object)((User)((Object)((Object)((Object)matchTenant.get())))))).getClass().getDeclaredFields();
                        Optional<Field> matchField2 = Arrays.stream(fields2).filter(ff -> f.equals(ff.getName())).findFirst();
                        if (matchField2.isPresent()) {
                            matchField2.get().setAccessible(true);
                            changeInfo.put("originValue", matchField2.get().get(matchTenant.get()).toString());
                        } else {
                            Field[] parentFields = matchTenant.getClass().getFields();
                            Optional<Field> matchPField = Arrays.stream(parentFields).filter(ff -> f.equals(ff.getName())).findFirst();
                            if (matchPField.isPresent()) {
                                matchPField.get().setAccessible(true);
                                changeInfo.put("originValue", matchPField.get().get(matchTenant).toString());
                            }
                        }
                    }
                    changeInfoList.add(changeInfo);
                }
                catch (IllegalAccessException e) {
                    logger.error("\u89e3\u6790\u53d8\u66f4\u5b57\u6bb5\u62a5\u9519", (Throwable)e);
                }
            });
            changeLogDO.setChangeInfoList(changeInfoList);
            changeLogDOS.add(changeLogDO);
        });
        this.remoteLMCService.batchSaveChangeLog(changeLogDOS);
    }

    @Override
    public void updateCompareChangeLog(String actionId, Object before, Object after, List<String> primaryKeyFields, List<String> logFieldList) {
        this.updateCompareChangeLog(actionId, before, after, null, primaryKeyFields, logFieldList);
    }

    @Override
    public void updateCompareChangeLog(String actionId, Object before, Object after, String primaryKey, List<String> primaryKeyFields, List<String> logFieldList) {
        ArrayList<Map<String, String>> logFieldMapList = new ArrayList<Map<String, String>>();
        logFieldList.forEach(f -> {
            HashMap<String, String> logField = new HashMap<String, String>();
            logField.put("fieldName", (String)f);
            logFieldMapList.add(logField);
        });
        this.remoteLMCService.updateCompareChangeLog(actionId, before, after, primaryKey, primaryKeyFields, logFieldMapList);
    }

    @Override
    public void updateCompareChangeLog(String actionId, Object before, Object after, String primaryKey, List<String> primaryKeyFields, List<String> logFieldList, Map<String, Object> otherInfo) {
        ArrayList<Map<String, String>> logFieldMapList = new ArrayList<Map<String, String>>();
        logFieldList.forEach(f -> {
            HashMap<String, String> logField = new HashMap<String, String>();
            logField.put("fieldName", (String)f);
            logFieldMapList.add(logField);
        });
        this.remoteLMCService.updateCompareChangeLog(actionId, before, after, primaryKey, primaryKeyFields, logFieldMapList, otherInfo);
    }

    @Override
    public void createChangeLog(String actionId, Object data, String primaryKey, String primaryKeyValue) {
        this.remoteLMCService.createChangeLog(actionId, data, primaryKey, primaryKeyValue);
    }
}

