/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.obsolete.service.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.TreeModel;
import com.digiwin.dap.middleware.iam.domain.permission.CalcUser;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionPolicy;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrg;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserOrgInTag;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserRole;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserTag;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionUserTagInOrg;
import com.digiwin.dap.middleware.iam.domain.permission.UserDataPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionResult;
import com.digiwin.dap.middleware.iam.domain.permission.UserPermissionVO;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyAction;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyCondition;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyModule;
import com.digiwin.dap.middleware.iam.domain.policy.PolicyPermission;
import com.digiwin.dap.middleware.iam.domain.policy.PolicySys;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.DataPermissionMapper;
import com.digiwin.dap.middleware.iam.mapper.PermissionMapper;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCalcService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.support.obsolete.domain.DataPolicyTarget;
import com.digiwin.dap.middleware.iam.support.obsolete.domain.PermissionField;
import com.digiwin.dap.middleware.iam.support.obsolete.domain.PermissionUserDefaultOrg;
import com.digiwin.dap.middleware.iam.support.obsolete.entity.FieldValue;
import com.digiwin.dap.middleware.iam.support.obsolete.service.DataPermissionService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.FieldValueCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.util.TreeUtil;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class DataPermissionServiceImpl
implements DataPermissionService {
    private static final Logger logger = LoggerFactory.getLogger(DataPermissionServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private CacService cacService;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private PermissionMapper permissionMapper;
    @Autowired
    private PolicyCalcService policyCalcService;
    @Autowired
    private DataPermissionMapper dataPermissionMapper;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private FieldValueCrudService fieldValueCrudService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;

    @Override
    public UserDataPermissionResult getUserDataPermission(UserPermissionVO input, AuthoredUser authoredUser) {
        this.checkData(input);
        CalcUser calcUser = this.getCalcUser(input, authoredUser);
        UserPermissionResult userPermissionResult = this.getUserPermission(calcUser);
        return new UserDataPermissionResult(userPermissionResult.getRoles(), userPermissionResult.getOrg(), userPermissionResult.getTag(), userPermissionResult.getDefaultOrg(), userPermissionResult.getDataPermissions());
    }

    protected void checkData(UserPermissionVO input) {
        Assert.notNull((Object)input, (String)"input \u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)input.getTarget(), (String)"input.target \u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)input.getQueryParameter(), (String)"input.queryParameter \u4e0d\u80fd\u4e3anull");
        Assert.notNull((Object)input.getQueryParameter().getEffect(), (String)"input.queryParameter.effect \u4e0d\u80fd\u4e3anull");
        String[] splitTarget = input.getTarget().split(":");
        if (splitTarget.length < 4) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_URL_ILLEGAL, new Object[]{input.getTarget()});
        }
    }

    protected CalcUser getCalcUser(UserPermissionVO input, AuthoredUser authoredUser) {
        if (authoredUser.getTenantSid() == 0L) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED);
        }
        String effect = "allow";
        if ("all".equals(input.getQueryParameter().getEffect())) {
            effect = "all";
        } else if ("onlyDeny".equals(input.getQueryParameter().getEffect())) {
            effect = "deny";
        }
        CalcUser calcUser = new CalcUser();
        calcUser.setTenantSid(authoredUser.getTenantSid());
        calcUser.setTenantId(authoredUser.getTenantId());
        calcUser.setAppId(input.getTarget().split(":")[3]);
        if (StringUtils.isEmpty((Object)input.getUserId())) {
            calcUser.setUserId(authoredUser.getUserId());
        } else {
            calcUser.setUserId(input.getUserId());
        }
        calcUser.setEffect(effect);
        return calcUser;
    }

    private UserPermissionResult getUserPermission(CalcUser calcUser) {
        User user = this.dataPermissionMapper.getUserByTenantSidAndUserId(calcUser.getTenantSid(), calcUser.getUserId());
        Assert.notNull((Object)((Object)user), (String)String.format("\u7528\u6237[%s]\u4e0d\u5b58\u5728\u6216\u7528\u6237\u4e0d\u5728\u6307\u5b9a\u7684\u79df\u6237\u5185!", calcUser.getUserId()));
        calcUser.setUserSid(user.getSid());
        Sys sys = this.sysMapper.findByTenantSidAndId(calcUser.getTenantSid(), calcUser.getAppId());
        Assert.notNull((Object)((Object)sys), (String)String.format("\u5e94\u7528[%s]\u4e0d\u5b58\u5728\u6216\u5e94\u7528\u4e0d\u5728\u6307\u5b9a\u7684\u79df\u6237\u5185!", calcUser.getAppId()));
        calcUser.setAppSid(sys.getSid());
        return this.calculateUserPermission(calcUser, sys.isInside());
    }

    private UserPermissionResult calculateUserPermission(CalcUser calcUser, boolean isInside) {
        List<PermissionUserRole> roles = this.permissionMapper.findUserRoles(calcUser.getTenantSid(), calcUser.getUserSid());
        List<PermissionUserOrg> orgs = this.permissionMapper.findUserOrgs(calcUser.getTenantSid(), calcUser.getUserSid());
        Map<String, PermissionUserOrg> org = this.addUserOrgTag(orgs, calcUser.getTenantSid(), calcUser.getUserSid());
        List<PermissionUserTag> tags = this.dataPermissionMapper.findUserTags(calcUser.getTenantSid(), calcUser.getUserSid());
        Map<String, PermissionUserTag> tag = this.addUserTagOrg(tags, calcUser.getTenantSid(), calcUser.getUserSid());
        List<PermissionUserDefaultOrg> defaultOrgs = this.dataPermissionMapper.findUserDefaultOrgs(calcUser.getTenantSid(), calcUser.getUserSid());
        LinkedHashMap<String, String> defaultOrg = new LinkedHashMap<String, String>();
        defaultOrgs.forEach(o -> defaultOrg.put(o.getOrgTypeUri(), o.getUri()));
        List<PermissionDataPolicy> dataPolicyPermissions = this.getUserDataPolicy(orgs, roles, calcUser.getTenantSid(), calcUser.getUserSid());
        PermissionField fieldPermissions = this.getUserFieldPermission(calcUser.getTenantSid(), calcUser.getUserSid(), calcUser.getAppId());
        return new UserPermissionResult(roles, org, tag, defaultOrg, dataPolicyPermissions, fieldPermissions);
    }

    private Map<String, PermissionUserOrg> addUserOrgTag(List<PermissionUserOrg> orgs, long tenantSid, long userSid) {
        List<PermissionUserTagInOrg> tagInOrgs = this.dataPermissionMapper.findUserTagInOrgs(tenantSid, userSid);
        Map<Long, List<PermissionUserTagInOrg>> orgTag = tagInOrgs.stream().collect(Collectors.groupingBy(PermissionUserTagInOrg::getOrgSid));
        for (PermissionUserOrg org : orgs) {
            if (!orgTag.containsKey(org.getSid())) continue;
            org.setOrgTag(orgTag.get(org.getSid()));
        }
        return orgs.stream().collect(Collectors.toMap(PermissionUserOrg::getPriority, a -> a, (k1, k2) -> k1));
    }

    private Map<String, PermissionUserTag> addUserTagOrg(List<PermissionUserTag> tags, long tenantSid, long userSid) {
        List<PermissionUserOrgInTag> orgInTags = this.dataPermissionMapper.findUserOrgInTags(tenantSid, userSid);
        Map<Long, List<PermissionUserOrgInTag>> tagOrg = orgInTags.stream().collect(Collectors.groupingBy(PermissionUserOrgInTag::getTagSid));
        for (PermissionUserTag tag : tags) {
            if (!tagOrg.containsKey(tag.getSid())) continue;
            tag.setOrg(tagOrg.get(tag.getSid()));
        }
        return tags.stream().collect(Collectors.toMap(PermissionUserTag::getPriority, a -> a, (k1, k2) -> k1));
    }

    private List<PermissionPolicy> getUserPolicy(long tenantSid, long targetSid, long sysSid, boolean admin, Map<Long, List<TargetCondition>> conditionValues) {
        PolicyPermission permission = this.getSysTree(tenantSid, sysSid);
        List<Long> actionSids = this.policyCalcService.getPolicyAction(tenantSid, "user", targetSid, sysSid);
        ArrayList<PermissionPolicy> permissionPolicies = new ArrayList<PermissionPolicy>();
        List<PolicyAction> actions = permission.getActions();
        for (PolicyAction action : actions) {
            if (!admin && !actionSids.contains(action.getSid())) continue;
            PermissionPolicy permissionPolicy = new PermissionPolicy();
            permissionPolicy.setSid(action.getSid());
            permissionPolicy.setId(action.getId());
            permissionPolicy.setName(action.getName());
            permissionPolicy.setTarget(action.getUri());
            permissionPolicy.setEffect("allow");
            permissionPolicy.setModuleId(action.getModuleId());
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Map<String, String>> conditions = new HashMap<String, Map<String, String>>();
            for (PolicyCondition condition : action.getCondition()) {
                String conditionValue = condition.getValue();
                if (conditionValues.containsKey(action.getSid())) {
                    List<TargetCondition> values = conditionValues.get(action.getSid());
                    for (TargetCondition value : values) {
                        if (!condition.getKey().equals(value.getKey()) || null == value.getValue()) continue;
                        conditionValue = value.getValue();
                        break;
                    }
                }
                map.put(condition.getKey(), conditionValue);
            }
            if (!map.isEmpty()) {
                conditions.put(action.getUri() == null ? "" : action.getUri(), map);
            }
            permissionPolicy.setConditions(conditions);
            permissionPolicies.add(permissionPolicy);
        }
        return permissionPolicies;
    }

    public PolicyPermission getSysTree(long tenantSid, long sysSid) {
        PolicySys app = this.dataPermissionMapper.findPolicySys(tenantSid, sysSid);
        List<PolicyModule> modules = this.dataPermissionMapper.findPolicyModule(app.getSid());
        List<PolicyAction> actions = this.dataPermissionMapper.findPolicyAction(tenantSid, app.getSid());
        List<PolicyCondition> conditions = this.dataPermissionMapper.findPolicyCondition(app.getSid());
        this.setConditionToAction(actions, conditions);
        return new PolicyPermission(app, modules, actions);
    }

    private void setConditionToAction(List<PolicyAction> actions, List<PolicyCondition> conditions) {
        conditions.forEach(o -> {
            try {
                o.setTypeParameter((List)objectMapper.readValue(o.getTypeParam(), (TypeReference)new TypeReference<List<String>>(){}));
            }
            catch (IOException e) {
                logger.warn("condition[sid=" + o.getSid() + "]Json\u5b57\u7b26\u4e32\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        });
        Map<Long, List<PolicyCondition>> map = conditions.stream().collect(Collectors.groupingBy(PolicyCondition::getActionSid));
        for (PolicyAction action : actions) {
            if (!map.containsKey(action.getSid())) continue;
            action.setCondition(map.get(action.getSid()));
        }
    }

    private List<PermissionDataPolicy> getUserDataPolicy(List<PermissionUserOrg> orgs, List<PermissionUserRole> roles, long tenantSid, long userSid) {
        ArrayList<DataPolicyTarget> targets = new ArrayList<DataPolicyTarget>();
        for (PermissionUserOrg userOrg : orgs) {
            DataPolicyTarget target = new DataPolicyTarget(userOrg.getSid(), true, "org", null);
            targets.add(target);
        }
        for (PermissionUserRole role : roles) {
            List<DataPolicyTarget> roleTargets = this.getRoleDataPolicyTarget(tenantSid, role.getSid());
            targets.addAll(roleTargets);
        }
        List<DataPolicyTarget> userTargets = this.getUserDataPolicyTarget(tenantSid, userSid);
        targets.addAll(userTargets);
        return this.calcUserDataPermission(tenantSid, targets);
    }

    public List<DataPolicyTarget> getRoleDataPolicyTarget(long tenantSid, long roleSid) {
        ArrayList<DataPolicyTarget> targets = new ArrayList<DataPolicyTarget>();
        List<DataPolicy> policies = this.dataPermissionMapper.findRoleDataPolicy(tenantSid, roleSid);
        for (DataPolicy dataPolicy : policies) {
            List<DataPolicyTarget> targetOrgs = this.dataPermissionMapper.findDataPolicyTarget(dataPolicy.getSid());
            targets.addAll(targetOrgs);
        }
        return targets;
    }

    public List<DataPolicyTarget> getUserDataPolicyTarget(long tenantSid, long userSid) {
        ArrayList<DataPolicyTarget> targets = new ArrayList<DataPolicyTarget>();
        List<DataPolicy> policies = this.dataPermissionMapper.findUserDataPolicy(tenantSid, userSid);
        for (DataPolicy dataPolicy : policies) {
            List<DataPolicyTarget> targetOrgs = this.dataPermissionMapper.findDataPolicyTarget(dataPolicy.getSid());
            targets.addAll(targetOrgs);
        }
        return targets;
    }

    private List<PermissionDataPolicy> calcUserDataPermission(long tenantSid, List<DataPolicyTarget> targets) {
        ArrayList<PermissionDataPolicy> dataPermissions = new ArrayList<PermissionDataPolicy>();
        List<TreeModel> orgs = this.permissionMapper.findOrgTreeModel(tenantSid);
        ArrayList<Long> allows = new ArrayList<Long>();
        ArrayList<Long> denys = new ArrayList<Long>();
        for (DataPolicyTarget target : targets) {
            if (target.isChecked()) {
                if ("orgCascade".equals(target.getEffect())) {
                    TreeUtil.getChildNodes(orgs, target.getSid(), allows);
                    continue;
                }
                allows.add(target.getSid());
                continue;
            }
            if ("orgCascade".equals(target.getEffect())) {
                TreeUtil.getChildNodes(orgs, target.getSid(), denys);
                continue;
            }
            denys.add(target.getSid());
        }
        List<Long> allow = allows.stream().distinct().collect(Collectors.toList());
        List deny = denys.stream().distinct().collect(Collectors.toList());
        allow.removeAll(deny);
        List<Org> orgAllows = this.orgRepository.findBySidIn(allow);
        for (Org org : orgAllows) {
            dataPermissions.add(new PermissionDataPolicy(org.getSid(), org.getId(), org.getName(), org.getUri()));
        }
        return dataPermissions;
    }

    public PermissionField getUserFieldPermission(long tenantSid, long userSid, String sysId) {
        PermissionField permissionField = null;
        Sys sys = this.sysMapper.findByTenantSidAndId(tenantSid, sysId);
        if (null == sys) {
            return null;
        }
        permissionField = new PermissionField();
        permissionField.setSid(sys.getSid());
        permissionField.setId(sys.getId());
        permissionField.setName(sys.getName());
        permissionField.setHasAll(false);
        List<QueryRoleResultVO> roles = this.userInRoleQueryService.queryUserInRoleByUser(tenantSid, userSid);
        if (roles.size() == 0) {
            return permissionField;
        }
        if (roles.stream().anyMatch(o -> "superadmin".equals(o.getId()))) {
            permissionField.setHasAll(true);
            return permissionField;
        }
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        for (QueryRoleResultVO role : roles) {
            List<FieldValue> fieldValues;
            DataPolicy dataPolicy = this.getDataPolicy(tenantSid, role.getId(), sysId);
            if (null == dataPolicy || (fieldValues = this.fieldValueCrudService.findByTargetSid(dataPolicy.getSid())).size() <= 0) continue;
            HashMap fieldValue = new HashMap();
            fieldValues.forEach(o -> {
                if (null == o.getType() || "".equals(o.getType()) || "multiple".equals(o.getType()) || "single".equals(o.getType())) {
                    fieldValue.put(o.getKey(), new HashSet<String>(Arrays.asList(o.getValue().split(","))));
                } else if ("int".equals(o.getType())) {
                    fieldValue.put(o.getKey(), Long.parseLong(o.getValue()));
                } else if ("boolean".equals(o.getType())) {
                    fieldValue.put(o.getKey(), "1".equals(o.getValue()));
                } else {
                    fieldValue.put(o.getKey(), o.getValue());
                }
            });
            fields.add(fieldValue);
        }
        if (fields.size() > 0) {
            permissionField.setFields(fields);
        }
        return permissionField;
    }

    public DataPolicy getDataPolicy(long tenantSid, String roleId, String sysId) {
        String policyId = "role_" + roleId + "_" + sysId;
        return (DataPolicy)this.dataPolicyCrudService.findByTenantSidAndId(tenantSid, policyId);
    }

    protected List<PermissionPolicy> filterModuleByCac(String tenantId, String appId, List<PermissionPolicy> permissions) {
        AuthorizationResultVO authorizationResultVO = this.cacService.queryAllAuthorization(tenantId, appId);
        if (authorizationResultVO != null) {
            ArrayList<PermissionPolicy> permissionPolicies = new ArrayList<PermissionPolicy>();
            List<AuthorizationModuleVO> authorizationModuleVOS = authorizationResultVO.getEnabledModules();
            block0: for (PermissionPolicy permissionPolicy : permissions) {
                if (authorizationModuleVOS == null || authorizationModuleVOS.size() <= 0) continue;
                for (AuthorizationModuleVO authorizationModuleVO : authorizationModuleVOS) {
                    if (authorizationModuleVO.getId() == null || !authorizationModuleVO.getId().equals(permissionPolicy.getModuleId()) || !LocalDateTime.now().isBefore(authorizationModuleVO.getExpiredTime())) continue;
                    permissionPolicies.add(permissionPolicy);
                    continue block0;
                }
            }
            if (authorizationModuleVOS.size() > 0) {
                return permissionPolicies;
            }
        }
        return permissions;
    }
}

