/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.obsolete.service.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInOrgResultVO;
import com.digiwin.dap.middleware.iam.domain.user.QueryUserInTagResultVO;
import com.digiwin.dap.middleware.iam.entity.OrgTag;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.entity.UserInTag;
import com.digiwin.dap.middleware.iam.mapper.UserInOrgMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTagMapper;
import com.digiwin.dap.middleware.iam.service.org.OrgQueryService;
import com.digiwin.dap.middleware.iam.service.org.OrgTagCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTagCrudService;
import com.digiwin.dap.middleware.iam.support.obsolete.service.UserV2Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UserV2ServiceImpl
implements UserV2Service {
    @Autowired
    private UserInTagCrudService userInTagCrudService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private OrgTagCrudService orgTagCrudService;
    @Autowired
    private UserInTagMapper userInTagMapper;
    @Autowired
    private UserInOrgMapper userInOrgMapper;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private OrgQueryService orgQueryService;

    @Override
    public void updateUserInOrgByUser(long tenantSid, long userSid, String updateMode, List<QueryUserInOrgResultVO> queryUserInOrgResultVOList) {
        ArrayList<Long> existOrgSids = new ArrayList<Long>();
        ArrayList<Long> newOrgSids = new ArrayList<Long>();
        List<QueryUserInOrgResultVO> userInOrgDBList = this.userInOrgMapper.queryUserInOrgByUser(tenantSid, userSid);
        HashMap<Long, QueryUserInOrgResultVO> userInOrgDBMap = new HashMap<Long, QueryUserInOrgResultVO>();
        for (QueryUserInOrgResultVO queryUserInOrgResultVO : userInOrgDBList) {
            existOrgSids.add(queryUserInOrgResultVO.getOrgSid());
            userInOrgDBMap.put(queryUserInOrgResultVO.getOrgSid(), queryUserInOrgResultVO);
        }
        int[] priorities = new int[queryUserInOrgResultVOList.size()];
        for (QueryUserInOrgResultVO orgVO : queryUserInOrgResultVOList) {
            Long orgSid = orgVO.getOrgSid() == 0L ? this.orgQueryService.getOrgSidByUri(tenantSid, orgVO.getOrgUri()) : Long.valueOf(orgVO.getOrgSid());
            orgVO.setOrgSid(orgSid);
            newOrgSids.add(orgSid);
            QueryRoleResultVO resultVO = new QueryRoleResultVO();
            if (Strings.isEmpty((CharSequence)orgVO.getRoleId()) && !"[empty]".equals(orgVO.getRoleId())) {
                resultVO = this.userInRoleQueryService.queryUserInRoleByUserAndRole(tenantSid, userSid, orgVO.getRoleId());
            } else {
                orgVO.setRoleId("[empty]");
                orgVO.setRoleName("[empty]");
            }
            if (!"all".equals(updateMode)) continue;
            if (orgVO.getPriority() < 0 || orgVO.getPriority() > queryUserInOrgResultVOList.size() || priorities[orgVO.getPriority()] == 1) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_PERMISSION_ERROR);
            }
            priorities[orgVO.getPriority()] = 1;
        }
        ArrayList arrayList = new ArrayList(newOrgSids);
        arrayList.retainAll(existOrgSids);
        ArrayList needInsert = new ArrayList(newOrgSids);
        needInsert.removeAll(existOrgSids);
        ArrayList needRemove = new ArrayList(existOrgSids);
        needRemove.removeAll(newOrgSids);
        if ("onlyAppend".equals(updateMode)) {
            int[] prioritys = new int[queryUserInOrgResultVOList.size() + needRemove.size()];
            for (QueryUserInOrgResultVO queryUserInOrgResultVO : queryUserInOrgResultVOList) {
                prioritys[queryUserInOrgResultVO.getPriority()] = 1;
            }
            for (Long tagSid : needRemove) {
                QueryUserInOrgResultVO queryUserInOrgResultVO = (QueryUserInOrgResultVO)userInOrgDBMap.get(tagSid);
                if (queryUserInOrgResultVO == null || prioritys[queryUserInOrgResultVO.getPriority()] != 1) continue;
                throw new BusinessException((ErrorHandler)I18nError.PRIORITY_ERROR);
            }
        }
        for (QueryUserInOrgResultVO current : queryUserInOrgResultVOList) {
            if (arrayList.contains(current.getOrgSid())) {
                QueryUserInOrgResultVO userInOrgDB = (QueryUserInOrgResultVO)userInOrgDBMap.get(current.getOrgSid());
                if (current.getRoleId().equals(userInOrgDB.getRoleId()) && current.getPriority() == userInOrgDB.getPriority()) continue;
                UserInOrg userInOrg = new UserInOrg();
                userInOrg.setSid(userInOrgDB.getSid());
                userInOrg.setOrgSid(current.getOrgSid());
                userInOrg.setRoleSid(current.getRoleSid());
                userInOrg.setUserSid(userSid);
                userInOrg.setPriority(current.getPriority());
                if (Strings.isEmpty((CharSequence)current.getHash())) {
                    userInOrg.setHash(userInOrgDB.getHash());
                } else {
                    userInOrg.setHash(current.getHash());
                }
                this.userInOrgCrudService.update(userInOrg);
            }
            if (!needInsert.contains(current.getOrgSid())) continue;
            UserInOrg userInOrg = new UserInOrg();
            userInOrg.setOrgSid(current.getOrgSid());
            userInOrg.setRoleSid(current.getRoleSid());
            userInOrg.setUserSid(userSid);
            userInOrg.setPriority(current.getPriority());
            this.userInOrgCrudService.create(userInOrg);
        }
        if (!"all".equals(updateMode)) {
            return;
        }
        for (Long orgSid : needRemove) {
            this.userInOrgCrudService.deleteByUnionKey(userSid, orgSid);
        }
    }

    @Override
    public void updateUserInTagByUser(long tenantSid, long userSid, List<QueryUserInTagResultVO> queryUserInTagResultVOList) {
        ArrayList<Long> existTagSids = new ArrayList<Long>();
        ArrayList<Long> newTagSids = new ArrayList<Long>();
        List<QueryUserInTagResultVO> userInTagDBList = this.userInTagMapper.queryUserInTagByUser(tenantSid, userSid);
        HashMap<Long, QueryUserInTagResultVO> userInTagVOMap = new HashMap<Long, QueryUserInTagResultVO>();
        for (QueryUserInTagResultVO queryUserInTagResultVO : userInTagDBList) {
            existTagSids.add(queryUserInTagResultVO.getTagSid());
            userInTagVOMap.put(queryUserInTagResultVO.getTagSid(), queryUserInTagResultVO);
        }
        int[] priorities = new int[queryUserInTagResultVOList.size()];
        for (QueryUserInTagResultVO current : queryUserInTagResultVOList) {
            OrgTag orgTag = this.orgTagCrudService.findByTenantSidAndCatalogIdAndTagId(tenantSid, current.getCatalogId(), current.getTagId());
            Assert.notNull((Object)((Object)orgTag), (String)String.format("\u627e\u4e0d\u5230\u6b64\u7ec4\u7ec7\u6807\u7b7e[%s]\uff01", current.getTagId()));
            newTagSids.add(orgTag.getSid());
            current.setTagSid(orgTag.getSid());
            QueryRoleResultVO resultVO = new QueryRoleResultVO();
            if (Strings.isEmpty((CharSequence)current.getRoleId()) && !"[empty]".equals(current.getRoleId())) {
                resultVO = this.userInRoleQueryService.queryUserInRoleByUserAndRole(tenantSid, userSid, current.getRoleId());
                Assert.notNull((Object)resultVO, (String)String.format("\u6ca1\u6709\u6b64\u89d2\u8272[%s]\u5173\u7cfb\uff01", current.getRoleId()));
            } else {
                current.setRoleName("[empty]");
                current.setRoleId("[empty]");
            }
            current.setRoleSid(resultVO.getSid());
            if (current.getPriority() < 0 || current.getPriority() > queryUserInTagResultVOList.size() || priorities[current.getPriority()] == 1) {
                throw new BusinessException((ErrorHandler)I18nError.ORG_PERMISSION_ERROR);
            }
            priorities[current.getPriority().intValue()] = 1;
        }
        ArrayList arrayList = new ArrayList(newTagSids);
        arrayList.retainAll(existTagSids);
        ArrayList needInsert = new ArrayList(newTagSids);
        needInsert.removeAll(existTagSids);
        for (QueryUserInTagResultVO current : queryUserInTagResultVOList) {
            UserInTag userInTag;
            QueryUserInTagResultVO userInTagDB = (QueryUserInTagResultVO)userInTagVOMap.get(current.getTagSid());
            if (arrayList.contains(current.getTagSid())) {
                if (current.getRoleId().equals(userInTagDB.getRoleId()) && current.getPriority().equals(userInTagDB.getPriority())) continue;
                userInTag = new UserInTag();
                userInTag.setSid(userInTagDB.getSid());
                userInTag.setUserSid(current.getUserSid());
                userInTag.setRoleSid(current.getRoleSid());
                userInTag.setPriority(current.getPriority().intValue());
                userInTag.setTagSid(current.getTagSid());
                if (Strings.isEmpty((CharSequence)current.getHash())) {
                    userInTag.setHash(userInTagDB.getHash());
                } else {
                    userInTag.setHash(current.getHash());
                }
                this.userInTagCrudService.update(userInTag);
            } else {
                userInTag = new UserInTag();
                userInTag.setUserSid(current.getUserSid());
                userInTag.setRoleSid(current.getRoleSid());
                userInTag.setTagSid(current.getTagSid());
                userInTag.setPriority(current.getPriority().intValue());
                this.userInTagCrudService.create(userInTag);
            }
            newTagSids.add(current.getTagSid());
        }
        ArrayList needRemove = new ArrayList(existTagSids);
        needRemove.removeAll(newTagSids);
        for (Long tagSid : needRemove) {
            this.userInTagCrudService.deleteByTagSidAndUserSid(tagSid, userSid);
        }
    }
}

