/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.authentication.service.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.RemoteException;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAccountInfo;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAuthParameter;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAuthResponse;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAuthResult;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EsignResponseVO;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonAccountInfo;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonalAuthParameter;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonalAuthResponse;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonalAuthResult;
import com.digiwin.dap.middleware.iam.support.remote.authentication.service.RemoteESignService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteESignServiceImpl
implements RemoteESignService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    private final String eSignAppIdKey = "X-Tsign-Open-App-Id";
    private final String eSignAppSecretKey = "X-Tsign-Open-App-Secret";
    private final String eSignTreatyUrL = "/opentreaty-service";
    private final String eSignRealNameUrL = "/openrealname-service";
    private Logger logger = LoggerFactory.getLogger(RemoteESignServiceImpl.class);

    @Override
    public String createPersonAccount(PersonAccountInfo personAccountInfo) {
        try {
            String accountId = null;
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)personAccountInfo, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/create/person/v2";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u521b\u5efa\u4e2a\u4eba\u8d26\u53f7\u8fd4\u56denull\uff01", personAccountInfo.getThirdId()));
            if (response.getErrCode() == 0) {
                accountId = response.getData().get("accountId");
            } else {
                this.logger.error(String.format("\u4f7f\u7528[%s]\u521b\u5efa\u4e2a\u4eba\u8d26\u53f7\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", personAccountInfo.getThirdId()) + response.getMsg());
            }
            return accountId;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public String createEnterpriseAccount(EnterpriseAccountInfo enterpriseAccountInfo) {
        try {
            String accountId = null;
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)enterpriseAccountInfo, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/create/organize/v2";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u521b\u5efa\u4f01\u4e1a\u8d26\u53f7\u8fd4\u56denull\uff01", enterpriseAccountInfo.getThirdId()));
            if (response.getErrCode() == 0) {
                accountId = response.getData().get("accountId");
            } else {
                this.logger.error(String.format("\u4f7f\u7528[%s]\u521b\u5efa\u4f01\u4e1a\u8d26\u53f7\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", enterpriseAccountInfo.getThirdId()) + response.getMsg());
            }
            return accountId;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void updatePersonAccount(PersonAccountInfo personAccountInfo) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)personAccountInfo, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/person/update";
            this.restTemplate.postForEntity(url, (Object)request, HashMap.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void updateEnterpriseAccount(EnterpriseAccountInfo enterpriseAccountInfo) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)enterpriseAccountInfo, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/organize/update";
            this.restTemplate.postForEntity(url, (Object)request, HashMap.class, new Object[0]);
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public Map<String, String> getPersonalAuthUrl(PersonalAuthParameter parameterVO) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)parameterVO, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/openrealname-service" + "/url/individual";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u8fd4\u56denull\uff01", parameterVO.getAccountId()));
            if (response.getErrCode() == 0) {
                return response.getData();
            }
            this.logger.error(String.format("\u4f7f\u7528[%s]\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", parameterVO.getAccountId()) + response.getMsg());
            return null;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public Map<String, String> getEnterpriseAuthUrl(EnterpriseAuthParameter parameterVO) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HttpEntity request = new HttpEntity((Object)parameterVO, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/openrealname-service" + "/url/org";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u8fd4\u56denull\uff01", parameterVO.getAgentAccountId()));
            if (response.getErrCode() == 0) {
                return response.getData();
            }
            this.logger.error(String.format("\u4f7f\u7528[%s]\u83b7\u53d6\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", parameterVO.getAgentAccountId()) + response.getMsg());
            return null;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public PersonalAuthResult getPersonalAuthenticationResult(String accountId, String serviceId) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HashMap<String, String> body = new HashMap<String, String>(2);
            body.put("accountId", accountId);
            if (!StringUtils.isEmpty((Object)serviceId)) {
                body.put("serviceId", serviceId);
            }
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/openrealname-service" + "/query/psn/result";
            PersonalAuthResponse response = (PersonalAuthResponse)this.restTemplate.postForObject(url, (Object)request, PersonalAuthResponse.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u67e5\u8be2\u4f01\u4e1a\u5b9e\u540d\u7ed3\u679c\u8fd4\u56denull\uff01", accountId));
            if (response.getErrCode() == 0) {
                return response.getData();
            }
            this.logger.error(String.format("\u4f7f\u7528[%s]\u67e5\u8be2\u4f01\u4e1a\u5b9e\u540d\u7ed3\u679c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", accountId) + response.getMessage());
            return null;
        }
        catch (RestClientResponseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public EnterpriseAuthResult getEnterpriseAuthenticationResult(String orgAccountId, String serviceId) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HashMap<String, String> body = new HashMap<String, String>(2);
            if (!StringUtils.isEmpty((Object)serviceId)) {
                body.put("serviceId", serviceId);
            }
            body.put("orgAccountId", orgAccountId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/openrealname-service" + "/query/org/result";
            EnterpriseAuthResponse response = (EnterpriseAuthResponse)this.restTemplate.postForObject(url, (Object)request, EnterpriseAuthResponse.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u67e5\u8be2\u4f01\u4e1a\u5b9e\u540d\u7ed3\u679c\u8fd4\u56denull\uff01", orgAccountId));
            if (response.getErrCode() == 0) {
                return response.getData();
            }
            this.logger.error(String.format("\u4f7f\u7528[%s]\u67e5\u8be2\u4f01\u4e1a\u5b9e\u540d\u7ed3\u679c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", orgAccountId) + response.getMsg());
            return null;
        }
        catch (RestClientResponseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getAccountId(String thirdId) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("thirdId", thirdId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/idexchange";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u4f7f\u7528[%s]\u67e5\u8be2e\u7b7e\u5b9d\u8d26\u6237Id\u8fd4\u56denull\uff01", thirdId));
            if (response.getErrCode() == 0) {
                return response.getData().get("accountId");
            }
            this.logger.info(String.format("\u4f7f\u7528[%s]\u67e5\u8be2e\u7b7e\u5b9d\u8d26\u6237Id\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", thirdId) + response.getMsg());
            return null;
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    @Override
    public void deleteAccount(String accountId) {
        try {
            HttpHeaders headers = this.getESignHeaders();
            HashMap<String, String> body = new HashMap<String, String>(2);
            body.put("accountId", accountId);
            HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
            String url = this.envProperties.getEsignUri() + "/opentreaty-service" + "/account/delete";
            EsignResponseVO response = (EsignResponseVO)this.restTemplate.postForObject(url, (Object)request, EsignResponseVO.class, new Object[0]);
            Assert.notNull((Object)response, (String)String.format("\u5220\u9664e\u7b7e\u5b9d\u8d26\u6237[%s]\u8fd4\u56denull\uff01", accountId));
            if (response.getErrCode() != 0) {
                throw new BusinessException((ErrorHandler)I18nError.DELETE_E_ACCOUNT_ERROR, new Object[]{accountId + response.getMsg()});
            }
        }
        catch (RestClientResponseException e) {
            throw RemoteException.create(e);
        }
    }

    private HttpHeaders getESignHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("X-Tsign-Open-App-Id", this.envProperties.getEsignAppId());
        headers.add("X-Tsign-Open-App-Secret", this.envProperties.getEsignAppSecret());
        return headers;
    }
}

