/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.domain;

import com.digiwin.dap.middleware.iam.domain.auth.AuthDataDO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsStrategy;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class GoodsAuthDO {
    private String appId;
    private String goodsAliasId;
    private Integer userNumber;
    private LocalDateTime effectiveDateTime;
    private LocalDateTime expiredDateTime;
    private String strategyCode;
    private String tenantId;
    private String tenantName;
    private String potentialCustomerId;
    private String customerServiceCode;
    private List<String> userIds;
    private Long tenantSid;
    private List<String> userNames;
    private Boolean updateTenantAuth = true;
    private Integer action = 0;
    private String sourceId;
    private String sourceCode;
    private String memo;
    private List<AuthorizationModuleVO> modules;
    private String userId;
    private List<Long> userSids;
    private GoodsStrategy strategyDetail;

    public GoodsAuthDO() {
    }

    public GoodsAuthDO(Tenant tenant, AuthorizationVO authorizationVO) {
        this(tenant);
        this.appId = authorizationVO.getCode();
        this.strategyCode = authorizationVO.getLastStrategyId();
        this.effectiveDateTime = authorizationVO.getEffectiveTime();
        this.expiredDateTime = authorizationVO.getExpiredTime();
        this.userNumber = 0 >= authorizationVO.getTotalUserCount() ? authorizationVO.getTotalUsage() : authorizationVO.getTotalUserCount();
    }

    public GoodsAuthDO(Tenant tenant) {
        this.tenantId = tenant.getId();
        this.tenantName = tenant.getName();
        this.tenantSid = tenant.getSid();
        this.potentialCustomerId = tenant.getPotentialCustomerId();
        this.customerServiceCode = tenant.getCustomerId();
    }

    public GoodsAuthDO(AuthDataDO authDataDO, Tenant tenant, List<String> userIds) {
        this(tenant);
        BeanUtils.copyProperties((Object)authDataDO, (Object)this);
        this.userIds = userIds;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Integer getUserNumber() {
        return this.userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public LocalDateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public String getStrategyCode() {
        return this.strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public List<String> getUserNames() {
        return this.userNames;
    }

    public void setUserNames(List<String> userNames) {
        this.userNames = userNames;
    }

    public String getGoodsAliasId() {
        return this.goodsAliasId;
    }

    public void setGoodsAliasId(String goodsAliasId) {
        this.goodsAliasId = goodsAliasId;
    }

    public Boolean getUpdateTenantAuth() {
        return this.updateTenantAuth;
    }

    public void setUpdateTenantAuth(Boolean updateTenantAuth) {
        this.updateTenantAuth = updateTenantAuth;
    }

    public String getPotentialCustomerId() {
        return this.potentialCustomerId;
    }

    public void setPotentialCustomerId(String potentialCustomerId) {
        this.potentialCustomerId = potentialCustomerId;
    }

    public String getCustomerServiceCode() {
        return this.customerServiceCode;
    }

    public void setCustomerServiceCode(String customerServiceCode) {
        this.customerServiceCode = customerServiceCode;
    }

    public Integer getAction() {
        return this.action;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<AuthorizationModuleVO> getModules() {
        return this.modules;
    }

    public void setModules(List<AuthorizationModuleVO> modules) {
        this.modules = modules;
    }

    public List<Long> getUserSids() {
        return this.userSids;
    }

    public void setUserSids(List<Long> userSids) {
        this.userSids = userSids;
    }

    public GoodsStrategy getStrategyDetail() {
        return this.strategyDetail;
    }

    public void setStrategyDetail(GoodsStrategy strategyDetail) {
        this.strategyDetail = strategyDetail;
    }
}

