/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.domain;

import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.domain.app.SysQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.GoodsCategoryEnum;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationModuleVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CountSettings;
import com.digiwin.dap.middleware.iam.support.remote.domain.DataPermissionFilterable;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.CustomAttributes;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsCategory;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.ResourceGoods;
import com.digiwin.dap.middleware.iam.support.serializer.StringUTCDateTimeSerializer;
import com.digiwin.dap.middleware.iam.support.serializer.UTCDateTimeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TenantApplication
implements DataPermissionFilterable {
    private List<CountSettings> CountSettings = new ArrayList<CountSettings>();
    private long sid;
    private String categoryId;
    private long tenantSid;
    private String tenantName;
    private String tenantId;
    private String id;
    private String idFirst;
    private String idSecond;
    private List<AuthorizationModuleVO> enabledModules = new ArrayList<AuthorizationModuleVO>();
    public String lastStrategyId;
    private String name;
    private String productId;
    private String itemId;
    private String strategyId;
    private String expiredTime;
    private boolean expired;
    private Boolean bufferPeriod;
    private boolean authOpen;
    private Boolean inside;
    private Integer paymentType;
    private Integer totalUsage;
    private Integer remainingUsage;
    private Integer totalUserCount;
    private Integer userCount;
    private String remainUsageCapacity;
    private String hash;
    private String createBy;
    private String secretKey;
    private String backUri;
    private long dueDay;
    private String logoImage;
    private String description;
    private LocalDateTime effectiveTime;
    private String customUnit;
    private String moduleName;
    private String moduleExpiredTime;
    private Boolean moduleStatus;
    private String servicerId;
    private String servicerName;
    private String purchaseId;
    private Boolean maintainServiceStatus;
    private String goodsAliasId;
    private String goodsAliasName;
    private String cloudwebsite;
    private String cloudwebsiteHw;
    private String tenantComeFrom;
    private String tags;
    private Boolean disabled;
    private Boolean showEntry;
    private List<GoodsCategory> goodsCategoryList;
    private List<String> platformCodes;
    private String appToken;
    private Boolean showConsole;
    private boolean enableMultiRow;
    private List<CustomAttributes> customAttributes;
    private int monthlyUsage;
    private Boolean monthlyPlan;
    private Boolean showConsoleManagement = true;
    private String bundleCode;
    private String bundleName;
    private String productCode;
    private String productName;
    private Boolean showConsolePolicy = true;
    private List<ResourceGoods> resourceGoods = new ArrayList<ResourceGoods>();
    private List<ResourceGoods> mainGoods = new ArrayList<ResourceGoods>();
    private Long todayInvokeCount;
    private Long totalInvokeCount;
    private Long failInvokeCount;
    private String batchCode;
    private Integer alertThreshold;
    private boolean willExpire;
    private boolean willExhaust;
    private boolean exhausted;
    private Boolean linked;
    private String actionFilterUrl;
    private Boolean enableFunctionControl;
    private String eocEntrance;

    public TenantApplication() {
    }

    public TenantApplication(Tenant tenant, AuthorizationResultVO authorization) {
        this.id = authorization.getCode();
        this.CountSettings = authorization.getCountSettings();
        this.expiredTime = new SimpleDateFormat("yyyy-MM-dd").format(authorization.getExpiredTime());
        this.itemId = authorization.getItemId();
        this.name = authorization.getDisplayName();
        this.paymentType = authorization.getPaymentType();
        this.productId = authorization.getId();
        this.remainingUsage = authorization.getRemainingUsage();
        this.tenantName = tenant.getName();
        this.tenantSid = tenant.getSid();
        this.totalUsage = authorization.getTotalUsage();
        this.enabledModules = authorization.getEnabledModules();
        this.setEnabledModulesExpired(this.enabledModules);
        this.categoryId = authorization.getCategoryId();
        this.lastStrategyId = authorization.getLastStrategyId();
        this.effectiveTime = authorization.getEffectiveTime();
        this.expired = authorization.getExpiredTime().isBefore(LocalDateTime.now());
        this.authOpen = authorization.getEffectiveTime().isBefore(LocalDateTime.now());
        this.userCount = authorization.getUserCount();
        this.totalUserCount = authorization.getTotalUserCount();
        this.customUnit = authorization.getCustomUnit();
    }

    public TenantApplication(TenantApplication o) {
        this.name = o.getName();
        this.tenantName = o.getTenantName();
        this.expiredTime = o.getExpiredTime();
        this.expired = o.isExpired();
        this.paymentType = o.getPaymentType();
        this.customUnit = o.getCustomUnit();
        this.userCount = o.getUserCount();
        this.authOpen = o.isAuthOpen();
        this.totalUserCount = o.getTotalUserCount();
        this.remainingUsage = o.getRemainingUsage();
        this.totalUsage = o.getTotalUsage();
    }

    public TenantApplication(TenantApplication o, AuthorizationModuleVO module) {
        this.name = o.getName();
        this.tenantName = o.getTenantName();
        this.expiredTime = o.getExpiredTime();
        this.expired = o.isExpired();
        this.paymentType = o.getPaymentType();
        this.customUnit = o.getCustomUnit();
        this.userCount = o.getUserCount();
        this.authOpen = o.isAuthOpen();
        this.totalUserCount = o.getTotalUserCount();
        this.remainingUsage = o.getRemainingUsage();
        this.totalUsage = o.getTotalUsage();
        this.moduleName = module.getName();
        this.moduleExpiredTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(module.getExpiredTime());
        this.moduleStatus = module.isExpired();
    }

    public TenantApplication(Tenant tenant, AuthorizationResultVO authorization, Boolean inside) {
        this.id = authorization.getCode();
        this.CountSettings = authorization.getCountSettings();
        this.expiredTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(authorization.getExpiredTime());
        this.itemId = authorization.getItemId();
        this.name = authorization.getDisplayName();
        this.paymentType = authorization.getPaymentType();
        this.productId = authorization.getId();
        this.remainingUsage = authorization.getRemainingUsage();
        this.tenantName = tenant.getName();
        this.tenantId = tenant.getId();
        this.tenantSid = tenant.getSid();
        this.totalUsage = authorization.getTotalUsage();
        this.enabledModules = authorization.getEnabledModules();
        this.setEnabledModulesExpired(this.enabledModules);
        this.categoryId = authorization.getCategoryId();
        this.lastStrategyId = authorization.getLastStrategyId();
        this.effectiveTime = authorization.getEffectiveTime();
        this.expired = authorization.getExpiredTime().isBefore(LocalDateTime.now());
        this.bufferPeriod = authorization.getBufferPeriod();
        this.inside = inside;
        this.authOpen = authorization.getEffectiveTime().isBefore(LocalDateTime.now());
        this.userCount = authorization.getUserCount();
        this.totalUserCount = authorization.getTotalUserCount();
        this.dueDay = this.getDueDay();
        this.customUnit = authorization.getCustomUnit();
        this.purchaseId = authorization.getPurchaseId();
        this.goodsAliasId = authorization.getGoodsAliasId();
        this.goodsAliasName = authorization.getGoodsAliasName();
        this.goodsCategoryList = authorization.getGoodsCategoryList();
        this.logoImage = authorization.getLogoImage();
        this.description = authorization.getDescription();
        this.cloudwebsite = authorization.getCloudwebsite();
        this.cloudwebsiteHw = authorization.getCloudwebsiteHw();
        this.tenantComeFrom = tenant.getComeFrom();
        this.platformCodes = authorization.getPlatformCodes();
        this.showConsole = authorization.getShowConsole();
        this.customAttributes = authorization.getCustomAttributes();
        this.monthlyPlan = authorization.getMonthlyPlan();
        this.monthlyUsage = authorization.getMonthlyUsage();
        this.bundleCode = authorization.getBundleCode();
        this.bundleName = authorization.getBundleName();
        this.resourceGoods = authorization.getResourceGoods();
        this.mainGoods = authorization.getMainGoods();
        this.todayInvokeCount = authorization.getTodayInvokeCount();
        this.totalInvokeCount = authorization.getTotalInvokeCount();
        this.failInvokeCount = authorization.getFailInvokeCount();
        this.batchCode = authorization.getBatchCode();
        this.remainUsageCapacity = authorization.getRemainUsageCapacity();
        this.alertThreshold = authorization.getAlertThreshold();
    }

    public TenantApplication(Tenant tenant, SysQueryResultVO sysQueryResultVO) {
        this(tenant, sysQueryResultVO, (Boolean)true);
    }

    public TenantApplication(Tenant tenant, SysQueryResultVO sysQueryResultVO, Boolean inside) {
        this.sid = sysQueryResultVO.getSid();
        this.id = sysQueryResultVO.getId();
        this.name = sysQueryResultVO.getName();
        this.tenantId = tenant.getId();
        this.tenantSid = tenant.getSid();
        this.tenantName = tenant.getName();
        this.inside = inside;
        this.totalUsage = -1;
        this.paymentType = 1;
        this.authOpen = true;
        this.expiredTime = "9999-12-31 23:59:59";
        this.effectiveTime = sysQueryResultVO.getCreateDate();
        this.categoryId = GoodsCategoryEnum.APP.id();
        this.enableMultiRow = sysQueryResultVO.isEnableMultiRow();
        this.appToken = sysQueryResultVO.getAppToken();
        this.showConsolePolicy = sysQueryResultVO.getShowConsolePolicy();
        this.showEntry = sysQueryResultVO.getShowEntry();
        this.linked = sysQueryResultVO.getLinked();
        this.actionFilterUrl = sysQueryResultVO.getActionFilterUrl();
    }

    @Override
    public boolean hasDataPermission(List<String> filter) {
        return filter.contains(this.id);
    }

    public void updateModuleLanguage(List<ModuleVO> modules) {
        modules.forEach(m -> this.enabledModules.add(new AuthorizationModuleVO(m.getId(), m.getName(), 0, 0, LocalDateTime.now())));
    }

    private void setEnabledModulesExpired(List<AuthorizationModuleVO> enabledModules) {
        for (AuthorizationModuleVO current : enabledModules) {
            current.setExpired(current.getExpiredTime().isBefore(LocalDateTime.now()));
        }
    }

    private static long fromDateStringToLong(String inVal) {
        Date date = null;
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            date = inputFormat.parse(inVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Objects.requireNonNull(date).getTime();
    }

    public boolean isEnableMultiRow() {
        return this.enableMultiRow;
    }

    public void setEnableMultiRow(boolean enableMultiRow) {
        this.enableMultiRow = enableMultiRow;
    }

    public String getCloudwebsite() {
        return this.cloudwebsite;
    }

    public void setCloudwebsite(String cloudwebsite) {
        this.cloudwebsite = cloudwebsite;
    }

    public String getCloudwebsiteHw() {
        return this.cloudwebsiteHw;
    }

    public void setCloudwebsiteHw(String cloudwebsiteHw) {
        this.cloudwebsiteHw = cloudwebsiteHw;
    }

    public String getTenantComeFrom() {
        return this.tenantComeFrom;
    }

    public void setTenantComeFrom(String tenantComeFrom) {
        this.tenantComeFrom = tenantComeFrom;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleExpiredTime() {
        return this.moduleExpiredTime;
    }

    public void setModuleExpiredTime(String moduleExpiredTime) {
        this.moduleExpiredTime = moduleExpiredTime;
    }

    public Boolean getModuleStatus() {
        return this.moduleStatus;
    }

    public void setModuleStatus(Boolean moduleStatus) {
        this.moduleStatus = moduleStatus;
    }

    @JsonSerialize(using=StringUTCDateTimeSerializer.class)
    public String getExpiredTimeUTC() {
        return this.expiredTime;
    }

    @JsonSerialize(using=UTCDateTimeSerializer.class)
    public LocalDateTime getEffectiveTimeUTC() {
        return this.effectiveTime;
    }

    public String getGoodsAliasId() {
        return this.goodsAliasId;
    }

    public void setGoodsAliasId(String goodsAliasId) {
        this.goodsAliasId = goodsAliasId;
    }

    public long getDueDay() {
        long startTime = TenantApplication.fromDateStringToLong(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()));
        long endTime = TenantApplication.fromDateStringToLong(this.getExpiredTime());
        return (endTime - startTime) / 86400000L;
    }

    public boolean isAuthOpen() {
        return this.authOpen;
    }

    public void setAuthOpen(boolean authOpen) {
        this.authOpen = authOpen;
    }

    public LocalDateTime getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(LocalDateTime effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public void setDueDay(long dueDay) {
        this.dueDay = dueDay;
    }

    public List<AuthorizationModuleVO> getEnabledModules() {
        return this.enabledModules;
    }

    public void setEnabledModules(List<AuthorizationModuleVO> enabledModules) {
        this.enabledModules = enabledModules;
    }

    public List<CountSettings> getCountSettings() {
        return this.CountSettings;
    }

    public String getLastStrategyId() {
        return this.lastStrategyId;
    }

    public void setLastStrategyId(String lastStrategyId) {
        this.lastStrategyId = lastStrategyId;
    }

    public void setCountSettings(List<CountSettings> countSettings) {
        this.CountSettings = countSettings;
    }

    public long getSid() {
        return this.sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getId() {
        return this.id;
    }

    public Integer getTotalUserCount() {
        return this.totalUserCount;
    }

    public void setTotalUserCount(Integer totalUserCount) {
        this.totalUserCount = totalUserCount;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getInside() {
        return this.inside;
    }

    public void setInside(Boolean inside) {
        this.inside = inside;
    }

    public String getIdFirst() {
        return this.idFirst;
    }

    public void setIdFirst(String idFirst) {
        this.idFirst = idFirst;
    }

    public String getIdSecond() {
        return this.idSecond;
    }

    public void setIdSecond(String idSecond) {
        this.idSecond = idSecond;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public void setStrategyId(String strategyId) {
        this.strategyId = strategyId;
    }

    public String getExpiredTime() {
        return this.expiredTime;
    }

    public void setExpiredTime(String expiredTime) {
        this.expiredTime = expiredTime;
    }

    public Integer getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getTotalUsage() {
        return this.totalUsage;
    }

    public void setTotalUsage(Integer totalUsage) {
        this.totalUsage = totalUsage;
    }

    public Integer getRemainingUsage() {
        return this.remainingUsage;
    }

    public void setRemainingUsage(Integer remainingUsage) {
        this.remainingUsage = remainingUsage;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public Boolean getBufferPeriod() {
        return this.bufferPeriod;
    }

    public void setBufferPeriod(Boolean bufferPeriod) {
        this.bufferPeriod = bufferPeriod;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getBackUri() {
        return this.backUri;
    }

    public void setBackUri(String backUri) {
        this.backUri = backUri;
    }

    public String getCustomUnit() {
        return this.customUnit;
    }

    public void setCustomUnit(String customUnit) {
        this.customUnit = customUnit;
    }

    public String getServicerId() {
        return this.servicerId;
    }

    public void setServicerId(String servicerId) {
        this.servicerId = servicerId;
    }

    public String getServicerName() {
        return this.servicerName;
    }

    public void setServicerName(String servicerName) {
        this.servicerName = servicerName;
    }

    public String getPurchaseId() {
        return this.purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public Boolean getMaintainServiceStatus() {
        return this.maintainServiceStatus;
    }

    public void setMaintainServiceStatus(Boolean maintainServiceStatus) {
        this.maintainServiceStatus = maintainServiceStatus;
    }

    public List<GoodsCategory> getGoodsCategoryList() {
        return this.goodsCategoryList;
    }

    public void setGoodsCategoryList(List<GoodsCategory> goodsCategoryList) {
        this.goodsCategoryList = goodsCategoryList;
    }

    public String getGoodsAliasName() {
        return this.goodsAliasName;
    }

    public void setGoodsAliasName(String goodsAliasName) {
        this.goodsAliasName = goodsAliasName;
    }

    public String getLogoImage() {
        return this.logoImage;
    }

    public void setLogoImage(String logoImage) {
        this.logoImage = logoImage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Boolean getShowEntry() {
        return this.showEntry;
    }

    public void setShowEntry(Boolean showEntry) {
        this.showEntry = showEntry;
    }

    public List<String> getPlatformCodes() {
        return this.platformCodes;
    }

    public void setPlatformCodes(List<String> platformCodes) {
        this.platformCodes = platformCodes;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public Boolean getShowConsole() {
        return this.showConsole;
    }

    public void setShowConsole(Boolean showConsole) {
        this.showConsole = showConsole;
    }

    public List<CustomAttributes> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttributes> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public int getMonthlyUsage() {
        return this.monthlyUsage;
    }

    public void setMonthlyUsage(int monthlyUsage) {
        this.monthlyUsage = monthlyUsage;
    }

    public Boolean getMonthlyPlan() {
        return this.monthlyPlan;
    }

    public void setMonthlyPlan(Boolean monthlyPlan) {
        this.monthlyPlan = monthlyPlan;
    }

    public Boolean getShowConsoleManagement() {
        return this.showConsoleManagement;
    }

    public void setShowConsoleManagement(Boolean showConsoleManagement) {
        this.showConsoleManagement = showConsoleManagement;
    }

    public String getBundleCode() {
        return this.bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Boolean getShowConsolePolicy() {
        return this.showConsolePolicy;
    }

    public void setShowConsolePolicy(Boolean showConsolePolicy) {
        this.showConsolePolicy = showConsolePolicy;
    }

    public List<ResourceGoods> getResourceGoods() {
        return this.resourceGoods;
    }

    public void setResourceGoods(List<ResourceGoods> resourceGoods) {
        this.resourceGoods = resourceGoods;
    }

    public List<ResourceGoods> getMainGoods() {
        return this.mainGoods;
    }

    public void setMainGoods(List<ResourceGoods> mainGoods) {
        this.mainGoods = mainGoods;
    }

    public Long getTodayInvokeCount() {
        return this.todayInvokeCount;
    }

    public void setTodayInvokeCount(Long todayInvokeCount) {
        this.todayInvokeCount = todayInvokeCount;
    }

    public Long getTotalInvokeCount() {
        return this.totalInvokeCount;
    }

    public void setTotalInvokeCount(Long totalInvokeCount) {
        this.totalInvokeCount = totalInvokeCount;
    }

    public Long getFailInvokeCount() {
        return this.failInvokeCount;
    }

    public void setFailInvokeCount(Long failInvokeCount) {
        this.failInvokeCount = failInvokeCount;
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public void setBatchCode(String batchCode) {
        this.batchCode = batchCode;
    }

    public String getRemainUsageCapacity() {
        return this.remainUsageCapacity;
    }

    public void setRemainUsageCapacity(String remainUsageCapacity) {
        this.remainUsageCapacity = remainUsageCapacity;
    }

    public Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public boolean isWillExpire() {
        return this.willExpire;
    }

    public void setWillExpire(boolean willExpire) {
        this.willExpire = willExpire;
    }

    public boolean isWillExhaust() {
        return this.willExhaust;
    }

    public void setWillExhaust(boolean willExhaust) {
        this.willExhaust = willExhaust;
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public void setExhausted(boolean exhausted) {
        this.exhausted = exhausted;
    }

    public Boolean getLinked() {
        return this.linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }

    public String getActionFilterUrl() {
        return this.actionFilterUrl;
    }

    public void setActionFilterUrl(String actionFilterUrl) {
        this.actionFilterUrl = actionFilterUrl;
    }

    public Boolean getEnableFunctionControl() {
        return this.enableFunctionControl;
    }

    public void setEnableFunctionControl(Boolean enableFunctionControl) {
        this.enableFunctionControl = enableFunctionControl;
    }

    public String getEocEntrance() {
        return this.eocEntrance;
    }

    public void setEocEntrance(String eocEntrance) {
        this.eocEntrance = eocEntrance;
    }
}

