/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.commons.util.EncryptUtils;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.token.GrantTypeInfo;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AccessTokenGetServiceImpl
implements EaiAnalyzeService {
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private DevSysService devSysService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_USER_ACCESSTOKEN_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        Map<Object, Object> parameter = this.verify(eaiParameter);
        if (parameter == null) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        if (ObjectUtils.isEmpty((Object)parameter.get("eData"))) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        String tenantId = UserUtils.getTenantId();
        if (ObjectUtils.isEmpty((Object)parameter.get("token"))) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        IamAuthoredUser authoredUser = this.authoredUserService.getByUserToken(parameter.get("token").toString());
        if (null == authoredUser) {
            eaiResponseExecution.setCode("401");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        tenantId = authoredUser.getTenantId();
        if (ObjectUtils.isEmpty((Object)tenantId)) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        if (ObjectUtils.isEmpty((Object)UserUtils.getAppToken())) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42appToken\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        DevSysVO devSysVO = this.devSysService.findDevSysById(UserUtils.getSysId());
        if (null == devSysVO || ObjectUtils.isEmpty((Object)devSysVO.getAppSecret())) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u52a0\u7b7ekey\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        GrantTypeInfo paramObj = (GrantTypeInfo)EncryptUtils.decrypt((String)devSysVO.getAppSecret(), (String)parameter.get("eData").toString(), GrantTypeInfo.class);
        if (ObjectUtils.isEmpty((Object)paramObj.getAppId())) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u5e94\u7528\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        if (ObjectUtils.isEmpty((Object)paramObj.getVerifyUserId())) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u4e09\u65b9\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        try {
            paramObj.setTenantId(tenantId);
            paramObj.setTokenExpire(120L);
            IamAuthoredUser authoredUser2 = this.authoredUserService.getByGrantTypeInfo(paramObj);
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setParameter(Collections.singletonMap("accessToken", authoredUser2.getToken()));
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        catch (Exception e) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(e.getMessage());
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
    }
}

