/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AesKeyGetServiceImpl
implements EaiAnalyzeService {
    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_IDENTITY_AES_KEY_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        Map<Object, Object> parameter = this.verify(eaiParameter);
        if (null == parameter || !parameter.containsKey("clientEncryptPublicKey") || ObjectUtils.isEmpty((Object)parameter.get("clientEncryptPublicKey"))) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        try {
            String clientPublicKey = RSA.decrypt((String)parameter.get("clientEncryptPublicKey").toString(), (String)KeyConstant.BASE64_PRIVATE_KEY);
            String aesKey = PwdUtils.getAesKey((String)clientPublicKey);
            String encryptAesKey = RSA.encrypt((String)aesKey, (String)clientPublicKey);
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setParameter(Collections.singletonMap("encryptAesKey", encryptAesKey));
        }
        catch (Exception ex) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(String.format("\u83b7\u53d6AES\u52a0\u5bc6\u79d8\u94a5\u5931\u8d25", ex.getMessage()));
        }
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

