/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.token.UserTokenVo;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="analyzeForTokenService")
@Order(value=0)
public class EaiAnalyzeForTokenServiceImpl
implements EaiAnalyzeService {
    @Autowired
    private RamService ramService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private AuthoredUserService authoredUserService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_IDENTITY_TOKEN_ANALYZE.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        AuthResult authResult;
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        if (eaiParameter == null || eaiParameter.getStd_data() == null || eaiParameter.getStd_data().getParameter() == null || !eaiParameter.getStd_data().getParameter().containsKey("userToken") || StringUtils.isEmpty((Object)eaiParameter.getStd_data().getParameter().get("userToken"))) {
            eaiResponseExecution.setCode("401");
            eaiResponseExecution.setDescription("userToken\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        String userToken = (String)eaiParameter.getStd_data().getParameter().get("userToken");
        String appToken = request.getHeader("digi-middleware-auth-app");
        IamAuthoredUser authoredUser = this.authoredUserService.getByUserToken(userToken);
        String appId = "";
        if (!StringUtils.isEmpty((Object)appToken)) {
            AuthoredSys app = AuthoredSys.obtainApp((String)appToken);
            Sys sys = this.commonCacheService.getSysById(app.getId());
            AppAuthContextHolder.getContext().setAuthoredSys(sys == null ? app : Sys.loginSys(sys));
            appId = app.getId();
        }
        if ((authResult = this.ramService.processAuth(AuthResult.of(), authoredUser, UserUtils.getAuthoredSys())).getAuthType() == AuthType.AppNone) {
            eaiResponseExecution.setCode("21006");
            eaiResponseExecution.setDescription(String.format("\u79df\u6237[%s]\u5c1a\u672a\u8d2d\u4e70\u5e94\u7528[%s]", authoredUser.getTenantId(), appId));
        } else if (authResult.getAuthType() == AuthType.AppExpired) {
            eaiResponseExecution.setCode("21008");
            eaiResponseExecution.setDescription(String.format("\u79df\u6237[%s]\u8d2d\u4e70\u7684\u5e94\u7528[%s]\u6388\u6743\u5df2\u8fc7\u671f", authoredUser.getTenantId(), appId));
        } else if (authResult.getAuthType() == AuthType.AppNoneUser) {
            eaiResponseExecution.setCode("21007");
            eaiResponseExecution.setDescription(String.format("\u79df\u6237[%s]\u7528\u6237[%s]\u5c1a\u672a\u5f97\u5230\u5e94\u7528[%s]\u7684\u6388\u6743", authoredUser.getTenantId(), authoredUser.getUserId(), appId));
        } else {
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setParameter(new UserTokenVo(authoredUser));
        }
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

