/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessToken;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthAccessTokenRequest;
import com.digiwin.dap.middleware.iam.service.oauth.OauthService;
import com.digiwin.dap.middleware.iam.support.remote.eai.impl.EaiAnalyzeForTokenServiceImpl;
import com.digiwin.dap.middleware.util.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service(value="oauthAccessTokenGetService")
@Order(value=4)
public class EaiOauthAccessTokenGetServiceImpl
extends EaiAnalyzeForTokenServiceImpl {
    @Autowired
    private OauthService oauthService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_OAUTH_ACCESSTOKEN_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        if (eaiParameter == null || eaiParameter.getStd_data() == null || eaiParameter.getStd_data().getParameter() == null) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u6388\u6743\u7801\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        OauthAccessTokenRequest oauthAccessTokenRequest = (OauthAccessTokenRequest)JsonUtils.readValue((String)JsonUtils.writeValue(eaiParameter.getStd_data().getParameter()), OauthAccessTokenRequest.class);
        OauthAccessToken accessToken = this.oauthService.getAccessToken(oauthAccessTokenRequest);
        if (null == accessToken) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u83b7\u53d6accessToken\u5931\u8d25");
        } else {
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setParameter(accessToken);
        }
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

