/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiServiceRegisterService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class EaiServiceRegisterServiceImpl
implements EaiServiceRegisterService {
    private Logger logger = LoggerFactory.getLogger(EaiServiceRegisterServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void registerService(String uid, String prod, String ip, String id, List<String> serviceNames) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getEaiUri())) {
            String uri = String.format("%s/CROSS/RESTful/regSrv", this.envProperties.getEaiUri());
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-action", "reg");
            HashMap requestMap = new HashMap();
            HashMap<String, String> hostRequestMap = new HashMap<String, String>();
            hostRequestMap.put("uid", uid);
            hostRequestMap.put("ip", ip);
            hostRequestMap.put("id", id);
            hostRequestMap.put("prod", prod);
            requestMap.put("host", hostRequestMap);
            HashMap<String, List<String>> serviceNameMap = new HashMap<String, List<String>>();
            serviceNameMap.put("srvname", serviceNames);
            requestMap.put("service", serviceNameMap);
            HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            try {
                this.restTemplate.exchange(uri, HttpMethod.POST, requestEntity, Map.class, new Object[0]);
            }
            catch (Exception ex) {
                this.logger.error("\u6ce8\u518c\u5e94\u7528\u5931\u8d25", (Throwable)ex);
            }
        } else {
            this.logger.error("eai\u5730\u5740\u672a\u914d\u7f6e");
        }
    }
}

