/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.eai.impl.EaiAnalyzeForTokenServiceImpl;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="userEmpGetService")
@Order(value=1)
public class EaiUserEmpGetServiceImpl
extends EaiAnalyzeForTokenServiceImpl {
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_USER_EMP_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        if (eaiParameter == null || eaiParameter.getStd_data() == null || eaiParameter.getStd_data().getParameter() == null || !eaiParameter.getStd_data().getParameter().containsKey("userToken") || StringUtils.isEmpty((Object)eaiParameter.getStd_data().getParameter().get("userToken"))) {
            eaiResponseExecution.setCode("401");
            eaiResponseExecution.setDescription("userToken\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        String userToken = (String)eaiParameter.getStd_data().getParameter().get("userToken");
        EmpInfoVO empInfoVO = this.remoteEocService.getEmpByCurrent(userToken);
        if (empInfoVO == null) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u5458\u5de5\u4fe1\u606f\u4e0d\u5b58\u5728");
        } else {
            eaiResponseExecution.setCode("0");
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("empId", empInfoVO.getId());
            parameter.put("empName", empInfoVO.getName());
            eaiResponse.getStd_data().setParameter(parameter);
        }
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

