/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.user.UserSimpleVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.eai.impl.EaiAnalyzeForTokenServiceImpl;
import com.digiwin.dap.middleware.util.UserUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="userInfoGetService")
@Order(value=2)
public class EaiUserInfoGetServiceImpl
extends EaiAnalyzeForTokenServiceImpl {
    @Autowired
    private UserCrudService userCrudService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_USER_INFO_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        String userId = UserUtils.getUserId();
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        if (null == authoredUser || StringUtils.isEmpty((Object)userId)) {
            eaiResponseExecution.setCode("401");
            eaiResponseExecution.setDescription("user\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        User user = (User)this.userCrudService.findById(userId);
        if (null == user) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(String.format("user[%s]\u4e0d\u5b58\u5728", userId));
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        UserSimpleVO simpleVO = new UserSimpleVO(user);
        eaiResponseExecution.setCode("0");
        eaiResponse.getStd_data().setParameter(simpleVO);
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

