/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.usermapping.UserMappingService;
import com.digiwin.dap.middleware.iam.support.remote.eai.impl.EaiAnalyzeForTokenServiceImpl;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="userMappingGetService")
@Order(value=2)
public class EaiUserMappingGetServiceImpl
extends EaiAnalyzeForTokenServiceImpl {
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private UserMappingService userMappingService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_USER_MAPPING_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        Long tenantSid = UserUtils.getTenantSid();
        Long userSid = UserUtils.getUserSid();
        String appId = UserUtils.getSysId();
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        boolean queryEmp = false;
        if (eaiParameter != null && eaiParameter.getStd_data() != null && eaiParameter.getStd_data().getParameter() != null) {
            String userToken;
            if (eaiParameter.getStd_data().getParameter().containsKey("userToken") && (authoredUser = this.authoredUserService.getByUserToken(userToken = (String)eaiParameter.getStd_data().getParameter().get("userToken"))) != null) {
                tenantSid = authoredUser.getTenantSid();
                userSid = authoredUser.getSid();
            }
            tenantSid = null == eaiParameter.getStd_data().getParameter().get("tenantSid") ? tenantSid : (Long)eaiParameter.getStd_data().getParameter().get("tenantSid");
            userSid = null == eaiParameter.getStd_data().getParameter().get("userSid") ? userSid : (Long)eaiParameter.getStd_data().getParameter().get("userSid");
            appId = StringUtils.isEmpty((Object)eaiParameter.getStd_data().getParameter().get("appId")) ? UserUtils.getSysId() : (String)eaiParameter.getStd_data().getParameter().get("appId");
            queryEmp = Optional.ofNullable(eaiParameter.getStd_data().getParameter().get("queryEmpId")).map(a -> Boolean.valueOf(a.toString())).orElse(false);
        }
        if (null == authoredUser) {
            eaiResponseExecution.setCode("401");
            eaiResponseExecution.setDescription("\u7528\u6237token\u4fe1\u606f\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        List<UserMappingQueryResultVO> identityInfos = this.userMappingService.getMappedByUserAndApp(tenantSid, userSid, appId);
        if (queryEmp && !CollectionUtils.isEmpty(identityInfos)) {
            String userId = identityInfos.get(0).getUserId();
            this.userMappingService.populateEmp(tenantSid, userId, identityInfos);
        }
        if (identityInfos.isEmpty()) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(String.format("\u79df\u6237\u4e0b%s\u7528\u6237%s\u6ca1\u6709\u6620\u5c04\u5230\u5e94\u7528%s\u7684\u4efb\u4f55\u7528\u6237", authoredUser.getTenantId(), authoredUser.getUserId(), appId));
        } else {
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setParameter(identityInfos);
        }
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

