/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.repository.UserMappingRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class IamAppMappingUsersGetServiceImpl
implements EaiAnalyzeService {
    private static final Logger logger = LoggerFactory.getLogger(IamAppMappingUsersGetServiceImpl.class);
    @Autowired
    private UserMappingRepository userMappingRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_APP_MAPPING_USERS_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        eaiResponseExecution.setCode("0");
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        LinkedList retFinal = new LinkedList();
        eaiResponse.getStd_data().setParameter(retFinal);
        try {
            Object o;
            String appId = StringUtils.hasText((String)UserUtils.getAppToken()) ? UserUtils.getAuthoredSys().getId() : "";
            Map<Object, Object> parameter = this.verify(eaiParameter);
            if (parameter != null && (o = parameter.get("appId")) instanceof String) {
                appId = (String)o;
            }
            if (ObjectUtils.isEmpty((Object)appId)) {
                eaiResponseExecution.setCode("400");
                eaiResponseExecution.setDescription("\u5e94\u7528\u4ee3\u53f7\u4e3a\u7a7a");
                return eaiResponse;
            }
            Object user = request.getAttribute("digi-middleware-auth-user-data");
            if (!(user instanceof AuthoredUser)) {
                eaiResponseExecution.setCode("400");
                eaiResponseExecution.setDescription("\u7528\u6237\u4e0d\u5b58\u5728");
                return eaiResponse;
            }
            long tenant = ((AuthoredUser)user).getTenantSid();
            List<UserMapping> byTenantSidAndAppId = this.userMappingRepository.findByTenantSidAndAppId(tenant, appId);
            List<Long> collect = byTenantSidAndAppId.stream().map(UserMapping::getUserSid).collect(Collectors.toList());
            List<User> bySidIn = this.userRepository.findBySidIn(collect);
            Map<Long, User> collect1 = bySidIn.stream().collect(Collectors.toMap(BaseEntity::getSid, a -> a, (a, b) -> a));
            for (UserMapping userMapping : byTenantSidAndAppId) {
                HashMap<String, String> ret = new HashMap<String, String>();
                long userSid = userMapping.getUserSid();
                User userTmp = collect1.get(userSid);
                EmpInfoVO empByUserId = null;
                try {
                    empByUserId = this.remoteEocService.getEmpByUserId(userTmp.getId(), true);
                }
                catch (Exception e) {
                    logger.warn("eoc\u5f02\u5e38", (Throwable)e);
                }
                ret.put("verifyUserId", userMapping.getVerifyUserId());
                ret.put("userId", userTmp.getId());
                ret.put("userName", userTmp.getName());
                if (empByUserId != null) {
                    ret.put("empId", empByUserId.getId());
                    ret.put("empName", empByUserId.getName());
                }
                retFinal.add(ret);
            }
            return eaiResponse;
        }
        catch (Exception e) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(e.getMessage());
            return eaiResponse;
        }
    }
}

