/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.commons.util.EncryptUtils;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.usermapping.UserMappingQueryResultVO;
import com.digiwin.dap.middleware.iam.mapper.UserMappingMapper;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class IamAppMappingUsersV2GetServiceImpl
implements EaiAnalyzeService {
    private static final Logger logger = LoggerFactory.getLogger(IamAppMappingUsersV2GetServiceImpl.class);
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private UserMappingMapper userMappingMapper;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_APP_MAPPINGS_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        Map<Object, Object> parameter = this.verify(eaiParameter);
        if (null == parameter || ObjectUtils.isEmpty((Object)parameter.get("appId"))) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return eaiResponse;
        }
        if (ObjectUtils.isEmpty((Object)UserUtils.getTenantId())) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return eaiResponse;
        }
        DevSysVO devSysVO = this.devSysService.findDevSysById(UserUtils.getSysId());
        if (null == devSysVO || ObjectUtils.isEmpty((Object)devSysVO.getAppSecret())) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription("\u52a0\u7b7ekey\u4e3a\u7a7a");
            return eaiResponse;
        }
        try {
            List<UserMappingQueryResultVO> userMappingList = this.userMappingMapper.findByApp(UserUtils.getTenantSid(), parameter.get("appId").toString(), null);
            LinkedList retFinal = new LinkedList();
            for (UserMappingQueryResultVO userMapping : userMappingList) {
                HashMap<String, String> ret = new HashMap<String, String>();
                EmpInfoVO empByUserId = null;
                try {
                    empByUserId = this.remoteEocService.getEmpByUserId(userMapping.getUserId(), true);
                }
                catch (Exception e) {
                    logger.warn("eoc\u5f02\u5e38", (Throwable)e);
                }
                ret.put("verifyUserId", userMapping.getVerifyUserId());
                ret.put("userId", userMapping.getUserId());
                ret.put("userName", userMapping.getUserName());
                if (empByUserId != null) {
                    ret.put("empId", empByUserId.getId());
                    ret.put("empName", empByUserId.getName());
                }
                retFinal.add(ret);
            }
            String eData = EncryptUtils.encrypt((String)devSysVO.getAppSecret(), retFinal);
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            eaiResponse.getStd_data().setParameter(Collections.singletonMap("eData", eData));
            return eaiResponse;
        }
        catch (Exception e) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(e.getMessage());
            return eaiResponse;
        }
    }
}

