/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.service.login.LoginFailureHandlingService;
import com.digiwin.dap.middleware.iam.service.login.impl.SecretKeyIdentityServiceImpl;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.exception.IncorrectUsernameOrPasswordException;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.I18nUtils;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class TenantTokenGetServiceImpl
implements EaiAnalyzeService {
    @Autowired
    private SecretKeyIdentityServiceImpl secretKeyIdentityService;
    @Autowired
    private LoginFailureHandlingService loginFailureHandlingService;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_IDENTITY_TENANT_TOKEN_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        Map<Object, Object> parameter = this.verify(eaiParameter);
        if (null == parameter || ObjectUtils.isEmpty((Object)parameter.get("clientEncryptPublicKey")) || ObjectUtils.isEmpty((Object)parameter.get("secretKey"))) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setSecretKey(parameter.get("secretKey").toString());
        loginUser.setClientEncryptPublicKey(parameter.get("clientEncryptPublicKey").toString());
        loginUser.setIdentityType(IdentityType.secretKey);
        try {
            IamAuthoredUser authoredUser = this.secretKeyIdentityService.login(loginUser);
            eaiResponseExecution.setCode("0");
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            eaiResponse.getStd_data().setParameter(Collections.singletonMap("token", authoredUser.getToken()));
            return eaiResponse;
        }
        catch (IncorrectUsernameOrPasswordException e) {
            this.loginFailureHandlingService.frozen(loginUser.getUserId(), 0, e.getMessage());
        }
        catch (Exception e) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(e.getMessage());
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
        eaiResponseExecution.setCode("500");
        eaiResponseExecution.setDescription(I18nUtils.getMessage((String)I18nError.LOGIN_TYPE_NO_SUPPORT.getCode(), (Locale)Locale.CHINA));
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        return eaiResponse;
    }
}

