/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.eai.impl;

import com.digiwin.dap.middleware.iam.domain.eai.EaiRequest;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponse;
import com.digiwin.dap.middleware.iam.domain.eai.EaiResponseExecution;
import com.digiwin.dap.middleware.iam.domain.eai.EaiServiceRegisterEnum;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserMappingRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.eai.EaiAnalyzeService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UserMappingAccesstokenGetServiceImpl
implements EaiAnalyzeService {
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired
    private UserMappingRepository userMappingRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SysRepository sysRepository;

    @Override
    public boolean support(String serviceName) {
        return EaiServiceRegisterEnum.IAM_USER_MAPPING_ACCESSTOKEN_GET.getServiceName().equals(serviceName);
    }

    @Override
    public EaiResponse get(HttpServletRequest request, EaiRequest eaiParameter) {
        HashMap<String, String> ret = new HashMap<String, String>();
        EaiResponse eaiResponse = new EaiResponse();
        EaiResponseExecution eaiResponseExecution = new EaiResponseExecution();
        eaiResponseExecution.setCode("0");
        eaiResponse.getStd_data().setParameter(ret);
        eaiResponse.getStd_data().setExecution(eaiResponseExecution);
        Map<Object, Object> parameter = this.verify(eaiParameter);
        if (parameter == null) {
            eaiResponseExecution.setCode("400");
            return eaiResponse;
        }
        Object o = parameter.get("verifyUserId");
        if (!(o instanceof String)) {
            eaiResponseExecution.setCode("400");
            return eaiResponse;
        }
        Long tenantSid = UserUtils.getTenantSid();
        if (ObjectUtils.isEmpty((Object)tenantSid) || 0L == tenantSid) {
            eaiResponseExecution.setCode("400");
            eaiResponseExecution.setDescription("\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return eaiResponse;
        }
        String appId = parameter.containsKey("appId") ? (String)parameter.get("appId") : "";
        try {
            List<UserMapping> byVerifyUserId = this.userMappingRepository.findByVerifyUserId((String)o);
            if (CollectionUtils.isEmpty(byVerifyUserId)) {
                eaiResponseExecution.setCode("500");
                return eaiResponse;
            }
            UserMapping userMapping = ObjectUtils.isEmpty((Object)appId) ? (UserMapping)byVerifyUserId.stream().filter(v -> tenantSid.longValue() == v.getTenantSid()).findFirst().orElse(null) : (UserMapping)byVerifyUserId.stream().filter(v -> tenantSid.longValue() == v.getTenantSid() && appId.equalsIgnoreCase(v.getAppId())).findFirst().orElse(null);
            if (null == userMapping) {
                eaiResponseExecution.setCode("400");
                eaiResponseExecution.setDescription(String.format("\u79df\u6237%s\u4e0b\u672a\u627e\u5230\u5e94\u7528%s\u4e0b\u7528\u6237%s\u7684\u6620\u5c04\u5173\u7cfb", UserUtils.getTenantId()));
                return eaiResponse;
            }
            LoginUser loginUser = new LoginUser();
            Optional tenant = this.tenantRepository.findById(tenantSid);
            if (!tenant.isPresent()) {
                eaiResponseExecution.setCode("500");
                eaiResponseExecution.setDescription(String.format("\u79df\u6237%s\u4e0d\u5b58\u5728", UserUtils.getTenantId()));
                return eaiResponse;
            }
            loginUser.setTenant((Tenant)((Object)tenant.get()));
            Optional user = this.userRepository.findById(userMapping.getUserSid());
            if (!user.isPresent()) {
                eaiResponseExecution.setCode("500");
                eaiResponseExecution.setDescription(String.format("\u7528\u6237%s\u4e0d\u5b58\u5728", userMapping.getUserSid()));
                return eaiResponse;
            }
            loginUser.setUser((User)((Object)user.get()));
            Sys sys = (Sys)this.sysRepository.findById(userMapping.getAppId());
            boolean checkAuth = true;
            if (sys == null) {
                sys = new Sys();
                sys.setId(userMapping.getAppId());
                checkAuth = false;
            }
            loginUser.setApp(sys);
            loginUser.setIdentityType(IdentityType.grant);
            IamAuthoredUser iamAuthoredUser = this.authoredUserService.generate(loginUser, checkAuth, false, 120L);
            ret.put("accessToken", iamAuthoredUser.getToken());
            return eaiResponse;
        }
        catch (Exception e) {
            eaiResponseExecution.setCode("500");
            eaiResponseExecution.setDescription(e.getMessage());
            eaiResponse.getStd_data().setExecution(eaiResponseExecution);
            return eaiResponse;
        }
    }
}

