/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.CacRecordSourceEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.migration.MigrateAppVO;
import com.digiwin.dap.middleware.iam.domain.tenant.CopyAppAuthVO;
import com.digiwin.dap.middleware.iam.domain.user.TenantWithSysAuthInfo;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthAppResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthorizationVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CACTenantAuthVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.CacAuth;
import com.digiwin.dap.middleware.iam.support.remote.domain.SearchParamVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AppAuthUserVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.AuthedUserInfoVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.CountResultVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.cac.ProductTypeVO;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class CacServiceImpl
implements CacService {
    private static final Logger logger = LoggerFactory.getLogger(CacServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public List<AuthorizationResultVO> queryAllAuthorization(String tenantId) {
        return this.queryAllAuthorization(tenantId, false, null);
    }

    @Override
    public List<AuthorizationResultVO> queryAllAuthorization(String tenantId, boolean countApiInvoke) {
        return this.queryAllAuthorization(tenantId, countApiInvoke, null);
    }

    @Override
    public List<AuthorizationResultVO> queryAllAuthorization(String tenantId, boolean countApiInvoke, String cacUri) {
        String uri = StringUtils.hasText((String)cacUri) ? cacUri : this.envProperties.getCacUri();
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        try {
            ArrayList<AuthorizationResultVO> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (StringUtils.hasText((String)uri)) {
                String url = String.format("%s/api/cac/v4/authorizations/tenants/%s?countApiInvoke=%s", uri, tenantId, countApiInvoke);
                AuthorizationResultVO[] authorizationResultVOS = (AuthorizationResultVO[])this.dapRetryRestTemplate.getForObject(url, AuthorizationResultVO[].class, new Object[0]);
                if (authorizationResultVOS != null && authorizationResultVOS.length > 0) {
                    authorizationResultVOList = new ArrayList<AuthorizationResultVO>(Arrays.asList(authorizationResultVOS));
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    @Override
    public List<AuthorizationResultVO> getAuthorizations(String tenantId, String userId) {
        try {
            String url = String.format("%s/api/cac/v4/authorizations/%s/%s/%s", this.envProperties.getCacUri(), tenantId, userId, true);
            AuthorizationResultVO[] result = (AuthorizationResultVO[])this.dapRetryRestTemplate.getForObject(url, AuthorizationResultVO[].class, new Object[0]);
            if (null != result && result.length > 0) {
                return new ArrayList<AuthorizationResultVO>(Arrays.asList(result));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<AuthorizationResultVO>();
    }

    @Override
    public List<AuthorizationResultVO> queryAuthorization(String tenantId, String userToken, Boolean countApiInvoke, Integer pageSize, Integer pageNum) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        try {
            ArrayList<AuthorizationResultVO> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("digi-middleware-auth-user", userToken);
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                SearchParamVO searchParamVO = new SearchParamVO();
                searchParamVO.setCustomerId(tenantId);
                searchParamVO.setCountApiInvoke(countApiInvoke);
                String json = objectMapper.writeValueAsString((Object)searchParamVO);
                String url = String.format("%s/api/cac/v4/authorizations/category/app?pageNum=%s&pageSize=%s&params={json}", this.envProperties.getCacUri(), pageNum, pageSize);
                ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[]{json});
                if (responseEntity.getBody() != null) {
                    String object = objectMapper.writeValueAsString(((Map)Objects.requireNonNull(responseEntity.getBody())).get("list"));
                    List authorizationResultVOS = (List)objectMapper.readValue(object, (TypeReference)new TypeReference<List<AuthorizationResultVO>>(){});
                    authorizationResultVOList.addAll(authorizationResultVOS);
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    @Override
    public List<String> queryGoodsCodeByCurrentAndUserId(String userId, String userToken) {
        try {
            List<String> goodsCodeList = new ArrayList<String>();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("digi-middleware-auth-user", userToken);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/currentTenant/users/" + userId + "/enabled";
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, List.class, new Object[0]);
            if (responseEntity.getBody() != null) {
                if (responseEntity.getStatusCode() != HttpStatus.OK) {
                    logger.error(String.format("\u53d6\u5f97\u79df\u6236\u5167\u7684\u7528\u6236\u53ef\u4f7f\u7528\u7684\u670d\u52d9\u6e05\u55ae\u5931\u8d25", new Object[0]));
                } else if (null != responseEntity.getBody()) {
                    goodsCodeList = (List)responseEntity.getBody();
                }
            }
            return goodsCodeList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public List<AuthorizationResultVO> queryAuthorizationExcludePolicy(String tenantId, String userToken, Integer pageSize, Integer pageNum) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        try {
            ArrayList<AuthorizationResultVO> authorizationResultVOList = new ArrayList<AuthorizationResultVO>();
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                headers.add("digi-middleware-auth-user", userToken);
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                SearchParamVO searchParamVO = new SearchParamVO();
                searchParamVO.setCustomerId(tenantId);
                String json = objectMapper.writeValueAsString((Object)searchParamVO);
                String url = String.format("%s/api/cac/v4/authorizations/category/app/exclude/policy?pageNum=%s&pageSize=%s&params={json}", this.envProperties.getCacUri(), pageNum, pageSize);
                ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[]{json});
                if (responseEntity.getBody() != null) {
                    String object = objectMapper.writeValueAsString(((Map)Objects.requireNonNull(responseEntity.getBody())).get("list"));
                    List authorizationResultVOS = (List)objectMapper.readValue(object, (TypeReference)new TypeReference<List<AuthorizationResultVO>>(){});
                    authorizationResultVOList.addAll(authorizationResultVOS);
                }
            } else {
                logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            }
            return authorizationResultVOList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<AuthorizationResultVO>();
        }
    }

    @Override
    public AuthorizationResultVO queryAllAuthorization(String tenantId, String appId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + appId;
                return (AuthorizationResultVO)this.dapRetryRestTemplate.getForObject(url, AuthorizationResultVO.class, new Object[0]);
            }
            logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean isAuthApp(String tenantId, String userId, String appId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        Assert.hasText((String)userId, (String)"userId is null");
        Assert.hasText((String)appId, (String)"appId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/" + tenantId + "/users/" + userId + "/goods/" + appId + "/isAuthorization";
                Map result = (Map)this.dapRetryRestTemplate.getForObject(url, Map.class, new Object[0]);
                String successKey = "isSuccess";
                if (result != null && result.containsKey("isSuccess")) {
                    return (Boolean)result.get("isSuccess");
                }
                return false;
            }
            logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public AuthAppResultVO getAuthAppResult(String tenantId, String userId, String appId) {
        String uri = String.format("%s/api/cac/v4/authorizations/tenants/%s/users/%s/goods/%s", this.envProperties.getCacUri(), tenantId, userId, appId);
        try {
            return (AuthAppResultVO)((Object)this.dapRetryRestTemplate.getForObject(uri, AuthAppResultVO.class, new Object[0]));
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u83b7\u53d6\u7528\u6237\u5e94\u7528\u6388\u6743", (String)uri, null, (Exception)e));
            return null;
        }
    }

    @Override
    public AuthAppResultVO getAuthPlatformAppResult(String tenantId, String userId, String appId, List<String> apps, List<String> platformAppsIds, List<String> tenants, Boolean checkUserAuth) {
        String url = String.format("%s/api/cac/v4/authorizations/tenant/user/goods/check", this.envProperties.getCacUri());
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            body.put("tenantId", tenantId);
            body.put("userId", userId);
            body.put("goodsCode", appId);
            body.put("tenants", tenants);
            body.put("checkUserAuth", Boolean.toString(checkUserAuth));
            body.put("apps", apps);
            body.put("platformApps", platformAppsIds);
            HttpEntity httpEntity = new HttpEntity(body);
            return (AuthAppResultVO)((Object)this.dapRetryRestTemplate.postForObject(url, (Object)httpEntity, AuthAppResultVO.class, new Object[0]));
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"\u83b7\u53d6\u7528\u6237\u5e94\u7528\u6388\u6743", (String)url, body, (Exception)e), (Throwable)e);
            return null;
        }
    }

    @Override
    public Boolean deleteUser(String tenantId, String userId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        Assert.hasText((String)userId, (String)"userId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                logger.info("\u5220\u9664\u79df\u6237[{}]\u4e0b\u7528\u6237[{}]\u7684\u6388\u6743", (Object)tenantId, (Object)userId);
                String url = String.format("%s/api/cac/v4/counting/user/remove/%s/%s", this.envProperties.getCacUri(), tenantId, userId);
                this.restTemplate.postForObject(url, null, Map.class, new Object[0]);
                return true;
            }
            logger.info("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean batchDeleteUserAuthorization(String userId) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                HashMap<String, String> httpEntityData = new HashMap<String, String>();
                httpEntityData.put("userId", userId);
                HttpEntity httpEntity = new HttpEntity(httpEntityData);
                logger.info("\u6279\u91cf\u5220\u9664\u7528\u6237[{}]\u7684\u6240\u6709\u6388\u6743", (Object)userId);
                String url = String.format("%s/api/cac/v4/counting/user/remove/all", this.envProperties.getCacUri());
                this.restTemplate.postForObject(url, (Object)httpEntity, Map.class, new Object[0]);
                return true;
            }
            logger.error("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public List<String> getAuthorizedUserIds(String tenantId, String appId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        Assert.hasText((String)appId, (String)"appId is null");
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                String url = this.envProperties.getCacUri() + String.format("/api/cac/v4/counting/%s/%s", tenantId, appId);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Content-Type", "application/json");
                return (List)this.dapRetryRestTemplate.getForObject(url, ArrayList.class, (Map)headers);
            }
            logger.error("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
            return new ArrayList<String>();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public Map addUserAuthorization(String uri, String tenantId, String appId, String userId) {
        return this.addUserAuthCore(uri, tenantId, appId, userId);
    }

    @Override
    public void addAuthorization(String uri, String tenantId, String appId, String userId) {
        Map result = this.addUserAuthCore(uri, tenantId, appId, userId);
        if (result == null || !((Boolean)result.get("isSuccess")).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.USER_AUTHORIZATION_SYS_FAILED, new Object[]{userId, appId});
        }
    }

    private Map addUserAuthCore(String uri, String tenantId, String appId, String userId) {
        Assert.hasText((String)tenantId, (String)"tenantId is null");
        Assert.hasText((String)appId, (String)"appId is null");
        Assert.hasText((String)appId, (String)"userId is null");
        try {
            if (!StringUtils.isEmpty((Object)uri)) {
                logger.info("[{}]\u7ed9\u79df\u6237[{}]\u4e0b\u7528\u6237[{}]\u6dfb\u52a0\u5e94\u7528[{}]\u7684\u6388\u6743", new Object[]{LocalDateTime.now(), tenantId, userId, appId});
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("countingId", appId);
                map.put("tenantId", tenantId);
                map.put("userId", userId);
                HttpEntity requestBody = new HttpEntity(map);
                String url = uri + "/api/cac/v4/counting/user/add";
                ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)requestBody, Map.class, new Object[0]);
                return (Map)responseEntity.getBody();
            }
            logger.error("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public AuthorizationVO getModuleIds(String tenantId, String appId) {
        try {
            String uri = String.format("%s/api/cac/v4/authorizations/tenants/%s/goods/%s/modules", this.envProperties.getCacUri(), tenantId, appId);
            return (AuthorizationVO)this.dapRetryRestTemplate.getForObject(uri, AuthorizationVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u5e94\u7528\u6388\u6743", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAuthModuleIds(String tenantId, String appId) {
        try {
            String uri = String.format("%s/api/cac/v4/authorizations/tenants/%s/goods/%s/modules/ids", this.envProperties.getCacUri(), tenantId, appId);
            return (List)this.dapRetryRestTemplate.getForObject(uri, List.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u5e94\u7528\u6388\u6743", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void batchUpdateAuthorization(String tenantId, String userId, List<String> addAppIds, List<String> deleteAppIds) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantId", tenantId);
            map.put("userId", userId);
            map.put("addAppIds", addAppIds);
            map.put("deleteAppIds", deleteAppIds);
            HttpEntity requestBody = new HttpEntity(map);
            logger.info("\u7ed9\u6307\u5b9a\u79df\u6237\u4e0b\u7684\u7528\u6237\u6279\u91cf\u66f4\u65b0\u5e94\u7528\u6388\u6743 {}", map);
            String url = this.envProperties.getCacUri() + "/api/cac/v4/counting/user/batch/update";
            StdData responseEntity = (StdData)this.restTemplate.postForObject(url, (Object)requestBody, StdData.class, new Object[0]);
            if (responseEntity != null && 200 != responseEntity.getCode()) {
                throw new BusinessException((ErrorHandler)I18nError.CAC_ADD_AUTHORIZATION_ERROR, new Object[]{responseEntity.getMessage()});
            }
        } else {
            logger.error("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public AuthorizationVO getAuthorizationVoByTenantIdAndGoodCode(String tenantId, String appId) {
        return this.getAuthorizationVoByTenantIdAndGoodCode(tenantId, appId, this.envProperties.getCacUri());
    }

    @Override
    public AuthorizationVO getAuthorizationVoByTenantIdAndGoodCode(String tenantId, String appId, String cacUri) {
        String uri = cacUri + "/api/cac/v4/authorizations/tenants/" + tenantId + "/goods/" + appId;
        try {
            return (AuthorizationVO)this.dapRetryRestTemplate.getForObject(uri, AuthorizationVO.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)String.format("\u83b7\u53d6\u79df\u6236%s\u5e94\u7528%s\u6388\u6743\u5f02\u5e38", tenantId, appId), (String)uri, null, (Exception)e), (Throwable)e);
            return null;
        }
    }

    @Override
    public void deletePurchaseGoods(String tenantId, String goodsCode) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("tenantId", tenantId);
            body.put("goodsCode", goodsCode);
            HttpEntity requestBody = new HttpEntity(body, (MultiValueMap)headers);
            logger.info("\u5220\u9664\u79df\u6237[{}]\u7684\u5546\u54c1[{}]\u6388\u6743", (Object)tenantId, (Object)goodsCode);
            String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/remove/tenant/goods";
            this.restTemplate.postForObject(url, (Object)requestBody, StdData.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.DELETE_TENANT_GOODS_FAILED, new Object[]{tenantId, goodsCode});
        }
    }

    @Override
    public void deleteByTenant(String tenantId) {
        block4: {
            if (!StringUtils.isEmpty((Object)this.envProperties.getCacUri())) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
                HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
                logger.info("\u5220\u9664\u79df\u6237[{}]\u7684\u6240\u6709\u6388\u6743\u4fe1\u606f", (Object)tenantId);
                String url = String.format("%s/api/cac/v4/authorizations/tenants/%s", this.envProperties.getCacUri(), tenantId);
                try {
                    ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, Object.class, new Object[0]);
                    if (responseEntity != null && HttpStatus.OK != responseEntity.getStatusCode()) {
                        throw new BusinessException((ErrorHandler)I18nError.DELETE_TENANT_AUTHORIZATION_INFO_FAILED, new Object[]{tenantId});
                    }
                    break block4;
                }
                catch (Exception ex) {
                    throw new BusinessException((ErrorHandler)I18nError.DELETE_TENANT_AUTHORIZATION_INFO_FAILED, new Object[]{tenantId});
                }
            }
            logger.error("cac\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public void copyAppAuth(CopyAppAuthVO copyAppAuthVO) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/copyappauth";
        try {
            String json = objectMapper.writeValueAsString((Object)copyAppAuthVO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.COPY_TENANT_AUTHORIZATION);
        }
    }

    @Override
    public void copyTenantAuth(String sourceTenantId, String tenantId, String tenantName) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/copy/all";
        try {
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("sourceTenantId", sourceTenantId);
            requestBody.put("tenantId", tenantId);
            requestBody.put("tenantName", tenantName);
            requestBody.put("sourceId", CacRecordSourceEnum.CopyTestTenant.getId());
            String json = objectMapper.writeValueAsString(requestBody);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.COPY_TENANT_AUTHORIZATION);
        }
    }

    @Override
    public List<TenantWithSysAuthInfo> checkUserInTenantAuth(String appId, String userId, List<String> tenantIds) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/app/tenant/user/auth/check";
        try {
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("appId", appId);
            requestBody.put("userId", userId);
            requestBody.put("tenantIds", tenantIds);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity result = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<TenantWithSysAuthInfo>>(){}, new Object[0]);
            if (HttpStatus.OK.equals((Object)result.getStatusCode())) {
                if (null == result.getBody()) {
                    return new ArrayList<TenantWithSysAuthInfo>();
                }
                return (List)result.getBody();
            }
            throw new BusinessException((ErrorHandler)I18nError.CHECK_AUTHORIZATION_FAILED);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.CHECK_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public List<AuthorizationVO> getTenantAuthsInDate(String beginTime, String endTime, String cacUri) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("beginTime", beginTime);
        requestMap.put("endTime", endTime);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = cacUri + "/api/cac/v4/authorizations/tenants/auth/date";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AuthorizationVO>>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.GET_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public void copyAuthFromSourceApp(CopyAppAuthVO copyAppAuthVO) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/copy/auth/source/app";
        try {
            String json = objectMapper.writeValueAsString((Object)copyAppAuthVO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, StdData.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                logger.error(String.format("\u6839\u636e\u6765\u6e90\u5e94\u7528%s\u521b\u5efa\u76ee\u6807\u5e94\u7528%s\u7684\u6388\u6743\u5931\u8d25", copyAppAuthVO.getSourceAppId(), copyAppAuthVO.getAppId()));
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.AUTHORIZATION_FAILED, new Object[]{copyAppAuthVO.getSourceAppId(), copyAppAuthVO.getAppId()});
        }
    }

    @Override
    public List<String> findAuthTenant(String appId) {
        List<CACTenantAuthVO> authByApp = this.findAuthByApp(appId);
        return authByApp.stream().map(CACTenantAuthVO::getTenantId).collect(Collectors.toList());
    }

    @Override
    public List<String> findAuthTenantIdValid(String appId, boolean excludeExpiredTenant, Long strategySid) {
        List<CACTenantAuthVO> authByApp = this.findAuthByApp(appId);
        return authByApp.stream().filter(a -> {
            boolean valid = true;
            if (excludeExpiredTenant) {
                valid = LocalDateTime.now().isBefore(a.getExpiredDateTime());
            }
            if (strategySid != null) {
                valid = valid && String.valueOf(strategySid).equals(a.getStrategySid());
            }
            return valid;
        }).map(CACTenantAuthVO::getTenantId).collect(Collectors.toList());
    }

    @NotNull
    private List<CACTenantAuthVO> findAuthByApp(String appId) {
        String uri = String.format("%s/api/cac/v4/authorizations/tenants/goods/%s?excludeName=true", this.envProperties.getCacUri(), appId);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(uri, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<CACTenantAuthVO>>(){}, new Object[0]);
            return (List)Objects.requireNonNull(responseEntity.getBody());
        }
        catch (Exception e) {
            logger.error("findAuthByApp failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<AuthorizationVO> findAuthByApps(List<String> appIds) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/apps";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("goodsCodes", appIds);
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity response = this.dapRetryRestTemplate.exchange(uri, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AuthorizationVO>>>(){}, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("findAuthByApp failed", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.GET_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public void updateUserInCounting(String tenantId, String appId, List<String> userIds) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/counting/user/update";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("countingId", appId);
        paramsMap.put("users", userIds);
        HttpEntity request = new HttpEntity(paramsMap, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Map.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                logger.error("\u66f4\u65b0\u79df\u6237[{}]\u5e94\u7528[{}]\u7528\u6236{}\u6388\u6743\u5931\u8d25", new Object[]{tenantId, appId, userIds});
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.UPDATE_TENANT_AUTHORIZATION_FAILED, new Object[]{tenantId, appId, userIds});
        }
    }

    @Override
    public void purchaseApp(CacAuth cacAuth) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/app/tenant/user/auth";
        try {
            String json = objectMapper.writeValueAsString((Object)cacAuth);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, String.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                logger.error(String.format("\u79df\u6237%s\u6388\u6743\u5e94\u7528%s\u5931\u8d25", cacAuth.getTenantId(), cacAuth.getAuthorizations().get(0).getCode()));
            }
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_AUTHORIZATION_SYS_FAILED, new Object[]{cacAuth.getTenantId(), cacAuth.getAuthorizations().get(0).getCode()});
        }
    }

    @Override
    public CountResultVO purchaseOrUpdateApp(CacAuth cacAuth) {
        String uri = this.envProperties.getCacUri() + "/api/cac/v3/authorizations";
        try {
            String json = objectMapper.writeValueAsString((Object)cacAuth);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)json, (MultiValueMap)headers);
            if (0 == cacAuth.getAction()) {
                ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    logger.error(String.format("\u79df\u6237%s\u6388\u6743\u5e94\u7528%s\u5931\u8d25", cacAuth.getTenantId(), cacAuth.getAuthorizations().get(0).getCode()));
                }
                return CountResultVO.noAuth();
            }
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, CountResultVO.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful() || null == response.getBody()) {
                logger.error(String.format("\u79df\u6237%s\u7ed9\u7528\u6237%s\u6388\u6743\u5e94\u7528%s\u5931\u8d25", cacAuth.getTenantId(), String.join((CharSequence)",", cacAuth.getUserIds()), cacAuth.getAuthorizations().get(0).getCode()));
            }
            return (CountResultVO)response.getBody();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_AUTHORIZATION_SYS_FAILED, new Object[]{cacAuth.getTenantId(), cacAuth.getAuthorizations().get(0).getCode()});
        }
    }

    @Override
    public List<CacAuth> getTenantsAndApps(List<String> tenantIds, List<String> appIds) {
        return this.getTenantsAndApps(tenantIds, appIds, null, this.envProperties.getCacUri(), UserUtils.getToken());
    }

    @Override
    public List<CacAuth> getTenantsAndApps(List<String> tenantIds, List<String> appIds, Boolean showDetail, String cacUrl, String userToken) {
        String url = cacUrl + "/api/cac/v4/authorizations/tenant/app/willexpired";
        if (tenantIds.isEmpty() || appIds.isEmpty()) {
            return new ArrayList<CacAuth>();
        }
        try {
            HashMap<String, List<String>> mapParams = new HashMap<String, List<String>>();
            mapParams.put("tenantIds", tenantIds);
            mapParams.put("appIds", appIds);
            Optional.ofNullable(showDetail).ifPresent(detail -> mapParams.put("showDetail", (List<String>)detail));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
            HttpEntity httpEntity = new HttpEntity(mapParams, (MultiValueMap)headers);
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData>(){}, new Object[0]);
            if (response != null && response.getBody() != null && ((StdData)response.getBody()).getSuccess().booleanValue()) {
                List cacAuths = (List)objectMapper.readValue(objectMapper.writeValueAsString(((StdData)response.getBody()).getData()), (TypeReference)new TypeReference<List<CacAuth>>(){});
                return cacAuths;
            }
            logger.error("\u83b7\u53d6\u79df\u6237[{}]\u5e94\u7528[{}]\u6388\u6743\u4fe1\u606f\u5931\u8d25", (Object)String.join((CharSequence)",", tenantIds), (Object)String.join((CharSequence)",", appIds));
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u79df\u6237[{}]\u5e94\u7528[{}]\u6388\u6743\u4fe1\u606f\u5931\u8d25", (Object)String.join((CharSequence)",", tenantIds), (Object)String.join((CharSequence)",", appIds));
        }
        return new ArrayList<CacAuth>();
    }

    @Override
    public List<CacAuth> getTenantsAndAppsAllowNull(List<String> tenantIds, List<String> appIds) {
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenant/app/willexpired";
        try {
            HashMap<String, List<String>> mapParams = new HashMap<String, List<String>>();
            if (!CollectionUtils.isEmpty(tenantIds)) {
                mapParams.put("tenantIds", tenantIds);
            }
            if (!CollectionUtils.isEmpty(appIds)) {
                mapParams.put("appIds", appIds);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity httpEntity = new HttpEntity(mapParams, (MultiValueMap)headers);
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<CacAuth>>>(){}, new Object[0]);
            return Optional.of(response).map(HttpEntity::getBody).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u79df\u6237[{}]\u5e94\u7528[{}]\u6388\u6743\u4fe1\u606f\u5931\u8d25", (Object)String.join((CharSequence)",", tenantIds), (Object)String.join((CharSequence)",", appIds));
            return new ArrayList<CacAuth>();
        }
    }

    @Override
    public List<AppAuthUserVO> getAppAuthUsers4Tenant(List<String> appIds, List<String> tenantIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, List<String>> requestMap = new HashMap<String, List<String>>();
        requestMap.put("appIds", appIds);
        requestMap.put("tenantIds", tenantIds);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/counting/app/authusers";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AppAuthUserVO>>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011\u83b7\u53d6\u83b7\u53d6\u79df\u6237\u5e94\u7528\u6388\u6743\u7528\u6237\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.USER_AUTHORIZATION_SYS_FAILED);
        }
    }

    @Override
    public List<String> queryUserHasAuth(String appId, String tenantId, List<String> userIds) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("appId", appId);
        requestMap.put("tenantId", tenantId);
        requestMap.put("users", userIds);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/counting/authed";
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<String>>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011\u83b7\u53d6\u83b7\u53d6\u79df\u6237\u5e94\u7528\u6388\u6743\u7528\u6237\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.GET_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public List<String> queryAuthUser(String tenantId, String appId) {
        return this.queryAuthUser(tenantId, appId, this.envProperties.getCacUri(), UserUtils.getToken());
    }

    @Override
    public List<String> queryAuthUser(String tenantId, String appId, String cacUri, String userToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = cacUri + String.format("/api/cac/v4/counting/%s/%s", tenantId, appId);
        try {
            ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[0]);
            return Optional.ofNullable(responseEntity.getBody()).orElseGet(Collections::emptyList);
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011\u83b7\u53d6\u83b7\u53d6\u79df\u6237\u5e94\u7528\u6388\u6743\u7528\u6237\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.GET_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public CountResultVO batchAddIncremental(String goodsCode, List<String> userIds) {
        return this.batchAddIncremental(goodsCode, userIds, null);
    }

    @Override
    public CountResultVO batchAddIncremental(String goodsCode, List<String> userIds, String tenantId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("goodsCode", goodsCode);
        requestMap.put("users", userIds);
        Optional.ofNullable(tenantId).ifPresent(id -> requestMap.put("tenantId", id));
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/counting/user/update/incremental";
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<CountResultVO>>(){}, new Object[0]);
            return (CountResultVO)((StdData)response.getBody()).getData();
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011batchAddIncremental\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.CAC_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public List<CountResultVO> batchAddIncrementalInBatches(String goodsCode, List<String> userIds) {
        int batchSize = 500;
        ArrayList<CountResultVO> result = new ArrayList<CountResultVO>();
        for (int i = 0; i < userIds.size(); i += batchSize) {
            int end = Math.min(i + batchSize, userIds.size());
            List<String> batch = userIds.subList(i, end);
            result.add(this.batchAddIncremental(goodsCode, batch));
        }
        return result;
    }

    @Override
    public CountResultVO batchDeleteIncremental(String goodsCode, List<String> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("goodsCode", goodsCode);
        requestMap.put("users", userIds);
        HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/counting/user/remove/batch";
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<CountResultVO>>(){}, new Object[0]);
            return (CountResultVO)((StdData)response.getBody()).getData();
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011batchAddIncremental\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.CAC_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public List<AuthedUserInfoVO> getAuthedUserInfo(String tenantId, String appId) {
        return this.getAuthedUserInfo(tenantId, appId, null, null);
    }

    @Override
    public List<AuthedUserInfoVO> getAuthedUserInfo(String tenantId, String appId, String start, String end) {
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.envProperties.getCacUri() + "/api/cac/v4/counting/info")).queryParam("tenantId", new Object[]{tenantId}).queryParam("appId", new Object[]{appId});
            if (start != null) {
                builder.queryParam("start", new Object[]{start});
            }
            if (end != null) {
                builder.queryParam("end", new Object[]{end});
            }
            URI uri = builder.build().toUri();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            RequestEntity request = RequestEntity.get((URI)uri).headers(headers).build();
            ResponseEntity response = this.dapRetryRestTemplate.exchange(request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AuthedUserInfoVO>>>(){});
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(new ArrayList());
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528IAM\u67e5\u8be2\u79df\u6237id\u5f02\u5e38", (Throwable)e);
            return new ArrayList<AuthedUserInfoVO>();
        }
    }

    @Override
    public void expireModules(MigrateAppVO body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/expire/modules";
        try {
            this.restTemplate.exchange(url, HttpMethod.POST, request, Object.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u3010CAC\u8c03\u7528\u3011expireModules\u5931\u8d25", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.CAC_AUTHORIZATION_FAILED);
        }
    }

    @Override
    public void updateGoodsAndModuleExpiredDateTime(ProductTypeVO body) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        String url = this.envProperties.getCacUri() + "/api/cac/v4/authorizations/tenants/goods/module/expire";
        try {
            this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.logError((String)"CAC\u66f4\u65b0\u5e94\u7528\u548c\u6a21\u7ec4\u7684\u8fc7\u671f\u65f6\u95f4\u4e3a\u5f53\u524d\u65f6\u95f4\u5931\u8d25", (String)url, (Object)request.getBody(), (Exception)e));
        }
    }
}

