/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.dmc.model.ShareRequest;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.DmcService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDMCBucketDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDMCUserDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ground.PurchaseRegisterDmcDirectoryDTO;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger logger = LoggerFactory.getLogger(DmcServiceImpl.class);
    @Autowired
    private DMC dmcClient;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public String getTempUrl(File file) throws Exception {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(file.getName());
        fileInfo.setExtension("xlsx");
        if (StrUtils.isEmpty((String)fileInfo.getTenantId())) {
            fileInfo.setTenantId(this.envProperties.getManagerTenant());
        }
        FileInfo upload = this.dmcClient.upload(file, fileInfo);
        return this.dmcClient.share(upload.getId(), 1, true).getUrl();
    }

    @Override
    public String getShareFileId(byte[] bytes, FileInfo fileInfo) throws Exception {
        if (StrUtils.isEmpty((String)fileInfo.getTenantId())) {
            fileInfo.setTenantId(this.envProperties.getManagerTenant());
        }
        return this.getShareFile(bytes, fileInfo).getUrl();
    }

    @Override
    public String getShareFileId(byte[] bytes, FileInfo fileInfo, int allowCount, LocalDateTime expireTime, boolean deleteFile) {
        try {
            if (StrUtils.isEmpty((String)fileInfo.getTenantId())) {
                fileInfo.setTenantId(this.envProperties.getManagerTenant());
            }
            FileInfo file = this.dmcClient.upload(bytes, fileInfo);
            ShareRequest request = new ShareRequest();
            request.setFileId(file.getId());
            request.setAllowCount(Integer.valueOf(allowCount));
            request.setExpireDate(expireTime);
            request.setDeleteFile(Boolean.valueOf(deleteFile));
            ShareInfo share = this.dmcClient.share(request);
            return share.getUrl();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    @Override
    public byte[] getFileByte(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    @Override
    public ShareInfo getShareFile(byte[] bytes, FileInfo fileInfo) throws Exception {
        if (StrUtils.isEmpty((String)fileInfo.getTenantId())) {
            fileInfo.setTenantId(this.envProperties.getManagerTenant());
        }
        FileInfo upload = this.dmcClient.upload(bytes, fileInfo);
        return this.dmcClient.share(upload.getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String upload(File file) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            int read = input.read(bytes);
            if (read <= 0) {
                logger.error("nothing to read");
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setExtension("xlsx");
            String string = this.getShareFileId(bytes, fileInfo);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.UPLOAD_FILE_FAILED);
        }
    }

    @Override
    public void createUser(PurchaseRegisterDMCUserDTO dto) {
        try {
            String uri = this.envProperties.getDmcUrl() + "/api/dmc/v2/users";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efadmc\u7528\u6237\u5f02\u5e38,{}", (Object)JsonUtils.writeValue((Object)dto), (Object)e);
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public void createBucket(PurchaseRegisterDMCBucketDTO dto) {
        try {
            String uri = this.envProperties.getDmcUrl() + "/api/dmc/v2/buckets";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efadmc\u7528\u6237\u5f02\u5e38,{}", (Object)JsonUtils.writeValue((Object)dto), (Object)e);
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public void createDirectory(String bucketName, PurchaseRegisterDmcDirectoryDTO dto) {
        try {
            String uri = this.envProperties.getDmcUrl() + "/api/dmc/v2/directory/{bucket}";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(uri, (Object)request, Object.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new BusinessException((ErrorHandler)I18nError.OMC_OPEN_AUTHORIZATION_FAILED);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efadmc\u7528\u6237\u5f02\u5e38,{}", (Object)JsonUtils.writeValue((Object)dto), (Object)e);
            throw new BusinessException(e.getMessage());
        }
    }
}

