/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.support.remote.FiiService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FiiServiceImpl
implements FiiService {
    private static final Logger log = LoggerFactory.getLogger(FiiServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public String getAccount(LoginUser loginUser) {
        LinkedMultiValueMap loginParas = new LinkedMultiValueMap();
        loginParas.add((Object)"account", (Object)loginUser.getUserId());
        loginParas.add((Object)"password", (Object)loginUser.getPasswordHash());
        loginParas.add((Object)"client_id", (Object)loginUser.getClient_id());
        loginParas.add((Object)"captcha", (Object)loginUser.getCaptcha());
        loginParas.add((Object)"key", (Object)loginUser.getKey());
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            HttpEntity requestBody = new HttpEntity((Object)loginParas, (MultiValueMap)headers);
            ResponseEntity userResult = this.restTemplate.postForEntity(this.envProperties.getFiiUri() + "/api/user/gitlogin", (Object)requestBody, String.class, new Object[0]);
            HashMap userInfo = (HashMap)this.objectMapper.readValue((String)userResult.getBody(), HashMap.class);
            int ret = Integer.parseInt(userInfo.get("ret").toString());
            if (ret > 0) {
                throw new BusinessException(userInfo.get("msg").toString());
            }
            return ((Map)userInfo.get("data")).get("account").toString();
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21016);
        }
    }

    @Override
    public String getAccessToken(Map<String, Object> paras) {
        LinkedMultiValueMap getParas = new LinkedMultiValueMap();
        getParas.add((Object)"grant_type", (Object)"authorization_code");
        getParas.add((Object)"client_id", paras.get("client_id"));
        getParas.add((Object)"client_secret", paras.get("client_secret"));
        getParas.add((Object)"redirect_uri", paras.get("redirect_uri"));
        getParas.add((Object)"code", paras.get("code"));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestBody = new HttpEntity((Object)getParas, (MultiValueMap)headers);
        try {
            ResponseEntity accessTokenResult = this.restTemplate.postForEntity(paras.get("fii_uri") + "/oauth/access_token", (Object)requestBody, String.class, new Object[0]);
            HashMap result = (HashMap)this.objectMapper.readValue((String)accessTokenResult.getBody(), HashMap.class);
            if (result.containsKey("access_token")) {
                return result.get("access_token").toString();
            }
        }
        catch (Exception e) {
            log.error("\u8bbf\u95eefii\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FII_RETURN_ERROR);
        }
        throw new BusinessException((ErrorHandler)I18nError.FII_NO_ACCESS);
    }

    @Override
    public String getUserId(Map<String, Object> paras, String access_token) {
        LinkedMultiValueMap getUserParas = new LinkedMultiValueMap();
        getUserParas.add((Object)"client_id", paras.get("client_id"));
        getUserParas.add((Object)"access_token", (Object)access_token);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestBody = new HttpEntity((Object)getUserParas, (MultiValueMap)headers);
        try {
            ResponseEntity userResult = this.restTemplate.postForEntity(this.envProperties.getFiiUri() + "/api/user/show", (Object)requestBody, String.class, new Object[0]);
            HashMap userInfo = (HashMap)this.objectMapper.readValue((String)userResult.getBody(), HashMap.class);
            int ret = Integer.parseInt(userInfo.get("ret").toString());
            if (ret == 0) {
                return "FII-" + userInfo.get("account").toString();
            }
            throw new BusinessException(userInfo.get("msg").toString());
        }
        catch (Exception e) {
            log.error("\u8bbf\u95eefii\u8fd4\u56de\u9519\u8bef\u4fe1\u606f", (Throwable)e);
            throw new BusinessException((ErrorHandler)I18nError.FII_RETURN_ERROR);
        }
    }
}

