/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authoritysummary.AuthoritySummaryVO;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.domain.GoodsAliasVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.MultiLanguageQueryVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.Goods;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsLanguage;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsVO;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.SellingStrategyVO;
import com.digiwin.dap.middleware.iam.support.remote.impl.CacServiceImpl;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class GmcServiceImpl
implements GmcService {
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    private Logger logger = LoggerFactory.getLogger(CacServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate dapRetryRestTemplate;
    @Autowired
    private RemoteIamService remoteIamService;
    private static final String MULTI_LANGUAGE_GOODSCODES_RESOURCES = "%s/api/gmc/v2/multi/language/goodscodes/resources";
    private static final String GOODS_DEV_ISV_OPTION = "%s/api/gmc/v2/goods/dev/isv/option";
    private static final String GOODS_SELLINGSTRATEGYS_CODE = "%s/api/cloudgoods/sellingstrategys/code/%s";
    private static final String GOODS_LANGUAGE = "%s/api/gmc/v2/goods/language";
    private static final String GOODS_CODE = "%s/api/cloudgoods/%s";
    private static final String GOODS_CODE_NONE = "/api/gmc/v2/goods/code/none";
    private static final String GOODS_LIST = "/api/gmc/v2/goods/list";
    private static final String GOODS_AUTO_CREATE = "/api/cloudgoods/autoCreate";
    public static final String GOODS_ALIAS_LIST = "/api/cloudgoods/alias";
    public static final String AUTHORITY_SUMMARY_CHILDREN = "%s/api/gmc/v2/authority/summary/list/child?goodsCode=%s";
    private static final String GOODS_LIST_SIMPLE = "/api/gmc/v2/goods";

    @Override
    public List<MultiLanguageQueryVO> getGoodsMultiLanguageVos(List<String> goodsCodes) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getGmcUri())) {
                String url = String.format(MULTI_LANGUAGE_GOODSCODES_RESOURCES, this.envProperties.getGmcUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
                HttpEntity request = new HttpEntity(goodsCodes, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<MultiLanguageQueryVO>>>(){}, new Object[0]);
                return Optional.ofNullable(responseEntity.getBody()).map(StdData::getData).orElse(Collections.emptyList());
            }
            this.logger.error("gmc\u8fde\u63a5\u5730\u5740\u662f\u7a7a\uff01");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return Collections.emptyList();
    }

    @Override
    public List<Goods> getDevIsvGoods(List<String> devIds, String servicerId) {
        try {
            if (!StringUtils.isEmpty((Object)this.envProperties.getGmcUri())) {
                String url = String.format(GOODS_DEV_ISV_OPTION, this.envProperties.getGmcUri());
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
                HashMap<String, Object> requestMap = new HashMap<String, Object>();
                requestMap.put("devIds", devIds);
                requestMap.put("servicerId", servicerId);
                HttpEntity request = new HttpEntity(requestMap, (MultiValueMap)headers);
                StdData result = (StdData)this.dapRetryRestTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
                if (result != null && result.getData() != null) {
                    return (List)objectMapper.convertValue(result.getData(), (TypeReference)new TypeReference<List<Goods>>(){});
                }
            } else {
                this.logger.error("gmc\u8fde\u63a5\u5730\u5740\u662f\u7a7a\uff01");
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
        return Collections.emptyList();
    }

    @Override
    public SellingStrategyVO getGoodsSellingStrategy(String sellingStrategyCode) {
        try {
            String url = String.format(GOODS_SELLINGSTRATEGYS_CODE, this.envProperties.getGmcUri(), sellingStrategyCode);
            HttpHeaders headers = new HttpHeaders();
            String token = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(this.envProperties.getManagerTenant()) : UserUtils.getToken();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, token);
            SellingStrategyVO result = (SellingStrategyVO)this.dapRetryRestTemplate.getForObject(url, SellingStrategyVO.class, (Map)headers);
            if (result != null) {
                return result;
            }
            this.logger.error(String.format("\u9500\u552e\u65b9\u6848%s\u4e0d\u5b58\u5728", sellingStrategyCode));
            return null;
        }
        catch (Exception ex) {
            throw new BusinessException((ErrorHandler)I18nError.GET_SELLING_STRATEGY_FAILED, new Object[]{sellingStrategyCode});
        }
    }

    @Override
    public List<GoodsAliasVO> findGoodsAliasList(Map<String, Object> paramsMap) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity(paramsMap, (MultiValueMap)headers);
        String url = this.envProperties.getGmcUri() + GOODS_ALIAS_LIST;
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<GoodsAliasVO>>>(){}, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)I18nError.QUERY_GOODS_ALIAS_FAILED, new Object[]{paramsMap});
        }
    }

    @Override
    public void deleteGoods(String appId) {
        if (!StringUtils.isEmpty((Object)this.envProperties.getGmcUri())) {
            String url = String.format(GOODS_CODE, this.envProperties.getGmcUri(), appId);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            this.restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        } else {
            this.logger.error("gmc\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a");
        }
    }

    @Override
    public List<GoodsLanguage> getGoodsLanguage(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return Collections.emptyList();
        }
        String url = String.format(GOODS_LANGUAGE, this.envProperties.getGmcUri());
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HttpEntity request = new HttpEntity(goodsCodes, (MultiValueMap)headers);
            StdData result = (StdData)this.dapRetryRestTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            if (result != null && result.getData() != null) {
                return (List)objectMapper.convertValue(result.getData(), (TypeReference)new TypeReference<List<GoodsLanguage>>(){});
            }
        }
        catch (Exception e) {
            ExceptionUtils.logError((String)"\u83b7\u53d6\u5546\u54c1\u591a\u8bed\u8a00\u4fe1\u606f", (String)url, goodsCodes, (Exception)e);
        }
        return new ArrayList<GoodsLanguage>();
    }

    @Override
    public Goods getGoodsInfoForTestEnv(String goodsId) {
        return this.getGoodsInfoForTestEnv(goodsId, this.envProperties.getGmcUri());
    }

    @Override
    public Goods getGoodsInfoForTestEnv(String goodsId, String gmcUri) {
        gmcUri = Optional.ofNullable(gmcUri).orElse(this.envProperties.getGmcUri());
        try {
            if (!StringUtils.isEmpty((Object)gmcUri)) {
                String url = String.format(GOODS_CODE, this.envProperties.getGmcUri(), goodsId);
                Goods goods = (Goods)this.dapRetryRestTemplate.getForObject(url, Goods.class, new Object[0]);
                if (null != goods) {
                    if (null == goods.getFirstSellingStrategy()) {
                        throw new BusinessException((ErrorHandler)I18nError.SELLING_STRATEGY_IS_NULL, new Object[]{goodsId});
                    }
                } else {
                    throw new BusinessException((ErrorHandler)I18nError.NO_GOODS_INFO, new Object[]{goodsId});
                }
                return goods;
            }
            this.logger.error("gmc\u6d4b\u8bd5\u73af\u5883\u5730\u5740\u4e3a\u7a7a!");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
        return null;
    }

    @Override
    public List<String> getGoodsCodeNone(List<String> goodsCode) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity requestBody = new HttpEntity(goodsCode, (MultiValueMap)headers);
            String url = this.envProperties.getGmcUri() + GOODS_CODE_NONE;
            return (List)this.dapRetryRestTemplate.postForObject(url, (Object)requestBody, List.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5546\u54c1code\u5931\u8d25:{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public List<GoodsVO> getGoodsCodeDetail(List<String> goodsCodes) {
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return new ArrayList<GoodsVO>();
        }
        String url = this.envProperties.getGmcUri() + GOODS_LIST;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String token = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(this.envProperties.getManagerTenant()) : UserUtils.getToken();
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("codes", goodsCodes);
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            StdData result = (StdData)this.dapRetryRestTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            if (result != null && result.getData() != null) {
                return (List)objectMapper.convertValue(result.getData(), (TypeReference)new TypeReference<List<GoodsVO>>(){});
            }
        }
        catch (Exception e) {
            ExceptionUtils.logError((String)"\u83b7\u53d6\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f", (String)url, goodsCodes, (Exception)e);
        }
        return new ArrayList<GoodsVO>();
    }

    @Override
    public Boolean autoCreateGoods(String devSysId, String cloud, Boolean other, String deployGmcUrl, String appCloudUrl, String pmEmails, String sourceIamUri, String tenantId, String sourceCloud, String sourceArea) {
        String url = this.envProperties.getGmcUri() + GOODS_AUTO_CREATE;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", UserUtils.getToken());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sysId", devSysId);
            params.put("cloud", cloud);
            params.put("other", other);
            params.put("deployGmcUrl", deployGmcUrl);
            params.put("sourceIamUri", sourceIamUri);
            params.put("appCloudUrl", appCloudUrl);
            params.put("pmEmails", pmEmails);
            params.put("tenantId", tenantId);
            params.put("sourceCloud", sourceCloud);
            params.put("sourceArea", sourceArea);
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            StdData result = (StdData)this.restTemplate.postForObject(url, (Object)request, StdData.class, new Object[0]);
            if (result != null && result.getCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionUtils.logError((String)"\u81ea\u52a8\u751f\u6210\u5546\u54c1", (String)url, (Object)devSysId, (Exception)e);
        }
        return false;
    }

    @Override
    public List<AuthoritySummaryVO> getAuthoritySummaryChildren(String goodsCode) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = String.format(AUTHORITY_SUMMARY_CHILDREN, this.envProperties.getGmcUri(), goodsCode);
        try {
            ResponseEntity response = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<AuthoritySummaryVO>>>(){}, new Object[0]);
            return Optional.ofNullable(response.getBody()).map(StdData::getData).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            ExceptionUtils.logError((String)"\u83b7\u53d6\u6c47\u6574\u6e05\u5355\u4fe1\u606f\u5931\u8d25", (String)url, (Object)goodsCode, (Exception)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<GoodsVO> getGoodsList(String goodsPurposeNotEq) {
        String url = String.format("%s%s?goodsPurposeNotEq=%s", this.envProperties.getGmcUri(), GOODS_LIST_SIMPLE, goodsPurposeNotEq);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            String token = StringUtils.isEmpty((Object)UserUtils.getToken()) ? this.remoteIamService.getUserToken(this.envProperties.getManagerTenant()) : UserUtils.getToken();
            headers.add("digi-middleware-auth-user", token);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity result = this.dapRetryRestTemplate.exchange(url, HttpMethod.GET, request, (ParameterizedTypeReference)new ParameterizedTypeReference<List<GoodsVO>>(){}, new Object[0]);
            if (result != null && result.getBody() != null) {
                return (List)result.getBody();
            }
        }
        catch (Exception e) {
            ExceptionUtils.logError((String)"\u83b7\u53d6\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f", (String)url, (Object)goodsPurposeNotEq, (Exception)e);
        }
        return new ArrayList<GoodsVO>();
    }
}

