/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.support.remote.KanBanService;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KanBanServiceImpl
implements KanBanService {
    private static final Logger logger = LoggerFactory.getLogger(KanBanServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    @Async(value="dapLogExecutor")
    public void callKanBan() {
        if (Strings.isBlank((String)this.envProperties.getKanbanUri())) {
            logger.info("kanbanUri\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u8c03\u7528\u770b\u677f\uff0c\u9000\u51fa...");
            return;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String result = (String)this.restTemplate.postForObject(this.envProperties.getKanbanUri(), (Object)request, String.class, new Object[0]);
            if (result != null && !result.startsWith("{")) {
                logger.error("\u770b\u677f\u8c03\u7528\u5931\u8d25:" + result);
            }
        }
        catch (Exception e) {
            logger.error("\u770b\u677f\u8c03\u7528\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

