/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.constant.enums.BooleanStrEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantMetadataVO;
import com.digiwin.dap.middleware.iam.domain.tenant.metadata.TenantMetadataLdapVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.support.remote.CustomSslSocketFactory;
import com.digiwin.dap.middleware.iam.support.remote.LdapConstants;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdExecution;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdOu;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdUser;
import com.digiwin.dap.middleware.iam.util.Dom4jUtil;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class LdapServiceImpl
implements LdapService {
    private static final Logger logger = LoggerFactory.getLogger(LdapServiceImpl.class);
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public AdExecution checkAccount(String username, String password, String appCountry) {
        username = StringEscapeUtils.escapeXml((String)username);
        password = StringEscapeUtils.escapeXml((String)password);
        ArrayList<BiFunction<String, String, String>> checkFunctions = new ArrayList<BiFunction<String, String, String>>();
        checkFunctions.add(Dom4jUtil::checkADEncrypted);
        if (Locale.SIMPLIFIED_CHINESE.getCountry().equalsIgnoreCase(appCountry)) {
            checkFunctions.add(Dom4jUtil::checkLdapAliyun);
            checkFunctions.add(Dom4jUtil::checkLdapCn);
            checkFunctions.add(Dom4jUtil::checkLdapTw);
        } else {
            checkFunctions.add(Dom4jUtil::checkLdapTw);
            checkFunctions.add(Dom4jUtil::checkLdapAliyun);
            checkFunctions.add(Dom4jUtil::checkLdapCn);
        }
        String xmlStr = LdapServiceImpl.checkInOrder(username, password, checkFunctions);
        if (xmlStr == null) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_LDAP_AUTH);
        }
        try {
            logger.info("ad\u9a8c\u8bc1\u8d26\u53f7\u4fe1\u606f{}", (Object)xmlStr);
            return Dom4jUtil.getAdExecution(xmlStr);
        }
        catch (Exception exception) {
            throw new BusinessException((ErrorHandler)I18nError.AD_INFO_FAILED, new Object[]{username});
        }
    }

    private static String checkInOrder(String username, String password, List<BiFunction<String, String, String>> checks) {
        for (BiFunction<String, String, String> check : checks) {
            String result = check.apply(username, password);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public DirContext connect(String url, String username, String password, boolean ssl) {
        InitialLdapContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        env.put("java.naming.provider.url", url);
        if (ssl) {
            env.put("java.naming.security.protocol", "ssl");
            if (Boolean.TRUE.equals(this.envProperties.getAdTrustSsl())) {
                Security.setProperty("jdk.tls.disabledAlgorithms", "");
                System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
                env.put("java.naming.authoritative", "true");
                env.put("java.naming.ldap.factory.socket", CustomSslSocketFactory.class.getName());
            }
        }
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            logger.error("LDAP\u8eab\u4efd\u9a8c\u8bc1\u5931\u8d25 {}, username={}, {}", new Object[]{url, username, e.getMessage(), e});
        }
        return ctx;
    }

    @Override
    public List<Map<String, String>> search(String url, String username, String password, boolean ssl, String searchDn, String searchFilter) {
        DirContext adminCtx = this.connect(url, username, password, ssl);
        if (adminCtx == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_ADMIN_ERROR);
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> results = adminCtx.search(searchDn, searchFilter, searchCtls);
            while (results != null && results.hasMoreElements()) {
                SearchResult result = results.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                NamingEnumeration<? extends Attribute> attrsAll = attrs.getAll();
                while (attrsAll.hasMoreElements()) {
                    Attribute attr = attrsAll.next();
                    map.put(attr.getID(), this.getAttrValue(attr));
                }
                list.add(map);
            }
        }
        catch (NamingException e) {
            logger.error("\u67e5\u8be2AD\u8d44\u6599\u5931\u8d25, searchDn={}, searchFilter={}", new Object[]{searchDn, searchFilter, e});
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_SEARCH_OBJECT_ERROR);
        }
        finally {
            try {
                adminCtx.close();
            }
            catch (NamingException namingException) {}
        }
        return list;
    }

    @Override
    public List<Map<String, String>> search(String url, String username, String password, boolean ssl, String searchDn, String searchFilter, int pageSize) {
        DirContext ctx = this.connect(url, username, password, ssl);
        if (ctx == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_ADMIN_ERROR);
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        byte[] cookie = null;
        try {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            do {
                ((LdapContext)ctx).setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
                NamingEnumeration<SearchResult> results = ctx.search(searchDn, searchFilter, searchCtls);
                while (results != null && results.hasMoreElements()) {
                    SearchResult result = results.next();
                    Attributes attrs = result.getAttributes();
                    if (attrs == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    NamingEnumeration<? extends Attribute> attrsAll = attrs.getAll();
                    while (attrsAll.hasMoreElements()) {
                        Attribute attr = attrsAll.next();
                        map.put(attr.getID(), this.getAttrValue(attr));
                    }
                    list.add(map);
                }
                Control[] controls = ((LdapContext)ctx).getResponseControls();
                if (controls == null) continue;
                for (Control control : controls) {
                    if (!(control instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                    cookie = prrc.getCookie();
                }
            } while (cookie != null);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2AD\u8d44\u6599\u5931\u8d25, searchDn={}, searchFilter={}", new Object[]{searchDn, searchFilter, e});
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_SEARCH_OBJECT_ERROR);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return list;
    }

    @Override
    public List<Map<String, String>> searchPage(LdapContext ctx, String searchDn, String searchFilter, int pageSize, List<byte[]> cookieList) {
        if (ctx == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_ADMIN_ERROR);
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookieList.get(0), true)});
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(searchDn, searchFilter, searchCtls);
            while (results != null && results.hasMoreElements()) {
                SearchResult result = results.next();
                Attributes attrs = result.getAttributes();
                if (attrs == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                NamingEnumeration<? extends Attribute> attrsAll = attrs.getAll();
                while (attrsAll.hasMoreElements()) {
                    Attribute attr = attrsAll.next();
                    map.put(attr.getID(), this.getAttrValue(attr));
                }
                list.add(map);
            }
            Control[] controls = ctx.getResponseControls();
            if (controls != null) {
                for (Control control : controls) {
                    if (!(control instanceof PagedResultsResponseControl)) continue;
                    PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                    cookieList.set(0, prrc.getCookie());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2AD\u8d44\u6599\u5931\u8d25, searchDn={}, searchFilter={}", new Object[]{searchDn, searchFilter, e});
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_SEARCH_OBJECT_ERROR);
        }
        return list;
    }

    @Override
    public AdUser getAdUser(LoginUser loginUser, Tenant tenant) {
        TenantMetadataLdapVO vo = this.getTenantMetadataLdapVO(tenant.getSid());
        String ldapBase = vo.getBaseDn();
        String adminAccount = vo.getAdminAccount();
        String adminPassword = AES.decrypt((String)vo.getAdminPassword(), (String)KeyConstant.WECHAT_UNION_ID);
        String userFilter = Optional.ofNullable(vo.getUserFilter()).filter(StringUtils::hasLength).orElse("(objectClass=user)");
        String userLoginAttr = Optional.ofNullable(vo.getUserLoginAttr()).filter(StringUtils::hasLength).orElse("sAMAccountName");
        String searchFilter = String.format("(&(%s=%s)(objectCategory=person)%s)", userLoginAttr, loginUser.getUserId(), userFilter);
        vo.setUserFilter(searchFilter);
        boolean ssl = BooleanStrEnum.TRUE.getValue().equals(vo.getSslEnabled());
        List<AdUser> adUserList = this.listAdUser(vo.getUrl(), adminAccount, adminPassword, ssl, ldapBase, vo);
        if (adUserList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_ACCOUNT_PASSWORD_ERROR);
        }
        AdUser adUser = adUserList.get(0);
        DirContext ctx = this.connect(vo.getUrl(), adUser.getDistinguishedName(), loginUser.getPassword(), ssl);
        if (ctx == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_ACCOUNT_PASSWORD_ERROR);
        }
        try {
            ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return adUser;
    }

    @Override
    public List<AdUser> listAdUser(String url, String username, String password, boolean ssl, String searchDn, TenantMetadataLdapVO vo) {
        vo = Optional.ofNullable(vo).orElse(new TenantMetadataLdapVO());
        String searchFilter = Optional.ofNullable(vo.getUserFilter()).filter(StringUtils::hasLength).orElse("(objectClass=user)");
        List<Map<String, String>> search = this.search(url, username, password, ssl, searchDn, searchFilter);
        ArrayList<AdUser> list = new ArrayList<AdUser>();
        for (Map<String, String> map : search) {
            this.checkObjectClass(map.get("objectClass"), "user", searchFilter);
            AdUser adUser = this.getAdUser(vo, map);
            if (ObjectUtils.isEmpty((Object)adUser.getId()) || ObjectUtils.isEmpty((Object)adUser.getName())) {
                logger.warn("AD\u7528\u6237id\u6216name\u4e3a\u7a7a\uff0cDN = {}, searchDn = {}, searchFilter={}, url = {},", new Object[]{adUser.getDistinguishedName(), searchDn, searchFilter, url});
                continue;
            }
            list.add(adUser);
        }
        return list;
    }

    @Override
    public List<AdUser> listAdUserPage(LdapContext ctx, String searchDn, TenantMetadataLdapVO vo, int pageSize, List<byte[]> cookieList) {
        vo = Optional.ofNullable(vo).orElse(new TenantMetadataLdapVO());
        String searchFilter = Optional.ofNullable(vo.getUserFilter()).filter(StringUtils::hasLength).orElse("(objectClass=user)");
        List<Map<String, String>> search = this.searchPage(ctx, searchDn, searchFilter, pageSize, cookieList);
        ArrayList<AdUser> list = new ArrayList<AdUser>();
        for (Map<String, String> map : search) {
            this.checkObjectClass(map.get("objectClass"), "user", searchFilter);
            AdUser adUser = this.getAdUser(vo, map);
            if (ObjectUtils.isEmpty((Object)adUser.getId()) || ObjectUtils.isEmpty((Object)adUser.getName())) {
                logger.warn("AD\u7528\u6237id\u6216name\u4e3a\u7a7a\uff0cDN = {}, searchDn = {}, searchFilter={}, ctx = {},", new Object[]{adUser.getDistinguishedName(), searchDn, searchFilter, ctx});
                continue;
            }
            list.add(adUser);
        }
        return list;
    }

    @Override
    public List<AdOu> listAdOu(String url, String adminAccount, String adminPassword, boolean ssl, String searchDn, TenantMetadataLdapVO vo) {
        String searchFilter = Optional.ofNullable(vo.getOuFilter()).filter(StringUtils::hasLength).orElse("(objectClass=organizationalUnit)");
        List<Map<String, String>> search = this.search(url, adminAccount, adminPassword, ssl, searchDn, searchFilter);
        ArrayList<AdOu> list = new ArrayList<AdOu>();
        for (Map<String, String> map : search) {
            this.checkObjectClass(map.get("objectClass"), "organizationalUnit", searchFilter);
            AdOu adOu = this.getAdOu(vo, map);
            if (ObjectUtils.isEmpty((Object)adOu.getId())) {
                logger.warn("AD\u7ec4\u7ec7id\u4e3a\u7a7a\uff0cDN = {}, searchDn = {}, searchFilter={}, url = {},", new Object[]{adOu.getDistinguishedName(), searchDn, searchFilter, url});
                continue;
            }
            list.add(adOu);
        }
        return list;
    }

    private AdUser getAdUser(TenantMetadataLdapVO vo, Map<String, String> map) {
        AdUser adUser = new AdUser();
        adUser.setId(map.get(Optional.ofNullable(vo.getUserLoginAttr()).filter(StringUtils::hasLength).orElse("sAMAccountName")));
        adUser.setName(map.get(Optional.ofNullable(vo.getUserNameAttr()).filter(StringUtils::hasLength).orElse("name")));
        adUser.setMail(map.get(Optional.ofNullable(vo.getUserEmailAttr()).filter(StringUtils::hasLength).orElse("mail")));
        adUser.setDepartment(map.get("department"));
        adUser.setMobile(map.get("mobile"));
        adUser.setTelephoneNumber(map.get(Optional.ofNullable(vo.getUserPhoneAttr()).filter(StringUtils::hasLength).orElse("telephoneNumber")));
        adUser.setDisplayName(map.get("displayName"));
        adUser.setDistinguishedName(map.get("distinguishedName"));
        adUser.setManager(map.get("manager"));
        adUser.setTitle(map.get("title"));
        adUser.setUserAccountControl(map.get("userAccountControl"));
        if (LdapConstants.LDAP_DISABLED_USER_FLAG.contains(adUser.getUserAccountControl())) {
            adUser.setDisabled(Boolean.TRUE);
        }
        return adUser;
    }

    private AdOu getAdOu(TenantMetadataLdapVO vo, Map<String, String> map) {
        AdOu adOu = new AdOu();
        adOu.setId(map.get(Optional.ofNullable(vo.getOuUniqueIdAttr()).filter(StringUtils::hasLength).orElse("distinguishedName")));
        adOu.setName(map.get(Optional.ofNullable(vo.getOuNameAttr()).filter(StringUtils::hasLength).orElse("name")));
        adOu.setDistinguishedName(map.get("distinguishedName"));
        adOu.setManagedBy(map.get("managedBy"));
        return adOu;
    }

    private void checkObjectClass(String objectClass, String ouObjectClass, String searchFilter) {
        if (ObjectUtils.isEmpty((Object)objectClass) || !Arrays.asList(objectClass.split(",")).contains(ouObjectClass)) {
            throw new BusinessException(StrUtil.indexedFormat((CharSequence)"\u67e5\u8be2AD\u8d44\u6599\u7c7b\u578b\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\u3002objectClass = {0}, searchFilter = {1}", (Object[])new Object[]{objectClass, searchFilter}));
        }
    }

    private TenantMetadataLdapVO getTenantMetadataLdapVO(long tenantSid) {
        List<TenantMetadataVO> tenantMetadataVOList = this.tenantMetadataCrudService.getTenantMetadataValue(tenantSid, "ldap", IamConstants.LDAP_KEY_LIST);
        if (tenantMetadataVOList.isEmpty()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21010);
        }
        return new TenantMetadataLdapVO(tenantMetadataVOList);
    }

    private String getAttrValue(Attribute attr) throws NamingException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean start = true;
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMoreElements()) {
            if (!start) {
                stringBuilder.append(",");
            }
            stringBuilder.append(e.nextElement());
            start = false;
        }
        return stringBuilder.toString();
    }
}

