/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.support.remote.impl;

import cn.hutool.core.date.DateUtil;
import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.producer.ProducerService;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyIdentityTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.DeletePurchaseGoods;
import com.digiwin.dap.middleware.iam.domain.creator.TransferCreatorApplicationVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestRegisterInfo;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.servicer.ServicerEmailVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantAuditVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantTransferOwnerUserVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantVO;
import com.digiwin.dap.middleware.iam.domain.user.ContactVO;
import com.digiwin.dap.middleware.iam.domain.user.UserAccountPasswordVO;
import com.digiwin.dap.middleware.iam.entity.IntellyExperienceApplication;
import com.digiwin.dap.middleware.iam.entity.IntellyIdentityApplication;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantDataExportRecord;
import com.digiwin.dap.middleware.iam.entity.TransferCreatorApplication;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.ServicerMapper;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.MailTypeEnum;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.UpdateTenantCreatorMessageVO;
import com.digiwin.dap.middleware.iam.support.stream.producer.domain.MessageContactInfo;
import com.digiwin.dap.middleware.iam.support.stream.producer.domain.TenantMessageInfo;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.I18nUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger logger = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ServicerMapper servicerMapper;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private DictDataService dictDataService;

    @Override
    public void sendRegisterMessage(Tenant tenant, String code) {
        if (tenant == null) {
            return;
        }
        try {
            MessageBody messageInfo = new MessageBody();
            if (tenant.isIsv()) {
                ServicerEmailVO servicerEmailVO = this.servicerMapper.getServicerTenant(tenant.getSid());
                servicerEmailVO.setCode("ISV");
                this.sendServicerApplyEmail(servicerEmailVO, MailTypeEnum.IAM_SERVICE_AUDIT.name());
                this.sendServicerApplyEmail(servicerEmailVO, MailTypeEnum.IAM_SERVICE_APPLY.name());
                return;
            }
            messageInfo.setOpType(MailTypeEnum.IAM_TENANT_REGISTER.name());
            messageInfo.setData((Object)tenant);
            this.producerService.msg(messageInfo);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u79df\u6237" + tenant.getId() + "\u6ce8\u518c\u6d88\u606f\u5931\u8d25:" + e);
        }
    }

    @Override
    public void sendTenantExportDataFailMessage(TenantDataExportRecord tenantDataExportRecord) {
        try {
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantDataExportRecord.getTenantSid());
            MessageBody messageInfo = new MessageBody();
            messageInfo.setOpType(MailTypeEnum.IAM_TENANT_EXPORT_DATA_FAIL.name());
            TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
            tenantMessageInfo.setTenantId(tenant.getId());
            tenantMessageInfo.setTenantName(tenant.getName());
            tenantMessageInfo.setSid(tenant.getSid());
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String applyDate = dateTimeFormatter.format(tenantDataExportRecord.getCreateDate());
            tenantMessageInfo.setApplyDate(applyDate);
            tenantMessageInfo.setUserSid(tenantDataExportRecord.getCreateBy());
            User user = (User)this.userCrudService.findBySid(tenantDataExportRecord.getCreateBy());
            if (user != null) {
                tenantMessageInfo.setUserName(user.getName());
                tenantMessageInfo.setUserId(user.getId());
            }
            tenantMessageInfo.setContent(tenantDataExportRecord.getId());
            messageInfo.setData((Object)tenantMessageInfo);
            this.producerService.msg(messageInfo);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u79df\u6237" + tenantDataExportRecord.getSid() + "\u5bfc\u51fa\u6d88\u606f\u5931\u8d25:" + e);
        }
    }

    @Override
    public void sendConfirmSuccessMessage(TenantAuditVO tenantAuditVO) {
        if (tenantAuditVO == null) {
            return;
        }
        try {
            MessageBody messageInfo = new MessageBody();
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
            if (tenant != null) {
                if (tenant.isIsv()) {
                    messageInfo.setOpType(MailTypeEnum.IAM_SERVICE_PASS_AUDIT.name());
                } else {
                    messageInfo.setOpType(MailTypeEnum.IAM_TENANT_REGISTER_PASS.name());
                }
                User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
                if (user != null) {
                    TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
                    tenantMessageInfo.setUserId(user.getId());
                    tenantMessageInfo.setUserName(user.getName());
                    tenantMessageInfo.setTenantId(tenant.getId());
                    tenantMessageInfo.setTenantName(tenant.getName());
                    tenantMessageInfo.setCreateDate(tenant.getCreateDate());
                    tenantMessageInfo.setEnterpriseType(tenant.getEnterpriseType());
                    messageInfo.setData((Object)tenantMessageInfo);
                    this.producerService.msg(messageInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6ce8\u518c\u6d88\u606f\u5931\u8d25:" + e);
        }
    }

    @Override
    public void sendConfirmFailMessage(TenantAuditVO tenantAuditVO) {
        if (tenantAuditVO == null) {
            return;
        }
        try {
            MessageBody messageInfo = new MessageBody();
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantAuditVO.getSid());
            if (tenant != null) {
                if (tenant.isIsv()) {
                    messageInfo.setOpType(MailTypeEnum.IAM_SERVICE_REFUSE_APPLY.name());
                } else {
                    messageInfo.setOpType(MailTypeEnum.IAM_TENANT_REGISTER_REJECT.name());
                }
                User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
                if (user != null) {
                    TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
                    tenantMessageInfo.setUserId(user.getId());
                    tenantMessageInfo.setUserName(user.getName());
                    tenantMessageInfo.setTenantName(tenant.getName());
                    tenantMessageInfo.setTenantId(tenant.getId());
                    tenantMessageInfo.setDescription(tenantAuditVO.getExplain());
                    tenantMessageInfo.setCreateDate(tenant.getCreateDate());
                    tenantMessageInfo.setEnterpriseType(tenant.getEnterpriseType());
                    messageInfo.setData((Object)tenantMessageInfo);
                    this.producerService.msg(messageInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6ce8\u518c\u6d88\u606f\u5931\u8d25:" + e);
        }
    }

    @Override
    public void sendCancelTenantMessage(long tenantSid) {
        if (tenantSid == 0L) {
            return;
        }
        try {
            MessageBody messageInfo = new MessageBody();
            messageInfo.setOpType(MailTypeEnum.CANCEL.name());
            TenantVO tenantVO = new TenantVO();
            tenantVO.setSid(tenantSid);
            messageInfo.setData((Object)tenantVO);
            this.producerService.msg(messageInfo);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u53d6\u6d88\u521b\u5efa\u79df\u6237\u6d88\u606f\u5931\u8d25:" + e);
        }
    }

    @Override
    public void sendApplyMessage(long userSid, long tenantSid, String inviteApp) {
        try {
            DictData data;
            if (userSid == 0L || tenantSid == 0L) {
                return;
            }
            MessageBody messageInfo = new MessageBody();
            messageInfo.setOpType(MailTypeEnum.IAM_USER_APPLY.name());
            if (StringUtils.hasText((String)inviteApp) && null != (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.USER_APPLY_JOIN_TENANT.name(), inviteApp)))) {
                messageInfo.setOpType(data.getDictValue());
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            User user = (User)this.userCrudService.findBySid(userSid);
            if (tenant != null && user != null) {
                TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
                tenantMessageInfo.setUserName(user.getName());
                tenantMessageInfo.setUserId(user.getId());
                tenantMessageInfo.setTenantId(tenant.getId());
                tenantMessageInfo.setTenantName(tenant.getName());
                tenantMessageInfo.setApplyDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                tenantMessageInfo.setContact(Collections.singletonMap("id", tenant.getId()));
                messageInfo.setData((Object)tenantMessageInfo);
                this.producerService.msg(messageInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u7528\u6237\u7533\u8bf7\u52a0\u5165\u4f01\u4e1a\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void sendInviteMessage(long tenantSid, String invitedUser, String inviteContent, List<String> appIds, boolean isNeedRegister, String inviteApp, Long invitedSid, String language) {
        MessageBody messageInfo = new MessageBody();
        TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
        tenantMessageInfo.setInviteUserName(UserUtils.getUserName());
        tenantMessageInfo.setTypes(Arrays.asList("email"));
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (isNeedRegister) {
            tenantMessageInfo.setEmail(invitedUser);
            tenantMessageInfo.setContent(inviteContent);
            tenantMessageInfo.setTenantId(tenant.getId());
            tenantMessageInfo.setTenantName(tenant.getName());
            tenantMessageInfo.setContent(inviteContent);
            tenantMessageInfo.setAppIds(appIds);
            tenantMessageInfo.setInviteDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            tenantMessageInfo.setInvitedSid(invitedSid);
            tenantMessageInfo.setUserId(invitedUser);
            messageInfo.setData((Object)tenantMessageInfo);
            String mailType = this.getInviteRegisterMailType(invitedUser, inviteApp, language);
            messageInfo.setOpType(mailType);
        } else {
            User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(invitedUser, invitedUser, invitedUser, null);
            tenantMessageInfo.setUserId(user.getId());
            tenantMessageInfo.setUserName(user.getName());
            tenantMessageInfo.setTenantId(tenant.getId());
            tenantMessageInfo.setTenantName(tenant.getName());
            tenantMessageInfo.setContent(inviteContent);
            tenantMessageInfo.setAppIds(appIds);
            tenantMessageInfo.setInviteDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            tenantMessageInfo.setInvitedSid(invitedSid);
            messageInfo.setData((Object)tenantMessageInfo);
            String mailType = this.getInviteLoginMailType(invitedUser, inviteApp, language, tenantMessageInfo);
            messageInfo.setOpType(mailType);
        }
        try {
            this.producerService.msg(messageInfo);
        }
        catch (Exception e) {
            logger.error(String.format("\u4f01\u4e1a[%s]\u53d1\u9001\u9080\u8bf7\u7528\u6237[%s]\u52a0\u5165\u90ae\u4ef6\u5931\u8d25!", tenant.getId(), inviteContent), (Throwable)e);
            logger.error("\u53d1\u9001\u4f01\u4e1a\u9080\u8bf7\u7528\u6237\u52a0\u5165\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    private String getInviteRegisterMailType(String invitedUser, String inviteApp, String language) {
        String mailType;
        if (invitedUser.toLowerCase().endsWith("@digiwin.com")) {
            DictData dictData;
            mailType = MailTypeEnum.IAM_INVITE_DIGIWIN_USER_LOGIN.name();
            if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)inviteApp) && null != (dictData = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_DIGIWIN_USER_REGISTER.name(), inviteApp)))) {
                mailType = dictData.getDictValue();
            }
        } else {
            DictData dictData;
            mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_ZH_CN.name();
            if (com.digiwin.dap.middleware.util.StringUtils.hasLength((String)inviteApp) && null != (dictData = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_REGISTER.name(), inviteApp)))) {
                mailType = dictData.getDictValue();
                return mailType;
            }
            if (StringUtils.isEmpty((Object)language)) {
                if ("TW".equalsIgnoreCase(this.envProperties.getCountry())) {
                    mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_ZH_TW.name();
                }
            } else if ("zh_CN".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_ZH_CN.name();
            } else if ("zh_TW".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_ZH_TW.name();
            } else if ("en_US".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_EN_US.name();
            } else if ("vi_VN".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_REGISTER_VI_VN.name();
            }
        }
        return mailType;
    }

    private String getInviteLoginMailType(String invitedUser, String inviteApp, String language, TenantMessageInfo tenantMessageInfo) {
        String mailType;
        if ("dev".equals(inviteApp)) {
            tenantMessageInfo.setEmail(invitedUser);
            mailType = invitedUser.toLowerCase().endsWith("@digiwin.com") ? MailTypeEnum.DEV_INVITE_DIGIWIN_USER_LOGIN.name() : MailTypeEnum.DEV_INVITE_USER_LOGIN.name();
        } else if ("ISV".equals(inviteApp)) {
            tenantMessageInfo.setEmail(invitedUser);
            mailType = invitedUser.toLowerCase().endsWith("@digiwin.com") ? MailTypeEnum.ISV_INVITE_DIGIWIN_USER_LOGIN.name() : MailTypeEnum.ISV_INVITE_USER_LOGIN.name();
        } else {
            DictData dictData;
            mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_ZH_CN.name();
            if (StringUtils.isEmpty((Object)language)) {
                if ("TW".equalsIgnoreCase(this.envProperties.getCountry())) {
                    mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_ZH_TW.name();
                }
            } else if ("zh_CN".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_ZH_CN.name();
            } else if ("zh_TW".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_ZH_TW.name();
            } else if ("en_US".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_EN_US.name();
            } else if ("vi_VN".equalsIgnoreCase(language)) {
                mailType = MailTypeEnum.IAM_INVITE_USER_LOGIN_VI_VN.name();
            }
            if (StringUtils.hasText((String)inviteApp) && null != (dictData = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_LOGIN.name(), inviteApp)))) {
                mailType = dictData.getDictValue();
            }
        }
        return mailType;
    }

    @Override
    public void sendApplyJoinTenantMessage(long userSid, long tenantSid) {
        try {
            if (userSid == 0L || tenantSid == 0L) {
                return;
            }
            MessageBody messageInfo = new MessageBody();
            messageInfo.setOpType(MailTypeEnum.IAM_USER_APPLY_PASS.name());
            User user = (User)this.userCrudService.findBySid(userSid);
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            if (tenant != null && user != null) {
                TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
                tenantMessageInfo.setUserName(user.getName());
                tenantMessageInfo.setUserId(user.getId());
                tenantMessageInfo.setTenantName(tenant.getName());
                tenantMessageInfo.setTenantId(tenant.getId());
                messageInfo.setData((Object)tenantMessageInfo);
                this.producerService.msg(messageInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u7528\u6237\u6210\u529f\u52a0\u5165\u4f01\u4e1a\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void sendRefuseJoinTenantMessage(long userSid, long tenantSid) {
        try {
            if (userSid == 0L || tenantSid == 0L) {
                return;
            }
            MessageBody messageInfo = new MessageBody();
            messageInfo.setOpType(MailTypeEnum.IAM_USER_APPLY_REJECT.name());
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            User user = (User)this.userCrudService.findBySid(userSid);
            if (tenant != null && user != null) {
                TenantMessageInfo tenantMessageInfo = new TenantMessageInfo();
                tenantMessageInfo.setUserId(user.getId());
                tenantMessageInfo.setUserName(user.getName());
                tenantMessageInfo.setTenantName(tenant.getName());
                tenantMessageInfo.setTenantId(tenant.getId());
                messageInfo.setData((Object)tenantMessageInfo);
                this.producerService.msg(messageInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u7528\u6237\u88ab\u62d2\u52a0\u5165\u4f01\u4e1a\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void sendChangeContactMessage(ContactVO contactVO) {
        try {
            if (contactVO == null) {
                return;
            }
            MessageBody messageInfo = new MessageBody();
            MessageContactInfo messageContactInfo = new MessageContactInfo();
            if (!StringUtils.isEmpty((Object)contactVO.getTenantSid())) {
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(contactVO.getTenantSid());
                messageContactInfo.setTenantName(tenant.getName());
            } else if (contactVO.getUserSid() != null) {
                User user = (User)this.userCrudService.findBySid(contactVO.getUserSid());
                messageContactInfo.setUserName(user.getName());
            }
            if (!StringUtils.isEmpty((Object)contactVO.getEmail()) && !contactVO.getEmail().equals(contactVO.getOldEmail())) {
                messageContactInfo.setUserId(contactVO.getUserId());
                messageContactInfo.setEmail(contactVO.getEmail());
                messageContactInfo.setOldEmail(contactVO.getOldEmail());
                messageInfo.setOpType(MailTypeEnum.IAM_EMAIL_CHANGE.name());
                messageInfo.setData((Object)messageContactInfo);
                this.producerService.msg(messageInfo);
            }
            if (!StringUtils.isEmpty((Object)contactVO.getTelephone()) && !contactVO.getTelephone().equals(contactVO.getOldTelephone())) {
                messageContactInfo.setUserId(contactVO.getUserId());
                messageContactInfo.setOldTelephone(contactVO.getOldTelephone());
                if (!StringUtils.isEmpty((Object)contactVO.getOldTelephone())) {
                    messageContactInfo.setOldEncryptTelephone(contactVO.getOldTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
                }
                messageContactInfo.setTelephone(contactVO.getTelephone());
                messageContactInfo.setEncryptTelephone(contactVO.getTelephone().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
                messageInfo.setOpType(MailTypeEnum.IAM_TELEPHONE_CHANGE.name());
                messageInfo.setData((Object)messageContactInfo);
                this.producerService.msg(messageInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u79df\u6237\u66f4\u6539\u8054\u7cfb\u65b9\u5f0f\u90ae\u4ef6\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void inviteUserRegisterOrLoginSms(long tenantSid, String telephone, String userId, long inviteSid, boolean isNeedRegister, String inviteApp) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        content.put("tenantName", tenant == null ? "" : tenant.getName());
        content.put("telephone", telephone);
        MessageBody messageInfo = new MessageBody();
        content.put("types", Arrays.asList("sms"));
        if (isNeedRegister) {
            DictData data;
            content.put("marketUri", this.envProperties.getMarketUri() + "/register");
            messageInfo.setOpType(MailTypeEnum.IAM_INVITE_USER_REGISTER_SMS.name());
            if (StringUtils.hasText((String)inviteApp) && null != (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_REGISTER.name(), inviteApp)))) {
                messageInfo.setOpType(data.getDictValue());
            }
        } else {
            DictData data;
            content.put("marketUri", this.envProperties.getConsoleUri() + "/invite-user-join?tenantName=" + content.get("tenantName") + "&invitedSid=" + inviteSid + "&userId=" + userId);
            messageInfo.setOpType(MailTypeEnum.IAM_INVITE_USER_LOGIN_SMS.name());
            if (StringUtils.hasText((String)inviteApp) && null != (data = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.INVITE_USER_LOGIN.name(), inviteApp)))) {
                messageInfo.setOpType(data.getDictValue());
            }
        }
        messageInfo.setData(content);
        this.producerService.msg(messageInfo);
    }

    @Override
    public void sendUserEnterpriseAccountPassword(UserAccountPasswordVO accountPasswordVO) {
        if (accountPasswordVO == null) {
            return;
        }
        this.sendUserEnterpriseAccountPasswordCore(MailTypeEnum.IAM_PASSWORD_EMAIL_SEND.name(), MailTypeEnum.IAM_PASSWORD_TELEPHONE_SEND.name(), accountPasswordVO);
    }

    @Override
    public void sendDevUserEnterpriseAccountPassword(UserAccountPasswordVO vo) {
        Tenant tenant;
        if (vo == null) {
            return;
        }
        MessageBody msgBody = new MessageBody();
        if (!StringUtil.checkEmail(vo.getAccount())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
        }
        msgBody.setOpType(MailTypeEnum.IAM_DEV_PASSWORD_EMAIL_SEND.name());
        if (!ObjectUtils.isEmpty((Object)vo.getTenantId()) && (tenant = (Tenant)this.tenantCrudService.findById(vo.getTenantId())) != null && tenant.isIsv()) {
            msgBody.setOpType(MailTypeEnum.IAM_ISV_PASSWORD_EMAIL_SEND.name());
        }
        String tenantId = String.format("%s$", vo.getTenantId());
        vo.setUserId(vo.getUserId().replace(tenantId, ""));
        msgBody.setData((Object)vo);
        this.producerService.msg(msgBody);
    }

    @Override
    public void sendServicerApplyEmail(ServicerEmailVO servicerEmailVO, String opType) {
        if (servicerEmailVO == null) {
            return;
        }
        MessageBody servicerEmailVOMessageInfo = new MessageBody();
        servicerEmailVOMessageInfo.setOpType(opType);
        servicerEmailVOMessageInfo.setData((Object)servicerEmailVO);
        this.producerService.msg(servicerEmailVOMessageInfo);
    }

    @Override
    public void sendTenantTransferOwnerUserEmail(TenantTransferOwnerUserVO tenantTransferOwnerUserVO) {
        if (tenantTransferOwnerUserVO == null) {
            return;
        }
        MessageBody tenantTransferOwnerUserVOMessageInfo = new MessageBody();
        tenantTransferOwnerUserVOMessageInfo.setOpType(MailTypeEnum.IAM_TRANSFER_TENANT_OWNER_USER.name());
        tenantTransferOwnerUserVOMessageInfo.setData((Object)tenantTransferOwnerUserVO);
        this.producerService.msg(tenantTransferOwnerUserVOMessageInfo);
    }

    @Override
    public void switchRedis(Object ha) {
        MessageBody messageInfo = new MessageBody();
        messageInfo.setOpType(MailTypeEnum.IAM_REDIS_SWITCH_OK.name());
        messageInfo.setData(ha);
        this.producerService.msg(messageInfo);
    }

    @Override
    public void sendDevRegisterSuccessForTest(DevTestRegisterInfo devRegisterInfo) {
        MessageBody messageInfo = new MessageBody();
        messageInfo.setOpType(MailTypeEnum.IAM_DEV_APPLY_TEST_ACCOUNT_SUCCESS.name());
        messageInfo.setData((Object)devRegisterInfo);
        this.remoteEMCService.sendEmailByEventId(devRegisterInfo.getSourceEmcUri(), messageInfo);
    }

    @Override
    public void sendDevRegisterFailForTest(DevTestRegisterInfo devTestRegisterInfo) {
        MessageBody messageInfo = new MessageBody();
        messageInfo.setOpType(MailTypeEnum.IAM_DEV_APPLY_TEST_ACCOUNT_FAIL.name());
        messageInfo.setData((Object)devTestRegisterInfo);
        this.remoteEMCService.sendEmailByEventId(devTestRegisterInfo.getSourceEmcUri(), messageInfo);
    }

    @Override
    public void sendDeletePurchaseGoods(DeletePurchaseGoods goods) {
        MessageBody messageInfo = new MessageBody();
        messageInfo.setOpType(MailTypeEnum.IAM_DELETE_PURCHASE_GOODS.name());
        messageInfo.setData((Object)goods);
        this.producerService.msg(messageInfo);
    }

    @Override
    public void sendRejectMessage(TransferCreatorApplication transferCreatorApplication, TransferCreatorApplicationVO body) {
        MessageBody messageInfo = new MessageBody();
        messageInfo.setOpType(MailTypeEnum.IAM_TRANSFER_CREATOR_REJECT.name());
        HashMap<String, String> data = new HashMap<String, String>();
        User user = (User)this.userCrudService.findById(transferCreatorApplication.getUserId());
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("rejectReason", body.getRejectReason());
        data.put("email", transferCreatorApplication.getEmail());
        data.put("phone", transferCreatorApplication.getTelephone());
        messageInfo.setData(data);
        this.producerService.msg(messageInfo);
    }

    @Override
    public void sendUpdateTenantCreator(long tenantSid, String email, String userId, Long oldOwnerUserSid, String telephone, String type) {
        try {
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
            User ownerUser = (User)this.userCrudService.findBySid(oldOwnerUserSid);
            User user = (User)this.userCrudService.findById(userId);
            UpdateTenantCreatorMessageVO updateTenantCreatorMessageVO = new UpdateTenantCreatorMessageVO();
            updateTenantCreatorMessageVO.setType(type);
            updateTenantCreatorMessageVO.setEmail(email);
            updateTenantCreatorMessageVO.setOwnerUserId(ownerUser.getId());
            updateTenantCreatorMessageVO.setOwnerUserName(ownerUser.getName());
            updateTenantCreatorMessageVO.setUserId(user.getId());
            updateTenantCreatorMessageVO.setUserName(user.getName());
            updateTenantCreatorMessageVO.setCustomerId(StringUtils.isEmpty((Object)tenant.getCustomerId()) ? "" : tenant.getCustomerId());
            updateTenantCreatorMessageVO.setId(tenant.getId());
            updateTenantCreatorMessageVO.setName(tenant.getName());
            updateTenantCreatorMessageVO.setPhone(telephone);
            MessageBody bossMessage = new MessageBody();
            bossMessage.setOpType("BOSS_UPDATE_CREATOR");
            bossMessage.setData((Object)updateTenantCreatorMessageVO);
            this.producerService.msg(bossMessage);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u79df\u6237\u521b\u5efa\u8005\u90ae\u4ef6\u53d1\u9001\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void sendTransferCreatorReminder(TransferCreatorApplication transferCreatorApplication) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(transferCreatorApplication.getTenantSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tenantName", tenant.getName());
        data.put("tenantId", tenant.getId());
        data.put("code", transferCreatorApplication.getApplyCode());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("IAM_TRANSFER_CREATOR_REMINDER");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendCompleteIdentityEmail(IntellyIdentityApplication intellyIdentityApplication) {
        User user = (User)this.userCrudService.findBySid(intellyIdentityApplication.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("idType", IntellyIdentityTypeEnum.getName(intellyIdentityApplication.getIdType()));
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("SUMT_PRFCT_INDT_INFO");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendRejectCompleteIdentityEmail(IntellyIdentityApplication application, IntellyIdentityVO body) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("remark", body.getRemark());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("PRFCT_IDNT_AUDT_RJCT");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendExperienceApplyEmail(IntellyExperienceApplication application) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("applyCode", application.getApplyCode());
        data.put("telephone", user.getTelephone());
        data.put("email", user.getEmail());
        data.put("applyRemark", application.getApplyRemark());
        data.put("goodsName", application.getGoodsName());
        data.put("occupation", I18nUtils.getMessage((String)("iam.experience.occupation." + application.getOccupation())));
        data.put("experience", I18nUtils.getMessage((String)("iam.experience.experience." + application.getExperience())));
        data.put("industry", application.getIndustry());
        data.put("code", application.getGoodsCode());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("SBMT_EXPR_APLY");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendRejectExperienceEmail(IntellyExperienceApplication application, String remark) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("applyCode", application.getApplyCode());
        data.put("remark", remark);
        data.put("goodsName", application.getGoodsName());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("EXPR_APLY_AUDT_RJCT");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendExperienceExtensionEmail(IntellyExperienceApplication application, IntellyExperienceVO body) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("applyCode", application.getApplyCode());
        data.put("telephone", user.getTelephone());
        data.put("email", user.getEmail());
        data.put("goodsName", application.getGoodsName());
        data.put("effectiveDate", DateUtil.format((LocalDateTime)application.getEffectiveDate(), (String)"yyyy-MM-dd"));
        data.put("expireDate", DateUtil.format((LocalDateTime)application.getExpireDate(), (String)"yyyy-MM-dd"));
        data.put("extensionRemark", application.getExtensionRemark());
        data.put("code", application.getGoodsCode());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("APLY_EXPR_DLY_SBMT");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendExperienceExtensionRejectEmail(IntellyExperienceApplication application, IntellyExperienceVO body) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("applyCode", application.getApplyCode());
        data.put("extensionReviewRemark", body.getExtensionReviewRemark());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("APLY_EXPR_DLY_ADUT_RJCT");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendExperienceExtensionConfirmEmail(IntellyExperienceApplication application, IntellyExperienceVO body, LocalDateTime oldExpireDate) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("applyCode", application.getApplyCode());
        data.put("expireDate", DateUtil.format((LocalDateTime)application.getExpireDate(), (String)"yyyy-MM-dd"));
        data.put("oldExpireDate", DateUtil.format((LocalDateTime)oldExpireDate, (String)"yyyy-MM-dd"));
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("APLY_EXPR_DLY_ADUT_PASS");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendConfirmIdentityEmail(IntellyIdentityApplication application) {
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("PRFCT_IDNT_AUDT_PASS");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendExperiencePreExpireNotice(IntellyExperienceApplication a) {
        User user = (User)this.userCrudService.findBySid(a.getUserSid());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", user.getId());
        data.put("userName", user.getName());
        data.put("expireDate", DateUtil.format((LocalDateTime)a.getExpireDate(), (String)"yyyy-MM-dd"));
        data.put("goodsName", a.getGoodsName());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType("DEV_EXPR_DUE_NOTICE");
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendIsvApplyMail(Tenant tenant) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("userId", UserUtils.getUserId());
        data.put("userName", UserUtils.getUserName());
        data.put("tenantName", tenant.getName());
        data.put("tenantId", tenant.getId());
        data.put("staffSize", tenant.getStaffSize());
        data.put("description", tenant.getDescription());
        data.put("address", tenant.getAddress());
        data.put("contacts", tenant.getContacts());
        data.put("telephone", tenant.getTelephone());
        data.put("email", tenant.getEmail());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType(MailTypeEnum.ISV_JIONIN_APLY_ADUT.name());
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendIsvSuccessMail(Tenant tenant) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tenantName", tenant.getName());
        data.put("tenantId", tenant.getId());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType(MailTypeEnum.ISV_JIONIN_SUCCESS.name());
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendIsvRejectMail(Tenant tenant, String reason) {
        Long createBy = tenant.getCreateBy();
        User creator = (User)this.userCrudService.findBySid(createBy);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("tenantName", tenant.getName());
        data.put("tenantSid", tenant.getSid());
        data.put("reason", reason);
        data.put("userId", creator.getId());
        data.put("userName", creator.getName());
        MessageBody bossMessage = new MessageBody();
        bossMessage.setOpType(MailTypeEnum.ISV_JIONIN_REJECT.name());
        bossMessage.setData(data);
        this.producerService.msg(bossMessage);
    }

    @Override
    public void sendAppAccountPasswordMail(UserAccountPasswordVO data) {
        if (data == null) {
            return;
        }
        if (StringUtils.hasText((String)data.getSourceAppId())) {
            DictData dictData = this.dictDataService.selectDictData(new DictDataDTO(MailTypeEnum.PASSWORD_SEND.name(), data.getSourceAppId()));
            if (null == dictData) {
                logger.error("\u5e94\u7528{}\u672a\u914d\u7f6e\u4e8b\u4ef6\u6a21\u7248{}", (Object)data.getSourceAppId(), (Object)MailTypeEnum.PASSWORD_SEND.name());
                return;
            }
            this.sendUserEnterpriseAccountPasswordCore(dictData.getDictValue(), dictData.getDictValue(), data);
        }
    }

    private void sendUserEnterpriseAccountPasswordCore(String mailTypeValue, String telephoneTypeValue, UserAccountPasswordVO userInfo) {
        MessageBody userAccountPasswordVOMessageInfo = new MessageBody();
        if (ObjectUtils.nullSafeEquals((Object)Boolean.TRUE, (Object)userInfo.getType())) {
            if (!StringUtil.isInt(userInfo.getAccount())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_FORMAT_ERROR);
            }
            userInfo.setTypes(Arrays.asList("sms"));
            userAccountPasswordVOMessageInfo.setOpType(telephoneTypeValue);
        } else {
            if (!StringUtil.checkEmail(userInfo.getAccount())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_FORMAT_ERROR);
            }
            if (userInfo.getUserId().contains("$")) {
                userInfo.setUserId(userInfo.getUserId().split("\\$")[1]);
            }
            userInfo.setTypes(Arrays.asList("email"));
            userAccountPasswordVOMessageInfo.setOpType(mailTypeValue);
        }
        userAccountPasswordVOMessageInfo.setData((Object)userInfo);
        this.producerService.msg(userAccountPasswordVOMessageInfo);
    }
}

